unit instr;

interface

uses graph,crt;

procedure instruccoes( conmem,alimem,objmem : pointer );
procedure cortina;

implementation


procedure cortina;
var c : integer;
begin
  for c := 1 to 24 do
    begin
      SetViewPort(3,c*8,316,c*8+8,ClipOn);
      ClearViewPort;
      Sound(400+100*c);
    end;
  Nosound;
  SetViewPort(0,0,319,199,ClipOn);
end; { cortina }


procedure colocar( py : integer; txt : string);
var c,cx,cy,pini : integer;
begin
  pini := (320 - length(txt) * 8 ) div 2 - 5;
  cy := py * 9 + 8;
  for c := 1 to length(txt) do
    begin
      cx := c * 8 + pini;
      SetColor(2);
      OutTextXY(cx,cy,txt[c]);
      SetColor(0);
      if ord(txt[c]) > 96 then
        Line(cx-3,cy-5,cx+3,cy-5)
      else
        Line(cx-3,cy-7,cx+3,cy-7);
      sound(2000);
      delay(5);
      NoSound;
    end;
  delay(40);
end; { colocar }


procedure instruccoes( conmem,alimem,objmem : pointer );
var tecla  : char;
    c      : integer;
    offset : pointer;
begin
  cortina;
  colocar(2,'ORGANIZACAO MUNDIAL DO AMBIENTE');
  colocar(4,'*** S E C R E T O ***');
  delay(100);
  colocar( 7,'Ao abrigo da resolucao UN1-2014 da');
  colocar( 8,'Confederacao das Nacoes, todo o lixo');
  colocar( 9,'radioactivo produzido nos estados que');
  colocar(10,'compoem a organizacao, sao recolhidos');
  colocar(11,'todos os meses, e teletransportados em');
  colocar(12,'recipientes proprios para o efeito,');
  colocar(13,'para a base lunar KL-3.');
  delay(200);
  colocar(18,'PAG 1 de 4');
  repeat until keypressed;
  tecla := ReadKey;
  cortina;
  colocar( 7,'Infelizmente, devido a uma avaria no');
  colocar( 8,'teletransportador, os recipientes nao');
  colocar( 9,'chegaram ao seu destino.');
  colocar(11,'Devido ao incidente, todos foram');
  colocar(12,'devolvidos as cidades que os tinham');
  colocar(13,'enviado, mas nao para o local de');
  colocar(14,'partida. Sabe-se que todos eles estao');
  colocar(15,'colocados numa parte desconhecida da');
  colocar(16,'cidade de origem.');
  delay(200);
  colocar(18,'PAG 2 de 4');
  repeat until keypressed;
  tecla := ReadKey;
  cortina;
  colocar( 7,'Os recipientes nao sao perigosos,');
  colocar( 8,'mas seria uma catastrofe se alguem ou');
  colocar( 9,'alguma coisa provocar a sua abertura!');
  colocar(11,'E preciso encontrar todos os');
  colocar(12,'recipientes e envia-los para a base');
  colocar(13,'lunar KL-3 sem alertar os habitantes.');
  colocar(14,'Para isso voce ira controlar um robot');
  colocar(15,'de limpeza da serie AF-002/5, tambem');
  colocar(16,'conhecidos como << LABO >>. So assim');
  colocar(17,'se podera evitar o panico ...');
  delay(200);
  colocar(19,'PAG 3 de 4');
  repeat until keypressed;
  tecla := ReadKey;
  cortina;
  colocar( 7,'O robot LABO devera evitar os');
  colocar( 8,'habitantes das cidades, pois estes na');
  colocar( 9,'sua proximidade terao conhecimento da');
  colocar(10,'situacao, pois os robots desta serie');
  colocar(11,'repetem a ordem que receberam.');
  colocar(13,'A sua missao e enviar todos os');
  colocar(14,'recipientes para a lua, atraves dos');
  colocar(15,'teletransportadores da cidade.');
  colocar(17,'BOA SORTE ....');
  delay(900);
  colocar(19,'>>>> FIM DE TRANSMISSAO');
  repeat until keypressed;
  tecla := ReadKey;
  cortina;
  PutImage(9,150,conmem^,NormalPut);
  SetColor(2);
  OutTextXY(160,30,'A CONSOLA DE COMANDO');
  SetColor(3);
  SetTextJustify(RightText,0);
  OutTextXY(304,60,'Recipientes Devolvidos');
  OutTextXY(304,80,'Pontuacao');
  OutTextXY(304,100,'Nivel de Panico');
  OutTextXY(304,120,'Objectos');
  SetColor(1);
  Line(124,56,33,56);
  Line(33,56,33,145);
  Line(228,76,84,76);
  Line(84,76,84,145);
  Line(180,96,160,96);
  Line(160,96,160,145);
  Line(260,125,260,145);
  repeat until keypressed;
  tecla := ReadKey;
  cortina;
  SetTextJustify(LeftText,0);
  for c := 0 to 8 do
    begin
      offset := ptr(seg(objmem^),ofs(objmem^)+70*c);
      PutImage(10,c*20+12,offset^,NormalPut);
    end;
  SetColor(2);
  OutTextXY(30,26, 'Recipiente Radioactivo  5000 pontos');
  OutTextXY(30,46, 'Oleo-Diminui Panico      100 pontos');
  OutTextXY(30,66, 'Joia-Bonus               100 pontos');
  OutTextXY(30,86, 'Dinamite-Rebenta tectos  550 pontos');
  OutTextXY(30,106,'Joia-Bonus               300 pontos');
  OutTextXY(30,126,'Chave-Bonus              200 pontos');
  OutTextXY(30,146,'Caveira-Efeito variado');
  OutTextXY(30,166,'Fuel-Diminui Panico      100 pontos');
  OutTextXY(30,186,'Joia-Bonus              1000 pontos');
  repeat until keypressed;
  tecla := ReadKey;
  cortina;
  SetTextJustify(CenterText,0);
  colocar(2, 'Labo devera recolher os 3 recipientes');
  colocar(3, 'radioactivos para os enviar, em');
  colocar(4, 'conjunto ou em separado, para a base');
  colocar(5, 'lunar KL-3, usando para isso os');
  colocar(6, 'teletransportadores da cidade. Depois');
  colocar(7, 'de ter enviado os recipientes, Labo');
  colocar(8, 'podera entao teletransportar-se para');
  colocar(9, 'fora da cidade. Para usar o');
  colocar(10,'teletransporte, basta estar proximo e');
  colocar(11,'premir Fogo/Accao.');
  colocar(13,'Para destruir as colunas de defesa,');
  colocar(14,'Labo devera decifrar o codigo, que');
  colocar(15,'consiste em colocar os digitos por');
  colocar(16,'ordem crescente. Basta premir a tecla');
  colocar(17,'Fogo/Accao perto da barreira.');
  repeat until keypressed;
  tecla := readkey;
  cortina;
  colocar(6, 'Cada nivel possui um codigo de acesso.');
  colocar(7, 'Quando Labo completa uma cidade (nivel)');
  colocar(8, 'sera dado um codigo para uma cidade');
  colocar(9, 'proxima. Para comecar o jogo, basta');
  colocar(10,'introduzir 0 ou apenas premir ENTER');
  colocar(11,'no pedido do nivel a jogar.');
  Delay(400);
  colocar(14,'-- BOA SORTE --');
  repeat until keypressed;
  tecla := ReadKey;
end; { instruccoes }


end.
