program labo(input,output);
{$R+}

uses graph,crt,dos,labo1,sprite,digit,instr,teclas;

type
  matriz  = array [1 .. 35] of byte;
  matriz2 = array [1 .. 35] of matriz;
  matriz3 = array [1 .. 2] of byte;
  matriz4 = array [1 .. 410] of matriz3;
  matriz5 = array [1 .. 206] of byte;
  matriz6 = array [1 .. 104] of matriz5;
  matriz7 = array [1 .. 20] of string;
  matriz8 = array [1 .. 20] of longint;

var opcao,labx,laby,panico  : integer;
    texto,ci,ba,es,di,fo    : string;
    imagem                  : word;
    tijolo,boneco           : pointer;
    mat                     : matriz2;
    lista                   : matriz4;
    l                       : matriz6;
    blocmem,digitmem,conmem : pointer;
    bonmem,alimem,objmem    : pointer;
    valtij,valtijb,valtijc  : byte;
    pontos,nivel            : longint;
    fichpont                : text;
    tabpont                 : matriz7;
    tabnum                  : matriz8;
    velb                    : integer;


procedure CgaDriverProc; external;
{$L CGA.OBJ }

procedure TriplexFontProc; external;
{$L TRIP.OBJ }


procedure verifica_pontuacao;
var ang,rot       : real;
    c,posi,px,py  : integer;
    nome,ll,tn,tp : string;

procedure abre_espaco;
var d : integer;
begin
  posi := 20;
  while (( pontos > tabnum[posi-1]) and ( posi > 2 )) do
    dec(posi);
  if pontos > tabnum[1] then
    dec(posi);

  for d := 20 downto posi+1 do
    begin
      tabpont[d] := tabpont[d-1];
      tabnum[d] := tabnum[d-1];
    end;
end; { abre_espaco }


begin
  if pontos > tabnum[20] then
    begin
      SetViewPort(0,0,305,152,ClipOn);
      ClearViewPort;
      SetViewPort(0,0,319,199,ClipOn);
      ang := 6.283/50;
      rot := 0;
      for c := 1 to 50 do
      begin
        px := round(cos(rot)*130+160);
        py := round(sin(rot)*60+79);
        PutImage(px-8,py-8,objmem^,OrPut);
        rot := rot + ang;
        Sound(round(cos(rot)*200)+1000);
        Delay(10);
      end;
      NoSound;
      SetColor(3);
      OutTextXY(160,65,'CONSEGIU UMA BOA PONTUACAO!');
      SetColor(2);
      OutTextXY(160,78,'INTRODUZA O SEU NOME');
      _input(80,95,nome,'XXXXXXXXXXXXXXXXXXXX');
      for c := length(nome) to 19 do
        nome := nome + ' ';
      abre_espaco;
      Str(nivel:5,tn);
      Str(pontos:6,tp);
      ll := nome + '..' + tn + '...' + tp;
      tabpont[posi] := ll;
      tabnum[posi] := pontos;
    end;
end; { verifica_pontuacao }


procedure desenhar_sala( sx,sy : integer );
var lx,ly,c,d : integer;
begin
  SetViewPort(0,0,319,160,ClipOn);
  ClearViewPort;
  SetViewPort(0,0,319,199,ClipOn);
  lx := sx*12-11;
  ly := sy*6-5;
  for c := 0 to 5 do
    for d := 0 to 11 do
      if l[ly+c,lx+d] < 140 then
        begin
          tijolo := ptr(seg(blocmem^),ofs(blocmem^)+150*l[ly+c,lx+d]);
          PutImage(d*24+16,c*24+8,tijolo^,NormalPut);
        end
      else
        if l[ly+c,lx+d] <> 255 then
          begin
            tijolo := ptr(seg(objmem^),ofs(objmem^)+70*(l[ly+c,lx+d]-200));
            PutImage(d*24+20,c*24+16,tijolo^,NormalPut);
          end;
end; { desenhar_sala }


procedure determinar_tijolo;
var valor : byte;
begin
  valor := round(random*78);
  if valor = 78 then
    valor := 111;
  if valor < 57 then
    begin
      valor := (valor div 3) * 3;
      valtij := valor;
      valtijc := valor + 1;
      valtijb := valor + 2;
    end
  else
    begin
      valtij := valor;
      valtijc := valor;
      valtijb := valor;
    end;
end; { determinar_tijolo }


procedure jogo;
var sx,sy,x,y,p1,p2,dir,bondir,obj1,obj2 : integer;
    o1,o2,o3,o4                          : byte;
    parar,fogo,conti                     : boolean;
    tecla                                : char;
    cobj,blx,bly,crad                    : integer;


procedure som1;
var cs : integer;
begin
  for cs := 1 to 20 do
    begin
      Sound(cs*100);
      delay(5);
    end;
  for cs := 20 downto 1 do
    begin
      Sound(cs*100);
      delay(5);
    end;
  NoSound;
end; { som1 }


procedure panico_geral2;
var cx,bon,px,py,barulho : integer;
    alien            : pointer;
begin
  for cx := 1 to 200 do
    begin
      px := round(random*280)+16;
      py := round(random*136)+8;
      bon := (round(random*98));
      alien := ptr(seg(alimem^),ofs(alimem^)+70*bon);
      PutImage(px,py,alien^,NormalPut);
      Sound(round(random*1000)+2000);
      Delay(9);
    end;
  NoSound;
  Delay(400);
  SetViewPort(60,40,260,120,ClipOn);
  ClearViewPort;
  SetViewPort(0,0,319,199,ClipOn);
  SetColor(1);
  Rectangle(60,40,260,120);
  barulho := 2000;
  repeat
    if keypressed then
      tecla := readkey;
  until not keypressed;
  repeat
    SetColor(round(random*4));
    OutTextXY(160,55,'O PANICO INSTALOU-SE');
    OutTextXY(160,70,'NA CIDADE!');
    OutTextXY(160,104,' LABO NAO CONSEGUIU...');
    Sound(barulho);
    barulho := barulho - 9;
  until ( keypressed ) or ( barulho < 50 );
  if keypressed then
    tecla := readkey;
  som1;
  som1;
end; { panico_geral2 }


procedure aumenta_panico2;
begin
  inc(panico);
  SetColor(3);
  Line(123+panico,172,123+panico,176);
  Sound(2000);
  Delay(2);
  Nosound;
  if panico > 80 then
    begin
      panico_geral2;
      parar := true;
      fogo := false;
    end;
end; { aumenta_panico2 }


procedure diminui_panico2;
begin
  SetColor(0);
  Line(123+panico,172,123+panico,176);
  Sound(2000);
  Delay(2);
  Nosound;
  if panico > 0 then
    dec(panico);
end; { diminui_panico2 }


procedure procura_objecto;
var obj3,obj4 : byte;
begin
  bly := round(int((y-6)/24));
  bly := sy*6-5+bly;
  blx := round(int((x-12)/24));
  blx := sx*12-11+blx;
  obj1 := l[bly,blx-1];
  obj2 := l[bly,blx+1];
  obj3 := l[bly-1,blx];
  obj4 := l[bly+1,blx];
  if (( obj1 = 78 ) or ( obj1 = 96 ) or ( obj1 = 115 ) or ( obj1 = 116 ) or ( obj1 > 199 )) and ( obj1 <> 255 ) then
    begin
      dec(blx);
    end
  else
    if (( obj2 = 78 ) or ( obj2 = 96 ) or ( obj2 = 115 ) or ( obj2 = 116 ) or ( obj2 > 199 )) and ( obj2 <> 255 ) then
      begin
        inc(blx);
        obj1 := obj2;
      end
    else
      if (( obj3 = 78 ) or ( obj3 = 96 ) or ( obj3 = 115 ) or ( obj3 = 116 ) or ( obj3 > 199 )) and ( obj3 <> 255 ) then
        begin
          dec(bly);
          obj1 := obj3;
        end
      else
        if (( obj4 = 78 ) or ( obj4 = 96 ) or ( obj4 = 115 ) or ( obj4 = 116 ) or ( obj4 > 199 )) and ( obj4 <> 255 ) then
          begin
            inc(bly);
            obj1 := obj4;
          end
        else
          begin
            obj1 := 0;
          end;
end; { procura_objecto }


procedure jogo_dos_digitos;
var ok : boolean;
    c  : integer;
begin
  ok := false;
  jogo_digitos(digitmem,es,di,fo,ok);
  if ok = true then
    begin
      for c := -1 to 1 do
        if l[bly+c,blx] = 96 then
          l[bly+c,blx] := 255;
      pontos := pontos + 500 + round(random*20);
      escrever_pontuacao(pontos);
    end
  else
    for c := 1 to 6 do
      if panico < 81 then
        begin
          aumenta_panico2;
          delay(10);
        end;
end; { jogo_dos_digitos }


procedure guarda_objecto( objec : byte);
var nobj   : integer;
    tijolo : pointer;
begin
  if o1 = 0 then
    begin
      o1 := objec;
      nobj := 0;
    end
  else
    if o2 = 0 then
      begin
        o2 := objec;
        nobj := 1;
      end
    else
      if o3 = 0 then
        begin
          o3 := objec;
          nobj := 2;
        end
      else
        begin
          o4 := objec;
          nobj := 3;
        end;
  tijolo := ptr(seg(objmem^),ofs(objmem^)+70*(objec-200));
  PutImage(nobj*21+220,168,tijolo^,NormalPut);
end; { guarda_objecto }


procedure apagar_objecto( num : integer );
begin
  SetViewPort(num*21+220,168,num*21+235,183,ClipOn);
  ClearViewPort;
  SetViewPort(0,0,319,199,ClipOn);
end; { apagar_objecto }


procedure retirar_objecto( objec : byte);
begin
  if o1 = objec then
    begin
      o1 := 0;
      apagar_objecto(0);
    end
  else
    if o2 = objec then
      begin
        o2 := 0;
        apagar_objecto(1);
      end
    else
      if o3 = objec then
        begin
          o3 := 0;
          apagar_objecto(2);
        end
      else
        if o4 = objec then
          begin
            o4 := 0;
            apagar_objecto(3);
          end;
end; { retirar_objecto }


procedure apanha_radiacao;
begin
  l[bly,blx] := 255;
  pontos := pontos + 5000;
  escrever_pontuacao(pontos);
  guarda_objecto(200);
  som1;
end; { apanha_radiacao }


procedure apanha_joia( pp : integer );
begin
  l[bly,blx] := 255;
  pontos := pontos + pp;
  escrever_pontuacao(pontos);
  som1;
end; { apanha_joia }


procedure apanha_dinamite;
begin
  l[bly,blx] := 255;
  pontos := pontos + 550;
  escrever_pontuacao(pontos);
  guarda_objecto(203);
  som1;
end; { apanha_dinamite }


procedure apanha_oleo_fuel;
var c : integer;
begin
  l[bly,blx] := 255;
  pontos := pontos + 100;
  escrever_pontuacao(pontos);
  for c := 1 to 8 do
    diminui_panico2;
  som1;
end; { apanha_oleo_fuel }


procedure rebenta_parede;
var c : integer;
begin
  for c := 1 to 3000 do
    Sound(round(Random*3000)+200);
  NoSound;
  for c := -2 to 2 do
    begin
      if (blx+c) > 0 then
        if (l[bly,blx+c] = 115) or (l[bly,blx+c] = 116) then
          l[bly,blx+c] := 255;
        if (l[bly+1,blx+c] = 115) or (l[bly+1,blx+c] = 116) then
          l[bly+1,blx+c] := 255;
    end;
  retirar_objecto(203);
  conti := false;
end; { rebenta_parede }


procedure apanha_caveira;
var c : integer;
begin
  l[bly,blx] := 255;
  case (round(random*4)) of
    0 : for c := 1 to 10 do
          diminui_panico2;
    1 : for c := 1 to 7 do
          aumenta_panico2;
    2 : begin
          pontos := pontos + round(random*1000)+1;
          escrever_pontuacao(pontos);
        end;
    3 : begin
          pontos := pontos - round(Random*500)-100;
          if pontos = 0 then
            pontos := 0;
          escrever_pontuacao(pontos);
        end;
  end;
  som1;
  som1;
end; { apanha_caveira }


procedure verifica_dinamite;
var pr : boolean;
begin
  pr := false;
  if (o1 = 203) or (o2 = 203) or (o3 = 203) or (o4 = 203) then
    pr := true;
  conti := true;
  if l[bly,blx] = 115 then
    begin
      if pr then
        begin
          dec(bly);
          rebenta_parede;
        end;
    end;
  if l[bly,blx] = 116 then
    begin
      if pr then
        rebenta_parede;
    end;
end; { verifica_dinamite }


procedure mensagem_final;
var c,px,py : integer;
    ang,rot : real;
begin
  SetViewPort(0,0,305,152,ClipOn);
  ClearViewPort;
  SetViewPort(0,0,319,199,ClipOn);
  ang := 6.283/50;
  rot := 0;
  for c := 1 to 50 do
    begin
      px := round(cos(rot)*130+160);
      py := round(sin(rot)*60+79);
      PutImage(px-8,py-8,bonmem^,OrPut);
      rot := rot + ang;
      Sound(c*100);
      Delay(10);
    end;
  som1;

  SetTextStyle(DefaultFont,0,2);
  OutTextXY(160,68,'PARABENS');

end; { mensagem_final }


procedure teletransporte;

procedure som_do_tele;
var c,d : integer;
begin
  d := 100;
  for c := 1 to 30 do
    begin
      sound(d);
      Delay(4);
      d := d + 100;
    end;
  for c := 1 to 40 do
    begin
      Sound(round(Random*1000)+200);
      Delay(4);
    end;
  Nosound;
end; { som_do_tele }


procedure desenha_simbolo;
begin
  SetColor(1);
  MoveTo(crad*8+21,172);
  LineRel(6,0);
  LineRel(-3,6);
  LineRel(-3,-6);
end; { desenha_simbolo }

begin
  if crad = 3 then
    begin
      mensagem_final;
      dar_codigo;
      parar := true;
      fogo := false;
    end
  else
    if (o1 = 200) or (o2 = 200) or (o3 = 200) or (o4 = 200) then
      begin
        som_do_tele;
        retirar_objecto(200);
        desenha_simbolo;
        inc(crad);
        pontos := pontos + 5000;
        escrever_pontuacao(pontos);
      end;
  conti := true;
end; { teletransporte }


begin
  cobj := 0;
  panico := 0;
  pontos := 0;
  o1 := 0;
  o2 := 0;
  o3 := 0;
  o4 := 0;
  crad := 0;
  conti := false;

  PutImage(10,161,conmem^,NormalPut);
  guarda_objecto(203);
  escrever_pontuacao(pontos);
  sx := round(Random*((labx-5) div 2))+1;
  sy := round(Random*((laby-5) div 2))+1;
  x := 160;
  y := 72;
  bondir := 1;
  repeat
    if conti = false then
      desenhar_sala(sx,sy);
    fogo := false;
    mover(velb,x,y,dir,panico,bondir,parar,fogo,conti,bonmem,alimem,es,di,ci,ba,fo);
    if conti = true then
      conti := false;
    if fogo = false then
      begin
        case dir of
          1 : begin
                dec(sx);
                p1 := round(int((y-7)/24));
                p2 := round(int((y+7)/24));
                if ( l[sy*6-5+p1,sx*12] <> 255 ) or ( l[sy*6-5+p2,sx*12] <> 255 ) then
                  begin
                    inc(sx);
                    x := 16;
                  end
                else
                  x := 288;
              end;
          2 : begin
                inc(sx);
                p1 := round(int((y-7)/24));
                p2 := round(int((y+7)/24));
                if ( l[sy*6-5+p1,sx*12-11] <> 255 ) or ( l[sy*6-5+p2,sx*12-11] <> 255 ) then
                  begin
                    dec(sx);
                    x := 288;
                  end
                else
                  x := 16;
              end;
          3 : begin
                dec(sy);
                p1 := round(int((x-7)/24));
                p2 := round(int((x+7)/24));
                if ( l[sy*6,sx*12-11+p1] <> 255 ) or ( l[sy*6,sx*12-11+p2] <> 255 ) then
                  begin
                    inc(sy);
                    y := 8;
                  end
                else
                  y := 136;
              end;
          4 : begin
                inc(sy);
                p1 := round(int((x-7)/24));
                p2 := round(int((x+7)/24));
                if ( l[sy*6-5,sx*12-11+p1] <> 255 ) or ( l[sy*6-5,sx*12-11+p2] <> 255 ) then
                  begin
                    dec(sy);
                    y := 136;
                  end
                else
                  y := 8;
              end;
        end;
      end
    else
      if fogo = true then
        begin
          conti := false;
          procura_objecto;
          case obj1 of
            96  : jogo_dos_digitos;
            200 : if cobj < 4 then
                    apanha_radiacao;
            202 : apanha_joia(100);
            204 : apanha_joia(300);
            208 : apanha_joia(1000);
            205 : apanha_joia(200);
            203 : apanha_dinamite;
            201 : apanha_oleo_fuel;
            207 : apanha_oleo_fuel;
            206 : apanha_caveira;
            115 : verifica_dinamite;
            116 : verifica_dinamite;
            78  : teletransporte;
            else
              conti := true;
          end;
        end;
  until ( parar ) and ( not fogo );
  verifica_pontuacao;
end; { jogo }


procedure mostra_matriz;
var f,g,cor : integer;
    tecla   : char;
begin
  SetViewPort(0,0,319,199,ClipON);
  ClearViewPort;
  SetTextStyle(DefaultFont,0,1);
  for f := 1 to 102 do
    for g := 1 to 204 do
      if l[f,g] <> 255 then
        PutPixel(g,f,2);
  repeat until keypressed;
  tecla := readkey;
end; { mostra_matriz }


procedure definir_labirinto( nivel : longint);
var f,g,pco,v,h,cli : integer;
    x               : byte;


procedure transformar;
var c,d,v,h,lv,lh,e : integer;
begin
  for c := 1 to (laby-3) div 2 do
    for d := 1 to (labx-3) div 2 do
      begin
        v := c*2+1;
        h := d*2+1;
        lv := c*6-5;
        lh := d*12-11;
        l[lv,lh] := valtij;
        l[lv+5,lh] := valtij;
        l[lv+5,lh+11] := valtij;
        l[lv,lh+11] := valtij;

        if mat[v-1,h] = 0 then         { paredes }
          for e := 1 to 10 do
            begin
              l[lv,lh+e] := valtij;
              if (Random > 0.5) then
                l[lv+1,lh+(round(Random*9)+1)] := valtijc;
            end;

        if mat[v+1,h] = 0 then
          for e := 1 to 10 do
            begin
              l[lv+5,lh+e] := valtij;
              if (Random > 0.5) then
                l[lv+4,lh+(round(Random*9)+1)] := valtijb;
            end;

        if mat[v,h-1] = 0 then
          for e := 1 to 4 do
            begin
              l[lv+e,lh] := valtij;
              if (Random > 0.5) then
                l[lv+(round(Random*3)+1),lh+1] := valtij;
            end;

        if mat[v,h+1] = 0 then
          for e := 1 to 4 do
            begin
              l[lv+e,lh+11] := valtij;
              if (Random > 0.5) then
                l[lv+(round(Random*3)+1),lh+10] := valtij;
            end;

      end;
end; { transformar }


procedure apagar_labirinto;
var c,d : integer;
begin
  for c := 1 to 102 do
    for d := 1 to 204 do
      l[c,d] := 255;
end; { apagar_labirinto }


procedure colocar_adicoes;
var ff : integer;
begin
  g := round(Random*((labx*laby)/80))+2;
  for ff := 1 to g do
    begin
      repeat
        h := round(Random*(labx/2-3))*2+4;
        v := round(Random*(laby/2-3))*2+3;
      until mat[v,h] = 0;
      mat[v,h] := 50;
    end;
end; { colocar_adicoes }


procedure colocar_barreiras;
var f,px,py,quant : integer;
    ok            : boolean;
begin
  for f := 1 to 4 do
    quant := round(random*(labx*laby/100))+6;

  if quant > 0 then
    for f := 1 to quant do
      begin
        ok := false;
        repeat
          px := round(Random*(labx/2-3))*2+3;
          py := round(Random*(laby/2-3))*2+3;
          if mat[py-1,px] = 0 then
            if mat[py+1,px] = 0 then
              begin
                mat[py,px] := 25;
                px := (px div 2)*12-10+round(random*8);
                py := (py div 2)*6-4;
                l[py,px] := 129;
                l[py+3,px] := 128;
                l[py+1,px] := 96;
                l[py+2,px] := 96;
                ok := true;
              end;
        until ok;
      end;
end; { colocar_barreiras }


procedure fechar_passagens;
var quant,f,g,px,py,dir : integer;
begin
  quant := round(labx*laby/40);
  for f := 1 to quant do
    begin
      px := round(random*(labx/2-2))*12+6;
      py := round(random*(laby/2-2))*6+7;
      dir := round(random*100);
      for g := 1 to round(random*5) do
        begin
          l[py,px] := valtij;
          l[py-1,px] := valtij;
          if (random > 0.5) then
            l[py-2,px] := valtijb;
          if (random > 0.5) then
            l[py+1,px] := valtijc;
          if dir > 50 then
            inc(px)
          else
            dec(px);
        end;
    end;
end; { fechar_passagens }


procedure colocar_solo;
var quant,f,g,px,py : integer;
begin
  quant := round(labx*laby/100)+1;
  for f := 1 to quant do
    begin
      px := round(random*(labx/2-3))*12+6;
      py := round(random*(laby/2-3))*6+7;
      for g := 0 to 5 do
        begin
          if l[py,px+g] = 255 then
            l[py,px+g] := 115;
          if l[py-1,px+g] = 255 then
            l[py-1,px+g] := 116;
          if l[py,px-g] = 255 then
            l[py,px-g] := 115;
          if l[py-1,px-g] = 255 then
            l[py-1,px-g] := 116;
        end;
    end;
end; { colocar_solo }


procedure colocar_parabolica;
var tent,px,py,ok : integer;
begin
  tent := 0;
  ok := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py+1,px] <> 255 then
      if l[py+1,px+1] <> 255 then
        if l[py,px] = 255 then
          if l[py,px+1] = 255 then
            begin
              l[py,px] := 101;
              l[py,px+1] := 102;
              l[py-1,px] := 99;
              l[py-1,px+1] := 100;
              inc(ok);
            end;
    inc(tent);
  until ( tent = 50 ) or ( ok = 2 );
end; { colocar_parabolica }


procedure colocar_arvore1;
var tent,px,py,ok : integer;
begin
  tent := 0;
  ok := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py+1,px] <> 255 then
      if l[py+1,px+1] <> 255 then
        if l[py,px] = 255 then
          if l[py,px+1] = 255 then
            begin
              l[py,px] := 124;
              l[py,px+1] := 125;
              l[py-1,px] := 122;
              l[py-1,px+1] := 123;
              inc(ok);
            end;
    inc(tent);
  until ( tent = 60 ) or ( ok = 3 );
end; { colocar_arvore1 }


procedure colocar_teletransporte;
var tent,px,py,ok : integer;
begin
  tent := 0;
  ok := 0;
  repeat
    px := round(random*(labx div 2 - 1))*12+3;
    py := round(random*(laby div 2 - 1))*6+5;
    if l[py+1,px] <> 255 then
      if l[py+1,px+1] <> 255 then
        if l[py,px] = 255 then
          if l[py,px+1] = 255 then
            begin
              l[py,px] := 78;
              l[py,px+1] := 79;
              l[py,px+2] := 255;
              inc(ok);
            end;
    inc(tent);
  until (( tent > 100 ) or ( ok = 5 )) and ( ok > 1 );
end; { colocar_teletransporte }


procedure colocar_quadros;
var tent,px,py,ok : integer;
begin
  tent := 0;
  ok := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] <> 255 then
      if l[py,px+1] <> 255 then
        begin
          l[py,px] := 120;
          l[py,px+1] := 121;
          inc(ok);
        end;
    inc(tent);
  until ( tent = 100 ) or ( ok = 5 );
end; { colocar_quadros }


procedure colocar_aviao;
var px,py,s,c : integer;
begin
  for c:= 1 to 4 do
  begin
    s := round(random*2);
    if s = 0 then
      s := 103
    else
      s := 107;
    px := (round(random*(labx div 2 - 1)))*12+3;
    py := (round(random*(laby div 2 - 1)))*6+5;
    if l[py+1,px] <> 255 then
      if l[py+1,px+1] <> 255 then
        if l[py+1,px+2] <> 255 then
          if l[py+1,px+3] <> 255 then
            begin
              l[py,px] := s;
              l[py,px+1] := s+1;
              l[py,px+2] := s+2;
              l[py,px+3] := s+3;
            end;
  end;
end; { colocar_aviao }


procedure colocar_objectos_diversos;
var px,py,quant,tipo,graf : integer;
begin
  quant := round(random*(labx*laby/4))+10;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      if l[py+1,px] = valtij then
        begin
          tipo := round(random*24)+1;
          case tipo of
            1 : graf := 81;
            2 : graf := 82;
            3 : graf := 83;
            4 : graf := 84;
            5 : graf := 87;
            6 : graf := 88;
            7 : graf := 89;
            8 : graf := 91;
            9 : graf := 92;
           10 : graf := 93;
           11 : graf := 94;
           12 : graf := 95;
           13 : graf := 97;
           14 : graf := 98;
           15 : graf := 112;
           16 : graf := 113;
           17 : graf := 114;
           18 : graf := 117;
           19 : graf := 118;
           20 : graf := 128;
           21 : graf := 116;
           22 : graf := 138;
           23 : graf := 139;
           24 : graf := 137;
           25 : graf := 119;
          end;
          l[py,px] := graf;
          dec(quant);
        end;

    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      if l[py-1,px] = valtij then
        begin
          tipo := round(random*5)+1;
          case tipo of
            1 : graf := 85;
            2 : graf := 86;
            3 : graf := 115;
            4 : graf := 129;
            5 : graf := 90;
            6 : graf := 80;
          end;
          l[py,px] := graf;

        end;
  until quant = 0;
end; { colocar_objectos_diversos }


procedure colocar_objectos;
var c,px,py : integer;
begin
  c := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      begin
        l[py,px] := 200;
        inc(c);
      end;
  until c = 3;

  c := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      begin
        l[py,px] := 201;
        inc(c);
      end;
  until c = 2;

  c := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      begin
        l[py,px] := 207;
        inc(c);
      end;
  until c = 2;

  c := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      begin
        l[py,px] := 206;
        inc(c);
      end;
  until c = 3;

  c := round(random*4)+2;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      begin
        l[py,px] := 205;
        dec(c);
      end;
  until c = 0;

  c := 0;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      begin
        l[py,px] := 203;
        inc(c);
      end;
  until c = 5;

  c := round(random*10)+5;
  repeat
    px := round(random*((labx div 2 - 1)*12)+2);
    py := round(random*((laby div 2 - 1)*6)+2);
    if l[py,px] = 255 then
      begin
        case (round(random*3)) of
          0 : l[py,px] := 202;
          1 : l[py,px] := 204;
          2 : l[py,px] := 208;
        end;
        dec(c);
      end;
  until (c = 0);

end; { colocar_objectos }


procedure procura_mov;
begin
  cli := 0;
  if mat[v+2,h] = 0 then inc(cli);
  if mat[v-2,h] = 0 then inc(cli);
  if mat[v,h+2] = 0 then inc(cli);
  if mat[v,h-2] = 0 then inc(cli);
end; { procura_mov }

procedure vguarda;
begin
  lista[pco,1] := v;
  lista[pco,2] := h;
  inc(pco);
end; { vguarda }

procedure vretira;
begin
  dec(pco);
  v := lista[pco,1];
  h := lista[pco,2];
end; { vretira }


label 130,200,500;

begin
  apagar_labirinto;
  lista[1,1] := 0;
  lista[1,2] := 0;
  RandSeed := nivel;
  for f := 1 to 10 do
    x := round(Random*250);
  repeat
    labx := round(Random*17)*2+1;
    laby := round(Random*17)*2+1;
  until ( labx*laby ) > 300;

  for f := 1 to laby do
    for g := 1 to labx do
      mat[f,g] := 0;

  for f := 1 to labx do
    begin
      mat[1,f] := 100;
      mat[laby,f] := 100;
    end;

  for f := 1 to laby do
    begin
      mat[f,1] := 100;
      mat[f,labx] := 100;
    end;

  pco := 2;
  v := 3;
  h := {round(Random*((labx-4)/2)+1)*2+2} 3;
  mat[v,h] := 100;

200:
  procura_mov;

  if cli = 0 then
    begin
      vretira;
      if ( v = 0 ) and ( h = 0 ) then
        goto 500;
      goto 200
    end;
  if cli > 1 then
    vguarda;
130:
  if ((Random > 0.6 ) or ( cli = 1 )) and ( mat[v-2,h] = 0 ) then
    begin
      mat[v-1,h] := 100;
      mat[v-2,h] := 100;
      v := v - 2;
      goto 200;
    end;
  if ((Random > 0.5 ) or ( cli = 1 )) and ( mat[v,h+2] = 0 ) then
    begin
      mat[v,h] := 100;
      mat[v,h+1] := 100;
      mat[v,h+2] := 100;
      h := h + 2;
      goto 200;
    end;
  if ((Random > 0.5 ) or ( cli = 1 )) and ( mat[v+2,h] = 0 ) then
    begin
      mat[v+1,h] := 100;
      mat[v+2,h] := 100;
      v := v + 2;
      goto 200;
    end;
  if ((Random > 0.5 ) or ( cli = 1 )) and ( mat[v,h-2] = 0 ) then
    begin
      mat[v,h] := 100;
      mat[v,h-1] := 100;
      mat[v,h-2] := 100;
      h := h - 2;
      goto 200;
    end;
  goto 130;

500:
  colocar_adicoes;
  transformar;
  fechar_passagens;
  colocar_aviao;
  colocar_quadros;
  colocar_barreiras;
  colocar_parabolica;
  colocar_arvore1;
  colocar_teletransporte;
  colocar_objectos_diversos;
  colocar_solo;
  colocar_objectos;
  mostra_matriz;
end; { definir_labirinto }


procedure jogar;
begin
  pedir_nivel(nivel);
  determinar_tijolo;
  definir_labirinto(nivel);
  jogo;
end; { jogar }


procedure ler_pontuacoes;
var linha : string;
    c     : integer;
    pont  : longint;

procedure calcula_pontuacao;
var d,erro : integer;
    t      : string;
begin
  t := '';
  for d := 31 to 36 do
    t := t + linha[d];
  Val(t,pont,erro);
end; { calcula_pontuacao }


begin
  assign(fichpont,'melhores.tab');
  reset(fichpont);
  for c := 1 to 20 do
    begin
      readln(fichpont,linha);
      tabpont[c] := linha;
      calcula_pontuacao;
      tabnum[c] := pont;
    end;
  close(fichpont);
end; { ler_pontuacoes }


procedure gravar_pontuacoes;
var c : integer;
begin
  assign(fichpont,'melhores.tab');
  rewrite(fichpont);
  for c := 1 to 20 do
    writeln(fichpont,tabpont[c]);
  close(fichpont);
end; { gravar_pontuacoes }


procedure mostrar_pontuacoes;
var c     : integer;
    tecla : char;
begin
  moldura;
  SetColor(3);
  OutTextXY(159,14,'OS MELHORES ROBOTS');
  OutTextXY(160,28,'__ NOME _____________ NIVEL   PONTOS');
  for c := 1 to 20 do
    begin
      SetColor(round(random*3)+1);
      OutTextXY(160,c*8+35,tabpont[c]);
      Sound(round(random*1000)+200);
    end;
  NoSound;
  repeat
    SetColor(Round(random*4));
    OutTextXY(159,14,'OS MELHORES ROBOTS');
  until keypressed;
  tecla := readkey;
end;  { mostrar_pontuacoes }


procedure ajusta_velocidade;
var c     : integer;
    ss1,x : word;
begin
  c := 0;
  repeat
    GetTime(x,x,x,ss1);
  until ss1 < 5;
  repeat
    inc(c);
    GetTime(x,x,x,ss1);
  until ss1 > 40;
  if c > 1500 then
    velb := 170
  else
    velb := 60;
end; { ajusta_velocidade }


begin
  if RegisterBGIfont(@TriplexFontProc) < 0 then
    Halt;
  if RegisterBGIdriver(@CGADriverProc) < 0 then
    Halt;
  ajusta_velocidade;
  fo := ' ';
  ci := #0+'H';
  ba := #0+'P';
  es := #0+'K';
  di := #0+'M';
  abrir_modo_grafico;
  carregar_graficos(blocmem,digitmem,conmem,bonmem,alimem,objmem);
  ler_pontuacoes;

  repeat
    menu(opcao,ci,ba,fo);

    case opcao of
      4 : jogar;
      1 : instruccoes(conmem,alimem,objmem);
      2 : begin
            cortina;
            definir_teclas(es,di,ci,ba,fo);
            cortina;
          end;
      3 : mostrar_pontuacoes;
    end;
  until opcao = 5;
  gravar_pontuacoes;
  CloseGraph;
  RestoreCrtMode;
end.
