unit labo1;

interface

uses graph,crt;

var fichgr : file;

procedure abrir_modo_grafico;
procedure som( freq,dur : integer);
procedure menu( var opcao : integer ; ci,ba,fo : string);
procedure _input( posx,posy : integer; var txt : string; pic : string);
procedure pedir_nivel( var nivel : longint);
procedure carregar_graficos(var blocmem,digitmem,conmem,bonmem,alimem,objmem : pointer);
procedure escrever_pontuacao( pontos : longint );
procedure moldura;

implementation


procedure abrir_modo_grafico;
var gd,gm   : integer;
begin
  gd := CGA;
  gm := 0;
  InitGraph(gd,gm,'');
  if GraphResult <> grOk then
    Halt(1);
end; { abrir_modo_grafico }


procedure som( freq,dur : integer);
begin
  Sound(freq);
  Delay(dur);
  NoSound;
end; { som }


procedure moldura;
begin
  SetViewPort(0,0,319,199,ClipOn);
  ClearViewPort;
  SetColor(1);
  Rectangle(0,0,319,199);
  SetColor(2);
  Rectangle(1,1,318,198);
end; { moldura }


procedure caixa( x,y : integer; texto : string );
var comprx,y1,y2 : integer;
begin
  comprx := (length(texto) * 8 + 12) div 2;
  y2 := y + 2;
  y1 := y - 12;
  SetColor(3);
  Rectangle(39,y1-1,281,y2+1);
  SetColor(0);
  Rectangle(38,y1-2,282,y2+2);

  SetColor(1);
  OutTextXY(x,y,texto);
end; { caixa }


procedure setas( opcao : integer);
var cy : integer;
begin
  cy := opcao * 20 + 70;
  OutTextXY(55,cy,#16#16);
  OutTextXY(265,cy,#17#17);
end; { setas }


procedure cursor(var opcao : integer; incr : integer);
begin
  SetColor(0);
  setas(opcao);
  opcao := opcao + incr;
  if opcao = 0 then
    opcao := 5;
  if opcao = 6 then
    opcao := 1;
  SetColor(3);
  setas(opcao);
  som(1000+200*opcao,30);
end; { cursor }


procedure menu( var opcao : integer ; ci,ba,fo : string);
var tecla : string;
begin
  moldura;
  SetTextJustify(1,0);
  SetTextStyle(TriplexFont,0,4);
  SetColor(0);
  OutTextXY(159,39,'L A B O');
  OutTextXY(163,43,'L A B O');
  SetColor(3);
  OutTextXY(160,40,'L A B O');
  SetColor(2);
  OutTextXY(161,41,'L A B O');
  SetColor(1);
  OutTextXY(162,42,'L A B O');

  SetTextStyle(DefaultFont,0,1);
  caixa(160,90,'INSTRUCCOES');
  caixa(160,110,'DEFINIR TECLAS');
  caixa(160,130,'TABELA DE PONTUACOES');
  caixa(160,150,'COMECAR JOGO');
  caixa(160,170,'SAIR PARA DOS');

  SetColor(2);
  OutTextXY(160,194,'(c) 1990 Rui Curado - SPOOLER');
  opcao := 1;
  cursor(opcao,0);
  repeat
    repeat until keypressed;
    tecla := readkey;
    if tecla = #0 then
      tecla := tecla + readkey;
    if tecla = ci then
      cursor(opcao,-1);
    if tecla = ba then
      cursor(opcao,1);
  until tecla = fo;
end; { menu }


procedure _input( posx,posy : integer; var txt : string; pic : string);
var c,cmax : integer;
    parar  : boolean;
    tecla  : char;

procedure por_caracter;
begin
  SetColor(1);
  OutTextXY(posx,posy,tecla);
  SetColor(2);
  OutTextXY(posx+1,posy,tecla);
  txt := txt + tecla;
  posx := posx + 9;
  inc(c);
  if c <= cmax then
    repeat
      if pos(pic[c],'9#ALNX!$*') = 0 then
        begin
          SetColor(1);
          OutTextXY(posx,posy,pic[c]);
          SetColor(2);
          OutTextXY(posx+1,posy,pic[c]);
          txt := txt + pic[c];
          posx := posx + 9;
          inc(c);
        end;
    until pos(pic[c],'9#ALNX!$*') > 0;

end; { por_caracter }


procedure apagar_caracter;
begin
  SetColor(0);
  posx := posx - 9;
  OutTextXY(posx,posy,txt[length(txt)]);
  OutTextXY(posx+1,posy,txt[length(txt)]);
  dec(c);
  delete(txt,length(txt),1);
  repeat
    if pos(pic[c],'9#ALNX!$*') = 0 then
      begin
        delete(txt,length(txt),1);
        posx := posx - 9;
        dec(c);
      end;
  until pos(pic[c],'9#ALNX!$*') > 0
end; { apagar_caracter }


begin
  parar := false;
  txt := '';

  cmax := length(pic);

  SetTextJustify(1,0);
  SetTextStyle(DefaultFont,0,1);
  for c := 1 to cmax do
    if pos(pic[c],'9#ALNX!$*') = 0 then
      begin
        SetColor(1);
        OutTextXY(c*9+posx,posy,pic[c]);
        SetColor(2);
        OutTextXY(c*9+posx+1,posy,pic[c]);
      end;
  c := 1;
  repeat
    repeat until keypressed;
    tecla := readkey;
    if ord(tecla) > 31 then
      if c <= cmax then
        begin
          if pic[c] = '9' then
            begin
              if pos(tecla,'0123456789') > 0 then
                por_caracter
            end
          else
            if pic[c] = 'X' then
              por_caracter
            else
              Som(2000,100);
    end;

    if ( ord(tecla) = 8 ) and ( c > 1 ) then
      apagar_caracter;

    if ord(tecla) = 13 then
      parar := true;

  until parar;

end; { _input }


procedure pedir_nivel( var nivel : longint);
var c,erro,estado         : integer;
    snivel,codigo,codigo2 : string;

procedure apagar_zona;
begin
  SetViewPort(44,174,276,186,ClipOn);
  ClearViewPort;
  SetViewPort(0,0,319,199,ClipOn);
end; { apagar_zona }


begin
  estado := 0;
  ClearViewPort;
  for c := 1 to 3 do
    begin
      SetColor(c);
      Rectangle(40+c,170+c,280-c,190-c);
    end;
  repeat
    SetColor(2);
    OutTextXY(135,185,'NIVEL A JOGAR :');
    GotoXY(16,19);
    _input(203,185,snivel,'99999');
    apagar_zona;
    val(snivel,nivel,erro);
    if nivel > 0 then
      begin
        calcular_codigo;
        SetTextStyle(DefaultFont,0,1);
        OutTextXY(125,185,'CODIGO DE ACESSO :');
        _input(213,185,codigo,'XXXX');
        apagar_zona;
        for c := 1 to 4 do
          if ord(codigo[c]) > 96 then
            codigo[c] := chr(ord(codigo[c]) - 32);
        if codigo = codigo2 then
          estado := 1;
      end
    else
      begin
        calcular_codigo;
        estado := 2;
      end;
  until estado <> 0
end; { pedir_nivel }


procedure carregar_graficos(var blocmem,digitmem,conmem,bonmem,alimem,objmem : pointer);
var tam : word;
begin
  tam := 21000;
  assign(fichgr,'labgraf.spr');
  reset(fichgr,1);
  GetMem(blocmem,tam);
  BlockRead(fichgr,blocmem^,tam,tam);
  close(fichgr);

  tam := 3450;
  assign(fichgr,'labdigit.spr');
  reset(fichgr,1);
  GetMem(digitmem,tam);
  BlockRead(fichgr,digitmem^,tam,tam);
  close(fichgr);

  tam := 2286;
  assign(fichgr,'labgraf2.spr');
  reset(fichgr,1);
  GetMem(conmem,tam);
  BlockRead(fichgr,conmem^,tam,tam);
  close(fichgr);

  tam := 560;
  assign(fichgr,'labo.spr');
  reset(fichgr,1);
  GetMem(bonmem,tam);
  BlockRead(fichgr,bonmem^,tam,tam);
  close(fichgr);

  tam := 6930;
  assign(fichgr,'aliens.spr');
  reset(fichgr,1);
  GetMem(alimem,tam);
  BlockRead(fichgr,alimem^,tam,tam);
  close(fichgr);

  tam := 630;
  assign(fichgr,'labobjec.spr');
  reset(fichgr,1);
  GetMem(objmem,tam);
  BlockRead(fichgr,objmem^,tam,tam);
  close(fichgr);

end; { carregar_graficos }


procedure escrever_pontuacao( pontos : longint );
var spontos : string;
    c       : integer;
begin
  SetViewPort(60,173,107,179,ClipOn);
  ClearViewPort;
  SetViewPort(0,0,319,199,ClipOn);
  str(pontos:6,spontos);
  for c := 1 to 6 do
    if spontos[c] = #32 then
      spontos[c] := #48;
  SetColor(2);
  OutTextXY(84,181,spontos);
end; { escrever_pontuacao }


end.
