program gravar_graficos_para_labo(input,output);

uses
   graph,crt;

type
  ficheiro = file;

var
  fich       : ficheiro;
  inicio,act : pointer;
  tam        : word;
  primeiro   : boolean;
  x,y        : integer;


procedure abrir_modo_grafico;
var gd,gm   : integer;
begin
  gd := CGA;
  gm := 1;
  InitGraph(gd,gm,'');
  if GraphResult <> grOk then
    Halt(1);
end; { abrir_modo_grafico }


procedure pedir_nome( var path : string);
begin
  OutTextXY(10,168,'Nome do fich :');
  GotoXY(17,22);
  readln(path);
  path := '\pic\' + path + '.pic';
end; { pedir_nome }


procedure por_imagem;
var c,tamanho : integer;
    d         : byte;
    imag      : pointer;
    path      : string;
begin
  pedir_nome(path);
  assign(fich,path);
  reset(fich,1);

  imag := ptr ($b800,$0000);
  tamanho := 7;
  BlockRead(fich,imag^,7,tamanho);
  imag := ptr ($b800,$0000);
  tamanho := 16384;
  BlockRead(fich,imag^,16384,tamanho);
end; { por_imagem }


procedure guardar;
var tam2 : word;
    lixo : string;
    c    : integer;
begin
  SetColor(0);
  str(tam,lixo);
  OutTextXY(250,190,lixo);
  tam2 := imagesize(x,y,x+23,y+23);
  Getmem(act,tam2);
  if primeiro then
    begin
      primeiro := false;
      inicio := act;
    end;
  GetImage(x,y,x+23,y+23,act^);
  tam := tam + tam2;
  Sound(2000);
  Delay(20);
  NoSound;
  SetWritemode(NormalPut);
  for c := 0 to 23 do
    Line(x,y+c,x+23,y+c);
  SetWritemode(XorPut);
  SetColor(2);
  str(tam,lixo);
  OutTextXY(250,190,lixo);
end; { guardar }


procedure editar;
var tecla : char;
    lixo  : string;
begin
  por_imagem;
  SetColor(2);
  OutTextXY(10,190,'SPACE para acabar');
  str(tam,lixo);
  OutTextXY(250,190,lixo);
  x := 81;
  y := 7;
  SetWriteMode(XorPut);
  repeat
    Rectangle(x,y,x+23,y+23);
    if keypressed then
      begin
        tecla := readkey;
        Rectangle(x,y,x+23,y+23);
        case tecla of
          'q' : y := y-24;
          'a' : y := y+24;
          'o' : x := x-24;
          'p' : x := x+24;
          'm' : guardar;
          'l' : por_imagem;
          #27 : Halt;
        end;
      end
    else
      Rectangle(x,y,x+23,y+23);
  until tecla = ' ';
  assign(fich,'labdigit.spr');
  rewrite(fich,1);
  Blockwrite(fich,inicio^,tam,tam);
end; { editar }


begin
  primeiro := true;
  tam := 0;
  abrir_modo_grafico;
  editar;
  repeat until keypressed;
end.