/* The game of Master Mind...copyright (c) 1990 by Richard F. Parker
   as a promotion for Thunderhead Software.  All rights reserved.
   This software and source are presented as freeware.  We ask for
   no money if you like this software, and you may distribute it in
   UNMODIFIED form wherever, whenever, however you wish, as long as
   our catalog and credits remain in place.  You may use the source
   code, as long as proper credit is given to the author, Rich Parker.

*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <time.h>

int goal[4], guess[11][4], temp[4], temp2[4];

int count, flag;

main()
{
    register int i, j;
    long int li;

    li = time(NULL); i = (unsigned int)li/2; srand(i);

    count = 1; flag = 0;

    for( i = 0; i < 3; i++ ) {
        goal[i] = rand() % 6;
        for( j = 0; j < 10; j++ ) guess[j][i] = 0;
    }

    scls();
    screen();
    while( count < 11 ) {
        inguess();
        analyze();
        count++;
    }
    sloc( 23, 30 ); sscs( 2, 8, 5 );
    printf( "Sorry, but you can not make any more guesses.\n");
    showgoal(); sscs( 1, 8, 1 );
    getch();
    done();
    exit(0);
}

screen()
{
    register int i;

    sloc( 1, 30 ); printf( "*** Master Mind ***\n");

    sloc( 3, 28 ); putch( 201 );
    for( i = 0; i < 22; i++ ) putch( 205 );
    putch(187);
    for( i = 4; i < 18; i++ ) {
        sloc( i, 28 ); putch( 186) ;
        sloc( i, 51 ); putch( 186 );
    }
    sloc( 18, 28 ); putch( 200 );
    for( i = 0; i < 22; i++ ) putch( 205 );
    putch( 188 );

    sloc( 4, 31 ); printf( "Game Board   Score" ); fflush(stdout);
    sloc( 5, 28 ); putch( 199 );
    for( i = 0; i < 22; i++ ) putch( 196 );
    putch( 182 );
    sloc( 3, 42 ); putch( 209 );

    for( i = 4; i < 18; i++ ) {
        sloc( i, 42 ); putch( 179 );
        if( i == 5 ) {
            sloc( 5, 42 ); putch( 197 );
        }
    }

    sloc( 18, 42 ); putch( 207 );
    sloc( 6, 32 ); printf( "? ? ? ?" ); fflush(stdout);
    sloc( 6, 43 ); printf( "! ! ! !" ); fflush(stdout);
    sloc( 7, 28 ); putch( 199 );
    for( i = 0; i < 22; i++ ) putch( 196 );
    putch( 182 );
    sloc( 7, 42 ); putch( 197 );

    sscs( 2, 8, 5 );
    sloc( 4, 5 ); printf( "Color Codes" );
    sloc( 5, 5 );
    for( i = 0; i < 11; i++ ) putch( 196 );
    sloc( 6, 5 ); sscs( 2, 1, 5 ); printf( "Black" );
    sloc( 7, 5 ); sscs( 2, 5, 1 ); printf( "bLue" );
    sloc( 8, 5 ); sscs( 2, 3, 5 ); printf( "Green" );
    sloc( 9, 5 ); sscs( 2, 2, 5 ); printf( "Red" );
    sloc( 10, 5 ); sscs( 2, 4, 5 ); printf( "Yellow" );
    sloc( 11, 5 ); sscs( 2, 8, 5 ); printf( "White" );
}

int ctab[6] = { 1, 5, 3, 2, 4, 8 };

inguess()
{
    register int i;
    char bull[20], c, v;

    sloc( 20, 1 ); sscs( 2, 8, 5 ); printf( "Your Guess: " ); fflush( stdout );
    gets( bull );

    sloc( 20, 1 );
    for( i = 0; i < 30; i++ ) putch( ' ' );

    flag = 0;

    for( i = 0; i < 4; i++ ) {
        c = toupper( bull[i] );
        switch( c ) {
            case 'B': v = 0; break;
            case 'L': v = 1; break;
            case 'G': v = 2; break;
            case 'R': v = 3; break;
            case 'Y': v = 4; break;
            case 'W': v = 5; break;
            default: flag = 1; break;
        }
        guess[count][i] = v;
    }

    for( i = 0; i < 4; i++ ) {
        sloc( 7+count, 32+2*i );
        sscs( 2, ctab[guess[count][i]], 5 );
        putch( 219 );
    }
}

analyze()
{
    register int i, j;
    int black, white;

    black = white = 0;
 
    for( i = 0; i < 4; i++ ) temp[i] = temp2[i] = 0;

    for( i = 0; i < 4; i++ ) {
        if( guess[count][i] == goal[i] ) {
            black++;
            temp[i] = 1; temp2[i] = 1;
        }
    }

    if( black <= 2 ) {
        for( i = 0; i < 4; i++ ) {
            for( j = 0; j < 4; j++ ) {
                if( guess[count][i] == goal[j] && temp[i] == 0 && temp2[j] == 0 ) {
                    white++; temp[i] = 1; temp2[j] = 1;
                }
            }
        }
    }

    if( black != 4 ) {
        flag = black + white;
        if( flag == 0 ) return;
        for( i = 0; i < flag; i++ ) {
            if( black > 0 ) {
                black--; sscs( 1, 1, 5 );
            }
            else if( white > 0 ) {
                white--; sscs( 1, 8, 5 );
            }
            sloc( 7+count, 43+2*i );
            putch(249);
        }
    }
    else {
        printf( "Winner\n"); showgoal(); sscs(1, 8, 1 );
        getch(); done();
        exit(0);
    }
}

showgoal()
{
    sloc( 6, 32 ); sscs( 2, ctab[goal[0]], 5 ); putch(219);
    sloc( 6, 34 ); sscs( 2, ctab[goal[1]], 5 ); putch(219);
    sloc( 6, 36 ); sscs( 2, ctab[goal[2]], 5 ); putch(219);
    sloc( 6, 38 ); sscs( 2, ctab[goal[3]], 5 ); putch(219);
}

sloc( x1, y1 )     /* Relocate the Cursor */
int x1, y1;
{
     printf("%c[%d;%dH", 27, x1, y1 );
     fflush(stdout);
}

sscs( a, f, b )     /* Select Color Scheme */
int a, f, b;
{
     if( a > 0 && a < 7 ) {
          putc( 27, stdout );
          putc( 91, stdout );
          switch(a) {
               case 1: putc( 48, stdout);
                    break;
               case 2: putc( 49, stdout);
                    break;
               case 3: putc( 52, stdout);
                    break;
               case 4: putc( 53, stdout);
                    break;
               case 5: putc( 55, stdout);
                    break;
               case 6: putc( 56, stdout);
                    break;
          }
          putc( 109, stdout );
     }
     if( f > 0 && f < 9 ) printf("%c[%dm", 27, f + 29 );
     if( b > 0 && b < 9 ) printf("%c[%dm", 27, b + 39 );
     fflush(stdout);
}

scls()     /* Clear the Screen */
{
     sscs( 2, 8, 5 );
     putc( 27, stdout ); putc( 91, stdout);
     putc( 50, stdout ); putc( 74, stdout);
     fflush(stdout);
}

done()
{
    scls();
    printf( "We hope you have enjoyed this game.  For more, and better games,\n");
    printf( "contact our COMMERCIAL software company: \n");
    printf( "           Thunderhead Software, Inc.\n");
    printf( "           P. O. Box 91\n");
    printf( "           McKeesport, Pa. 15135\n");
    printf( "           412-751-4020 voice\n");
    getch();
}

