{$D-}    {debug code? }
{$S-}    {Stack checking?}
{$R-}    {Range checking?}
{$I-}    {I/O checking?}
{$N-}    {Numeric coprocessor}


program SneeSnooSnake;

{ COPYRIGHT (C) 1986, 1987, 1990 BRUCE L. ROSENBERG }
{ last revised 8/23/90 }

Uses
  Crt, {Unit found in TURBO.TPL}
  Dos; {Unit found in TURBO.TPL}

const
   version = '5.0'; { current version of program }
   snakefile = 'SNAKE.DAT';  { filename where top 20 scores saved }
   lin = 6;  {length of straight line to keep from going back over self, i.e.,
              goes in straight line for LIN moves. }
   snlen = (2*lin)+1;  { length of snake, 2 times lin plus 1 }
   toplist = 1;
   botlist = 20;  { size of score list }
   namelen = 21;  { length of name & namearray for entry on score list }
   p = 1.112; { twelfth root of two squared for generating musical scale }
   IBMPCtime = 23.29; { time in sec. taken by IBM PC to do thisPCtime routine }
   Kbd_Int = 9;    { # of the hardware keyboard interrupt pointer }
   ScanCode : byte = 0;  { must be a typed constant for inline variable }
   HexDigit : ARRAY[0..15] OF Char = '0123456789ABCDEF';
   OrigWaitSn = 30.0;   { values which multiplied by CPUspeed determine waitsn }
   OrigWaitBag = 2.0;   { and waitbag values, i.e., how often snakebiz & bagbiz  }
                    { are executed.  Waitbag does not change during game,  }
                 { but waitsn decreases to increase snake speed (difficulty) }
   LongWaitSn = 30.0; { times CPUspeed determines minimum snake speed }
   ShortWaitSn = 5.0; { times CPUspeed determines maximum snake speed }
    {  4.3 snake moves/sec at slowest,  26 snake moves/sec at fastest  }
    { compared to a constant 60 bag moves per sec. no matter how fast snake }


type
    regrec = record
              ax,bx,cx,dx,bp,di,si,ds,es,flags: integer;
            end;
  snptr = ^snrec;
  snrec   = record
               x,y : shortint;
               next : snptr;
            end;
   namearray  = array [toplist..botlist] of string[namelen];
   scorearray = array [toplist..botlist] of real;
   speedarray = array [toplist..botlist] of real;
   namestr = string[namelen];
   censtr = string[80];
   rnamestr = string[6];
   string2  = string[2];
   string4  = string[4];

var
   autodem,demo,dying,deadly,bitten,NoFile,bagged,tooclose,soundon : boolean;
   ret2menu,quickout : boolean;
   wipetrail : boolean;
   CPUspeed,pscore,time,starttime : real;
   head, neck, tail : snptr;
   nsnakes,ndsnakes : integer;
   oldx,oldy,deltx,delty : shortint;
   SnooHead,SnooBody,SneeHead,SneeBody,menusel : char;
   BagCmd,SnooHdColor,SnooBdColor,SneeHdColor,SneeBdColor : byte;
   name : namearray;  score : scorearray; speed : speedarray;
   pname : namestr;
   rname : rnamestr;
   n2autodem,nticks : byte;
   dancedelay,nbites,ndbites : byte;
   blx,bly,oldblx,oldbly : shortint;
   waitbag,waitsn : integer;
   ns,minX,minY,maxX,maxY,oldtime : byte;
   btx,bty,nlen,n2die : byte;
   rslack,tcount,L,R,T,B,bagszx,bagszy,bitedx,bitedy : byte;
   ThisKey,robodelay : byte;
   nrobo,difbagged,oldbagged,nbagged : integer;
   autodelay,ncycles,supvtime,playtime,timeleft,elapsedtime  : integer;
   Kbd_Vec, Exit_Vec : Pointer;
   speedsn,maxWait,minWait,thisPCtime : real;
{============================================================================}
  FUNCTION HexByte(B : Byte) : string2;
  BEGIN
    HexByte := HexDigit[B SHR 4]+HexDigit[B AND $F];
  END;

  FUNCTION Hex(I : Word) : string4;
  BEGIN
    Hex := HexByte(Hi(I))+HexByte(Lo(I));
  END;
{----------------------------------------------------------------------------}
{$F+}  PROCEDURE My_Error; {$F-}
  BEGIN
    SetIntVec(Kbd_Int, Kbd_vec); {restore OLD INT9}
    IF (ExitCode <> 0) OR (ErrorAddr <> NIL) THEN
      BEGIN
        Assign(Output,'');
        ReWrite(OutPut);
        WriteLn(#7);
        IF ExitCode = $FF THEN
          WriteLn('USER BREAK')
        ELSE
          BEGIN
            WriteLn('Critical Error # ',HEX(ExitCode));
            Write('AT PROGRAM LOCATION ');
            WriteLn(HEX(seg(ErrorAddr^)),':',Hex(ofs(ErrorAddr^)));
          END;
      END;
    ExitProc := Exit_Vec;        {restore previous ExitProc}
  END;
{----------------------------------------------------------------------------}
  PROCEDURE CLI; INLINE($FA);
{----------------------------------------------------------------------------}
  PROCEDURE STI; INLINE($FB);
{----------------------------------------------------------------------------}
  PROCEDURE INT9_ISR(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
                     _SI, _DI, _DS, _ES, _BP:word);
  INTERRUPT;
  BEGIN
  Inline(
    $9C/              {PUSHF        ;Save flags}
    $E4/$60/          {IN   AL,$60  ;Read the keyboard port}
    $A2/>ScanCode/    {MOV  BYTE PTR [>ScanCode]; sole purpose of this ISR }
    (* ============================ *)
    (* CHAIN to the regular INT 9   *)
    (* ============================ *)
    $9D/              {POPF         ;Restore the flags}
    $A1/>KBD_VEC+2/   {MOV  AX,[>KBD_VEC+2] ;Old vector seg to AX}
    $8B/$1E/>KBD_VEC/ {MOV  BX,[>KBD_VEC]   ;Old vector ofs to BX}
    $87/$5E/$0E/      {XCHG BX,[BP+$0E] ;Swap ofs w/ return address}
    $87/$46/$10/      {XCHG AX,[BP+$10] ;Swap seg w/ return address}
    $89/$EC/          {MOV  SP,BP ;UNDO procedure's entry code}
    $5D/              {POP  BP}
    $07/              {POP  ES}
    $1F/              {POP  DS}
    $5F/              {POP  DI}
    $5E/              {POP  SI}
    $5A/              {POP  DX}
    $59/              {POP  CX}
    $CB);             {RETF ;in effect, JMP to old vector}
  END;
{----------------------------------------------------------------------------}
  FUNCTION KeyScan : Byte;
  BEGIN
    CLI; {Don't want it changing DURING this!}
    KeyScan := ScanCode;
    STI; {OK, can change now}
  END;
{----------------------------------------------------------------------------}
procedure initialize;
begin
   minX := 1;
   maxX := 78;  {hor. text screen limit, STARTS AT 1 at LEFT, NOT 0! }
   { don't use 80 because screen handler automatically puts in CR,LF }
   minY := 1;
   maxY := 24;   { vert. text screen limit, STARTS AT 1 at TOP, NOT 0! }
   {don't go to line 25 because screen control then starts scrolling }
   SnooBody := char(15);   { something like a big, hollow asterisk }
   SnooHead := char($8E);  { a capital A with two dots at top }
   SneeBody := '0';        { a zero }
   SneeHead := char(2);    { a happy face }
   SnooHdColor := white;
   SnooBdColor := cyan;
   SneeHdColor := lightred;
   SneeBdColor := lightgreen;
   quickout := false;
   autodem := true;
   n2autodem:= 10;
   autodelay := 1000;  { time between doticks for self-running prompt }
   playtime := 120; { 120 seconds or two minutes }
   robodelay := 1;
   rslack := 1;  { slack distance for robot movement }
   dancedelay := 20; { delay for snake dance rate }
   n2die := 5;   { # bites before die }
   bagszx := 3;  { bag size in x }
   bagszy := 2;  { bag size in y }
   bitedx := 5;  { snake striking distance in x }
   bitedy := 4;  { snake striking distance in y }
   supvtime := 3; { interval (seconds) at which supervisegame called }
   (*** this time interval is critical to the speed change algorithm ***)
end;   { initialize }
{============================================================================}
procedure initshow;
begin
   demo := true;
   playtime := 60; { changed from 120 seconds or two minutes }
   n2die := 3;   { # bites before die }
end;
{============================================================================}
function timer: real;
var
  regs:          regrec;             {assign record}
  ah,al       :   byte;
  hr,mn,sc,th :   byte;
begin
  ah := $2c;      { call DOS fcn to get system time }
  with regs do
  begin
    ax := ah shl 8 + al;
  end;
  intr($21,Dos.Registers(regs));                     {call interrupt}
  with regs do
  begin
    hr := cx shr 8;    { LO(cx) }
    mn := cx mod 256;  { HI(cx) }
    sc := dx shr 8;   { more significant byte }
    th := dx mod 256; { less significant byte }
  end;
  timer := ((hr*3600)+(mn*60)+sc)+(th/100); { returns time in seconds }
 end;                                     { function timer }
{----------------------------------------------------------------------------}
function monochrome: boolean;
var regs : regrec;
begin
    intr(17,Dos.Registers(regs));
    if (regs.ax) and $0030 = $30  then monochrome := true
    else monochrome := false;
end; { function monochrome }
{----------------------------------------------------------------------------}
procedure setvidmode;
var regs : regrec;
begin
  with regs do
  begin
      if monochrome then ax := $0007 else ax := $0003;
  end;  { with }
    intr(16,Dos.Registers(regs));
  end;  { procedure setvidmode }
{----------------------------------------------------------------------------}
procedure curson;
var regs : regrec;
begin
  with regs do
  begin
      ax := $0100;
      if monochrome then cx := $0B0C else cx := $0607;
  end;  { with }
    intr(16,Dos.Registers(regs));
  end;  { procedure curson }
{----------------------------------------------------------------------------}
procedure cursoff;
var regs : regrec;
begin
  with regs do
  begin
     ax := $0100;
     cx := $2000;
  end;  { with }
    intr(16,Dos.Registers(regs));
  end;  { procedure cursoff   }
{----------------------------------------------------------------------------}
procedure cen(cstring : censtr);
begin
    gotoxy(40-length(cstring) div 2,wherey);
    write(cstring);
end;
{----------------------------------------------------------------------------}
procedure cenln(cstring : censtr);
begin
    gotoxy(40-length(cstring) div 2,wherey);
    writeln(cstring);
end;
{----------------------------------------------------------------------------}
procedure censcr(cstring : censtr);
begin
    gotoxy(40-length(cstring) div 2,12);
    write(cstring);
end;
{----------------------------------------------------------------------------}
procedure upscale;
var
  n : byte;
  s : real;
begin
  n := 0;
  s:= 880.0;
for n := 1 to 12 do
   begin
    s := s*p;
   if soundon then sound(trunc(s));
    delay(30);
    nosound;
    delay(16-n);
   end;
end;
{----------------------------------------------------------------------------}
procedure dnscale;
var
  n : byte;
  s : real;
begin
  n := 0;
  s:= 1760.0;
for n := 1 to 12 do
   begin
    s := s/p;
   if soundon then sound(trunc(s));
    delay(30);
    nosound;
    delay(16-n);
   end;
end;
{----------------------------------------------------------------------------}
procedure uptweet;
var
  i : byte;
  s : real;
begin
    s := 1760.0;
      begin
        for i := 1 to 12 do
          begin
            s := s*p;
            if soundon then sound(trunc(s));
            delay((16-i));
          end;
       end;
    nosound;
end;
{----------------------------------------------------------------------------}
procedure dntweet;
var
  i : byte;
  s : real;
begin
    s := 3520.0;
      begin
        for i := 1 to 12 do
          begin
            s := s/p;
            if soundon then sound(trunc(s));
            delay((16-i));
          end;
       end;
     nosound;
end;
{----------------------------------------------------------------------------}
procedure dotick;
var
  s : real;
begin
    s := 1000.0;
      begin
        if soundon then sound(trunc(s));
	delay(4);
       end;
     nosound;
end;
{----------------------------------------------------------------------------}
procedure ClrKey;
begin
  memw[0:$41A] := memw[0:$41C]; { sets keyboard BIOS buffer head = tail }
                  { signalling empty status.  Don't put any delays here }
end;
{----------------------------------------------------------------------------}
procedure AutoContinue(tickdelay : integer);
VAR    timedout : boolean;
begin
   cursoff;
   ClrKey;
   timedout := false;
   nticks := 0;
   textcolor(white);textbackground(black);
   gotoxy(1,25);
   write('Press a key for menu, else --');
   gotoxy(40,25);
   write('RUN AUTO-DEMO');
   gotoxy(30,25);
   cursoff;
   repeat
     dotick;
     write('>');
     delay(tickdelay);
     nticks := succ(nticks);
     timedout := nticks = n2autodem;
   until timedout or keypressed;
   if not timedout then
     begin
       ClrKey;
       autodem := false
     end else
     autodem := true;
   curson;
   uptweet;
end;
{----------------------------------------------------------------------------}
procedure PressToContinue;
var trash : char;
begin
   curson;
   textcolor(white);textbackground(black);
   gotoxy(1,25);
   delay(500);
   while keypressed do trash := readkey;
   write('Press a key for menu --- ');
   ClrKey;
   repeat until keypressed;
end;
{----------------------------------------------------------------------------}
procedure menu; FORWARD;
{----------------------------------------------------------------------------}
procedure afterdeath;  { return to menu through here if killed }
var
  ncells : integer;
begin
   gotoxy(1,1);
   port[$3D9] := black;
   textcolor(0);
   for ncells := 1 to 2000 do write(char(219));
   curson;
   textbackground(black);
   textcolor(white);
end;
{============================================================================}
procedure ZeroScoreArray;
var
 n : byte;
begin
   for n := toplist to botlist do
     begin
       name[n] := '';
       repeat name[n] := name[n] + '.' until length(name[n]) = namelen;
       score[n] := 0.0;
       speed[n] := 0.0;
     end;
end;
{----------------------------------------------------------------------------}
procedure WriteScoreArray;
var
   infile : text;
   n : byte;
begin
   assign(infile,snakefile);
   rewrite(infile);
   for n := toplist to botlist do
      begin
       writeln(infile,name[n],' ',score[n],' ',speed[n]);
      end;
   close(infile);
end;
{----------------------------------------------------------------------------}
procedure ReadScoreArray;
var
   infile : text;
   n :byte;
begin
   assign(infile,snakefile);
  {$I-} reset(infile)  {$I+};   { check if the 'snake.dat' file exists. }
   NoFile := (IOresult = 2);
   if NoFile then               { if not, then create it  }
    begin
       zeroscorearray;
       writescorearray;
     end
     else
     close(infile); { When using autodemo I had to add this to prevent
                      "too many files open" error.}
   assign(infile,snakefile);    { NOW that it exists, we can read from it }
   reset(infile);                  { without crashing.  }
   for n := toplist to botlist do
      begin
       readln(infile,name[n],score[n],speed[n]);
      end;
   close(infile);
end;
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
function roboname : rnamestr;
type
  tristr     = string[3]  ;
var
  vowels        : string[7]  ;
  consonants    : string[20] ;
  rname1,rname2 : string[3];
  ch            : char;
{----------------------------------------------------------------------------}
procedure initrname;
begin
  consonants := 'bdfgklmnprssttvwz';
  vowels     := 'aaeeiou';
  randomize;
end;
{----------------------------------------------------------------------------}
function triad: tristr;
var tri : string[3]; v1,c1,c2 : integer;
begin
   c1 := 1+trunc(random(length(consonants)));
   v1 := 1+trunc(random(length(vowels)));
   c2 := 1+trunc(random(length(consonants)));
  tri := consonants[c1];
  tri := tri+ vowels[v1];
  tri := tri+ consonants[c2];
  triad := tri
end;

begin
  initrname;
  rname1 := triad;
  rname2 := triad;
  ch := char(ord(rname1[1])-$20); { capitalize first letter of name }
  rname1[1] := ch;
  roboname := rname1 + rname2;
end;  { function roboname }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
procedure robowrite;
var  numstr : string[3]; nr : integer;
begin
  textcolor(yellow);textbackground(black);
  nrobo := nrobo + 1;
  rname := roboname;
  str(nrobo:3,numstr);
  pname := 'I '+rname+', robot #'+numstr+',';
  for nr := 1 to length(pname) do
  begin
    write(pname[nr]);
    dotick;
    delay(200);
  end;
end;
{----------------------------------------------------------------------------}
procedure checkscore;
 var
   i,k,insertpos : byte;
   trash : char;
 begin
   port[$3D9] := blue;
   textcolor(yellow);textbackground(black);
   if (pscore < score[botlist]) or (pscore <= 0) then
   begin
     gotoxy(1,11);
     writeln
     ('Sorry Hunter, your score of ',pscore:5:2,' is not in the top 20.');
     if pscore < 0 then pscore := 0;
     ClrKey;
     if autodem then AutoContinue(150) else PressToContinue;
     exit;
   end
   else
   begin
       insertpos := toplist;
       if pscore > score[toplist] then
          begin
            gotoxy(1,11);
            writeln
            ('WOW! You scored ',pscore:5:2,'.  Hail the New Champion!');
          end
        else
         begin
            gotoxy(1,11);
            writeln
            ('Jolly Good!  Your score of ',pscore:5:2,' is in the top 20.');
         end;
         writeln;
         write('OK, SneeSnoo Snaker, enter your name here :');
         for i := 1 to namelen do write('.');
         write(':');
         gotoxy(wherex-(namelen+1),wherey);
         delay(1500);   { wait and clear keyboard buffer }
         while keypressed do trash := readkey;
	 if demo then robowrite else
         begin
	    readln(pname);   { player keys in name here from keyboard }
	    repeat pname := pname + '.' until length(pname) = namelen;
         end;

         while pscore < score[insertpos] do insertpos := succ(insertpos);
        { find insert position for name and score }
        { shift all down, starting at list bottom & losing lowest score }
         for k := botlist-1 downto insertpos do  { botlist > insertpos }
         begin                { ****  must run this loop from bottom up! }
           name[k+1] := name[k];
           score[k+1] := score[k];
           speed[k+1] := speed[k];
         end;
         score[insertpos] := pscore; { put new array values in their place }
	 name[insertpos] := pname;
	 speed[insertpos] := SpeedSN;
                  { SpeedSN := 100.0*(maxWait+minWait-waitsn)/(maxwait);}
   end;
end;
{----------------------------------------------------------------------------}
procedure listscores;
var
n : byte;
begin
  clrscr;
  textcolor(yellow);textbackground(black);
  port[$3D9] := blue;
  cenln('HERE  ARE  THE  SCORES  FOR');
  cenln('The  Top  20  SneeSnoo Snake Snatchers:');
  writeln;
  for n := toplist to botlist do
     begin
       gotoxy(1,n+3);
       write(n:2,'. ',name[n],' scored ',score[n]:5:1,' points per minute;');
       write(' final speed = ',speed[n]:5:1,'.');
     end;
   if autodem then AutoContinue(1000) else PressToContinue;
end;
{===========================    END SCOREBIZ    ==============================}
procedure SnakeBiz;
 FORWARD;
{----------------------------------------------------------------------------}
procedure die;
var
s : real;
ncells : integer;
nl,nshud : byte;
 begin
       s := 220;
       clrscr;
       gotoxy(1,1);
       port[$3D9] := 15;
       textcolor(15);
       textbackground(15);
       for ncells := 1 to 2000 do write(chr(219));
       textcolor(black);
       for nl := 1 to 16 do
        begin
          gotoxy(1,9 + nl);
          cen('                                                          ');
        end;
       gotoxy(1,15);
       cen('  YOUR WORLDLY PROBLEMS ARE OVER.  ');
       gotoxy(1,18);
       cen('  HUNTER, REST IN PEACE!  ');
       for nshud := 1 to 7 do
          begin
             s := s/p;
             if soundon then sound(trunc(s));
             delay(600+30*nshud);
          end;
        nosound;
      afterdeath;
end;
{----------------------------------------------------------------------------}
procedure newsnake;
begin
     randomize;
     dispose(@head);
     dispose(@neck);
     dispose(@tail);
     new(head);
     { create beginning position for snake }
     head^.next := head;
     tail := head;   { set all 3 pointers pointing to head memory location }
     neck := head;
     head^.x :=minX + trunc(random(maxX-minX)); { L border + random(rangeX)}
     head^.y :=minY + trunc(random(maxY-minY));
     deltx := trunc(random(3))-1; delty := trunc(random(3))-1;
     oldx := deltx; oldy := delty;
     nlen:=0;  wipetrail := false;
end;
{----------------------------------------------------------------------------}
procedure ChopTailNode;
begin
   gotoxy(tail^.x, tail^.y);
   write(chr(32)); { write blank over snake tail end }
   tail := tail^.next;  { link to record one up ahead }
   dispose(head^.next); { clear the old tail from heap memory }
   head^.next := tail;  { stores next value of tail ptr for disposal }
   dispose(@tail);
end;
{----------------------------------------------------------------------------}
procedure EraseOldSnake;
begin
   repeat   { erase old snake  }
     ChopTailNode;
   until head^.next = head;
 end;
{----------------------------------------------------------------------------}
procedure bagshut;
var
   ks : byte;
begin
   L := blx - bagszx; R := blx + bagszx;
   T := bly - bagszy; B := bly + bagszy;
   textcolor(white);
   gotoxy(L,T);  write(''); { scanwise order }
   gotoxy(R,T);  write('');
   gotoxy(L,B);  write('');
   gotoxy(R,B);  write('');
   uptweet;
   bagged :=((head^.x >= blx-bagszx) and
             (head^.x <= blx+bagszx) and
             (head^.y >= bly-bagszy) and
             (head^.y <= bly+bagszy));

 tooclose :=((head^.x >= blx-bitedx) and
             (head^.x <= blx+bitedx) and
             (head^.y >= bly-bitedy) and
             (head^.y <= bly+bitedy));

     if bagged then
       begin
           eraseOldSnake;
              if deadly then begin
                 ndsnakes := succ(ndsnakes);
                 L := blx - bagszx; R := blx + bagszx;
                 T := bly - bagszy; B := bly + bagszy;
                 textcolor(SnooBdColor);
                 gotoxy(L,T);  write(SnooBody); { scanwise order }
                 gotoxy(R,T);  write(SnooBody);
                 gotoxy(L,B);  write(SnooBody);
                 gotoxy(R,B);  write(SnooBody);
                 censcr('Snagged Snoo # ');
                 textcolor(SnooHdColor);
                 write(ndsnakes:2,' ',SnooHead);
                 uptweet;
                 upscale;
              end else begin
                 nsnakes := succ(nsnakes);
                 L := blx - bagszx; R := blx + bagszx;
                 T := bly - bagszy; B := bly + bagszy;
                 textcolor(SneeBdColor);
                 gotoxy(L,T);  write(SneeBody); { scanwise order }
                 gotoxy(R,T);  write(SneeBody);
                 gotoxy(L,B);  write(SneeBody);
                 gotoxy(R,B);  write(SneeBody);
                 censcr('Snatched Snee # ');
                 textcolor(SneeHdColor);
                 write(nsnakes:2,' ',SneeHead);
                 upscale; { message displayed while music plays }
              end;
                 gotoxy(10,12); clreol;
         end;  { bagged the snake }
     if  not bagged and tooclose then
        begin
            bitten := true;
            if not deadly then
              begin
               nbites := succ(nbites);
               { change bag temporarily when bitten }
               L := blx - bagszx; R := blx + bagszx;
               T := bly - bagszy; B := bly + bagszy;
               textcolor(SneeHdColor);
               gotoxy(L,T);  write(SneeHead); { scanwise order }
               gotoxy(R,T);  write(SneeHead);
               gotoxy(L,B);  write(SneeHead);
               gotoxy(R,B);  write(SneeHead);
               port[$3d9] := 4; { make border red }
               textcolor(SneeHdColor);
               censcr('Snee Bite!');
               dnscale;         { message displayed while music plays }
               port[$3d9] := 2; { make border green }
              end else
             begin
               ndbites := succ(ndbites);
               if ndbites = n2die then
                 begin
                   clrscr;
                   dying := true;
                   exit;
                  end;
               L := blx - bagszx; R := blx + bagszx;
               T := bly - bagszy; B := bly + bagszy;
               textcolor(SnooHdColor);
               gotoxy(L,T);  write(SnooHead); { scanwise order }
               gotoxy(R,T);  write(SnooHead);
               gotoxy(L,B);  write(SnooHead);
               gotoxy(R,B);  write(SnooHead);
               port[$3d9] := 15; { make border bright white }
               dntweet;
               gotoxy(28,12);
               write((n2die-ndbites):2,' More & You DIE!');
               dnscale;         { message displayed while music plays }
               port[$3d9] := 2; { make border green }
              end;   { if deadly }
            for ks := 1 to 40 do SnakeBiz; { make snake dance joyfully }
            nosound;  { turn snake dance sound off }
            gotoxy(10,12); clreol;
            bitten := false;
         end;  { bitten by snake }
 if bagged then
   begin
     newsnake; { generate new snake starting point }
     bagged := false;
   end;
end;     { procedure bagshut }
{----------------------------------------------------------------------------}
procedure fastout;
   begin
     clrscr;
     textcolor(white);textbackground(black);
     port[$3D9] := black;  { set border to black }
     curson; { turn cursor back on }
     quickout := true;
     { halt;      fast way out of the game if boss comes in }
   end;
{----------------------------------------------------------------------------}
function RobotsMove : byte;
VAR  diffX, diffY : integer;
begin
if (trunc(random(8)) > 5) then        { Was > 5 }

  begin
    L := blx-bagszx; R := blx+bagszx;  { L = left, R = right  }
    T := bly-bagszy; B := bly+bagszy;  { T =  top, B = bottom edges of bag }
    diffX := abs(head^.x - blx);  diffY := abs(head^.y - bly);

     if (((head^.x >= L-rslack) and
          (head^.x <= R {+rslack} ) and
          (head^.y >= T-rslack) and
          (head^.y <= B {+rslack} )) and (trunc(random(2)) > 0))
          then RobotsMove := 57;  { SPACE BAR = close bag }

    if diffX > (diffY*2) then
    begin     { move bag in the x direction }
     if (head^.x < L) then RobotsMove := 33; { F = move L }
     if (head^.x > R) then RobotsMove := 34; { G = move R }
    end else
    begin     { move bag in the y direction }
     if (head^.y < T) then RobotsMove := 19; { R = move U }
     if (head^.y > B) then RobotsMove := 47; { V = move D }
    end;
  end;
end;
{-----------------------------------------------------------------------------}
procedure BagBiz;
var
  BagCmd : byte;  
begin  { read keyboard for inputs controlling bag }

  BagCmd := 128;  { set initial value for BagCmd }
  blx := oldblx; bly := oldbly; { restore bag location to old }

  ThisKey := KeyScan;

  if Demo then BagCmd := RobotsMove;
  If ThisKey in [19,20,22,23,33,34,35,36,47,49,57] then
    BagCmd := ThisKey;

  { the int09 ISR routine getting KeyScan codes is a modified form of a
  Neil Rubenking program derived from ACCEL.PAS in KEYINT.ARC on
  compuserve Borland Programming A library #6 }

  ClrKey;  { this sets DOS kbd buffer head =  tail
              thus clearing it, prevents buffer overflow and beeping }
begin
  case BagCmd of
      33,35 : { F or H = bag left }
                begin
                  btx:=blx-1;
                  if btx-bagszx >= minX then blx := btx;
                end;
      34,36 :  { G or J = bag right }
                 begin
                   btx:=blx+1;
                   if btx+bagszx <= maxX+1 then blx := btx;
                 end;
      19,20,22,23 :   { R,T,U, or I = bag up }
                begin
                  bty:=bly-1;
                  if bty-bagszy >= minY then bly := bty;
                end;
      47,49 :   { V or N = bag down }
                begin
                  bty:=bly+1;
                  if bty+bagszy <= maxY then bly := bty;
                end;
        57 :   { spacebar to close bag }
             begin
               bagshut;   { close bag & determine results, }
                          { whether bagged, bitten and/or dying }
               if dying then
                 begin
                   EraseOldSnake;
                   exit;
                 end;
             end;

  128..255 :   begin end;
 end ;{ case }

         L := blx - bagszx; R := blx + bagszx;   { draw new bag  }
        T := bly - bagszy; B := bly + bagszy;
        textcolor(yellow);
        gotoxy(L,T);  write(''); { scanwise order }
        gotoxy(R,T);  write('');
        gotoxy(L,B);  write('');
        gotoxy(R,B);  write('');
     if not ((oldbly = bly) and (oldblx = blx)) then
        begin
           L := oldblx - bagszx; R := oldblx + bagszx; { erase old bag }
           T := oldbly - bagszy; B := oldbly + bagszy;
           textcolor(black);
           gotoxy(L,T);  write(''); { scanwise order }
           gotoxy(R,T);  write('');
           gotoxy(L,B);  write('');
           gotoxy(R,B);  write('');
         end;
 end; { if keypressed and case }
  oldblx := blx; oldbly := bly; { save old bag location for erasing bag }
end;  { procedure BagBiz and return to playgame  }
{----------------------------------------------------------------------------}
procedure updatetime;
begin
      time := timer;
      elapsedtime := trunc(time - starttime); {must take diff before trunc}
      timeleft := trunc(playtime-elapsedtime);
 end;
{----------------------------------------------------------------------------}
procedure computescore;
begin
      nbagged := nsnakes + (4 * ndsnakes) - nbites - (2 * ndbites);
      pscore := 60 * nbagged / elapsedtime;
end;
{----------------------------------------------------------------------------}
procedure displayscorebar;
begin
       gotoxy(1,25);
       textcolor(white);textbackground(black);
       write
       ('  Score=',pscore:5:1,'  Time=',timeleft:3);
       write
       ('   Bites Left=',(n2die-ndbites):2);
      speedsn := 100.0*(maxWait+minWait-waitsn)/(maxwait);
       write
       ('  Speed=',speedsn:5:1,'  ESC=DOS  0=MENU  Send $');
end; { do score bar at bottom of screen }
{----------------------------------------------------------------------------}
procedure GrowNewHead;
begin
 { the order of the following node (list) linking steps is critical }
     neck := head;   { neck now points to snake's old head record }
                     { "demote" the former head to being a neck }
     dispose(@head);
     new(head);       { allocate a new snake head record in heap }
     head^.x := neck^.x;
     head^.y := neck^.y; { fill new head record with old head fields }
     neck^.next := head;  { link neck (old head) to new head }
     head^.next := tail; { point new head^.next to the tail (circular list) }
end;
{----------------------------------------------------------------------------}
procedure SnakeBiz;
var
  xt, yt  : integer;
  membytes : real;
begin
   nlen := succ(nlen);  { nlen is counter for sn moves, snlen is max length }
   if (nlen > snlen) then nlen := 1;

   deltx := oldx; delty := oldy;    { let the new increments equal the old }

   { following generates change in X direction when snlen:=1 or if no change }
   { on previous execution,  allowing for occasional no change makes
     movement more interesting }
   if (nlen = 1) or (deltx = 0) then    { 0 means no change }
   deltx := trunc(random(3)) - 1; { gen new x incr, 0, 1, or 2; minus 1}
   xt := head^.x + deltx;  { the -1 shifts the increment, so +1 or -1 }
   if (xt > maxX) then deltx :=  trunc(random(2)) - 1; { scrn rt side limit }
   if (xt < minX) then deltx :=  trunc(random(2)); { scrn left side limit }

   { following generates change in Y direction when snlen:=5 or if no change }
   if (nlen = 6) or (delty = 0) then
   delty := trunc(random(3))-1;   {gen new y increment }
   yt := head^.y + delty;
   if (yt > maxY) then delty := trunc(random(2)) - 1; { screen bottom limit }
   if (yt < minY) then delty := trunc(random(2));    { screen top limit }

   head^.x := head^.x + deltx; { new x location of head }
   head^.y := head^.y + delty; { new y location of head }

   oldx := deltx; oldy := delty;  { remember the current increments }

   if (nlen = snlen) then wipetrail := true;
   if wipetrail then ChopTailNode;
   { start following the head, erasing last char
    once the snake has grown to full length }

     gotoxy(neck^.x,neck^.y);
     { overwrite the old head with body symbol }
     if deadly then
        begin
          textcolor(SnooBdColor);
          write(SnooBody);
        end else
        begin
          textcolor(SneeBdColor);
          write(SneeBody);
        end;

     gotoxy(head^.x,head^.y);
     if deadly then
        begin   { write head for poisonous snake }
           textcolor(SnooHdColor);
           write(snoohead); { face with fangs }
        end else
        begin   { write head for nonpoisonous snake }
           textcolor(SneeHdColor);
           write(sneehead);  { solid happy face }
        end;

     if bitten and not dying then
     begin
       if deadly and soundon then
       for ns := 1 to 10 do
         begin
           sound(trunc(random(2640))+1760);
           delay(1);
         end;
       if soundon then sound(trunc(random(2640))+1760);
       delay(20);
     end;   { IF BITTEN: DANCING SOUND FOR SNAKE AFTER BITING HUNTER }

     if not bagged or not dying then GrowNewHead;

end;   { SnakeBiz }
{============================================================================}
procedure AdjustSpeed;
var
  CurrWait,IncrWait,DecrWait : real;
begin
  CurrWait := waitsn / 1.0; { converts from integer to real number }
  if CurrWait <= 20 * CPUspeed then { if fast make change slower }
    begin

       DecrWait := CurrWait/16.0; { 16, % of delay is consistent
                            with psychophysical power (S. S. Stevens) law }
       IncrWait := CurrWait/20.0; { 32, gets harder faster than slows down}
     end else
     begin   { if slow make change faster }
        DecrWait := CurrWait/12.0;    { 8 }
        IncrWait := CurrWait/16.0;   { 16 }
     end;

   difbagged := nbagged - oldbagged;
   if difbagged >= 2 then CurrWait := CurrWait - DecrWait;
   { speeds up the snake when 2 or more points scored in 3 seconds }
   if difbagged <= 0 then CurrWait := CurrWait + IncrWait;
   { slows down the snake when zero or fewer points scored in 3 seconds.}
   { snake speed does not change when 1 point is scored in 3 seconds.}
   if CurrWait >= MaxWait then CurrWait := MaxWait;
   if CurrWait <= MinWait then CurrWait := MinWait;
   oldbagged := nbagged; { nbagged gets incremented in computescore }
   waitsn := round(CurrWait);
   {if CPUspeed=10, snake moves every 300th to 50th game cycle}

end;
{--------------------------------------------------------------------------}
procedure FinalScoreBiz;
begin
   readscorearray;  { read scores from SNAKEFILE file }
   checkscore; { compare present score with top 20, ask for name if in }
   if (pscore < score[botlist]) or (pscore <= 0) then exit;
   writescorearray;   { write new score array to disk }
   listscores;     { display new scores to player }
end;
{--------------------------------------------------------------------------}
procedure SuperviseGame;
begin
    {  every 3 seconds, display scores and determine whether to
         make snake deadly and/or to speedup or slowdown game }
    deadly := false;
    if elapsedtime > 0 then computescore;
    displayscorebar;
    if trunc(random(2)) = 1 then
    deadly := true; { make snake deadly half of the time }

    AdjustSpeed;
  end;
{--------------------------------------------------------------------------}
procedure setGameScrn;
begin
    port[$3D9] := GREEN; { SET BORDER COLOR }
    cursoff;
    textbackground(black);
    clrscr;
end;
{--------------------------------------------------------------------------}
procedure initgame;
begin
    MaxWait := LongWaitSn * CPUspeed;
    MinWait := ShortWaitSn * CPUspeed;
    WaitSn := round(MinWait+MaxWait/2);
               { start out with speed=50 }
    waitbag := round(OrigWaitBag * CPUspeed);
                { bag speed constant, not proportional to snake speed }
    nsnakes := 0; nbites := 0; ndsnakes := 0;  ndbites := 0;
    difbagged := 0; nbagged := 0; oldbagged := 0;
    blx := 40; bly := 12;  oldblx := 40; oldbly := 12;
    timeleft := playtime;
    starttime := timer; { gets time for start of game }
    time := timer;
    supvtime := 3;    { supervise game every three seconds, scorebar, etc. }
    tcount := 0; oldtime := 0; elapsedtime := 0;
    pscore := 0.0;
    bitten := false;
    deadly := false;
    dying := false;
    BagCmd := 128;
    minX := 1; minY := 1;
    maxX :=79; maxY :=24;
    quickout := false;
    ret2menu := false;
    ThisKey := 128;
end;
{--------------------------------------------------------------------------}
procedure exitgame;
begin
  clrscr; curson;
  finalscorebiz;
  textcolor(white);textbackground(black);
  port[$3d9]:=black;
  clrscr;
end;
{--------------------------------------------------------------------------}
procedure playgame;
begin
  initgame;
  setGameScrn;
  newsnake;

  repeat            {----- main arcade game loop -----}
    if ThisKey = 1 then
    begin   { ESC = boss coming abort to DOS }
      EraseOldSnake;
      fastout; { esc key to abort current game }
      exit;
    end else
    if ThisKey = 11 then
    begin   { 0 = return to MENU }
      EraseOldSnake;
      ret2menu := true;
      exit;
   end;
   ncycles := succ(ncycles);
   if (ncycles mod waitsn = 0) then  { "if" determines snake speed }
      begin
        snakebiz;  { move snake one head length }
      end;
    updatetime;
    if not bitten then
       if (ncycles mod waitbag = 0) then
       begin
         BagBiz; { determines bag speed }
       end;
    if dying or quickout or ret2menu then exit;
        { next 4 lines are logic for doing supervisegame
         once and only once every supvtime seconds }
    if elapsedtime > oldtime then tcount := succ(tcount);
    if (elapsedtime > oldtime) and (tcount = supvtime) then supervisegame;
       { skips line above if elapsedtime in seconds has not changed }
    if tcount > supvtime then tcount := 1;
    oldtime := elapsedtime;
    bitten := false;
    if ncycles = maxint then ncycles := 0;   { reset so don't exceed maxint }
  until timeleft <= 0;  {-- end of repeat-until loop - main playgame loop --}

  eraseOldSnake;  { game playing time expired so exit }
  if dying or quickout then exit;
  exitgame;
end;  { playgame and return to menu }
{============================================================================}
procedure intro;
var
  tc : byte;
  nw : integer;
begin

cursoff;
randomize;
dancedelay := 20;
textbackground(black);
clrscr;
port[$3D9] := 1+trunc(random(7));
gotoxy(1,2);
write('  ');
textcolor(SneeBdColor);
for nw := 1 to 11 do
  begin
    write(SneeBody);
    dotick;
    delay(50);
  end;
textcolor(SneeHdColor); write(SneeHead);
write('  S n e e  ');
if soundon then sound(880);
delay(1000);
nosound;
textcolor(SneeHdColor); write(SneeHead);
textcolor(SneeBdColor);
for nw := 1 to 11 do
  begin
    write(SneeBody);
    dotick;
    delay(50);
  end;
write('      ');

initgame;
bitten := true; dying := false;
minY := 3;  maxY := 24;
minX := 3;  maxX := 35;
deadly := false;    { make the snake a Snee-Snake }
newsnake;
for nw := 1 to 100 do snakebiz;
eraseOldSnake;
nosound;

gotoxy(43,2);
textcolor(SnooBdColor);
for nw := 1 to 11 do
  begin
    write(SnooBody);
    dotick;
    delay(50);
  end;
textcolor(SnooHdColor); write(SnooHead);
write('  S n o o  ');
if soundon then sound(660);
delay(1000);
nosound;
textcolor(SnooHdColor); write(SnooHead);
textcolor(SnooBdColor);
for nw := 1 to 11 do
  begin
    write(SnooBody);
    dotick;
    delay(50);
  end;

initgame;
bitten := true; dying := false;
minY :=  3;  maxY := 24;
minX := 45;  maxX := 77;
deadly := true;   { make the snake a Snoo-Snake }
newsnake;
for nw := 1 to 100 do snakebiz;
eraseOldSnake;
nosound;

window(10,5,20,12);
tc := 10+trunc(random(6));
textcolor(tc);
uptweet;
writeln('  0000    ');
writeln(' 0    00  ');
writeln(' 00       ');
writeln('   0000   ');
writeln('       00 ');
writeln('  00    0 ');
writeln('    0000  ');
delay(100);
window(23,5,31,12);
tc := 10 + (succ(tc) mod 6);
textcolor(tc);
dntweet;
gotoxy(1,3);
writeln(' 00000  ');
writeln('00   00 ');
writeln('00   00 ');
writeln('00   00 ');
writeln('00    00');
delay(100);
window(34,5,44,12);
tc := 10+ (succ(tc) mod 6);
textcolor(tc);
uptweet;
gotoxy(1,3);
writeln('  000     ');
writeln('00   00   ');
writeln('00   00   ');
writeln('00   000  ');
writeln('  000   00');
delay(100);
window(44,5,56,12);
tc := 10+ (succ(tc) mod 6);
textcolor(tc);
dntweet;
writeln('00          ');
writeln('  00        ');
writeln('   00   00  ');
writeln('    00 00   ');
writeln('    0000    ');
writeln('    00  000 ');
writeln('   00     00');
delay(100);
window(58,5,67,12);
tc := 10+ (succ(tc) mod 6);
textcolor(tc);
uptweet;
gotoxy(1,3);
writeln('  0000   ');
writeln('00    00 ');
writeln('00  000  ');
writeln(' 00      ');
writeln('   00000 ');
delay(100);
window(1,1,80,25);
gotoxy(69,5);
tc := 10+ (succ(tc) mod 6);
write('TM');
delay(100);
gotoxy(1,14);textcolor(lightred);cen('Version 5.0');
gotoxy(1,16);
cenln('Copyright (C) 1986, 1987, 1990 by Bruce L. Rosenberg');
gotoxy(1,19);
cenln('Version 5.0 of SNEESNOO SNAKE TM has arrived!');
cenln
('Alright, folks, here''s the scoop. I really want to run that');
cenln
('$10,000.00  INTERNATIONAL   S N E E S N O O   S N A K E  (TM)  CONTEST');
cenln
('by the end of 1990; but it''s up to you.  I need 5000 $8 checks to do it.');
cenln
('If you hotshot SNEESNOO SNAKERS want a chance at the prize, form a club!');
cenln
('Let the AUTO-DEMO run for a while.  Can you beat the Robot''s scores?');
gotoxy(1,25);
curson;
if autodem then AutoContinue(1500) else PressToContinue;
end;
{--------------------------------------------------------------------------}
procedure instruct;
begin
clrscr;
port[$3D9] := blue;  { sets border }
textcolor(lightred);
cenln(' INSTRUCTIONS  FOR  THE  GAME  OF  SNEESNOO SNAKE TM');
writeln;
textcolor(yellow);
writeln
('You are a herpetologist for Megalop Zoo.  Your assignment is to go to the ');
writeln
('Foetid Forest of Amazonia and catch rare SneeSnoo Snakes.  Poisonous Snoo''s');
write
('head is a white ');
write(SnooHead);
write(' & it''s body segments are cyan ');
write(SnooBody,'''s');
writeln('.  Nonvenomous Snee''s head''s');
write
('a red ',SneeHead,' & it''s body segments are green ');
write(SneeBody,'''s');
writeln('.  You control movement of a bag,');
writeln
('which is a rectangle.  To catch the snake you close the bag.  SneeSnoo can ');
writeln
('enter from any side.  Closing bag with the Snee head inside , gets 1 point,');
writeln
('or 4 points if a Snoo.  If outside bag, but within striking distance, it ');
writeln
('bites and you drop 1 point, 2 if venomous.  Five venomous bites & you  DIE!!');
writeln
('Your score is the total number of snake points per minute.  You have a time');
writeln
('limit.  Time in seconds remaining is shown in the lower right.  Good Luck!');
writeln;
textcolor(lightred);
cen('C O N T R O L    K E Y S');
writeln('                                                                               ');
cenln('R, T, U, I keys move bag up.');
cenln('V or N keys move bag down.  ');
cenln('F or H keys move bag left.  ');
cenln('G or J keys move bag right. ');
textcolor(lightgreen);
writeln;
cenln('Space bar closes bag.   During play ESC exits to DOS; 0 to MENU.');
writeln;
cenln('For hints on how to improve your score, etc., read Snake50.doc.');
if autodem then AutoContinue(1500) else PressToContinue;
end;
{----------------------------------------------------------------------------}
procedure moreinfo;
begin
port[$3D9] := blue;  { sets border }
clrscr;textcolor(lightred);
gotoxy(1,1);
cen(' FURTHER  INFORMATION  ON  THE  GAME  OF  SNEESNOO SNAKE TM ');
gotoxy(1,3);textcolor(yellow);
cenln
('This game was written in TurboPascal 5.5 (TM Borland International). ');
cenln
('It consists of about 1700 lines of code.  It is -not- freeware!  You may');
cenln
('try it on a temporary basis and share it with others.  If you use it a lot,');
cenln
('then please register and encourage development of further games by');
cenln
('the author.  It may be offered by user groups for a nominal fee & placed');
cenln
('on computer bulletin boards (BBS''s).  Consideration will be given to');
cenln
('offers from commercial firms regarding licensing on a royalty basis.');
cenln
('Send an $8.00 check to register, get latest version on disk, and to be');
cenln
('notified about the $10,000.00 INTERNATIONAL SNEESNOO SNAKE CONTEST. This');
cenln
('contest will be held after 5,000 people send $8 each.  It''s up to you!');
cenln(
'This offer is for personal use only. It is not a license for commercial use.');
writeln;
textcolor(lightred);
writeln
('Send inquiries and checks to:');
cenln('EXACT SOLUTIONS');
cenln('Bruce L. Rosenberg');
cenln('23 N. Chelsea Avenue');
cenln('Atlantic City, NJ 08401');
writeln;
textcolor(lightgreen);
cenln
('Further information on SneeSnoo Snake TM is available in Snake50.doc file.');
cenln
('Any suggestions for improvements or ideas for games can be mailed to');
cenln
('the above address,  via voice phone evenings at (609) 345-4712, or');
cenln
('leave message on Compuserve to 73547,402 or on BIX to Brucifer.');
if autodem then AutoContinue(1500) else PressToContinue;
end;
{----------------------------------------------------------------------------}
procedure AskSound;
var
  resp : char;
begin
clrscr;
soundon := false;
ClrKey;
write('Do you want sound? (Y or N) : ');
ClrKey;
repeat resp := readkey; until upcase(resp) in ['Y','N'];
if upcase(resp)='Y' then
   begin
     soundon := true;
      upscale;
   end;
writeln;
writeln;
end;
{----------------------------------------------------------------------------}
procedure options;
var
  resp : char;
begin
clrscr;
setvidmode;
port[$3D9] := blue;
AskSound;
writeln;
if not(monochrome) then
   begin
     write('You are using a CGA, EGA, or VGA adapter card.');
     textcolor(lightgreen);
     writeln;
     writeln('And this message should be green on color monitors.');
     writeln;
     textcolor(yellow);
    end else
    begin
      textcolor(15);
      writeln;
      Writeln('You are using a monochrome adapter (this should be bright).');
      textcolor(7);
      writeln('Whereas this message should be dim.');
      textcolor(yellow);
    end;
writeln;writeln;
write('Do you want to reset all the high scores? (Y or N) : ');
repeat resp := readkey until upcase(resp) in ['Y','N'];
if (upcase(resp) = 'Y') then
   begin
     writeln;writeln;
     textcolor(white);
     write('Press "Y" again to confirm : ');
     resp := 'N';
     repeat resp := readkey until upcase(resp) in ['Y','N'];
     if (upcase(resp) = 'Y') then
        begin
          zeroscorearray;
          writescorearray;
          writeln;writeln;
          textcolor(yellow);
          writeln('All scores set to zero, history about to be made.');
          writeln;writeln;
        end;  { confirm reset all scores }
     end; { first time ask reset scores }
     PressToContinue;
end;  { options }
{----------------------------------------------------------------------------}
procedure showoff;
begin
  initshow;
 repeat
  playgame;
  if not autodem or quickout or ret2menu then exit; if dying then die;
  instruct;
  if not autodem or quickout or ret2menu then exit;
  playgame;
  if not autodem or quickout or ret2menu then exit; if dying then die;
  intro;
  if not autodem or quickout or ret2menu then exit;
  playgame;
  if not autodem or quickout or ret2menu then exit; if dying then die;
  moreinfo;
  if not autodem or quickout or ret2menu then exit;
 until not autodem;
end;
{----------------------------------------------------------------------------}
procedure menu;
var  scanbyte : byte;
begin
   demo := false;
   autodem := false;
   clrscr;textcolor(yellow); port[$3D9] := blue;  { sets border }
   gotoxy(1,2);
   write
   ('   M A I N    M E N U   F O R   S N E E S N O O   S N A K E  (TM)  Ver.');
   write(version:4);
   gotoxy(1, wherey + 3);
   cen('1.  BEGINNING SCREEN   ');
   gotoxy(1, wherey + 2);
   cen('2.  GAME INSTRUCTIONS  ');
   gotoxy(1, wherey + 2);
   cen('3.  FURTHER INFORMATION');
   gotoxy(1, wherey + 2);
   cen('4.  PLAY GAME          ');
   gotoxy(1, wherey + 2);
   cen('5.  AUTO-DEMO          ');
   gotoxy(1, wherey + 2);
   cen('6.  DISPLAY SCORES     ');
   gotoxy(1, wherey + 2);
   cen('7.  CHANGE OPTIONS     ');
   gotoxy(1, wherey + 2);
   cen('8.  FAREWELL           ');
   gotoxy(1, wherey + 2);
   cen('ESC.  QUICK EXIT TO DOS');
   gotoxy(1,25);textcolor(white);
   curson;
   write('Please choose one of the above numbers (1 to 8) ... ');
     gotoxy(54,25);
     ClrKey;
     repeat
     menusel := readkey;
     scanbyte := keyscan;
     if scanbyte = 1 then
     begin
       menusel := '8';
       quickout := true;
       exit
     end;
     if not (menusel in ['1'..'8']) then
       begin
         gotoxy(54,25);
         write('Wrong key, try again. ');
         ClrKey;
         write(chr(7));
         gotoxy(54,25);
         clreol;
       end;
     until menusel in ['1' .. '8'];
     if soundon then
     begin
       dntweet;
       uptweet;
     end;
   case menusel of
         '1':  intro;
         '2':  instruct;
         '3':  moreinfo;
         '4':  begin
                 demo := false;
                 n2die := 5;
                 playtime := 120;
                 playgame;
                 if dying then die;
                 if quickout then
                 begin
                   menusel :='8';
                   exit;
                 end;
               end;
	 '5':  begin
		 autodem := true;
                 demo := true;
		 showoff;
                 if quickout then
                 begin
                   menusel :='8';
                   exit;
                 end;
	       end;
         '6':  begin
                 readscorearray;
                 listscores;
               end;
         '7':  options;
	 '8':  exit;
   end;
end;
{----------------------------------------------------------------------------}
procedure promoJingle;
begin
  writeln;
  write('                       S N E E ');
  if soundon then sound(880);
  delay(400);
  nosound; delay(400);
  write('S N O O   ');
  if soundon then sound(660);
  delay(400);
  nosound; delay(500);
  writeln('S N A K E  (TM)');
  if soundon then sound(770);
  delay(500);
  nosound; delay(600);
  writeln;
  cenln('A quality game brought to you by   E X A C T   S O L U T I O N S.');
  writeln;
  cen('Copyright (C) 1986, 1987, 1990  by Bruce L. Rosenberg');
end;
{----------------------------------------------------------------------------}
function chkCPUspeed : real;
var  init, fin : real;
     xc,yc,nc : integer;
begin
   initgame;
   minY := 13;  maxY := 24;
   minX := 20;   maxX := 50;
   deadly := false;    { make the snake a Snee-Snake }
   newsnake;
   init := timer;
   for nc := 1 to 200 do  { was 200 }
   begin
     snakebiz;
     if soundon then sound(trunc(random(2640)+1760));
     xc := 1;
     yc := 11;
     while xc < maxint div 50 do    { was 50 }
       begin
         xc := (((xc div yc)*yc)+ (xc mod yc));
         xc := xc+2;
         xc := xc-1;
       end;
   end;
  fin := timer;
  chkCPUspeed  := fin - init;
  eraseOldSnake;
  nosound;
end;
{----------------------------------------------------------------------------}
procedure prelimbiz;
begin
  textcolor(lightcyan);textbackground(black);
  port[$3D9] := lightmagenta; { sets border }
  nrobo := 0;
  AskSound;
  clrscr;
  cursoff;
  writeln;
  cenln('W E L C O M E   T O   T H E   G A M E   O F');
  delay(1000);
  promojingle;
  writeln; writeln; writeln;
  cenln('Please wait, adjusting game to compensate for CPU speed.');
  thisPCtime := chkCPUspeed;
  CPUspeed :=  IBMPCtime/thisPCtime;
  gotoxy(8,11);
  clreol;
  textcolor(yellow);
  write('Elapsed time = ',thisPCtime:5:3,' sec.  ');
  write('Speed Relative to IBM PC = ');
  write(CPUspeed:5:2);
  delay(1500);
  curson;
  AutoContinue(200);
  clrscr;
end;
{----------------------------------------------------------------------------}
procedure farewell;
begin
  cursoff;
  clrscr;
  port[$3D9] := blue;
  gotoxy(1,10);
  cenln('Thanks for playing');
  delay(1000);
  promojingle;
  delay(2000);
end;
{----------------------------------------------------------------------------}
BEGIN {MAIN PROGRAM}

  CheckBreak := TRUE;
  GetIntVec(Kbd_Int, Kbd_Vec);   {save "old" INT9 vector}
  SetIntVec(Kbd_Int, @INT9_ISR); {install new INT9 vector}
  Exit_Vec := ExitProc;          {save old ExitProc, built-in TPas vars}
  ExitProc := @My_Error;         {install new error pointer}
  CPUspeed := 1.0; { must init. CPUspeed here, prior to initgame }
  initialize;
  prelimbiz;   { check CPU speed so game will run same on all PCs. }
  readscorearray; {checks to see if file there, if not, makes it}
  intro; { display introductory screen }

  if autodem then showoff;
  if not quickout then repeat menu until (menusel = '8') or quickout;
  if not quickout then farewell;

  port[$3D9] := 0; {black border}
  textcolor(white);
  curson;
  normvideo;    { resets system to video mode it was in when pgm began }
  clrscr;
  {The interrupt vector gets RESTORED in the implicitly accessed ExitProc}
  END.
{============================================================================}
