 {streets and alleys solitaire in Turbo Pascal}
 program streets(play,deal,script);
  {$V-}
  uses crt;
  const brdbck=white; msgbck=black; msgtxt=white;
  {declarations}
   type
    msgtype= string[24];
    {aggregate types}
     cardrec= record suit,denom:byte; end;
     odtyp=file of cardrec;
     decktyp= array[1..52] of cardrec;
   var
    blanks: msgtype;
    pic: string[27];
    instring: string[9];
    nogood: string[5];
    {aggregate variables}
     deck: decktyp;
     deal: odtyp;
     play,script: text;
     piledepth:array[1..8] of byte;
     pilecons:array[1..8,1..19] of byte;
     pile: array[3..6] of 0..13;
    i,j,llo,n,npmid: byte; wk1:char;
    ni,nj,np,ptime: integer;
    autoplay,control,ingame,replay,waserr: boolean;
  {internal procedures}
   procedure shuffle;
    {shuffle deck of 52 cards}
    var i,j,t: byte;
    begin
     {swap card identities; don't rearrange cards}
     for i:=52 downto 3 do begin
      j := 1+random(i-1); t := deck[i].suit;
      deck[i].suit := deck[j].suit; deck[j].suit :=t;
      {swap denoms, having done suits}
       t := deck[i].denom;
       deck[i].denom := deck[j].denom;
       deck[j].denom :=t;
     end;
    end;
   procedure unload;
    {unload a deal to disk}
     var i: byte;
     begin
      rewrite(deal);
       for i:=1 to 52 do write(deal,deck[i]);
      close(deal);
     end;
   procedure reload;
    {reload a saved deal from disk}
     var i: byte;
     begin
      (*close(play);*) writeln(play); rewrite(play); llo:=0;
      reset(deal);
       for i:=1 to 52 do read(deal,deck[i]);
      close(deal);
     end;
   procedure create;
    {create deck of 52 cards in new deck order}
    var i: byte;
    begin
     for i:=1 to 52 do with deck[i] do begin
      suit:=3+((i-1) div 13);
      denom:=1+((i-1) mod 13);
     end;
     shuffle;
    end;
   procedure blankcard(p,n:byte);
    {blank a card on the table}
     var i,x,y:byte;
     begin
      if p<=4 then x := 4*p+2 else x := 4*p-14;
      if p<=4 then y := 2*n+1 else y := 79-2*n;
      for i:=0 to 1 do begin
       textbackground(brdbck);
       gotoxy(y,x+i); write(copy(blanks,1,2));
       textbackground(black);
      end;
     end;
   procedure posterror(message:msgtype);
    begin
     textcolor(msgtxt+blink);
      {make a raspberry}
      sound(50); delay(750); nosound;
      waserr:=true;
      write(play,'<==='); llo:=llo+4;
      gotoxy(1,23); write(message);
     textcolor(msgtxt);
    end;
   procedure showone(card,p,n:byte);
    {show a single card on the table}
    var x,y:byte;
    begin with deck[card] do begin
     textbackground(brdbck);
      if p<=4 then x := 4*p+2 else x := 4*p-14;
      if p<=4 then y := 2*n+1 else y := 79-2*n;
      if suit<=4 then
       textcolor(red)
      else
       textcolor(black);
      gotoxy(y,x); write(copy(pic,2*denom,2));
       gotoxy(y,x+1); write(' ',chr(suit));
     textbackground(black);
     textcolor(msgtxt);
     end end;
   procedure showtable;
    {display entire table on screen}
    var i,j: byte;
    begin {showtable}
     for i:=1 to 8 do begin
      for j:=1 to piledepth[i] do begin
       showone(pilecons[i,j],i,j);
      end;
     end;
    end;
   procedure speed;
    var ifr,ito,pfrom,pto:byte;
    begin
     val(instring[2],nj,ni);
 n:=nj; if ni<>0 then begin posterror('bad number of cards'); exit; end;
     val(instring[3],nj,ni);
 pfrom:=nj; if ni<>0 then begin posterror('bad from-pile'); exit; end;
     if n>piledepth[pfrom] then
      begin posterror('pile shallower than n'); exit; end;
     val(instring[4],nj,ni);
      pto:=nj; if ni<>0 then begin posterror('bad to-pile'); exit; end;
     i:=5; j:=1;
      while i<=length(instring) do begin
       val(instring[i],nj,ni);
        if ni<>0 then begin posterror('bad empty pile'); exit; end;
       i:=succ(i); j:=j+j;
       {check empties really are empty}
 if nj=pto then begin posterror('target cannot be an e'); exit; end;
 if piledepth[nj]<>0 then begin posterror('non-empty pile'); exit; end;
      end;
     if n>j then {can't move so many in empties}
      begin posterror('too little motility'); exit; end;
     for i:=1 to n-1 do begin
      {checking sequential order of moving set}
      if deck[pilecons[pfrom,piledepth[pfrom]-i]].denom<>
       deck[pilecons[pfrom,piledepth[pfrom]]].denom+i then
        begin posterror('pile not in sequence'); exit; end;
     end;
     if piledepth[pto]>0 then begin
      {checking denomination of to-card}
       ifr:=pilecons[pfrom,piledepth[pfrom]-n+1];
       ito:=pilecons[pto,piledepth[pto]];
       if deck[ifr].denom+1<>deck[ito].denom then
        begin posterror('move not to sequence'); exit; end;
     end;
     for i:=1 to n do begin
 pilecons[pto,piledepth[pto]+i]:=pilecons[pfrom,piledepth[pfrom]-n+i];
      showone(pilecons[pto,piledepth[pto]+i],pto,piledepth[pto]+i);
      blankcard(pfrom,piledepth[pfrom]-n+i);
     end;
     piledepth[pto]:=piledepth[pto]+n;
     piledepth[pfrom]:=piledepth[pfrom]-n;
    end;
   procedure piletomid(pfrom:byte);
    var card: byte;
    begin
     {play card from table to aces foundation at middle}
     card:=pilecons[pfrom,piledepth[pfrom]];
     {legal move?}
      if piledepth[pfrom]=0 then begin
       posterror('from pile empty'); exit
      end;
      if pile[deck[card].suit]+1<>deck[card].denom then begin
       posterror('move not in sequence'); exit
      end;
     npmid:=succ(npmid);
     pile[deck[card].suit]:=deck[card].denom;
     blankcard(pfrom,piledepth[pfrom]);
     piledepth[pfrom]:=pred(piledepth[pfrom]);
     {output foundation change}
      textbackground(brdbck);
       if deck[card].suit<=4 then
        textcolor(red)
       else
        textcolor(black);
       gotoxy(40,4*deck[card].suit-6);
        write(copy(pic,2*deck[card].denom,2),chr(deck[card].suit));
       textcolor(msgtxt);
      textbackground(black);
    end;
   procedure piletopile(pfrom,pto:byte);
    {play from pile to pile on table}
     var ifr,ito: byte;
     begin {piletopile}
      ifr:=pilecons[pfrom,piledepth[pfrom]];
      if piledepth[pto]>0 then
      ito:=pilecons[pto,piledepth[pto]];
      {is move o.k. to do?}
       if piledepth[pfrom]=0 then begin
        posterror('from pile empty'); exit
       end
       else
        if piledepth[pto]>0 then
        if deck[ifr].denom+1<>deck[ito].denom then begin
         posterror('move not in sequence'); exit
        end;
      {update layout controls to reflect move}
       piledepth[pto]:=succ(piledepth[pto]);
       pilecons[pto,piledepth[pto]]:=ifr;
       showone(ifr,pto,piledepth[pto]);
       blankcard(pfrom,piledepth[pfrom]);
       piledepth[pfrom]:=pred(piledepth[pfrom]);
     end;
  {main routine}
   begin
    textbackground(brdbck); clrscr;
     assign(deal,'streets.dck');
     assign(play,'streets.ply');
    val(paramstr(1),ptime,ni);
    replay:=false; control :=true; autoplay := false;
    textcolor(black);
    gotoxy(1,1); write('want a replay?(r/n)');
    readln(instring);
    if (instring[1]='R') or (instring[1]='r') then begin
     replay:=true;
     gotoxy(1,1); write('any autoplay of it?(y/n)');
     readln(instring);
     if (instring[1]='Y') or (instring[1]='y') then begin
      assign(script,'streets.ans');
      autoplay:=true; reset(script);
     end
     else autoplay:=false;
    end;
    blanks:='                        ';
    pic := '  A 2 3 4 5 6 7 8 910 J Q K';
    randomize;
    create;
    while control do begin
     {initialization}
      textbackground(brdbck); clrscr;
       rewrite(play);
       textcolor(black);
      nogood := chr(10)+chr(13)+' <=';
      npmid:=0; llo:=0;
     ingame:=true;
     for i:=3 to 6 do pile[i]:=0;
     np:=1; i:=1;
     while np<=52 do begin
      j:=1;
      while (np<=52) and (j<=8) do begin
       if j<=4 then gotoxy(1,2+4*j) else gotoxy(80,4*j-14);
       write(j:1);
       pilecons[j,i]:=np;
       piledepth[j]:=i;
       np:=succ(np); j:=succ(j);
      end;
      i:=succ(i);
     end;
     gotoxy(1,1);
     write('Numbers[1..8] are: f: from-pile; t: to-pile; ',
      'n: number cards; e: empty-pile.');
     gotoxy(1,2);
      write('Letters are:      S: speed move; M: middle;  Q: quit.');
       gotoxy(1,3);
        write('Valid commands are: ft, fM, Snftee.., Q.');
     if replay then reload else begin; shuffle; unload; end;
     showtable;
      {loop acting on instructions}
       while ingame do begin
        gotoxy(40,23);
        if not waserr then write(blanks);
        waserr:=false;
        gotoxy(40,23);
        if autoplay then begin
         instring:=''; read(script,wk1);
         repeat
          if pos(wk1,nogood) = 0 then instring:=instring+wk1;
          read(script,wk1);
          if eoln(script) then readln(script);
         until wk1=';';
         write(instring);delay(ptime);
         if eoln(script) then readln(script);
         if eof(script) then autoplay:=false;
        end
        else readln(instring);
        write(play,instring,'; '); llo:=llo+length(instring)+2;
        if llo>=70 then begin
         writeln(play); llo:=0;
        end;
        gotoxy(1,23);
        write(blanks);
        case instring[1] of
         '1'..'8':begin
          val(instring[1],nj,ni); i:=nj;
          delete(instring,1,1);
          if pos('M',instring)+pos('m',instring)>0 then begin
           piletomid(i);
           if npmid=52 then begin
            textcolor(white+blink);
            gotoxy(1,23); write('YOU WON <====',blanks);
            delay(5000); ingame:=false;
            textcolor(white);
           end;
          end
          else begin
           if instring[1]=' ' then delete(instring,1,1);
           val(instring[1],nj,ni);
           if ni<>0 then posterror('bad second number');
           j:=nj; piletopile(i,j);
          end
         end;
         's','S':begin
          speed;
         end;
         'q','Q':begin
          ingame:=false;
         end;
         else begin
          posterror('bad first character');
         end;
        end;
       end;
     writeln(play);
     {ask if want to play again}
      replay:=false;
      gotoxy(1,23); write('play again? (y/n/r)',blanks);
       gotoxy(40,23); readln(instring);
        gotoxy(40,23); write(blanks);
      gotoxy(1,23); write(blanks);
       if (instring[1]='N') or (instring[1]='n') then
        control := false;
       if (instring[1]='R') or (instring[1]='r') then
        replay:=true;
    end;
    close(play);
   end.
