#include "wand_hea.h"
#include <curses.h>

extern int debug_disp;
extern int edit_mode;
extern char screen_name[61];
extern char *edit_memory, *memory_end;
extern WINDOW *win,*displaywin,*mapwin,*infowin;
extern WINDOW *messagewin;
extern int pause2;
extern int pause1;

void draw_object(y,x,glyph)
int x,y;
char glyph;
{
	wmove(win,y,x);
	waddch(win,glyph);
}

void map(row_ptr)
char (*row_ptr)[ROWLEN+1];
{
    int  x, y;
    char ch;

    draw_object(0,0,'+');

    for (x = 0; x < ROWLEN; x++)
	waddch(win,'-');
   waddch(win,'+');

    for (y = 0; y < NOOFROWS; y++) {
      draw_object(y+1,0,'|');

    

	for (x = 0; x < ROWLEN; x++) {
	    ch = (*row_ptr)[x];
	    if (ch == '@')
		{
		wattron(win,A_BOLD);
		waddch(win,ch);
		wattroff(win,A_BOLD);
		continue;
		}
	    if (!debug_disp) {
		if ((ch == 'M') || (ch == 'S'))
		    ch = ' ';
		waddch(win,ch);
	    } else if (ch != '\0')
		waddch(win,ch);
	    else
		waddch(win,'"');
	}
	waddch(win,'|');
	row_ptr++;
    }
    draw_object(y+1,0,'+');
    for (x = 0; x < ROWLEN; x++)
	waddch(win,'-');
    waddch(win,'+');
    wrefresh(win);
    if (!debug_disp) {
	wmove(messagewin,0,0);
	waddstr(messagewin,"Press any key to return to the game.");
	wrefresh(messagewin);
	wgetch(messagewin);
	wmove(messagewin,0,0);
	waddstr(messagewin,"                                    ");
	wrefresh(messagewin);
	for (y = 0; y <= (NOOFROWS+1); y++) {
	    wmove(win,y,0);
	    for (x = 0; x <= (ROWLEN+2); x++)
		waddch(win,' ');
	}
    } 
}

void display(cx, cy, row_ptr)
char (*row_ptr)[ROWLEN+1];
int  cx, cy;
{
    static int init=0;
    int  x, y = 0,
	 x_coord, y_coord;
    char ch;

    while (y < (cy-3)) {
	y++;
	row_ptr++;
    }
    wmove(win,0,0);
    waddstr(win,"+---------------------------------+");
    wmove(win,15,0);
    waddstr(win,"+---------------------------------+");
    wrefresh(win);
    for (y = (cy-3); y <= (cy+3); y++) {
	y_coord = (y+3-cy)*2;
	if ((y < 0) || (y >= NOOFROWS)) {
	    wmove(win,y_coord+1,0);
	    waddstr(win,"|#################################|");
	    wmove(win,y_coord+2,0);
	    waddstr(win,"|#################################|");
	} else {
	    wmove(win,y_coord+1,0);
	    waddch(win,'|');
	    wmove(win,y_coord+1,34);
	    waddch(win,'|');
	    wmove(win,y_coord+2,0);
	    waddch(win,'|');
	    wmove(win,y_coord+2,34);
	    waddch(win,'|');
	    for (x = (cx-5); x <= (cx+5); x++) {
		x_coord = (x+5-cx)*3;
		if ((x < 0) || (x > ROWLEN-1))
		    draw_symbol(x_coord,y_coord,'#');
		else {
		    ch = (*row_ptr)[x];
		    draw_symbol(x_coord,y_coord,ch);
		}
	    }
	    row_ptr++;
	}	/* end if */
    }	/* end y loop */
    wmove(win,16,0);
    wrefresh(win);

    if(init == 0)
	{
	init = 1;
	wmove(messagewin,0,0);
	waddstr(messagewin,"Press ? for help. Press # for map mode.");
	wrefresh(messagewin);
	}
}

void redraw_screen(bell, maxmoves, num, score, nf, diamonds, mx, sx, sy, frow)
int *bell, maxmoves, num, nf, diamonds, mx, sx, sy;
long score;
char (*frow)[ROWLEN+1];
{
char buffer[50];

    wclear(infowin);
    if(!edit_mode)
      {
      sprintf(buffer,"screen %d",num);
      wmove(infowin,0,0);
      waddstr(infowin,buffer);
      }
    wmove(infowin,1,0);
    if ((screen_name[0] == '#') || (screen_name[0] == '\0'))
	waddstr(infowin,"no name                          ");
    else
	waddstr(infowin,screen_name);
    sprintf(buffer,"score = %d ",score);
    wmove(infowin,2,0);
    waddstr(infowin,buffer);
    sprintf(buffer,"diamonds = %d/%d   ",nf,diamonds);
    wmove(infowin,3,0);
    waddstr(infowin,buffer);
    wmove(infowin,4,0);
    if (maxmoves != -1)
       sprintf(buffer,"max moves = %d",maxmoves);
    else
       sprintf(buffer,"max moves = no limit");
    waddstr(infowin,buffer);
    wmove(infowin,5,0);
    if(*bell)
     waddstr(infowin,"bell on");
    else 
     waddstr(infowin,"bell off");

/*    if (edit_memory)  { */
	wmove(infowin,7,0);
	waddstr(infowin,"MEMORY: ( Start, ) End,");
	wmove(infowin,8,0);
	waddstr(infowin,"* Play, & Extend.");
	wmove(infowin,9,0);
	waddstr(infowin,"- Chkpt, + Cont.");
	wmove(infowin,10,0);
	if (memory_end == edit_memory)
	    waddstr(infowin,"--Empty--");
	else
	    waddstr(infowin,"-Occupied-");
        wmove(infowin,11,0);
        waddstr(infowin,"> Speed up < Slow down ");
        wmove(infowin,12,0);
        sprintf(buffer,"Play pause = %d",pause2);
        waddstr(infowin,buffer);
	sprintf(buffer,"Animation delay = %d ",pause1);
        wmove(infowin,14,0);
        waddstr(infowin,buffer);
 

    wrefresh(infowin);

    if (!debug_disp)
        {
        win=displaywin;
	display(sx,sy,frow);
        }
    else
        {
        win=mapwin; 
	map(frow);
        }

}

int inform_me(s, qable)
char *s;
int qable;
{
    int retval = 0;

    wmove(messagewin,0,0);
#ifdef TVI
    waddstr(messagewin,TVI);
#endif
    wstandout(messagewin);
    waddstr(messagewin,s);
#ifdef NOTVI
    waddstr(messagewin,NOTVI);
#endif
    wstandend(messagewin);
    waddstr(messagewin," <MORE>");
    if (qable)
	waddstr(messagewin," (q stops)");
    wrefresh(messagewin);
    if (wgetch(messagewin) == 'q')
	retval = 1;
    wmove(messagewin,0,0); waddstr(messagewin,"                                                         ");
    wrefresh(messagewin);
    return (retval);
}
