#include "wand_hea.h"
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <curses.h>

#ifdef TOS
#include <keycodes.h>
extern long _stksize = 50000L;
#endif

extern char *playscreen();
extern int rscreen();
extern int savescore();
extern void map();
extern void check_legality();
int err;
int debug_disp = 0;
char screen[NOOFROWS][ROWLEN+1];
int edit_mode = 0;
int saved_game = 0;
char *edit_screen = (char *) 0;
char *edit_memory = (char *) 0;
char *memory_end = (char *) 0;
char screen_name[61] ;
int record_file = -1;
long dictsize = 0L;
FILE *dictfp;
WINDOW *win,*mapwin,*displaywin,*infowin;
WINDOW *messagewin;
int old_score=0;
int pause1 = 30; /* delay time for moving objects */
int pause2 = 50; /* delay time for playback */
int recording=0; /* need to link it also with fall.c */

int readline(fd, ptr, max)
int fd, max;
char *ptr;
{
    int count = 0;
    while (read(fd,ptr,1) == 1) {
	if (++count == max)
	    break;
	if (*ptr=='\n')
	    break;
	ptr++;
    }
    *ptr = '\0';
    return count;
}

show_credits(opt)
int opt;
{
    int maxlines, linecount;
    FILE *fp;
    char ch, buffer[100];
#ifdef TOS
    long i;	/* index used to approximate half second between scrolls */
#else
    int inp, nul;
    struct timeval tv;
#endif

    sprintf(buffer,"%s/credits",SCREENPATH);
    if ((fp = fopen(buffer,"r")) == NULL) {
	printf("Sorry - credits unavailable!\n");
	exit(1);
    }
    initscr();
    win = stdscr;
    CBON;
    noecho();
    maxlines = /* tgetnum("li") - 3;*/ 21;
    linecount = 0;
#ifndef TOS
    nul = 0;
    tv.tv_sec = 0;
    tv.tv_usec = 500000L;	/* half second between scrolls */
#endif
    while (fgets(buffer,100,fp)) {
	addstr(buffer);
	if (!opt) {
	    if (++linecount == maxlines) {
		move(maxlines + 2,0);
		addstr("-- More --");
		refresh();
		ch = getch();
		if (ch == 'q') break;
		move(maxlines + 2,0);
		addstr("          ");
		refresh();
		clear();
		linecount = 0;
	    }
	} else {
#ifdef TOS
	    printf("%s",buffer);
	    for (i = 0; i < 110000; i++);
	    if (console_input_status(0)) {	/* if character is available */
		read(0,&ch,1);
		if (ch == 'q') break;
	    }
#else
	    inp = 1;
	    printf("%s",buffer);
	    /* select(1,&inp,&nul,&nul,&tv); SS compiler in compatibility */
	    if (inp) {
		read(0,&ch,1);
		if (ch == 'q') break;
	    }
#endif
	}
    }
    CBOFF;
    echo();
    if (!opt) {
	move(maxlines+2,0);
	refresh();
    }
    endwin();
}

extern int optind, opterr;
extern char *optarg;

main(argc, argv)
int  argc;
char **argv;
{
    char (*frow)[ROWLEN+1] = screen;
    long score = 0;
    int fp, num = 1, bell = 0, maxmoves = 0, x, y;
    char howdead[25], buffer[100], *name, *keys, *dead;
    char c, *malloc();
    struct stat statbuf;

    keys = (char *) 0;
    memory_end = edit_memory = malloc(EMSIZE * sizeof(char));
    while ((c = getopt(argc,argv,"01k:et:r:fmCcvs")) != -1)
	switch (c) {
	case '0': bell = 0; break;
	case '1': bell = 1; break;
	case 'k': keys = optarg; break;
	case 'm': erase_scores();
		exit(0);
	case 'c': show_credits(0);
		exit(0);
	case 'C': show_credits(1);
		exit(0);
	case 's': savescore("-",-1L,-1,"-");
		exit(0);
	case 'f': debug_disp = 1; break;
	case 'v':
         printf("\nWANDERER Copyright (C) 1988 S. Shipway. Version %s.\n\n",VERSION);
 	 printf("Adapted for MSDOS in protected mode (using DJGPP).\n");
         printf("by seymour.shlien@crc.doc.ca\n");
 	 exit (0);

	case 'e': edit_mode = 1;
	    break;

	case 't': edit_screen = optarg;
	    debug_disp = edit_mode = 1;
	    rscreen(0,&maxmoves);
	    initscr();
            win = stdscr;
	    map(frow);
	    check_legality();
	    move(21,0); refresh();
	    endwin();
	    exit(0);
	default:
	    fprintf(stderr,"Usage: %s [ -e | -m | -C | -c | -s | [ -f ] | -t file ] [ -0 | -1 ] [ -k keys ] [ file ]\n",argv[0]);
	    exit(1);
	}

    if (optind < argc) edit_screen = argv[optind];

/* bjr@watserv1.waterloo.edu, added the following to fix password searching.
   To properly search the 'words' dictionary, the size of the file
   is needed.  As a result, there are now five conditions (there were
   originally two,) under which passwords will be disabled.
	1. The program was run with flag -e (screen editor)
	2. The file no_pws is present in the screens directory
	3. A stat() call on the dictionary file fails
	4. The dictionary file cannot be opened using fopen()
	5. The dictionary is empty (0 bytes)
   The variable no_passwords has been replaced by dictsize.  If
   dictsize = 0, passwords are disabled. */

    if (!edit_mode) {
	sprintf(buffer,"%s/no_pws",SCREENPATH);
#ifdef TOS
	if ((fp = open(buffer,O_RDONLY)) < 0)	/* if no_pws does not exist */
#else
	if ((fp = open(buffer,O_RDONLY)) == -1)	/* if no_pws does not exist */
#endif
	 {err = stat(DICTIONARY,&statbuf);
	  if (err == 0)	/* and we can stat dictionary */
		if ((dictfp = fopen(DICTIONARY, "r")) != NULL) /* and open */
		    dictsize = statbuf.st_size; /* save size */
	  
	 close(fp);
         }
    }

    if ((name = (char *)getenv("NEWNAME")) == NULL)
	if ((name = (char *)getenv("NAME")) == NULL)
	    if ((name = (char *)getenv("FULLNAME")) == NULL)
		if ((name = (char *)getenv("USER")) == NULL)
		    if ((name = (char *)getenv("LOGNAME")) == NULL)
#ifdef	ASKNAME	/* M001 */
		    {
			name = malloc(80L);
			if (name == NULL) {
			    printf("malloc error\n");
			    exit(1);
			}
			printf("Name? "); fflush(stdout);
			scanf("%s",name);
			if (name[0] == '\0')
			    name = "noname";
		    }
#else
			name = "noname";
#endif

    if (!keys)
	if ((keys = (char *)getenv("NEWKEYS")) == NULL) {
	    keys = malloc(5);
 	    strcpy(keys,"kjhl");	    
	}

#ifdef TOS
/* bind the cursor keys to the movement keys.  Also, bind */
/* the HELP key to the '?' command. */
    {
    char key[2] = "?";
    key[0] = keys[0]; console_set_key(CURS_UP, key, NULL, NULL);
    key[0] = keys[1]; console_set_key(CURS_DN, key, NULL, NULL);
    key[0] = keys[2]; console_set_key(CURS_LF, key, NULL, NULL);
    key[0] = keys[3]; console_set_key(CURS_RT, key, NULL, NULL);
    console_set_key(K_HELP, "?", NULL, NULL);
    }
#endif

    initscr();
    win = stdscr;
    displaywin = stdscr;
    mapwin = stdscr;

    start_color();
    infowin = newwin(19,32,0,45);

    displaywin = newwin(17,36,0,0);
    init_pair(1,COLOR_WHITE,COLOR_BLACK);
    init_pair(2,COLOR_RED,COLOR_WHITE);
    wbkgd(displaywin,COLOR_PAIR(2)); 
    err=keypad(displaywin,1); /* enable function/arrow keys */

    mapwin = newwin(18,42,0,0);
    init_pair(3,COLOR_BLUE,COLOR_YELLOW);
    wbkgd(mapwin,COLOR_PAIR(2));
    err=keypad(mapwin,3); /* enable function/arrow keys */

    messagewin = newwin(5,70,20,0);

    if (!edit_mode)
      win = mapwin;


/* MAIN PROGRAM HERE */

    CBON; noecho();

    if (!edit_mode) {
	for (;;) {
	    if (rscreen(num,&maxmoves)) {
		strcpy(howdead,"a non-existant screen");
		break;
	    }
	    dead = playscreen(&num,&score,&bell,maxmoves,keys);
	    if ((dead != NULL) && (*dead == '~')) {
		num = (int)(dead[1]) - 1;
		dead = NULL;
	    }
	    if (dead != NULL) {
		strcpy(howdead,dead);
#ifdef FRIENDLY
		if(retry(name,howdead)==1) break;
		else num--;
#else
		break;
#endif
	    }
	    num++;
	}
    } else {
	if (rscreen(num,&maxmoves)) {
	    for (x = 0; x < ROWLEN; x++)
		for (y = 0; y < NOOFROWS; y++)
		    screen[y][x] =  ' ';
	}
	editscreen(num,&score,&bell,maxmoves,keys);
    }
/* END OF MAIN PROGRAM */

/* SAVE ROUTINES FOR SCORES */

    if (!edit_mode) {
	if ((savescore(howdead,score,num,name) == 0) && (score != 0))
	    printf("\nWARNING: %s : score not saved!\n",argv[0]);
    }

    echo();
    CBOFF;
    endwin();
    printf("WANDERER (C) 1988 S. Shipway. DJGPP MSDOS version by S.Shlien (1997).\n");
    if (record_file != -1) close(record_file);
    if (!dictsize) fclose(dictfp);	/* bjr */
#ifdef TOS
    if (!strcmp(argv[0], "")) {		/* probably run from the desktop */
	printf("Press any key to end...");
	c = getch();
    }
#endif	/* TOS */
}

int retry(name,howdead,score)
char *name,howdead[];
int *score;
{	char ans;
	wclear(messagewin);
	wattron(messagewin,A_BOLD);
        wmove(messagewin,0,0);
	waddstr(messagewin,name);
        waddstr(messagewin," killed by ");
        waddstr(messagewin,howdead);
	wattroff(messagewin,A_BOLD);
        wmove(messagewin,1,0);
	ans = ' ';
	waddstr(messagewin,"Do you want to exit?");
	wrefresh(messagewin);
	ans = wgetch(messagewin);
	while (ans !='n' && ans != 'y')
		{
		waddstr(messagewin,"Enter y or n :");
		ans = wgetch(messagewin);
		}
	wclear(messagewin);
	wrefresh(messagewin);
        if (ans == 'y') return 1;
	else {*score = old_score; return 0;}
}
	
