
   DIM STATIC PName$(5), PrizeName$(5,5), BoardScore%(5), _
              GameScore&(5),FreeSpin%(5), WheelPrice%(5,20), _
              WheelColor%(20), PrizeCoord%(5,5), SpeedCo%(60), _
              PrizesAvail$(40), PrizePrice%(40), PrizeDesc$(40), SpeedY%(60)
   Vers$ = "Ver: 1.0.A"
   GOSUB InitMain
   GOSUB SetUpDefaultSettings
   GOSUB PrepDataFile
   GOSUB PrepNewGame
   FOR GameCount% = 1 to 5
      GOSUB PrepNewBoard
      GOSUB PlayOneBoard
   NEXT
   GOSUB PlaySpeedRound
   COLOR LYellow%,0
   LOCATE 2,18
   PRINT SPACE$(60);
   LOCATE 2,18
   PRINT "Well this Game's Over. Hope you had fun ...............";
   K$=FnWantExit$
   CLOSE
   RUN
'=============================================================================
ParseSpeedDots:
   DotCount%=0
   SpeedY%(0)=1
   SpeedCo%(0)=1
   For C%=1 to LEN(Dots$)
      IF Mid$(Dots$,C%,1)=CHR$(254) THEN
         Incr DotCount%
         SpeedY%(DotCount%)=C%+12
         SpeedCo%(DotCount%)=C%
      END IF
   NEXT
RETURN
'=============================================================================
TestND:
   SpeedSuccess%=True%
   For C%=1 to DotCount%
      IF MID$(ND$,SpeedCo%(C%),1) = MID$(Puzzle$,SpeedCo%(C%),1) THEN _
                     MID$(Dots$,SpeedCo%(C%),1) = MID$(Puzzle$,SpeedCo%(C%),1)
      IF MID$(Dots$,SpeedCo%(C%),1) = CHR$(254) THEN SpeedSuccess%=False%
   NEXT
   ND$ = Dots$
RETURN
'=============================================================================
DoSpeedGet:
   locate 1,1 : print dotcount%
   ND$=Dots$
   GOSUB TestND
   COLOR 15,0
   LOCATE 16,13 : PRINT SPACE$(55);
   LOCATE 16,13 : PRINT ND$;
   CurrSpeedCoor%=1
   IF Lvl$="E" THEN
      K% = FnStartTimer%(121)
   ELSE
      IF Lvl$="A" THEN K% = FnStartTimer%(61) ELSE K% = FnStartTimer%(46)
   END IF
   While (FnSecondsElapsed%(10,59)>0) AND (SpeedSuccess%=False%)
      LOCATE 16,SpeedY%(CurrSpeedCoor%)
      COLOR 0,15 : PRINT MID$(ND$,SpeedCo%(CurrSpeedCoor%),1);
      K$=""
      WHILE K$=""
         K$=UCASE$(INKEY$)
         IF FnSecondsElapsed%(10,59) = 0 THEN K$=CHR$(13)
      WEND
      IF K$=CHR$(13) THEN
         GOSUB TestND
         COLOR 15,0
         LOCATE 16,13 : PRINT SPACE$(55);
         LOCATE 16,13 : PRINT ND$;
      ELSE
         IF INSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZ'",K$)>0 THEN _
                                        MID$(ND$,SpeedCo%(CurrSpeedCoor%),1)=K$
      END IF
      LOCATE 16,SpeedY%(CurrSpeedCoor%)
      COLOR 15,0 : PRINT MID$(ND$,SpeedCo%(CurrSpeedCoor%),1);
      IF K$=CHR$(8) THEN DECR CurrSpeedCoor% ELSE Incr CurrSpeedCoor%
      IF CurrSpeedCoor%>DotCount% THEN CurrSpeedCoor%=1
      IF CurrSpeedCoor%<1 THEN CurrSpeedCoor%=DotCount%
   WEND
RETURN
'=============================================================================
PlaySpeedRound:
   SpeedRound%=True%
   GOSUB ShowSpeedScreen
   GOSUB SetUpPuzzle
   GOSUB ParseSpeedDots
   GOSUB Collect5N1
   GOSUB ShowSpeedText
   GOSUB ShowSpeedLetters
   GOSUB DoSpeedGet
   If SpeedSuccess%=True% THEN
      LOCATE 20,10
      FOR C%=1 to 4
         COLOR 31,0 : PRINT " Winner ";
         COLOR 16,7 : PRINT " Winner ";
      NEXT
      LOCATE 22,10
      IF Clr% THEN COLOR HYellow%,0
      PRINT Pname$(WinningPly%);
      IF Clr% THEN COLOR LGreen%,0
      PRINT " ...... Total Winnings = ";
      IF Clr% THEN COLOR HYellow%,0
      PRINT USING "##,###,###"; GameScore&(WinningPly%)+25000
      GOSUB SoundWeHaveAWinner
   ELSE
      LOCATE 20,10
      IF Clr% THEN COLOR LGreen%,0
      PRINT "Answer:  ";
      IF CLR% THEN COLOR HYellow%,0
      PRINT GuessTest$;
      IF Clr% THEN COLOR HGreen%,0
      LOCATE 22,10 : PRINT "Sorry ..... Better Luck Next Time!!!";
      GOSUB SoundWrongGuess
   END IF
RETURN
'=============================================================================
PlayOneBoard:
   GOSUB DefineFirstPlayer
   WinningPly%=0
   WHILE Puzzle$<>Dots$
      GOSUB ShineCurrPlayer
      CollectAction:
         K%=FnStartTimer%(0)
         IF FnConstLeft%=True% THEN
            Act$= FnDialog1$("SGB","<S>pin  <G>uess  <B>uy-Vowel : ",1)
            TurnDone% = False%
            SELECT CASE Act$
               CASE "S" : GOSUB Spin
               CASE "G" : GOSUB Guess
               CASE "B" : GOSUB BuyVowel
            END SELECT
            IF TurnDone%=False% THEN GOTO CollectAction
         ELSE
            X$=FnMsg$("ONLY VOWELS LEFT! One Guess per Player")
            GOSUB SoundVowelsOnlyLeft
            X$=FnAnyKey$(13,47)
            FOR VL%=1 to QntPly%
               X$=FnMsg$(PName$(CurrPly%)+" ... Your turn to GUESS")
               GOSUB SoundVowelsOnlyPlayerXGuess
               X$=FnAnyKey$(13,47)
               GOSUB Guess
               IF Puzzle$=Dots$ THEN
                  VL%=QntPly%+1
               ELSE
                  GOSUB IncrCurrPlayer
                  GOSUB ShineCurrPlayer
               END IF
            NEXT
            IF Puzzle$<>Dots$ THEN
               LOCATE 5,4 : COLOR 31,0 : PRINT Puzzle$;
               Dots$=Puzzle$
               WinningPly%=0
               X$=FnMsg$("No One Wins ......... ")
               GOSUB SoundNoOneWins
               X$=FnAnyKey$(13,47)
            END IF
         END IF
         IF Puzzle$<>Dots$ THEN GOSUB IncrCurrPlayer
   WEND
   FOR C%=1 to QntPly%
      IF WinningPly%<>C% THEN
         PrizeName$(C%,GameCount%)="        "
         PrizeCoord%(C%,GameCount%) = 0
      END IF
   NEXT
   GameScore&(WinningPly%)=GameScore&(WinningPly%)+BoardScore%(WinningPly%)
   GOSUB ShowGameWinnings
   IF GameCount%=5 THEN _
      X$=FnMsg$("   ------- Game Over ------- ") _
      ELSE X$=FnMsg$("Ready for the Next Round!!!!")
   GOSUB SoundBoardOverOrGameOver
   X$=FnAnyKey$(13,47)
RETURN
'=============================================================================
DEF FnConstLeft%
   LOCAL C%,ConstLeft%
   SHARED Dots$, Puzzle$, True%, False%
   ConstLeft%=False%
   FOR C%=1 to LEN(Dots$)
      IF MID$(Dots$,C%,1)=CHR$(254) THEN
         IF INSTR("BCDFGHJKLMNPQRSTVWXYZ", MID$(Puzzle$,C%,1))>0 THEN
            ConstLeft%=True%
            C%=LEN(Dots$)+1
         END IF
      END IF
   NEXT
   FnConstLeft%=ConstLeft%
END DEF
'=============================================================================
Spin:
   GOSUB SpinWheel
   IF (WheelPrice%(GameCount%,WheelPointer%))<1 THEN GOTO SpecialSpinAction
   FinishSpinAfterPrizeAward:
      Choice$=FnDialog1$("BCDFGHJKLMNPQRSTVWXYZ","What Letter? : ",2)
      IF FnHiliteChoice$(True%,Choice$)<>Choice$ THEN
         X$=FnMsg$("Opps! Letter { "+Choice$+" } already used!")
         GOSUB SoundOppsLetterAlreadyUsed
         X$=FnAnyKey$(13,47)
         X$=FnHiliteChoice$(False%,Choice$)
         TurnDone%=True%
      ELSE
         LtrsPlaced%=0
         FOR C%=1 to LEN(Puzzle$)
            IF MID$(Puzzle$,C%,1)=Choice$ THEN
               INCR LtrsPlaced%
               Mid$(Dots$,C%,1)=Choice$
               COLOR 15,0
               LOCATE 4,4 : PRINT Dots$;
               COLOR 31,0
               LOCATE 5,3+C% : PRINT CHR$(24);
            END IF
         NEXT
         IF LtrsPlaced%=0 THEN
            X$=FnMsg$("Sorry! No letter { "+Choice$+" } in puzzle!")
            GOSUB SoundNoSuchLetterInPuzzle
            X$=FnAnyKey$(13,47)
            TurnDone%=True%
         ELSE
            X$=FnMsg$("Good Guess! You win .....$")
            PRINT Using "##,###";(LtrsPlaced% * _
                                        WheelPrice%(GameCount%,WheelPointer%));
            BoardScore%(CurrPly%)=BoardScore%(CurrPly%)+(LtrsPlaced% * _
                                        WheelPrice%(GameCount%,WheelPointer%))
            GOSUB ShowBoardWinnings
            GOSUB SoundGoodGuessLetterInPuzzle
            X$=FnAnyKey$(13,47)
            LOCATE 5,4 : PRINT SPACE$(55);
         END IF
         X$=FnHiliteChoice$(False%,Choice$)
      END IF
      IF ((FreeSpin%(CurrPly%)>0) AND (TurnDone%=True%)) THEN
         Ans$ = FnDialog1$("YN","Want to use a FREE SPIN? (Y-N) : ",4)
         IF Ans$="Y" THEN
            DECR FreeSpin%(CurrPly%)
            GOSUB ShowFreeSpins
            X$=FnMsg$("Okay SAME PLAYER Again! ")
            GOSUB SoundSamePlayerAgain
            X$=FnAnyKey$(13,47)
            TurnDone%=False%
         END IF
      END IF
RETURN
'=============================================================================
Guess:
   TurnDone%=True%
   K%=FnStartTimer%(60)
   Guess$=FnCollectGuess$
   IF GuessTest$ = Guess$ THEN
      LOCATE 5,4 : COLOR 31,0 : PRINT Puzzle$;
      Dots$=Puzzle$
      WinningPly%=CurrPly%
      X$=FnMsg$("CORRECT!......... We Have A Winner!")
      GOSUB SoundWeHaveAWinner
      X$=FnAnyKey$(13,47)
   ELSE
      LOCATE 5,23 : IF Clr% THEN COLOR Hred%,0 ELSE COLOR 15,0
      PRINT "Sorry ..... Wrong!";
      GOSUB SoundWrongGuess
      X$=FnAnyKey$(6,27)
      LOCATE 5,23 : COLOR 15,0 : PRINT "                  ";
      LOCATE 6,27 : PRINT "          ";
   END IF
RETURN
'=============================================================================
BuyVowel:
   IF BoardScore%(CurrPly%)<250 THEN
      X$=FnMsg$("Sorry! Not enough money to buy a Vowel!")
      GOSUB SoundNoMonyToBuyVowel
      X$=FnAnyKey$(13,47)
   ELSE
      Choice$=FnDialog1$("AEIOU","Buy what Vowel? : ",3)
      IF FnHiliteChoice$(True%,Choice$)<>Choice$ THEN
         X$=FnMsg$("Opps! Vowel { "+Choice$+" } already used!")
         GOSUB SoundOppsLetterAlreadyUsed
         X$=FnAnyKey$(13,47)
         X$=FnHiliteChoice$(False%,Choice$)
         TurnDone%=True%
      ELSE
         LtrsPlaced%=0
         FOR C%=1 to LEN(Puzzle$)
            IF MID$(Puzzle$,C%,1)=Choice$ THEN
               INCR LtrsPlaced%
               Mid$(Dots$,C%,1)=Choice$
               COLOR 15,0
               LOCATE 4,4 : PRINT Dots$;
               COLOR 31,0
               LOCATE 5,3+C% : PRINT CHR$(24);
            END IF
         NEXT
         IF LtrsPlaced%=0 THEN
            X$=FnMsg$("Sorry! No Vowel { "+Choice$+" } in puzzle!")
            GOSUB SoundNoSuchLetterInPuzzle
            X$=FnAnyKey$(13,47)
            TurnDone%=True%
         ELSE
            X$=FnMsg$("Vowels Cost $250")
            GOSUB SoundBoughtAVowel
            X$=FnAnyKey$(13,47)
            BoardScore%(CurrPly%)=BoardScore%(CurrPly%) - 250
            GOSUB ShowBoardWinnings
            LOCATE 5,4 : PRINT SPACE$(55);
         END IF
         X$=FnHiliteChoice$(False%,Choice$)
      END IF
   END IF
RETURN
'=============================================================================
SpecialSpinAction:
   ON (ABS(WheelPrice%(GameCount%,WheelPointer%))) GOTO DoBankrupt, _
                                             DoLoseTurn, DoFreeSpin, DoPrize
      '=======================================================================
      DoBankrupt:
         X$=FnMsg$("You're BANKRUPT!!")
         GOSUB SoundBankrupt
         X$=FnAnyKey$(13,47)
         BoardScore%(CurrPly%)=0
         GOSUB ShowBoardWinnings
         PrizeName$(CurrPly%,GameCount%)="        "
         PrizeCoord%(CurrPly%,GameCount%)=0
         LOCATE 15, ((CurrPly%-1)*11)+4
         PRINT "        ";
         IF FreeSpin%(CurrPly%)>0 THEN
            Ans$ = FnDialog1$("YN","Want to use a FREE SPIN? (Y-N) : ",4)
            IF Ans$="Y" THEN
               DECR FreeSpin%(CurrPly%)
               GOSUB ShowFreeSpins
               X$=FnMsg$("Okay SAME PLAYER Again! ")
               GOSUB SoundSamePlayerAgain
               X$=FnAnyKey$(13,47)
            ELSE
               TurnDone%=True%
            END IF
         ELSE
            TurnDone%=True%
         END IF
      RETURN
      '=======================================================================
      DoLoseTurn:
         IF FreeSpin%(CurrPly%)>0 THEN
            Ans$ = FnDialog1$("YN","Want to use a FREE SPIN? (Y-N) : ",4)
            IF Ans$="Y" THEN
               DECR FreeSpin%(CurrPly%)
               GOSUB ShowFreeSpins
               X$=FnMsg$("Okay SAME PLAYER Again! ")
               GOSUB SoundSamePlayerAgain
               X$=FnAnyKey$(13,47)
            ELSE
               TurnDone%=True%
            END IF
         ELSE
            TurnDone% = True%
            X$=FnMsg$("You lose your Turn!")
            GOSUB SoundLoseTurn
            X$=FnAnyKey$(13,47)
         END IF
      RETURN
      '=======================================================================
      DoFreeSpin:
         X$=FnMsg$("Way To Go! You Get A FREE SPIN Token!")
         GOSUB SoundEarnFreeSpin
         X$=FnAnyKey$(13,47)
         INCR FreeSpin%(CurrPly%)
         GOSUB ShowFreeSpins
      RETURN
      '=======================================================================
      DoPrize:
         X$=FnMsg$(PrizeDesc$(CurrPrize%))
         GOSUB SoundPrizeWon
         X$=FnAnyKey$(13,47)
         BoardScore%(CurrPly%)=BoardScore%(CurrPly%)+PrizePrice%(CurrPrize%)
         GOSUB ShowBoardWinnings
         LOCATE 15, ((CurrPly%-1)*11)+4
         IF Clr% THEN COLOR (7-CurrPly%),0 ELSE COLOR 15,0
         PRINT PrizesAvail$(CurrPrize%);
         WheelPrice%(GameCount%,WheelPointer%)=250
         WheelColor%(WheelPointer%)=4
         IF Clr% THEN COLOR 0,4 ELSE COLOR 0,15
         LOCATE 21,61 : PRINT "   250  ";
         PrizeName$(CurrPly%,GameCount%)=PrizesAvail$(CurrPrize%)
         PrizeCoord%(CurrPly%,GameCount%)=CurrPrize%
         GOTO FinishSpinAfterPrizeAward
      '=======================================================================
'=============================================================================
DEF FnCollectGuess$
   LOCAL Rtn$,CurrLen%,K$
   BeginFCG:
      IF Clr% THEN COLOR Hred%,0 ELSE COLOR 15,0
      LOCATE 13,7 : PRINT "?: ";SPACE$(47);
      COLOR 15,0
      Rtn$=""
      CurrLen%=0
   ReCycleFCG:
      LOCATE 13,10+CurrLen%,1
      K$=""
      WHILE K$=""
         K$=UCASE$(INKEY$)
         IF FnSecondsElapsed%(3,63)=0 THEN K$=CHR$(13)
         IF K$=CHR$(27) THEN
            K$=FnWantExit$
            LOCATE 13,10+CurrLen%,1
         END IF
      WEND
      IF K$=CHR$(13) THEN GOTO EndFCG
      IF K$=CHR$(8) THEN
         IF CurrLen%<2 THEN GOTO BeginFCG
         DECR CurrLen%
         Rtn$=LEFT$(Rtn$,CurrLen%)
         LOCATE 13,10+CurrLen% : PRINT " ";
      END IF
      IF CurrLen%<47 THEN
         IF INSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZ '",K$)>0 THEN
            Rtn$=Rtn$+K$
            COLOR 15,0
            PRINT K$;
            INCR CurrLen%
         END IF
      END IF
      GOTO ReCycleFCG
   EndFCG:
      FnCollectGuess$=Rtn$
END DEF
'=============================================================================
DEF FnHiliteChoice$(Hilite%,Ltr$)
   LOCAL ChAsc%, X%,Y%
   SHARED LettersLeft$,True%
   ChAsc%=ASC(Ltr$)-64
   IF ChAsc%<14 THEN
      X%=8
      Y%=((ChAsc%-1)*4)+6
   ELSE
      X%=10
      Y%=((ChAsc%-14)*4)+6
   END IF
   LOCATE X%,Y%
   IF Hilite%=True% THEN
      IF INSTR("AEIOU",Ltr$)>0 THEN
         IF Clr% THEN COLOR 0,Lred% ELSE COLOR 0,15
      ELSE
         IF Clr% THEN COLOR 0,LWhite% ELSE COLOR 0,15
      END IF
   ELSE
      IF Clr% THEN COLOR 0,0 ELSE COLOR 15,0
      MID$(LettersLeft$,ChAsc%,1) = " "
   END IF
   PRINT " ";MID$(LettersLeft$,ChAsc%,1);" ";
   FnHiliteChoice$=MID$(LettersLeft$,ChAsc%,1)
END DEF
'=============================================================================
SpinWheel:
   IF Clr% THEN COLOR 0,0 ELSE COLOR 15,0
   LOCATE 13,7,0 : PRINT SPACE$(50);
   IF Clr% THEN COLOR Hred%+16,0 ELSE COLOR 15,0
   LOCATE 13,7,0 : PRINT "<Any Key> To Stop Wheel";
   K$=""
   WHILE K$=""
      K$=INKEY$
      IF K$=CHR$(27) THEN
         K$=FnWantExit$
      END IF
      GOSUB MoveWheel1Frame
      DELAY .02
   WEND
   COLOR 15,0
   LOCATE 13,7,0 : PRINT SPACE$(50);
   IF Clr% THEN COLOR Hred%,0 ELSE COLOR 15,0
   LOCATE 13,7,0 : PRINT "Wheel Slowing......";
   Slower#=20
   WHILE Slower#<1250
      Slower#=Slower#+INT(RND(INT(Slower#))*INT(Slower#/3))
      GOSUB MoveWheel1Frame
      DELAY (Slower#/1000)
      K$=INKEY$
      IF K$=CHR$(27) THEN
         K$=FnWantExit$
      END IF
   WEND
   IF Clr% THEN
      X%=FnDrawFrame%(WheelColor%(WheelPointer%),WheelColor%(WheelPointer%),WheelPointer%)
   ELSE
      X%=FnDrawFrame%(16,15,WheelPointer%)
   END IF
RETURN
'=============================================================================
MoveWheel1Frame:
   LastWheelPointer%=WheelPointer%
   IF Snd% THEN SOUND 2000,(.1)
   IF LastWheelPointer%=0 THEN LastWheelPointer%=1
   IF WheelPointer%<11 THEN
      IF Wheelpointer%=10 THEN WheelPointer%=20 ELSE INCR WheelPointer%
   ELSE
      IF WheelPointer%=11 THEN WheelPointer%=1 ELSE DECR WheelPointer%
   END IF
   IF WheelPointer%>20 THEN WheelPointer%=1
   IF Clr% THEN
      X%=FnDrawFrame%(Lblue%,0,LastWheelPointer%)
   ELSE
      X%=FnDrawFrame%(15,0,LastWheelPointer%)
   END IF
   IF Clr% THEN
      X%=FnDrawFrame%(0,WheelColor%(WheelPointer%),WheelPointer%)
   ELSE
      X%=FnDrawFrame%(0,15,WheelPointer%)
   END IF
RETURN
'=============================================================================
DEF FnDrawFrame%(Fore%,Back%,Where%)
   COLOR Fore%, Back%
   SELECT CASE Where%
      CASE  1 : Pattern%=1
      CASE 10 : Pattern%=2
      CASE 11 : Pattern%=3
      CASE 20 : Pattern%=4
      CASE ELSE : Pattern%=0
   END SELECT
   IF Where%<11 THEN
      X%=((Where%-1)*2)+4 : Y%=60
      IF Pattern%=0 THEN Pattern%=5
   ELSE
      X%=((Where%-11)*2)+4 : Y%=69
      IF Pattern%=0 THEN Pattern%=6
   END IF
   LOCATE X%,Y%,0
   SELECT CASE Pattern%
      CASE 5 : PRINT "";
      CASE 6 : PRINT "Ĵ";
      CASE 1 : PRINT "";
      CASE 2 : PRINT "";
      CASE 3 : PRINT "Ŀ";
      CASE 4 : PRINT "Ĵ";
   END SELECT
   LOCATE X%+1,Y%  ,0 : PRINT "";
   LOCATE X%+1,Y%+9,0 : PRINT "";
   LOCATE X%+2,Y%,0
   SELECT CASE Pattern%
      CASE 5 : PRINT "";
      CASE 6 : PRINT "Ĵ";
      CASE 1 : PRINT "";
      CASE 2 : PRINT "";
      CASE 3 : PRINT "Ĵ";
      CASE 4 : PRINT "";
   END SELECT
   FnDrawFrame%=Where%
END DEF
'=============================================================================
DEF FnMsg$(Prmt$)
   SHARED Clr%
   IF Clr% THEN COLOR Hred%,0 ELSE COLOR 15,0
   LOCATE 13,7,0 : PRINT SPACE$(50);
   LOCATE 13,7,1 : PRINT Prmt$;
   FnMsg$=""
END DEF
'=============================================================================
DEF FnDialog1$(Valid$,Prmt$,UseSound%)
   SHARED True%,False%,Clr%
   LOCAL KeepGoing%, K$
   RecycleDialog:
      IF Clr% THEN COLOR 0,0 ELSE COLOR 15,0
      LOCATE 13,7,0 : PRINT SPACE$(50); : LOCATE 13,7,1
      IF UseSound% = 1 THEN
         IF Clr% THEN
            COLOR HBlue%,0 : PRINT "<";
            COLOR Hred%,0  : PRINT "S";
            COLOR HBlue%,0 : PRINT ">";
            COLOR Hwhite%,0: PRINT "pin  ";
            COLOR HBlue%,0 : PRINT "<";
            COLOR Hred%,0  : PRINT "G";
            COLOR HBlue%,0 : PRINT ">";
            COLOR Hwhite%,0: PRINT "uess  ";
            COLOR HBlue%,0 : PRINT "<";
            COLOR Hred%,0  : PRINT "B";
            COLOR HBlue%,0 : PRINT ">";
            COLOR Hwhite%,0: PRINT "uy-Vowel : ";
         ELSE
           COLOR 15,0
      	PRINT Prmt$;
         END IF
      ELSE
         IF Clr% THEN COLOR Hred%,0 ELSE COLOR 15,0
         PRINT Prmt$;
      END IF
      IF Snd% THEN
         SELECT CASE UseSound%
            CASE 1 : SOUND  4000,1  '<S>pin  <G>uess  <B>uy-Vowel
            CASE 2 : SOUND  4000,1   ' What Letter?
            CASE 3 : SOUND  4000,1   ' Buy what Vowel?
            CASE 4 : SOUND  4000,1   ' use a FREE SPIN?
         END SELECT
      END IF
      K$="" : KeepGoing%=True%
      WHILE KeepGoing%=True%
         K$=""
         WHILE K$=""
            K$=UCASE$(INKEY$)
            K%=FnSecondsElapsed%(3,63)
            IF K$=CHR$(27) THEN
               K$=FnWantExit$
               GOTO RecycleDialog
            END IF
         WEND
         IF INSTR(Valid$,K$)>0 THEN
            KeepGoing%=False%
         ELSE
            IF Snd% THEN SOUND 500,3
         END IF
      WEND
      LOCATE 13,7,0 : PRINT SPACE$(50);
      LOCATE 13,7,1
      FnDialog1$=K$
END DEF
'=============================================================================
DefineFirstPlayer:
   CurrPly%=LastBoardBeginPly%+1
   IF CurrPly%>QntPly% THEN CurrPly%=1
   LastBoardBeginPly%=CurrPly%
   LastPly%=0
RETURN
'=============================================================================
ShineCurrPlayer:
      IF LastPly%>0 THEN
         LOCATE 16,((LastPly%-1)*11)+5
         IF Clr% THEN COLOR (7-LastPly%),0 ELSE COLOR 15,0
         PRINT PName$(LastPly%);
      END IF
      LOCATE 16,((CurrPly%-1)*11)+5
      IF Clr% THEN COLOR 0,(7-CurrPly%) ELSE COLOR 0,15
      PRINT PName$(CurrPly%);
      LastPly%=CurrPly%
RETURN
'=============================================================================
IncrCurrPlayer:
      CurrPly%=LastPly%+1
      IF CurrPly%>QntPly% THEN CurrPly%=1
      GOSUB SoundPlayerChange
RETURN
'=============================================================================
DEF FnEncode$(enc$)
   local c%
   for c% = 1 to len(enc$)
     mid$(enc$, c%,1) = chr$(asc(mid$(enc$,c%,1))+(c%*2))
   next
   FnEncode$=enc$
END DEF
'=============================================================================
DEF FnDecode$(enc$)
   local c%
   for c% = 1 to len(enc$)
     mid$(enc$, c%,1) = chr$(asc(mid$(enc$,c%,1))-(c%*2))
   next
   FnDecode$=UCASE$(enc$)
END DEF
'=============================================================================
BlankBoard:
   cls
   locate 1,1
   IF Clr% THEN COLOR Hblue%,0 ELSE COLOR 15,0
   PRINT " ͻ"
   PRINT "                                                                            "
   PRINT "                                                                       Ķ"
   PRINT "                                                          Ŀ"
   PRINT "                                                                          "
   PRINT "                                                          Ĵ"
   PRINT "   Ŀ                  "
   PRINT "                                            Ĵ"
   PRINT "   Ĵ                  "
   PRINT "                                            Ĵ"
   PRINT "                     "
   PRINT "   ͻ  Ĵ"
   PRINT "                                                                        "
   PRINT "   ͼ  Ĵ"
   PRINT "                                                                          "
   PRINT "                                                    Ĵ"
   PRINT "                                                                    "
   PRINT " Ĵ Ĵ"
   PRINT "                                                                    "
   PRINT "                                                    Ĵ"
   PRINT "                                                                    "
   PRINT "                                                    Ĵ"
   PRINT "                                                                    "
   LOCATE 24,1
   PRINT "                                                    ٺ";
   LOCATE 25,1
   PRINT " ͼ";
   IF Clr% THEN COLOR Lwhite%,0 ELSE COLOR 15,0
   LOCATE 2,74 : PRINT "12345";
   IF Clr% THEN COLOR Hred%,0 ELSE COLOR 0,15
   LOCATE 2,(73+GameCount%) : PRINT USING "#";GameCount%;
   LOCATE 1,1
RETURN
'=============================================================================
PrepNewGame:
   GOSUB GetGameSpecs
   BoardsPlayed% = 0
   FOR C% = 1 to QntPly%
      FOR B% = 1 to 5
         PrizeName$(C%,B%)="        "
         PrizeCoord%(C%,B%)=0
      NEXT
      GameScore&(C%)=0
      FreeSpin%(C%)=0
   NEXT
RETURN
'=============================================================================
PrepNewBoard:
   GOSUB BlankBoard
   LettersLeft$="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   GOSUB ShowLettersLeft
   FOR C%=1 to QntPly%
      BoardScore%(C%)=0
      LOCATE 16, ((C%-1)*11)+5
      IF Clr% THEN COLOR (7-C%),0 ELSE COLOR 15,0
      PRINT PName$(C%);
   NEXT
   GOSUB ShowFreeSpins
   GOSUB ShowGameWinnings
   GOSUB SetUpWheel
   GOSUB SetUpPuzzle
RETURN
'=============================================================================
SetUpPuzzle:
   Puzzle$=FnGetNextPuz$
   WHILE MID$(Puzzle$,2,1)<> Lvl$
      Puzzle$=FnGetNextPuz$
   WEND
   CurrTopic$=LEFT$(Puzzle$,1)
   K$ = FnShowTopic$(CurrTopic$)
   Puzzle$=FnReduce$(Puzzle$)
   GuessTest$=Puzzle$
   GOSUB ParsePuzzle
   GOSUB SetUpDotPuzzle
   IF Clr% THEN COLOR 15,0 ELSE COLOR 15,0
   IF SpeedRound%=True% THEN LOCATE 15,13 ELSE LOCATE 4,4
   PRINT Dots$;
RETURN
'=============================================================================
DEF FnShowTopic$(Which$)
   Shared SpeedRound%, False%
   IF SpeedRound%=False% THEN LOCATE 2,61 ELSE LOCATE 12,56
   IF Clr% THEN COLOR Hred%,0 ELSE COLOR 15,0
   SELECT CASE Which$
      CASE "?" : PRINT "  Potluck   ";
      CASE "A" : PRINT "  Proverb   ";
      CASE "B" : PRINT "    Book    ";
      CASE "C" : PRINT "  Cartoon   ";
      CASE "D" : PRINT "  Dr.Zuess  ";
      CASE "E" : PRINT " Esop Fable ";
      CASE "F" : PRINT "FamousPerson";
      CASE "G" : PRINT " Geography  ";
      CASE "J" : PRINT "    Joke    ";
      CASE "K" : PRINT "  Punchline ";
      CASE "M" : PRINT "   Movie    ";
      CASE "N" : PRINT "NurseryRhyme";
      CASE "O" : PRINT " Occupation ";
      CASE "P" : PRINT "   People   ";
      CASE "Q" : PRINT "    Quote   ";
      CASE "S" : PRINT "    Song    ";
      CASE "T" : PRINT "   TV Show  ";
      CASE "X" : PRINT "   X-Rated  ";
      CASE "Z" : PRINT " Old Saying ";
   END SELECT
   FnShowTopic$=Which$
END DEF
'=============================================================================
SetUpDotPuzzle:
  Dots$=Space$(55)
  FOR C%=1 to LEN(Puzzle$)
     IF MID$(Puzzle$,C%,1)="'" THEN
        MID$(Dots$,C%,1)="'"
     ELSE
        IF MID$(Puzzle$,C%,1)>" " THEN MID$(Dots$,C%,1)=chr$(254)
     END IF
  NEXT
RETURN
'=============================================================================
ParsePuzzle:
   NewPuzzle$=""
   FOR C% = 1 to LEN(Puzzle$)
      IF MID$(Puzzle$,c%,1)=" " THEN NewPuzzle$=NewPuzzle$+"  " _
         ELSE NewPuzzle$=NewPuzzle$+MID$(Puzzle$,c%,1)
   NEXT
   Puzzle$=NewPuzzle$
   NewPuzzle$=""
   Puzzle$=LEFT$(SPACE$(INT((55-Len(Puzzle$))/2))+Puzzle$+SPACE$(55),55)
RETURN
'=============================================================================
DEF FnReduce$(X$)
  LOCAL C%, Y$
  X$=MID$(X$,4,47)
  C%=47
  WHILE MID$(X$,C%,1)=" "
     Decr C%
  WEND
  FnReduce$=LEFT$(X$,C%)
END DEF
'=============================================================================
SetUpWheel:
   CurrPrize% = INT(RND(TopPrizeCount%)*(TopPrizeCount%-1))+1
   FOR C% = 1 to 20
      IF C%=9 THEN WheelColor%(C%)=Hwhite%
      IF C%<11 THEN
         X% = ((C%-1)*2)+5
         Y% = 61
      ELSE
         X% = ((C%-11)*2)+5
         Y% = 70
      END IF
      LOCATE X%,Y%
      IF WheelPrice%(GameCount%,C%)>0 then
         IF Clr% THEN COLOR 0,WheelColor%(c%) ELSE COLOR 0,15
         PRINT USING "##,###";WheelPrice%(GameCount%,C%);
         PRINT "  ";
      ELSE
         IF Clr% THEN COLOR Hwhite%,Lblue% ELSE COLOR 15,0
         SELECT CASE WheelPrice%(GameCount%,C%)
            CASE (-1)
               PRINT "Bankrupt";
            CASE (-2)
               PRINT "LoseTurn";
            CASE (-3)
               PRINT "FreeSpin";
            CASE (-4)
               PRINT PrizesAvail$(CurrPrize%);
         END SELECT
      END IF
   NEXT
RETURN
'=============================================================================
ShowGameWinnings:
   FOR C% = 1 to QntPly%
      Y%=((C%-1)*11)+5
      FOR B% = 1 to 5
         LOCATE B%+18, y%
         IF Clr% THEN COLOR (7-C%),0 ELSE COLOR 15,0
         PRINT PrizeName$(C%,B%);
      NEXT
      LOCATE 24, y%-1
      IF Clr% THEN COLOR (7-C%),0 ELSE COLOR 15,0
      IF GameScore&(C%)>0 then PRINT USING "#,###,###"; GameScore&(C%); _
         ELSE PRINT "         ";
   NEXT
RETURN
'=============================================================================
ShowBoardWinnings:
   FOR C% = 1 to QntPly%
      Y%=((C%-1)*11)+5
      LOCATE 17, y%-1
      IF Clr% THEN COLOR (7-C%),0 ELSE COLOR 15,0
      IF BoardScore%(C%)>0 then PRINT USING "#,###,###"; BoardScore%(C%); _
         ELSE PRINT "         ";
   NEXT
RETURN
'=============================================================================
ShowFreeSpins:
   FOR C%=1 to QntPly%
      LOCATE 18, ((C%-1)*11)+5
      IF FreeSpin%(C%) = 0 THEN
         IF Clr% THEN COLOR Lblue%,0 ELSE COLOR 15,0
         PRINT "";
      ELSE
         IF FreeSpin%(C%) = 1 THEN
            IF Clr% THEN COLOR (7-C%),0 ELSE COLOR 15,0
            PRINT "FreeSpin";
         ELSE
            IF Clr% THEN COLOR (7-C%),0 ELSE COLOR 15,0
            PRINT "FreeSp=";right$(STR$(FreeSpin%(C%)),1);
         END IF
      END IF
   NEXT
RETURN
'=============================================================================
ShowLettersLeft:
   FOR C% = 1 to 26
      IF C%<14 THEN
         X%=8
         Y%=((C%-1)*4)+7
      ELSE
         X%=10
         Y%=((C%-14)*4)+7
      END IF
      IF INSTR("AEIOU",MID$(LettersLeft$,C%,1))>0 THEN
         IF Clr% THEN
            LOCATE X%, Y% : COLOR Hred%,0
            IF MID$(LettersLeft$,C%,1)>" " THEN
               PRINT MID$(LettersLeft$,C%,1);
            ELSE
               PRINT " ";
            END IF
         ELSE
            LOCATE X%, Y%-1
            COLOR 15,0
            IF MID$(LettersLeft$,C%,1)>" " THEN
               PRINT "-";MID$(LettersLeft$,C%,1);"-";
            ELSE
               PRINT "   ";
            END IF
         END IF
      ELSE
         LOCATE X%, Y%
         COLOR 15,0
         IF MID$(LettersLeft$,C%,1)>" " THEN
            PRINT MID$(LettersLeft$,C%,1);
         ELSE
            PRINT " ";
         END IF
      END IF
   NEXT
RETURN
'=============================================================================
PrepDataFile:
   OPEN "B", #1, "WOF.DAT"
   IF LOF(1)=0 THEN
      CLOSE #1
      KILL "WOF.DAT"
      CLS
      PRINT "Cannot find Puzzle Data File:  WOF.DAT "
      PRINT "Game Terminated.............";
      WHILE Inkey$="" : WEND
      PRINT : PRINT
      END
   END IF
RETURN
'=============================================================================
DEF FnAnyKey$(X%,Y%)
  LOCAL K$
  COLOR 15,0
  locate X%,Y%
  PRINT "<Any Key>";
  LOCATE X%,Y%+4,1
  K$=""
  WHILE K$=""
     K$=INKEY$
     IF K$=CHR$(27) THEN
        K$=FnWantExit$
        LOCATE X%,Y%+4,1
     END IF
  WEND
  FnAnyKey$=K$
END DEF
'=============================================================================
DEF FnWantExit$
   IF Clr% THEN COLOR (7-CurrPly%),0 ELSE COLOR 15,0
   LOCATE 2,61 : PRINT " QUIT?(Y/N) ";
   LOCATE 2,61 : PRINT " QUIT?(Y/N)";
   K$=""
   COLOR 15,0
   WHILE K$<>"Y" AND K$<>"N"
      K$=UCASE$(INKEY$)
      K%=FnSecondsElapsed%(3,63)
   WEND
   IF K$="Y" THEN
      CLS
      CLOSE #1
      END
   END IF
   K$ = FnShowTopic$(CurrTopic$)
   FnWantExit$=""
END DEF
'=============================================================================
InitMain:
   Esc$ = CHR$(27)
   True%=1
   False%=0
   SpeedRound%=False%
   FOR C%=1 to 20
      FOR B% = 1 to 5
         READ WheelPrice%(B%,C%)
      NEXT
      READ WheelColor%(C%)
   NEXT
   C%=0
   While PrizesAvail$(c%)<>"END"
     INCR C%
     READ PrizesAvail$(c%), PrizePrice%(c%), PrizeDesc$(c%)
   WEND
   TopPrizeCount%=C%-1
   RANDOMIZE (INT(VAL(LEFT$(Time$,2)))+INT(VAL(RIGHT$(TIME$,2))))

   Lblack%    =  0     :     Hblack%    =  8
   Lblue%     =  1     :     Hblue%     =  9
   Lgreen%    =  2     :     Hgreen%    = 10
   Lliteblue% =  3     :     Hliteblue% = 11
   Lred%      =  4     :     Hred%      = 12
   Lpurple%   =  5     :     Hpurple%   = 13
   Lyellow%   =  6     :     Hyellow%   = 14
   Lwhite%    =  7     :     Hwhite%    = 15

   Cmd$=Command$

   IF Cmd$>"" THEN
     Clr$=LEFT$(Cmd$,1)
     Snd$=RIGHT$(Cmd$,1)
   END IF

RETURN
'=============================================================================
Data   100  , 1500  , 3500  , 5000  , 5000  ,  2
Data   500  ,  550  ,  600  ,  700  ,  800  ,  3
Data   350  ,  450  ,  550  ,  650  ,  750  ,  4
Data    -1  ,   -1  ,   -1  ,   -1  ,   -1  ,  5
Data   220  ,  270  ,  320  ,  370  ,  420  ,  6
Data   150  ,  150  ,  150  ,  150  ,  150  ,  2
Data   410  ,  420  ,  430  ,  460  ,  470  ,  3
Data   170  ,  270  ,  370  ,  470  ,  550  ,  4
Data    -4  ,   -4  ,   -4  ,   -4  ,   -4  ,  15
Data   280  ,  600  ,  410  ,  320  , 1500  ,  6
Data   320  ,  260  ,  170  ,  800  ,  320  ,  4
Data   400  ,  400  ,  280  ,  600  ,  890  ,  5
Data    -3  ,   -3  ,   -3  ,   -3  ,   -3  ,  6
Data   190  ,  310  ,  310  ,  750  ,  910  ,  2
Data   240  ,  590  ,  590  ,  250  ,  750  ,  3
Data   360  ,  180  ,  290  ,  390  , 1000  ,  4
Data    -2  ,   -2  ,   -2  ,   -2  ,   -2  ,  5
Data   480  ,  210  ,  270  ,  410  ,  230  ,  6
Data   110  ,  460  ,  340  ,  560  ,  480  ,  2
Data   300  ,  520  ,  660  ,  300  ,  620  ,  3
Data  " Diamond", 7000, "Diamond Ring, 2 carets! Value = $7,000  "
Data  "  Gold  ", 6990, "Gold Bullion, Market Value = $6,990     "
Data  " Disney ", 4530, "Trip to Disney World, 5 days = $4,530   "
Data  "  Ruby  ", 5000, "Fire-Eye Ruby Necklace! Value = $5,000  "
Data  " Silver ", 3500, "Silver Tea Service for 8! Value = $3,500"
Data  " Denmark", 8640, "10 day Trip to Denmark! Cost = $8,640   "
Data  " Hawaii ", 3550, "5 day/4 nights in Honolulu = $3,550     "
Data  " Stereo ", 4860, "Stereo system with CD Player = $4,860   "
Data  " Europe ",11750, "Eurpoean Tour, 1st Class Air = $11,750  "
Data  "Galleon ", 6870, "Sunken Treasure Diving Trip! $6,870     "
Data  "  Video ", 3890, "25''TV, Video Camera & VCR! $3,890      "
Data  "  Topaz ", 3300, "Topaz and Diamond Ring! Value = $3,300  "
Data  "  Boat  ", 4230, "18' Ski Boat & Trailer! Value = $4,230  "
Data  " Truck  ", 7480, "Ford Lil'Mac Pickup Truck! Cost = $7,480"
Data  " Emerald", 3900, "Emerald Earings & Broach! Cost = $3,900 "
Data  "Computer", 3650, "IBM Computer, Fully equipped! $3,650    "
Data  " Mexico ", 3990, "5 day cruise in Baja de Mexico! $3,990  "
Data  " Pop-Art", 7550, "Modern Art Painting! Market Value $7,550"
Data  "Bahamas ", 4010, "Sailboat Tour of the Bahammas! $4,010   "
Data  "  Ford  ", 6840, "Newest Model Ford Escort Wagon! $6,840  "
Data  "MtrCycle", 4950, "Harley Davidson 2000 Motorcycle! $4,950 "
Data  " Africa ", 8980, "Africa Safari, 5 day/4 nite! $8,980     "
Data  "  Chevy ", 7190, "Chevy Sprint 4 door! Value = $7,190     "
Data  "   RV   ",14930, "22' Winnebago Motorhome! WOW!  $14,930  "
Data  " HotTub ", 4820, "Hot-Tub for Six & Installation = $4,820 "
Data  "Fishing ", 3990, "Fishing Trip to Alaska for 4 .... $3,990"
Data  "Austrail",11720, "10 days 9 nights Kangroo Land! $11,720  "
Data  "Saphire ", 2890, "Saphire & Ruby Ring ....... $2,890      "
Data  " SkiDoo ", 5900, "Kawaski 250 Water SkiDoo!   $5,900      "
Data  " Aspen  ", 4200, "Aspen Skiing Trip for SIX!  $4,200      "
Data  " Mardi  ", 8210, "5 days of Mardi Gras for four! $8,210   "
Data  " Piano  ", 4250, "Steinway Baby-Grand Piano!  $4,250      "
Data  "Mystery?",10000, "Ski Weekend with Vanna or Pat!  $10,000 "
Data  " Polar  ",12370, "North Pole Expedition!   $12,370        "
Data  " Egypt  ", 9300, "Visit the Pyramids (7 days)   $9,300    "
Data  " Amazon ", 8650, "Float trip down the Amazon!   $8,650    "
Data  " Glider ", 3200, "Hang Glider & Free Lessons!   $3,200    "
Data  "END",0," "
'=============================================================================
GetGameSpecs:
   CLS
   IF Clr% THEN COLOR HBlue%,0
   LOCATE 1,1
   PRINT "    Ŀ"
   PRINT "                                                                 "
   PRINT "    "
   IF Clr% THEN COLOR HWhite%,0
   LOCATE 2,9
   PRINT "Wheel-Of-Fortune ...... ";
   IF Clr% THEN COLOR Hred%,0
   PRINT "By Frederick Volking";
   IF Clr% THEN COLOR Hpurple%,0
   LOCATE 2,57
   PRINT Vers$;
   IF Clr% THEN COLOR Hgreen%,0
   IF (QntPly$="" or (INSTR("12345",QntPly$)<1) or Len(QntPly$)>1) THEN QntPly$="1"
   LOCATE 5,1 : PRINT "How Many Players? (1-5) (0=QUIT) : [";QntPly$;"]";
   LOCATE 5,37: INPUT "",K$
   IF K$="0" THEN
      CLS
      CLOSE #1
      END
   END IF
   IF K$>"" THEN QntPly$=K$
   QntPly%=INT(VAL(QntPly$))
   IF QntPly%<1 or QntPly%>5 THEN GOTO GetGameSpecs
   FOR C% = 1 to QntPly%
      PName$(C%)=LEFT$(PName$(c%)+Space$(8),8)
      LOCATE 6+C%,5 : PRINT "Name of Player";C%;": "
      LOCATE 6+C%,23: PRINT "[";PName$(C%);"]";
      LOCATE 6+C%,23: INPUT "[",K$
      IF K$>"" THEN PName$(C%)=K$
      PName$(C%)=RIGHT$(SPACE$(8)+PName$(c%),8)
      IF PName$(c%)=SPACE$(8) THEN PName$(C%)=LEFT$("Player"+str$(c%)+SPACE$(8),8)
      LOCATE 6+C%,23: PRINT "[";PName$(C%);"]           ";
   NEXT
   LOCATE 13,1 : INPUT "Names Okay? (Y-n) : ",Ans$
   Ans$ = UCASE$(Ans$)
   IF Ans$="N" THEN GOTO GetGameSpecs
   IF (Lvl$="" or (INSTR("EAH",Lvl$)<1)) THEN Lvl$ = "E"
   LOCATE 15,1 : PRINT "Difficulty Level?  <E>asy <A>verage <H>ard : [";Lvl$;"]";
   LOCATE 15,47 : INPUT "",K$
   IF K$>"" THEN Lvl$ = K$
   Lvl$ = LEFT$(UCASE$(Lvl$),1)
   IF (Lvl$="" or (INSTR("EAH",Lvl$)<1)) THEN GOTO GetGameSpecs
   LOCATE 20,1 : INPUT "Ready To Play? (Y-n) : ", Ans$
   Ans$ = LEFT$(UCASE$(Ans$),1)
   IF ANS$ = "N" THEN GOTO GetGameSpecs
RETURN
'=============================================================================
DEF FnGetNextPuz$
    LOCAL MyVal$, NextRec%
    SEEK #1, 0
    GET$ #1, 50, MyVal$
    NextRec% = (INT(VAL(MID$(MyVal$, 45,6))))+1
    IF NextRec%=>INT(LOF(1)/50) THEN NextRec%=1
    SEEK #1, 0
    MID$(MyVal$,45,6)=Left$(STR$(NextRec%)+"      ",6)
    PUT$ #1, MyVal$
    SEEK #1, FnRecAddr&(NextRec%)
    GET$ #1, 50, MyVal$
    FnGetNextPuz$=FnDecode$(MyVal$)
END DEF
'=============================================================================
DEF FnRecAddr&(X%)=X%*50
'=============================================================================
SetUpDefaultSettings:
   color Hwhite%,0,0
   cls
   IF Clr$="" THEN
      INPUT "Color? (Y/N): ",Clr$
   END IF
   IF UCASE$(Clr$) <> "Y" THEN Clr%=False% ELSE Clr%=True%
   IF Snd$="" THEN
      INPUT "Sound? (Y/N): ",Snd$
   END IF
   IF UCASE$(Snd$) <> "Y" THEN Snd%=False% ELSE Snd%=True%
RETURN
'=============================================================================
SoundVowelsOnlyLeft:
   IF Snd% THEN SOUND 200,2
RETURN
'=============================================================================
SoundVowelsOnlyPlayerXGuess:
   GOTO SoundPlayerChange
RETURN
'=============================================================================
SoundNoOneWins:
   IF Snd% THEN
      SOUND 500,1
      SOUND 450,1
      SOUND 400,1
      SOUND 350,1
      SOUND 300,1
      SOUND 250,1
   END IF
RETURN
'=============================================================================
SoundBoardOverOrGameOver:
   IF Snd% THEN
      FOR S%=1 to 20
         SOUND 3000, (.5)
         SOUND 2000, (.5)
      NEXT
   END IF
RETURN
'=============================================================================
SoundOppsLetterAlreadyUsed:
   IF Snd% THEN SOUND 200,1
RETURN
'=============================================================================
SoundNoSuchLetterInPuzzle:
   IF Snd% THEN
      SOUND 500,(.05)
      SOUND 500,(.05)
      SOUND 500,(.05)
      SOUND 400,2
   END IF
RETURN
'=============================================================================
SoundGoodGuessLetterInPuzzle:
   IF Snd% THEN
      FOR S%=500 to 1000 STEP 25
         SOUND S%, (.5)
      NEXT
   END IF
RETURN
'=============================================================================
SoundWeHaveAWinner:
IF Snd% THEN
   FOR S1%=1 TO 3
      FOR S%=1000 to 3000 STEP 10
         SOUND S%, (.035*S1%)
      NEXT
   NEXT
END IF
RETURN
'=============================================================================
SoundWrongGuess:
   IF Snd% THEN
      SOUND 400,2
      SOUND 500,(.05)
      SOUND 500,(.05)
      SOUND 500,(.05)
   END IF
RETURN
'=============================================================================
SoundNoMonyToBuyVowel:
   IF Snd% THEN SOUND 200,2
RETURN
'=============================================================================
SoundBoughtAVowel:
   IF Snd% THEN
      FOR S%=1 to 3
         SOUND 1000, (.05)
         SOUND 1500, (.05)
         SOUND 2000, (.05)
      NEXT
   END IF
RETURN
'=============================================================================
SoundBankrupt:
   IF Snd% THEN
      SOUND 300,1
      SOUND 250,1
      SOUND 200,3
   END IF
RETURN
'=============================================================================
SoundSamePlayerAgain:
RETURN
'=============================================================================
SoundLoseTurn:
RETURN
'=============================================================================
SoundEarnFreeSpin:
RETURN
'=============================================================================
SoundPrizeWon:
RETURN
'=============================================================================:
SoundPlayerChange:
   IF Snd% THEN
      FOR S%=1 TO 5
         SOUND 2000, (.5)
         SOUND 2100, (.5)
         SOUND 2200, (.5)
         SOUND 2300, (.5)
      NEXT
   END IF
RETURN
'=============================================================================
DEF FnStartTimer%(Long%)
   SHARED Elapsed&,CountDown%,True%,False%
   IF Long% = 0 THEN
      CountDown% = False%
      Elapsed& = 0
   ELSE
      CountDown% = True%
      Elapsed& = (CLNG(Long%)) * 997564
   END IF
   MTIMER
END DEF
'=============================================================================
DEF FnSecondsElapsed%(TUR%,TUC%)
   SHARED Elapsed&,CountDown%,True%,False%
   LOCAL TimeSinceLast&, K%
   TimeSinceLast&=MTIMER
   MTIMER
   IF CountDown% THEN
      Elapsed& = Elapsed& - TimeSinceLast&
      IF Elapsed&<0 THEN Elapsed&=0
      K% = FnShowTime(Elapsed&,TUR%,TUC%)
   ELSE
      Elapsed& = Elapsed& + TimeSinceLast&
      K% = FnShowTime(Elapsed&,TUR%,TUC%)
   END IF
   FnSecondsElapsed% = K%
END DEF
'=============================================================================
DEF FnShowTime%(HowMuch&, TRR%, TRC%)
   SHARED LastSecond%,CountDown%
   LOCAL HoldX%, HoldY%, Minutes%, HoldSeconds%
   HoldX% = CSRLIN
   HoldY% = POS
   HoldSeconds%=INT(FIX(HowMuch&/997564))
   Minutes%=INT(FIX(HowMuch&/59853831))
   HowMuch&=HowMuch&-(CLNG(Minutes%) * 59853831)
   Seconds%=INT(FIX(HowMuch&/997564))
   IF LastSecond%<>HoldSeconds% THEN
      LOCATE TRR%, TRC%, 0
      IF Snd% AND CountDown% THEN SOUND 1000,(.1)
      PRINT USING "###";Minutes%;
      PRINT ":";
      PRINT RIGHT$(STR$(Seconds%+100),2);
      LOCATE HoldX%,HoldY%,1
      LastSecond%=HoldSeconds%
   END IF
   FnShowTime%=HoldSeconds%
END DEF
'=============================================================================
DEF FnSetColor%(SC%)
   SHARED True%
   LOCAL FColor%,BColor%
   FColor%=(SC% MOD 16)
   BColor%=(((SC%-FColor%)/16)MOD 128)
   COLOR FColor%, BColor%
   FnSetColor%=True%
END DEF
'=============================================================================
ShowSpeedScreen:
   cls
   locate 1,1
   IF Clr% THEN COLOR Hblue%,0 ELSE COLOR 15,0
   PRINT " ͻ"
   PRINT "                                                                            "
   PRINT " Ķ"
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                      Ŀ                               "
   PRINT "                                                   Ŀ          "
   PRINT "                                                                         "
   PRINT "        ;      ͻ        "
   PRINT "                                                                           "
   PRINT "                                                                           "
   PRINT "                                                                           "
   PRINT "                                                                           "
   PRINT "        ͼ        "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             "
   PRINT "                                                                             ";
   LOCATE 25,1
   PRINT " ͼ";
   LOCATE 1,1
   IF Clr% THEN COLOR Lwhite%,0
   LOCATE 2,4 : PRINT "Speed Round";
   IF Clr% THEN COLOR Hred%,0
   LOCATE 2,18: PRINT "Playing For: ";
   IF Clr% THEN COLOR Lwhite%,0
   LOCATE 2,31: PRINT "$25,000 Cash!";
   IF Clr% THEN COLOR Hwhite%,0
   LOCATE 4,17: PRINT PName$(WinningPly%);
   IF Clr% THEN COLOR Hred%,0
   PRINT " is the WINNER! ...... $";
   IF Clr% THEN COLOR Hwhite%,0
   PRINT USING "##,###,###"; GameScore&(WinningPly%)
   IF Clr% THEN COLOR Hyellow%,0
   X%=0 : Y% = 0
   FOR C%=1 to 5
      IF PrizeCoord%(WinningPly%,C%)>0 THEN INCR Y%
   NEXT
   IF Y%<4 THEN Y%=1 ELSE Y%=0
   FOR C%=1 to 5
      IF PrizeCoord%(WinningPly%,C%)>0 THEN
         INCR X%
         LOCATE 4+X%+Y%,23 : PRINT PrizeDesc$(PrizeCoord%(WinningPly%,C%));
      END IF
   NEXT
   IF X%=0 THEN
      LOCATE 5,24
      PRINT "------ Sorry .... No Prizes! ------";
   END IF
   IF Clr% THEN COLOR Hred%,0
   LOCATE 11,10 : PRINT "Pick ";
   IF Clr% THEN COLOR HWhite%,0
   PRINT "5";
   IF CLR% THEN COLOR HRed%,0
   PRINT " consonants & ";
   IF CLR% THEN COLOR HWhite%,0
   PRINT "1";
   IF CLR% THEN COLOR HRed%,0
   PRINT " vowel ";CHR$(26);
RETURN
'=============================================================================
Collect5N1:
   Begin5N1:
      Rtn$=""
      LOCATE 11,41
      PRINT "      ";
      C5N1%=0
      V5N1%=False%
      CurrLen%=0
   ReCycle5N1:
      LOCATE 11,41+CurrLen%,1
      K$=""
      WHILE K$=""
         K$=UCASE$(INKEY$)
         IF K$=CHR$(27) THEN
            K$=FnWantExit$
            LOCATE 11,41+CurrLen%,1
         END IF
      WEND
      IF K$=CHR$(13) AND CurrLen%=6 THEN GOTO End5N1
      IF K$=CHR$(8) THEN
         IF CurrLen%<2 THEN GOTO Begin5N1
         K$=Right$(Rtn$,1)
         DECR CurrLen%
         Rtn$=LEFT$(Rtn$,CurrLen%)
         LOCATE 11,41+CurrLen% : PRINT " ";
         IF INSTR("AEIOU",K$)>0 THEN V5N1% = False% ELSE DECR C5N1%
         GOTO ReCycle5N1
      END IF
      IF CurrLen%<6 THEN
         IF (V5N1%=False%) and (INSTR("AEIOU",K$)>0) THEN
            Rtn$=Rtn$+K$
            COLOR 15,0
            PRINT K$;
            INCR CurrLen%
            V5N1% = True%
         END IF
         IF (INSTR("BCDFGHJKLMNPQRSTVWXYZ",K$)>0) AND (C5N1%<5) AND (INSTR(Rtn$,K$)<1) THEN
            Rtn$=Rtn$+K$
            COLOR 15,0
            PRINT K$;
            INCR CurrLen%
            INCR C5N1%
         END IF
      END IF
      GOTO ReCycle5N1
   End5N1:
      C5V1$=Rtn$
RETURN
'=============================================================================
ShowSpeedText:
   IF Clr% THEN COLOR HRed%,0 ELSE COLOR 15,0
   LOCATE 20,10: PRINT "When the last letter in the puzzle has been displayed, you will";
   LOCATE 21,10: PRINT "have ";
   IF Clr% THEN COLOR HWhite%,0
   IF Lvl$="E" THEN PRINT "2 Minutes";
   IF Lvl$="A" THEN PRINT "1 Minute";
   IF Lvl$="H" THEN PRINT "45 Seconds";
   IF Clr% THEN COLOR HRed%,0
   PRINT " to guess. Within the time limit, you may guess as";
   LOCATE 22,10: PRINT "many times as you like. Just Type your answer and press <Enter>.";
   LOCATE 24,33: PRINT "To begin showing letters";
   K$ = FnAnyKey$(24,23)
   LOCATE 20,10: PRINT SPACE$(65);
   LOCATE 21,10: PRINT SPACE$(65);
   LOCATE 22,10: PRINT SPACE$(65);
   LOCATE 24,10: PRINT SPACE$(65);
RETURN
'=============================================================================
ShowSpeedLetters:
   COLOR 15,0
   D!=(.03)
   LOCATE 1,1,0
   FOR C%=1 to 6
      K$=MID$(C5V1$,C%,1)
      LOCATE 12,40+C% : PRINT K$; : DELAY D!
      LOCATE 12,40+C% : PRINT " ";
      LOCATE 13,40+C% : PRINT K$; : DELAY D!
      LOCATE 13,40+C% : PRINT " ";
      FOR G%=(40+C%) TO 13 STEP (-1)
         LOCATE 14,G%,0   : PRINT K$; : DELAY D!
         LOCATE 14,G%+1 : PRINT " ";
      NEXT
      FOR H%=1 to LEN(Puzzle$)
         LOCATE 14,H%+12 : PRINT K$; : DELAY (D!*3)
         IF MID$(Puzzle$,H%,1)<>" " THEN DELAY (D!*5)
         IF MID$(Puzzle$,H%,1)=K$ THEN
           LOCATE 15,H%+12 : PRINT K$;
           MID$(Dots$,H%,1)=K$
           DELAY (D!*10)
         END IF
         LOCATE 14,H%+12 : PRINT " ";
      NEXT
      LOCATE 14,H% : PRINT " ";: DELAY D!
      LOCATE 12,40+C% : PRINT " ";
      LOCATE 13,40+C% : PRINT " ";
   NEXT
RETURN
'=============================================================================
