/**
    Program :   3D Maze Game   ( maze.* )
    Purpose :   Fun and pleasure, as well as for entering
                the Borland C++ contest.
                
    Author  :   Charles W. Haden
                Shoebox Software
                699 Lantana Street, Apt. #54
                Camarillo, CA   93010
                USA
                CIS: 71760,3557
    
    Revision :  July 28, 1991   - version 1.00  (CWH)
                
    Notes :
**/

#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include <conio.h>
#include <ctype.h>


// ==============
#define max_length  25
#define max_width   25

#define NORTH   1
#define WEST    2
#define SOUTH   3
#define EAST    4
// ==============

typedef struct {
    int N, S, E, W;
} Location;

Location    Maze[max_length][max_width];

typedef struct {
    int X, Y, Dir;
} Player;

// ==============
int debug_c;
int endX=0, endY=0;
// ==============



// ==============
int  intro();
void init_maze( Player *p1, int maze_num );
void init_player( Player *p1, FILE *fp );
void init_scr();

int  at_end( Player p1 );

void draw_view( Player p1 );
int  get_move( Player *p1 );

// ==============


main(){
    int     quit = 0;
    int     maze_num = 0;
    Player  p1;

    maze_num = intro();
    if( maze_num == 0 )
        exit( -1 );     // ESC key was pressed during intro routine.

    init_maze( &p1, maze_num );
    init_scr();

    while(( !at_end( p1 )) && ( !quit )){
        draw_view( p1 );
        quit = get_move( &p1 );
    }

    closegraph();

    system( "cls" );
    if( !quit ){
        printf( "\n\n" );
        printf( "   C O N G R A T U L A T I O N S  !!!!!\n\n" );
        printf( " You have successfully found your way out of the maze.\n" );
        printf( "\n\n" );
    }
    return( 0 );
}


// ------------------
int
intro(){
    printf( "\n\n\n" );
    printf( "   Welcome to the 3D people maze\n" );
    printf( "  ===============================\n\n" );
    printf( " This program is similar  to type of  maze  that mice are\n" );
    printf( " put into and are  timed to see how long it takes them to\n" );
    printf( " the cheese at the other end.  The big difference is that\n" );
    printf( " you are the mouse.  ( and there is no cheese. )  To give\n" );
    printf( " you the same  obstacles as  the mice,  the view you will\n" );
    printf( " have of the maze will be the same as the mice. It should\n" );
    printf( " look as if you are  walking down  a series of corridors.\n" );
    printf( " Your only object in this game is to find the position in\n" );
    printf( " the maze that releases you from it. Good Luck !!\n" );
    printf( "\n\n" );
    printf( " Controls :\n" );
    printf( "       Left Arrow  - turns you to the left 90 degrees.\n" );
    printf( "       Right Arrow - turns you to the right 90 degrees.\n" );
    printf( "       Up Arrow    - moves you forward one position.\n" );
    printf( "       ESC         - exit the game. ( give-up key )\n" );
    printf( "\n\n" );
    printf( " Choose maze type ( 1 = easy, 2 = intermediate ) :  " );

    int c = 0;
    while(( c != '1' ) && ( c != '2' ) && ( c != 27 )){
        c = getch();
        if( !c ){
            c = getch();
            c = 0;
        }
    }

    if( c == 27 ){
        printf( "Quit\n" );
        return( 0 );
    } else {
        printf( "%c\n", c );
        return( c );
    }
}

// ------------------
int
get_num( FILE *fp ){
    int     ch, done = 0;
    char    str[80], *s_ptr = str;

    while( !done ){
        do{
            ch = getc( fp );
        }while(( !isdigit( ch )) && ( ch != '#' ));

        if( ch == '#' ){
            while(( ch = getc( fp )) != '\n' );
        }
        else{
            while( isdigit( ch )){
                *s_ptr++ = ch;
                ch = getc( fp );
            }
            done = 1;
        }
    }

    *s_ptr = '\0';
    return( atoi( str ));
}

// ------------------
void
init_maze( Player *p1, int maze_num ){
    int     length, width;
    char    in_str[80], file_name[80];
    FILE    *fp;

    sprintf( file_name, "MAZE%c.DAT", maze_num );
    fp = fopen( file_name, "rt" );
    if( fp != NULL ){
        init_player( p1, fp );

        endX = get_num( fp );
        endY = get_num( fp );

        width = get_num( fp );
        length = get_num( fp );

        for( int y = 0; y < length; y++ ){
            for( int x = 0; x < width; x++ ){
                                Maze[x][y].N = get_num( fp );
                                Maze[x][y].S = get_num( fp );
                                Maze[x][y].E = get_num( fp );
                                Maze[x][y].W = get_num( fp );
            }
        }
    }
    else{
        exit( -1 );
    }
}

// ------------------
void
init_player( Player *p1, FILE *fp ){
    p1->X = get_num( fp );
    p1->Y = get_num( fp );
    p1->Dir = get_num( fp );
}

// ------------------
int
at_end( Player p1 ){
    if(( p1.X == endX ) && ( p1.Y == endY ))
        return( 1 );    // at the maze ending point.
    return( 0 );    // not at the maze ending point.
}

// ------------------
int
get_move( Player *p1 ){
    int ch, done = 0;

    while( !done ){
        ch = getch();
        if( !ch ){
            ch = getch();
            switch( ch ){
             case 72 :  // up arrow  --  move forward.
                done = 1;
                switch( p1->Dir ){
                 case NORTH :
                    if( Maze[p1->X][p1->Y].N != 1 )
                        p1->Y -= 1;
                    break;
                 case SOUTH :
                    if( Maze[p1->X][p1->Y].S != 1 )
                        p1->Y += 1;
                    break;
                 case EAST :
                    if( Maze[p1->X][p1->Y].E != 1 )
                        p1->X += 1;
                    break;
                 case WEST :
                    if( Maze[p1->X][p1->Y].W != 1 )
                        p1->X -= 1;
                    break;
                 default :
                    break;
                }
                break;
             case 75 :  // left arrow  --  turn left.
                done = 1;
                if( p1->Dir == NORTH )
                    p1->Dir = WEST;
                else if( p1->Dir == WEST )
                    p1->Dir = SOUTH;
                else if( p1->Dir == SOUTH )
                    p1->Dir = EAST;
                else
                    p1->Dir = NORTH;
                break;
             case 77 :  // right arrow  --  turn right.
                done = 1;
                if( p1->Dir == NORTH )
                    p1->Dir = EAST;
                else if( p1->Dir == EAST )
                    p1->Dir = SOUTH;
                else if( p1->Dir == SOUTH )
                    p1->Dir = WEST;
                else
                    p1->Dir = NORTH;
                break;
             default :
                break;
            }
        }
        else{
            switch( ch ){
             case 27  :
             case 'q' :
             case 'Q' :
                return( 1 );
             default :
                break;
            }
        }
    }

    return( 0 );
}

// ------------------
void
init_scr(){
    int gdriver = DETECT, gmode;

    initgraph( &gdriver, &gmode, "" );
    setbkcolor( BLACK );
    setcolor( WHITE );
}

// ------------------
int
wall_left( Player p ){
    switch( p.Dir ){
     case NORTH :
        return( Maze[p.X][p.Y].W == 1 );
     case SOUTH :
        return( Maze[p.X][p.Y].E == 1 );
     case EAST :
        return( Maze[p.X][p.Y].N == 1 );
     case WEST :
        return( Maze[p.X][p.Y].S == 1 );
     default :
        return( 1 );
    }
}

int
wall_right( Player p ){
    switch( p.Dir ){
     case NORTH :
        return( Maze[p.X][p.Y].E == 1 );
     case SOUTH :
        return( Maze[p.X][p.Y].W == 1 );
     case EAST :
        return( Maze[p.X][p.Y].S == 1 );
     case WEST :
        return( Maze[p.X][p.Y].N == 1 );
     default :
        return( 1 );
    }
}

int
wall_front( Player p ){
    switch( p.Dir ){
     case NORTH :
        return( Maze[p.X][p.Y].N == 1 );
     case SOUTH :
        return( Maze[p.X][p.Y].S == 1 );
     case EAST :
        return( Maze[p.X][p.Y].E == 1 );
     case WEST :
        return( Maze[p.X][p.Y].W == 1 );
     default :
        return( 1 );
    }
}

// ------------------
void
move_left( Player *p ){
    switch( p->Dir ){
     case NORTH :
        p->X -= 1;
        break;
     case SOUTH :
        p->X += 1;
        break;
     case EAST :
        p->Y -= 1;
        break;
     case WEST :
        p->Y += 1;
        break;
     default :
        break;
    }
}

void
move_right( Player *p ){
    switch( p->Dir ){
     case NORTH :
        p->X += 1;
        break;
     case SOUTH :
        p->X -= 1;
        break;
     case EAST :
        p->Y += 1;
        break;
     case WEST :
        p->Y -= 1;
        break;
     default :
        break;
    }
}

void
move_forward( Player *p ){
    switch( p->Dir ){
     case NORTH :
        p->Y -= 1;
        break;
     case SOUTH :
        p->Y += 1;
        break;
     case EAST :
        p->X += 1;
        break;
     case WEST :
        p->X -= 1;
        break;
     default :
        break;
    }
}

// ------------------
void
draw_view( Player p1 ){
    int section1, section2, section3, section4, section5, section6, section7;

    //  check left side.
    Player tp = p1;
    if( wall_left( tp ))
        section1 = 1;
    else{
        move_left( &tp );
        if( wall_front( tp ))
            section1 = 11;
        else{
            move_forward( &tp );
            if( wall_front( tp ))
                section1 = 14;
            else{
                move_forward( &tp );
                if( wall_left( tp ))
                    section1 = 7;
                else{
                    move_left( &tp );
                    if( wall_left( tp ))
                        section1 = 8;
                    else{
                        if( wall_front( tp ))
                            section1 = 17;
                        else
                            section1 = 0;
                    }
                }
            }
        }
    }
    //  check right side.
    tp = p1;
    if( wall_right( tp ))
        section2 = 4;
    else{
        move_right( &tp );
        if( wall_front( tp ))
            section2 = 13;
        else{
            move_forward( &tp );
            if( wall_front( tp ))
                section2 = 16;
            else{
                move_forward( &tp );
                if( wall_right( tp ))
                    section2 = 9;
                else{
                    move_right( &tp );
                    if( wall_right( tp ))
                        section2 = 10;
                    else{
                        if( wall_front( tp ))
                            section2 = 23;
                        else
                            section2 = 0;
                    }
                }
            }
        }
    }
    //  check forward.
    tp = p1;
    if( wall_front( tp )){
        section3 = 0;
        section4 = 0;
        section5 = 0;
        section6 = 0;
        section7 = 12;
    }
    else{
        move_forward( &tp );
        // check left.
        Player tp2 = tp;
        if( wall_left( tp2 ))
            section3 = 2;
        else{
            move_left( &tp2 );
            if( wall_front( tp2 ))
                section3 = 14;
            else{
                move_forward( &tp2 );
                if( wall_left( tp2 ))
                    section3 = 7;
                else{
                    move_left( &tp2 );
                    if( wall_front( tp2 ))
                        section3 = 18;
                    else
                        section3 = 0;
                }
            }
        }

        // check right.
        tp2 = tp;
        if( wall_right( tp2 ))
            section4 = 5;
        else{
            move_right( &tp2 );
            if( wall_front( tp2 ))
                section4 = 16;
            else{
                move_forward( &tp2 );
                if( wall_right( tp2 ))
                    section4 = 9;
                else{
                    move_right( &tp2 );
                    if( wall_front( tp2 ))
                        section4 = 22;
                    else
                        section4 = 0;
                }
            }
        }
        // check forward.
        if( wall_front( tp )){
            section5 = 0;
            section6 = 0;
            section7 = 15;
        }
        else{
            move_forward( &tp );
            // check left.
            tp2 = tp;
            if( wall_left( tp2 ))
                section5 = 3;
            else{
                move_left( &tp2 );
                if( wall_front( tp2 ))
                    section5 = 19;
                else
                    section5 = 0;
            }
            // check right.
            tp2 = tp;
            if( wall_right( tp2 ))
                section6 = 6;
            else{
                move_right( &tp2 );
                if( wall_front( tp2 ))
                    section6 = 21;
                else
                    section6 = 0;
            }
            // check forward.
            if( wall_front( tp ))
                section7 = 20;
            else
                section7 = 0;
        }
    }

    // do the graphics drawing.
//    clearviewport();
    cleardevice();
    rectangle( 100, 100, 310, 212 );    // view limit.
    // section 1
    switch( section1 ){
     case  1 :
        line( 100, 100, 130, 116 );
        line( 100, 212, 130, 196 );
        break;
     case 11 :
        line( 100, 116, 130, 116 );
        line( 100, 196, 130, 196 );
        break;
     case 14 :
        line( 100, 132, 130, 132 );
        line( 100, 180, 130, 180 );
        break;
     case  7 :
        line( 100, 137, 130, 143 );
        line( 100, 175, 130, 169 );
        break;
     case  8 :
        line( 100, 144, 130, 148 );
        line( 100, 168, 130, 164 );
        break;
     case 17 :
        line( 100, 148, 130, 148 );
        line( 100, 164, 130, 164 );
        break;
     default :
        break;
    }
    // section 2
    switch( section2 ){
     case  4 :
        line( 310, 100, 280, 116 );
        line( 310, 212, 280, 196 );
        break;
     case 13 :
        line( 310, 116, 280, 116 );
        line( 310, 196, 280, 196 );
        break;
     case 16 :
        line( 310, 132, 280, 132 );
        line( 310, 180, 280, 180 );
        break;
     case  9 :
        line( 310, 137, 280, 143 );
        line( 310, 175, 280, 169 );
        break;
     case 10 :
        line( 310, 144, 280, 148 );
        line( 310, 168, 280, 164 );
        break;
     case 23 :
        line( 310, 148, 280, 148 );
        line( 310, 164, 280, 164 );
        break;
     default :
        break;
    }
    // section 3
    switch( section3 ){
     case  2 :
        line( 130, 116, 160, 132 );
        line( 130, 196, 160, 180 );
        break;
     case 14 :
        line( 130, 132, 160, 132 );
        line( 130, 180, 160, 180 );
        break;
     case  7 :
        line( 130, 143, 160, 148 );
        line( 130, 169, 160, 164 );
        break;
     case 18 :
        line( 130, 148, 160, 148 );
        line( 130, 164, 160, 164 );
        break;
     default :
        break;
    }
    // section 4
    switch( section4 ){
     case  5 :
        line( 280, 116, 250, 132 );
        line( 280, 196, 250, 180 );
        break;
     case 16 :
        line( 280, 132, 250, 132 );
        line( 280, 180, 250, 180 );
        break;
     case  9 :
        line( 280, 143, 250, 148 );
        line( 280, 169, 250, 164 );
        break;
     case 22 :
        line( 280, 148, 250, 148 );
        line( 280, 164, 250, 164 );
        break;
     default :
        break;
    }
    // section 5
    switch( section5 ){
     case  3 :
        line( 160, 132, 190, 148 );
        line( 160, 180, 190, 164 );
        break;
     case 19 :
        line( 160, 148, 190, 148 );
        line( 160, 164, 190, 164 );
        break;
     default :
        break;
    }
    // section 6
    switch( section6 ){
     case  6 :
        line( 250, 132, 220, 148 );
        line( 250, 180, 220, 164 );
        break;
     case 21 :
        line( 250, 148, 220, 148 );
        line( 250, 164, 220, 164 );
        break;
     default :
        break;
    }
    // section 7
    switch( section7 ){
     case 12 :
        line( 130, 116, 280, 116 );
        line( 130, 196, 280, 196 );
        break;
     case 15 :
        line( 160, 132, 250, 132 );
        line( 160, 180, 250, 180 );
        break;
     case 20 :
        line( 190, 148, 220, 148 );
        line( 190, 164, 220, 164 );
        break;
     default :
        break;
    }

    // draw needed intersections.
    if(( section1 == 1 ) || ( section1 == 11 ) ||
       ( section3 == 2 ) || ( section7 == 12 )){
        if(!((( section1 == 1 ) && ( section3 == 2 )) ||
           (( section1 == 11 ) && ( section7 == 12 ))))
            line( 130, 116, 130, 196 );
    }

    if(( section2 == 4 ) || ( section2 == 13 ) ||
       ( section4 == 5 ) || ( section7 == 12 )){
        if(!((( section2 == 4 ) && ( section4 == 5 )) ||
           (( section2 == 13 ) && ( section7 == 12 ))))
            line( 280, 116, 280, 196 );
    }

    if(( section3 == 2 ) || ( section3 == 14 ) ||
       ( section5 == 3 ) || ( section7 == 15 )){
        if(!((( section3 == 2 ) && ( section5 == 3 )) ||
           (( section3 == 14 ) && ( section7 == 15 ))))
            line( 160, 132, 160, 180 );
    }

    if(( section4 == 5 ) || ( section4 == 16 ) ||
       ( section6 == 6 ) || ( section7 == 15 )){
        if(!((( section4 == 5 ) && ( section6 == 6 )) ||
           (( section4 == 16 ) && ( section7 == 15 ))))
            line( 250, 132, 250, 180 );
    }

    if(( section5 == 3 ) || ( section5 == 19 ) || ( section7 == 20 )){
        if(!(( section5 == 19 ) && ( section7 == 20 )))
            line( 190, 148, 190, 164 );
    }

    if(( section6 == 6 ) || ( section6 == 21 ) || ( section7 == 20 )){
        if(!(( section6 == 21 ) && ( section7 == 20 )))
            line( 220, 148, 220, 164 );
    }
}

// ------------------
// ------------------
