/* Android Nim Game - Microsoft QuickC - (c) 1991 Leo Christopherson*/

#include <stdio.h>
#include <conio.h>
#include <graph.h>
#include <malloc.h>
#include <math.h>

#define head_cnt   9                   /* Number of Head Frames */
#define arms_cnt  10                   /* Number of Arm Frames */
#define fire_cnt   6                   /* Number of Arm-Firing Frames */
#define blowup_cnt 6                   /* Number of blowup Frames */

									   /* Pointers to Arrays */
char far *head[head_cnt];              /* Head Arrays */
char far *blink[head_cnt];             /* Blink Arrays */
char far *arms[arms_cnt];              /* Arms Arrays */
char far *fire[fire_cnt];              /* Head Arrays */
char far *blowup[blowup_cnt];          /* Blowup Array Arrays */
char far *filename1 = "HEAD_X.BIN";    /* Head Array LOAD Blank */
char far *filename2 = "BLINK_X.BIN";   /* Blink Array LOAD Blank */
char far *filename3 = "ARMS_X.BIN";    /* Arms Array LOAD Blank */
char far *filename4 = "FIRE_X.BIN";    /* Fire Array LOAD Blank */
char far *filename5 = "BLOW_X.BIN";    /* Blowup Array LOAD Blank */
char far *body[1];                     /* Body Array Name */
char far *screen;                      /* Background Screen */

/* Macro to get a random integer within a specified range, min to max */
#define getrandom( min, max ) ((rand() % (int)((max) - (min))) + (min) + 1)

/* use: srand( (unsigned)time( NULL ) ); to seed random function */
/* use: getrandom( min, max ); to get random number */

										 /* Functions */
void delay( int );                       /* Animation Delay */
void load_arrays( void );                /* Load all Graphics Arrays */
void initialize( void );                 /* Set up start of game */
void control( void );                    /* Control for Game */
void look_around( int a, int b, int c ); /* Main Android animation */
void save_config( void );                /* Save speed, color mode */
void load_config( void );                /* Re-set speed, color mode */
void player_move( void );                /* To select row and how many */
void computer_move( void );              /* Computer is player 2 */
void move_to_win( void );                /* Computer move: row?  */
void base_2( void );                     /* Base Two converter */
void fire_gun( void );                   /* To take androids */
void play_music( int );                  /* Make musical tones */
void gun_sound( int );                   /* Upweep gun sound */
void gun_shot( int );                    /* Gun bang sound */
void help( void );                       /* Set help screen */
int  _kbhit( void );                     /* Improved keyboard scan */

int delay_number = 7;                    /* Delay factor */
int flag1, flag2, flag3, speed, palette; /* Over-all animation delay */
int config[0][3] = { { 5000, 2, 1 } };   /* Array for speed, color mode */
int andy[19][12];                        /* Current andy characteristics */
int rows[4][5];                          /* Current row numbers */
int sum[4];                              /* array to process base 2 numbers */
int r[4];                                /* array to process base 2 numbers */
int row, how_many;                       /* Variables for game */
int starter;                             /* Who starts? flag */
int player2;                             /* 2nd player person or computer? */
int computer;                            /* Computer play level flag */
int sound;                               /* Sound flag */
int turns;                               /* Number of turns */

int andy_init[19][12] =                  /* Andy init. characteristics */
	{
		{   0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0 }, /*  0 = x-position       */
		{  80,  20, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  1 = y-position       */
		{ 112,  20, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  2 = head status      */
		{ 144,  20, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  3 = new head frame#  */
		{ 176,  20, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  4 = (not used)       */
		{ 208,  20, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  5 = head frame#      */
		{ 240,  20, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  6 = R-Arm status     */
		{ 272,  20, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  7 = R-Arm frame#     */
		{ 128,  70, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  8 = L-Arm status     */
		{ 160,  70, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /*  9 = L-Arm frame#     */
		{ 192,  70, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /* 10 = Blink status     */
		{ 224,  70, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /* 11 = Blowup counter   */
		{ 256,  70, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 },
		{ 144, 120, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /* Status:               */
		{ 176, 120, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /* 0 = android gone      */
		{ 208, 120, 1, 0, 0, 2, 1, 1, 1, 8, 1, 0 }, /* 1 = OK, set animation */
		{  24,  20, 1, 0, 0, 4, 1, 3, 1, 6, 1, 0 }, /* 2 = Block animation   */
		{  32,  70, 1, 0, 0, 4, 1, 3, 1, 6, 1, 0 },
		{  40, 120, 1, 0, 0, 4, 1, 3, 1, 6, 1, 0 }
	};

char help_screen[21][39] =                          /* Help Screen Array */
	{
		{ "Menu Screen:                          " },
		{ "Press <1> or <ENTER> to start the game" },
		{ "Pressing <2> or <ESC> goes back to DOS" },
		{ "Pressing <3> sets who makes first move" },
		{ "<4> sets player 2 as human or computer" },
		{ "Use <5> to pick the computer's ability" },
		{ "Using <6> toggles 4 color combinations" },
		{ "Press <7> to turn sound effects on/off" },
		{ "<+> and <-> effect the animation speed" },
		{ "Play Screen:                          " },
		{ "When it is your turn, <1>, <2>, or <3>" },
		{ "top to bottom, is used to select a row" },
		{ "Pressing the space bar allows a player" },
		{ "to re-select a row, then press the key" },
		{ "for the number of androids to be taken" },
		{ "Press <ESC> to cancel the current game" },
		{ "Rules for Nim:                        " },
		{ "When it is your turn remove the number" },
		{ "of androids you wish from just one row" },
		{ "You win if you remove the last android" },
		{ "-Press <ESC> to return to Menu Screen-" }
	};

main()
{
	char ch;
	int d, q, r, x, y;
	int arrow =  1;
	flag1     = 0;
	starter   = 1;
	player2   = 2;
	computer  = 2;
	sound     = 1;

	if( _setvideomode( _MRES4COLOR ) == 0 ) /* Set video mode */
		{
			_setvideomode( _DEFAULTMODE );
			_clearscreen( _GCLEARSCREEN );
			printf( "Program Requires CGA Graphics." );
			exit(0);
		}

	_setbkcolor( _BLACK );
	_clearscreen( _GCLEARSCREEN );
	srand( (unsigned)time( NULL ) );

	flag1 = 1;                              /* Load configurations */
	load_config();
	if( flag1 == 1 )
	{
		speed   = config[0][0];
		palette = config[0][1];
		arrow   = config[0][2];
	}
	else
		{                                    /* Or set config. if none saved */
			speed   = 32000;
			palette =     2;
			arrow   =     1;
		}

	_selectpalette( palette );              /* Load Graphic Files */
	_settextposition( 18, 7 );
	printf( "Loading Program" );
	flag1 = 1;
	load_arrays();

	if( flag1 == 0 )
		{
			_setvideomode( _DEFAULTMODE );
			_clearscreen( _GCLEARSCREEN );
			printf( "Cannot Load Necessary Files." );
			exit(0);
		}

	_putimage( 0, 0, screen, _GPSET );


	while( ch != 27 )                             /* Main Menu Messages */
	{
		_settextposition(  6,  8 );                       /* Play Game */
		printf( "<1> Play Android Nim" );

		_settextposition(  7,  8 );                       /* Quit Game */
		printf( "<2> Quit Android Nim" );

		_settextposition(  9,  8 );                       /* Help Screen */
		printf( "<F1> for Help Screen" );

		_settextposition( 11,  8 );                       /* Set Who Starts */
		printf( "<3> Who starts?:  " ),
		_settextposition( 11, 26 );
		switch( starter )
		{
			case 1:
			printf( "Player 1" );
				break;
			case 2:
			printf( "Player 2" );
				break;
			case 3:
			printf( "Computer" );
				break;
			default:
				break;
		}

		_settextposition( 12,  8 );                       /* Set Player 2 */
		printf( "<4> Player Two?:  " );
		_settextposition( 12, 26 );
		if( player2 == 2 )
			printf( "Player 2" );
		else
			printf( "Computer" );

		_settextposition( 13,  8 );
		if( player2 == 3 )                                /* Set Computer */
		{
			printf( "<5> Computer is:  " );
			_settextposition( 13, 26 );

			switch( computer )
			{
				case 1:
					printf( "[Bright]" );
					break;
				case 2:
					printf( "[Normal]" );
					break;
				case 3:
					printf( "[Stupid]" );
					break;
				default:
					break;
			}

		}
		else
			printf( "                            " );

		_settextposition( 15,  8 );                       /* Set Palette */
		printf( "<6> Set palette:  Number%2d", palette );

		_settextposition( 16,  8 );
		printf( "<7> Set effects:  " );                   /* Set Sound Effects */
		_settextposition( 16, 26 );
		if( sound == 1 )
			printf( "Sound on" );
		else
			printf( "No sound" );

		_settextposition( 18, 6 );
		printf( "<-> slower..........faster <+>" );       /* Set Speed */

		_settextposition( 19, 6 );
		printf( " ____________________________ " );

		_settextposition( 19, 6 + arrow/2 );
		printf( "%c", 24 );

		_settextposition( 22, 7 );                        /* Set (c) Notice */
		printf( "(c) 1991  Leo Christopherson" );


							   /* Set test Android on screen for speed adj. */
		_putimage( 240,  20, head[2], _GPSET );
		_putimage( 240,  38, body[0], _GPSET );
		_putimage( 256,  38, arms[1], _GPSET );
		_putimage( 240,  38, arms[8], _GPSET );

		q = 0;

		while( !_kbhit() )
		{
			for( x = 2; x < 5; x++ )
			{
			_putimage( 240,  20, head[x], _GPSET );
				delay( delay_number );
			}

			for( x = 4; x > 1; x-- )
			{
			_putimage( 240,  20, head[x], _GPSET );
				delay( delay_number );
			}
		}

		ch = getch();
		if( ch == 0 || ch == 0XE0 )
		{
			ch = getch();
			if( ch == 59 ) help();
		}
		else
		{
			switch( ch )
			{
				case '-':                         /* delay loops - slower */
					if( arrow > 1 ) arrow--;
					if( speed <  10   ) d = 1;
					if( speed >= 10   ) d = 10;
					if( speed >= 100  ) d = 100;
					if( speed >= 1000 ) d = 1000;
					if( speed < 32000 ) speed += d;
					else
						speed = 32000;
					break;
				case '+':                         /* delay loops - faster */
					if( arrow < 59 ) arrow++;
					if( speed >  1000  ) d = 1000;
					if( speed <= 1000  ) d = 100;
					if( speed <= 100   ) d = 10;
					if( speed <= 10    ) d = 1;
					if( speed > 1 ) speed -= d;
					else
						speed = 1;
					break;
				case '1':        /* Start Game */
				case '\r':
					_putimage( 0, 0, screen, _GPSET );
					initialize();
					control();
					_putimage( 0, 0, screen, _GPSET );
					break;
				case '2':        /* exit the program */
					goto Leave_Program_1;
					break;
				case '3':        /* Set Who starts */
					if( starter == 1 ) starter = player2;
					else
						starter = 1;
					break;
				case '4':        /* Set 2nd Player */
					if( player2 == 2 ) player2 = 3;
					else
						player2 = 2;
					if( starter != 1 ) starter = player2;
					break;
				case '5':        /* Set computer ability */
					if( ++computer > 3 ) computer = 1;
					break;
				case '6':        /* Change Palette Colors */
					if( palette++ > 2 ) palette = 0;
					_selectpalette( palette );
					break;
				case '7':        /* Set  Sound Effects on/off */
					if( sound == 1 ) sound = 0;
					else
						sound = 1;
					break;
				default:
					break;
			}
		}
	}

Leave_Program_1:

	config[0][0] = speed;                 /* Save speed and color info */
	config[0][1] = palette;
	config[0][2] = arrow;
	save_config();

	_setvideomode( _DEFAULTMODE );
}

void initialize( void )                  /* Set for start of game */
{
	int x, y;
	turns = 1;
	rows[1][0] = 7;
	rows[2][0] = 5;
	rows[3][0] = 3;

	for(y = 0; y < 19; y++ )              /* init android array */
	{
		for(x = 0; x < 12; x++ )
			andy[y][x] = andy_init[y][x];
	}

	for( x = 1; x < 19; x++ )             /* Androids to screen */
	{
		_putimage ( andy[x][0], andy[x][1], head[andy[x][5]], _GPSET );
		_putimage ( andy[x][0], andy[x][1] + 18, body[0], _GPSET );
		_putimage ( andy[x][0] + 16, andy[x][1] + 18, arms[andy[x][7]], _GPSET );
		_putimage ( andy[x][0], andy[x][1] + 18, arms[andy[x][9]], _GPSET );
	}

}

void control( void )                     /* Game Control */
{
	int x;
	int winner;
	int game_over = 1;
	int whose_turn = starter;
	char ch;
	flag3 = 1;

	while( game_over != 0 )
	{
	   switch( whose_turn )
		{
			case 1:                /* Player 1 */
LOOP_1:
				_settextposition( 22, 7 );
				printf( "   Player 1              " );
				flag2 = 0;                            /* Flag 2: bad move */
				player_move();
				if( flag3 == 0 ) break;               /* Flag 3: <ESC> pressed */
				_settextposition( 2, 6 );
				printf( "Row %d", row );
				_settextposition( 2, 30 );
				printf( "Take %d", how_many );
				fire_gun();
				if( flag2 == 0 ) goto LOOP_1;
				break;

			case 2:                /* Player 2 */
LOOP_2:

				_settextposition( 22, 7 );
				printf( "   Player 2              " );
				flag2 = 0;
				player_move();
				if( flag3 == 0 ) break;
				_settextposition( 2, 6 );
				printf( "Row %d", row );
				_settextposition( 2, 30 );
				printf( "Take %d", how_many );
				fire_gun();
				if( flag2 == 0 ) goto LOOP_2;
				break;

			case 3:                /* Computer */
LOOP_3:
				_settextposition( 22, 7 );
				printf( "   Computer's Turn       " );
				flag2 = 0;
				computer_move();
				_settextposition( 2, 6 );
				printf( "Row %d", row );
				_settextposition( 2, 30 );
				printf( "Take %d", how_many );
				fire_gun();
				break;

			default:
				break;
		}

		turns += 1;

		_settextposition( 2, 6 );             /* Remove Messages */
		printf( "        " );
		_settextposition( 2, 30 );
		printf( "        " );

		_settextposition( 22, 7 );
		printf( "                             " );
		_settextposition( 23, 7 );
		printf( "                             " );

		if( flag3 == 0 )                         /* Cancel Game */
			{
				flag3 = 1;
				_settextposition( 22, 7 );
				printf( "        Game Is Canceled    " );
				for( x = 1; x < 4; x++ ) rows[x][0] = 0;
				for( x = 1; x < 16; x++ )
				{                                  /* blowup androids */
					andy[x][2] = 0;
					look_around( 1, 18, 0 );
				}
				for( x = 0; x < 6; x++ ) look_around( 1, 18, 0 );
			}

		winner = whose_turn;

		if( whose_turn == 1 ) whose_turn = player2;
		else
			whose_turn = 1;
		if( flag3 == 0 ) winner = whose_turn;

		if( rows[1][0] + rows[2][0] + rows[3][0] == 0 ) game_over = 0;
	}

	_settextposition( 11, 14 );

	switch( winner )
	{
		case 1:
			printf( "    Player 1 Wins!" );
			break;
		case 2:
			printf( "    Player 2 Wins!" );
			break;
		case 3:
			printf( "The Computer Wins!" );
			break;
		default:
			break;
	}
	_settextposition( 13, 14 );
	printf( "    Press Any Key " );
	_settextposition( 14, 14 );
	printf( "     To Continue  " );

	while( !_kbhit() )
	{
		look_around( 16, 18, 0 );
	}
	ch = getch();
	if( ch == 0 || ch == 0XE0 ) ch = getch();
}

void player_move( void )
{
	char ch;
	flag3 = 1;

LOOP_1:
	row = 0;

	_settextposition( 23, 7 );
	printf( "   Which Row:  1, 2, or 3?" );

	while( row == 0 )
	{
		while( !_kbhit() )
		{
			look_around( 1, 18, 0 );
		}

		ch = getch();
		if( ch == 0 || ch == 0XE0 ) ch = getch();

		switch( ch )                        /* Player select Row */
		{
			case '1':
				row = 1;
				break;
			case '2':
				row = 2;
				break;
			case '3':
				row = 3;
				break;
			case 27:
				flag3 = 0;
				return;
				break;
			default:
				break;
		}
	}

	how_many = 0;

	_settextposition( 23, 7 );
	printf( " Take how many from row %d?  ", row );

	while( how_many == 0 )
	{
		while( !_kbhit() )
		{
			look_around( 1, 18, 0 );
		}

		ch = getch();
		if( ch == 0 || ch == 0XE0 ) ch = getch();

		switch( ch )                     /* Player select how many */
		{
			case '1':
				how_many = 1;
				break;
			case '2':
				how_many = 2;
				break;
			case '3':
				how_many = 3;
				break;
			case '4':
				how_many = 4;
				break;
			case '5':
				how_many = 5;
				break;
			case '6':
				how_many = 6;
				break;
			case '7':
				how_many = 7;
				break;
			case ' ':
				goto LOOP_1;
				break;
			case 27:
				flag3 = 0;
				return;
				break;
			default:
				break;
		}
	}
	_settextposition( 22, 7 );
	printf( "                             " );
	_settextposition( 23, 7 );
	printf( "                             " );
}

void computer_move( void )
{
	int mix, x;

	base_2();                           /* Wining move possible? */
	if( ( sum[1] % 2 ) == 0 && ( sum[2] % 2 ) == 0 && ( sum[3] % 2 ) == 0 )
	{
LOOP_3:
		row = getrandom( 1, 4 ) - 1;     /* No win or random move */
		how_many = getrandom( 1, 3 ) - 1;
		if( ( how_many > rows[row][0] ) || ( rows[row][0] == 0 ) )
			goto LOOP_3;
		return;
	}
	else
		if( turns > ( computer - 1 ) * 4 )  /* Set for winning move */
		{
			mix = getrandom( 0, 7 ) - 1;
			switch( mix )
			{
				case 0:
					r[1] = 1; r[2] = 2; r[3] = 3;
					break;
				case 1:
					r[1] = 1; r[2] = 3; r[3] = 2;
					break;
				case 2:
					r[1] = 2; r[2] = 3; r[3] = 1;
					break;
				case 3:
					r[1] = 2; r[2] = 1; r[3] = 3;
					break;
				case 4:
					r[1] = 3; r[2] = 1; r[3] = 2;
					break;
				case 5:
					r[1] = 3; r[2] = 2; r[3] = 1;
					break;

				default:
					break;
			}
			move_to_win();                      /* Get move to win */
			if( flag2 == 0 ) goto LOOP_3;       /* Random move */
		}
		else
			goto LOOP_3;
}

void move_to_win( void )
{
	char ch;
	int x;

	for( x = 1; x < 4; x++ )             /* Try possible moves until */
	{                                    /* sum of bit positions is even */
		row = r[x];
		rows[r[x]][4] = rows[r[x]][0];
		if( rows[r[x]][4] != 0 )
		{
			for( rows[r[x]][0] = 0; rows[r[x]][0] < rows[r[x]][4]; rows[r[x]][0] += 1 )
			{
				base_2();

				if( ( sum[1] % 2 ) == 0 && ( sum[2] % 2 ) == 0 && ( sum[3] % 2 ) == 0 )
				{
					how_many = rows[r[x]][4] - rows[r[x]][0];
					rows[r[x]][0] = rows[r[x]][4];
					flag2 = 1;
					return;
				}
			}
		}

		rows[r[x]][0] = rows[r[x]][4];
	}

	flag2 = 0;

}

void base_2( void )
{
	int x;

	for( x = 1; x < 4; x++ )             /* convert rows to base 2 */
	{
		switch( rows[x][0] )
		{
			case 0:
				rows[x][1] = 0;
				rows[x][2] = 0;
				rows[x][3] = 0;
				break;
			case 1:
				rows[x][1] = 0;
				rows[x][2] = 0;
				rows[x][3] = 1;
				break;
			case 2:
				rows[x][1] = 0;
				rows[x][2] = 1;
				rows[x][3] = 0;
				break;
			case 3:
				rows[x][1] = 0;
				rows[x][2] = 1;
				rows[x][3] = 1;
				break;
			case 4:
				rows[x][1] = 1;
				rows[x][2] = 0;
				rows[x][3] = 0;
				break;
			case 5:
				rows[x][1] = 1;
				rows[x][2] = 0;
				rows[x][3] = 1;
				break;
			case 6:
				rows[x][1] = 1;
				rows[x][2] = 1;
				rows[x][3] = 0;
				break;
			case 7:
				rows[x][1] = 1;
				rows[x][2] = 1;
				rows[x][3] = 1;
				break;
			default:
				break;
		}
	}
                                   /* Find sums of bit positions */
	for( x = 1; x < 4; x++ )
		sum[x] = rows[1][x] + rows[2][x] + rows[3][x];
}

void fire_gun( void )              /* Remove selected androids */
{
	char ch;
	int v, w, x, z;
	int y = row + 15;

	/* Check for legal move: turn head - nod, etc. */

	andy[y][3] = 6;                /* Turn head right */
	for( x = 0; x < 6; x++ )
	{
		andy[y][2] = 2;
		look_around( 1, 18, 0 );
	}
	_putimage ( andy[y][0], andy[y][1], head[6], _GPSET );
	delay( delay_number );

	for( x = 0; x < 6; x++ )       /* delay */
	{
		look_around( 1, 18, y );
	}

	andy[y][3] = 3;                /* Turn head front */
	for( x = 5; x > -1; x-- )
	{
		andy[y][2] = 2;
		look_around( 1, 18, 0 );
	}
	_putimage ( andy[y][0], andy[y][1], head[3], _GPSET );
	delay( delay_number );

	if( ( how_many > rows[row][0] ) || ( rows[row][0] == 0 ) ) /* Shake no */
	{
		for( z = 0; z < getrandom( 2, 4 ); z++ )
		{
			for( x = 2; x < 5; x++ )
			{
				andy[y][10] = 1;
				andy[y][5] = x;
				andy[y][2] = 2;
				look_around( 1, 18, y );
			}

			for( x = 4; x > 1; x-- )
			{
				andy[y][10] = 1;
				andy[y][5] = x;
				andy[y][2] = 2;
				look_around( 1, 18, y );
			}
		}
		andy[y][5] = 2;

		for( x = 0; x < 4; x++ )               /* Face front */
		{
			andy[y][2] = 2; andy[y][3] = 3;
			look_around( 1, 18, 0 );
		}

		flag2 = 0;
		return;
	}

	for( z = 0; z < getrandom( 2, 4 ); z++ )  /* Nod head Yes */
	{
		andy[y][10] = 1;
		andy[y][5] = 7;
		andy[y][2] = 2;
		look_around( 1, 18, y );

		andy[y][10] = 1;
		andy[y][5] = 3;
		andy[y][2] = 2;
		look_around( 1, 18, y );

		andy[y][10] = 1;
		andy[y][5] = 8;
		andy[y][2] = 2;
		look_around( 1, 18, y );

		andy[y][10] = 1;
		andy[y][5] = 3;
		andy[y][2] = 2;
		look_around( 1, 18, y );
	}

	andy[y][3] = 6;                           /* Turn head and raise arm */
	for( x = 0; x < 6; x++ )
	{
		andy[y][2] = 2;
		_putimage ( andy[y][0] + 16, andy[y][1] + 18, fire[x], _GPSET );
		look_around( 1, 18, y );
	}
	_putimage ( andy[y][0], andy[y][1], head[6], _GPSET );
	delay( delay_number );

											            /* fire and remove androids */
	andy[y][10] = 1;
	for( x = 0; x < 4; x++ )
	{
		look_around( 1, 18, y );         /* Pause */
	}

	switch( row )
	{                                   /* Get # of 1st android to blow up */
		case 1:
			x =  8 - rows[1][0];
			w = 16;
			break;
		case 2:
			x = 13 - rows[2][0];
			w = 17;
			break;
		case 3:
			x = 16 - rows[3][0];
			w = 18;
			break;
		default:
			break;
	}

	for( z = x; z < x + how_many; z++ ) /* set for and start blow up */
	{
		andy[z][2] = 0;
		andy[y][10] = 1;
		_setcolor( 3 );
		for( v = andy[w][0] + 38; v < andy[z][0] + 11; v += 8 )
		{
			_moveto( v + 3, andy[w][1] + 19 );
			_lineto( v,     andy[z][1] + 19 );
		}
		gun_shot( 2 );
		look_around( 1, 18, y );
		_setcolor( 0 );
		gun_sound( 1 );
		_moveto( andy[w][0] + 38, andy[w][1] + 19 );
		_lineto( andy[z][0] + 11, andy[z][1] + 19 );
	}

	andy[y][10] = 1;
	for( x = 0; x < 4; x++ )
	{
		look_around( 1, 18, y );         /* Pause */
	}

	andy[y][3] = 3;                           /* Lower arm after firing */
	for( x = 5; x > -1; x-- )
	{
		andy[y][2] = 2;
		_putimage ( andy[y][0] + 16, andy[y][1] + 18, fire[x], _GPSET );
		look_around( 1, 18, 0 );
	}
	_putimage ( andy[y][0], andy[y][1], head[3], _GPSET );
	delay( delay_number );

	rows[row][0] -= how_many;
	flag2 = 1;
}

void look_around( int lower, int upper, int except ) /* Animate androids */
{
	int x;

	for( x = lower; x < upper + 1; x++ )       /* Android blowup or gone? */
	{
		if( andy[x][2] == 0 )
			{
				if( andy[x][11] != 5 )
					andy[x][11] += 1;
			}
		else                                   /* Set android animation */
		{
			if( andy[x][2] == 1 && x != except ) /* Set head animation */
			{
				if( getrandom( 0, 15 ) == 1 )
				{
					andy[x][3] = getrandom( 0, 7 ) - 1;
					andy[x][2] = 2;
				}
			}

			if( andy[x][6] == 1 && x != except ) /* Set Right Arm */
			{
				if( getrandom( 0, 37) == 1 )
				{
					andy[x][7] = getrandom( 0, 4) - 1;
					andy[x][6] = 2;
				}
			}

			if( andy[x][8] == 1 && x != except ) /* Set Left Arm */
			{
				if( getrandom( 0, 37) == 1 )
				{
					andy[x][9] = getrandom( 0, 4) + 4;
					andy[x][8] = 2;
				}
			}

			if ( x != except )
			{
				if( andy[x][10] == 1 )            /* Set blinking */
				{
					if( getrandom( 0, 15) == 1 )
					{
						andy[x][10] = 2;
					}
				}
				else
				{
					andy[x][10] = 1; andy[x][2] = 2;
				}
			}
		}
	}

									       /* Place android on screen */
	for( x = lower; x < upper + 1; x++ )
	{
		if( andy[x][2] == 0 )
			{
				if( andy[x][11] == 5 )
				_putimage ( andy[x][0], andy[x][1], blowup[5], _GPSET );
				else
				_putimage ( andy[x][0], andy[x][1], blowup[andy[x][11]], _GXOR );
			}
		else
		{
			if( andy[x][2] == 2 )                /* Head to screen */
			{
				_putimage ( andy[x][0], andy[x][1], head[andy[x][5]], _GPSET );
				if( andy[x][3] == andy[x][5] )
					andy[x][2] = 1;
				else
				{
					if( andy[x][3] > andy[x][5] ) andy[x][5] += 1;
					else
						andy[x][5] -= 1;
				}
			}

			if( andy[x][6] == 2 )                /* Right Arm to screen */
			{
				_putimage ( andy[x][0] + 16, andy[x][1] + 18, arms[andy[x][7]], _GPSET );
				andy[x][6] = 1;
			}

			if( andy[x][8] == 2 )                /* Left Arm to screen */
			{
				_putimage ( andy[x][0], andy[x][1] + 18, arms[andy[x][9]], _GPSET );
				andy[x][8] = 1;
			}

			if( andy[x][10] == 2 )               /* Blink to screen */
			{
				_putimage ( andy[x][0], andy[x][1], blink[andy[x][5]], _GPSET );
			}
		}
	}
	delay( delay_number );
}

void help( void )                             /* Set Help Screen */
{
	int x;
	char ch;

	_putimage( 0, 0, screen, _GPSET );

	for( x = 0; x < 21; x++ )
	{
		_settextposition( x + 3, 2 );
		printf( &help_screen[x][0] );
	}

	while( ch != 27 )
	{
		while( !_kbhit() );
		ch = getch();
		if( ch == 0 || ch == 0XE0 ) ch = getch();
	}
	_putimage( 0, 0, screen, _GPSET );
}

void gun_sound( int sound )                  /* Make 2nd gun sound */
{
	int sweep;
	int delay1;
	if( sound != 1 ) return;

	switch( sound )
	{
		case 0:
			break;
		case 1:										    /* upsweep */
			for( sweep = 2500; sweep < 3500; sweep += 250 )
			{
				play_music( sweep );
				for( delay1 = 2000; delay1 > 0; delay1-- );
			}
			break;
		default:
			break;
	}
	play_music( 0 );
}

void gun_shot( int type )                     /* Make 1st gun sound */
{
	unsigned int status;

	if( sound != 1 ) return;
	switch( type )
	{
		case 0:
			break;
		case 1:                         /* higher shot sound */
			_asm \
			{
						mov   dx,140h       ; initial value of frequency
						mov   bx,10h        ; set count (duration)
						in    al,61h        ; get speaker control byte
						mov   status,al     ; save control byte
						and   al,11111100b  ; AND off bits 1 and 0
		sound1:		xor   al,2          ; toggle bit 1 in AL
						out   61h,al        ; output control byte
						add   dx,9248h      ; add random bit pattern
						mov   cl,3          ; set to rotate 3 bits
						ror   dx,cl         ; rotate it
						mov   cx,dx         ; put frequency in CX
						and   cx,90h        ; set lower limit of frequency
						or    cx,10h        ; set upper limit of frequency
		delay3:		loop  delay3        ; wait for frequency duration
						dec   bx            ; decrement count (duration)
						jnz   sound1        ; loop if not done
						mov   al,status     ; get former speaker status
						out   61h,al        ; restore speaker status
			}
			break;
		case 2:                         /* lower shot sound */
			_asm \
			{
						mov   dx,140h       ; essentially the same as case 1
						mov   bx,10h
						in    al,61h
						mov   status,al
						and   al,11111100b
		sound2:		xor   al,2
						out   61h,al
						add   dx,9248h
						mov   cl,3
						ror   dx,cl
						mov   cx,dx
						and   cx,3ffh
						or    cx,10h
		delay4:		loop  delay4
						dec   bx
						jnz   sound2
						mov   al,status
						out   61h,al
			}
			break;
		}
}

void play_music( int note )                   /* Make musical notes */
{                                             /* Used for gun upsweep */
	int freq = note;
	if( sound != 1 ) return;
	_asm\
	{
					mov   al,note        ; load al with note number
					cmp   al,0           ; compare with "note off = zero"
					jz    noteoff        ; if zero turh off speaker
					cmp   al,1           ; compare with "skip on = one"
					jz    finish         ; leave routine
					mov   ax,34DEh       ; numerator-low word
					mov   dx,12h         ; numerator-high word
					mov   cx,freq        ; put freq in cx
					div   cx             ; divide-with pitch number
					mov   freq,ax        ; save quotient (frequency) in freq
					mov   al,10110110b   ; special number to initialize port
					out   43h,al         ; out to timer2
					mov   ax,freq        ; frequency into ax
					out   42h,al         ; LSB to timer2
					mov   al,ah          ; MSB to al
					out   42h,al         ; MSB to timer2
					in    al,61h         ; reads speaker control port to al
					or    al,3           ; turns on bits 0 and 1
					out   61h,al         ; turns on speaker
					jmp   finish         ; exit with note playing
	noteoff:		in    al,61h         ; get speaker control byte
					and   al,11111100b   ; mask off bit 0 and 1
					out   61h,al         ; turn off speaker
	finish:
	}
}

void load_arrays( void )
{
	FILE *ap;
	int x;

		 /* Load Head Arrays */
	for( x = 0; x < head_cnt; x++ )
	{
		head[x] = ( char far * ) malloc( ( unsigned int )
				  _imagesize( 0, 0, 23, 17 ) );

		if( head[x] != NULL )
		{
			filename1[5] = 'A' + x;
			if( ( ap = fopen( filename1, "rb" ) ) != NULL )
			{
				fread( head[x], ( unsigned int )
					 _imagesize( 0, 0, 23, 17 ) , 1, ap );
				fclose( ap );
			}
			else
				flag1 = 0;
		}
		else
			flag1 = 0;
	}

		/* Load Blinker Arrays */
	for( x = 0; x < head_cnt; x++ )
	{
		blink[x] = ( char far * ) malloc( ( unsigned int )
				  _imagesize( 0, 0, 23, 17 ) );

		if( blink[x] != NULL )
		{
			filename2[6] = 'A' + x;
			if( ( ap = fopen( filename2, "rb" ) ) != NULL )
			{
				fread( blink[x], ( unsigned int )
					 _imagesize( 0, 0, 23, 17 ) , 1, ap );
				fclose( ap );
			}
			else
				flag1 = 0;
		}
		else
			flag1 = 0;
	}

		/* Load Body Array */
		body[0] = ( char far * ) malloc( ( unsigned int )
				  _imagesize( 0, 0, 23, 26 ) );

		if( body[0] != NULL )
		{
			if( ( ap = fopen( "BODY.BIN", "rb" ) ) != NULL )
			{
				fread( body[0], ( unsigned int )
					 _imagesize( 0, 0, 23, 26 ) , 1, ap );
				fclose( ap );
			}
			else
				flag1 = 0;
		}
		else
			flag1 = 0;

		 /* Load Blowup Arrays */
	for( x = 0; x < blowup_cnt; x++ )
	{
		blowup[x] = ( char far * ) malloc( ( unsigned int )
				  _imagesize( 0, 0, 23, 41 ) );

		if( blowup[x] != NULL )
		{
			filename5[5] = 'A' + x;
			if( ( ap = fopen( filename5, "rb" ) ) != NULL )
			{
				fread( blowup[x], ( unsigned int )
					 _imagesize( 0, 0, 23, 41 ) , 1, ap );
				fclose( ap );
			}
			else
				flag1 = 0;
		}
		else
			flag1 = 0;
	}

		 /* Load Arms Arrays */
	for( x = 0; x < arms_cnt; x++ )
	{
		arms[x] = ( char far * ) malloc( ( unsigned int )
				  _imagesize( 0, 0, 9, 17 ) );

		if( arms[x] != NULL )
		{
			filename3[5] = 'A' + x;
			if( ( ap = fopen( filename3, "rb" ) ) != NULL )
			{
				fread( arms[x], ( unsigned int )
					 _imagesize( 0, 0, 9, 17 ) , 1, ap );
				fclose( ap );
			}
			else
				flag1 = 0;
		}
		else
			flag1 = 0;
	}

		 /* Load Fire Arrays */
	for( x = 0; x < fire_cnt; x++ )
	{
		fire[x] = ( char far * ) malloc( ( unsigned int )
				  _imagesize( 0, 0, 23, 17 ) );

		if( fire[x] != NULL )
		{
			filename4[5] = 'A' + x;
			if( ( ap = fopen( filename4, "rb" ) ) != NULL )
			{
				fread( fire[x], ( unsigned int )
					 _imagesize( 0, 0, 23, 17 ) , 1, ap );
				fclose( ap );
			}
			else
				flag1 = 0;
		}
		else
			flag1 = 0;
	}

	screen = ( char far * ) malloc( ( unsigned int )
			  _imagesize( 0, 0, 319, 199 ) );

	if( screen != NULL )
		{
			if( ( ap = fopen( "SCREEN.BIN", "rb" ) ) != NULL )
			{
				fread( screen, ( unsigned int )
					 _imagesize( 0, 0, 319, 199 ) , 1, ap );
				fclose( ap );
			}
			else
				flag1 = 0;
		}
	else
		flag1 = 0;
}


void delay( int number )     /* Animation delay: speed is counter, */
{                            /*   number is times through counter  */
	int num1, num2;

	for( num1 = number; num1 > 0; num1-- )
	{
		for( num2 = speed; num2 > 0; num2-- );
	}

}

void save_config( void )
{
	FILE *ap;
	{
		if( ( ap = fopen( "CONFIG.AND", "wb" ) ) != NULL )
		{
			fwrite( config[0], sizeof( config[0] ), 1, ap );
			fclose( ap );
		}
	}
}

void load_config( void )
{
	FILE *ap;
	{
		if( ( ap = fopen( "CONFIG.AND", "rb" ) ) != NULL )
		{
			fread( config[0], sizeof( config[0] ), 1, ap );
			fclose( ap );
      }
		else
			flag1 = 0;
	}
}

int _kbhit( void )         /* Routine to sense key press: */
{                          /* Result of call to MicroSoft */
	int key;                /* Corrects some sort of error */
	_asm \
		{
			mov   ah,0Bh
			int   21h
			and   ax,0001h
			mov   key,ax
		}
	return( key );
}

