(* ------------------------------------------------------ *)
(*                   EXPLODE2.PAS                         *)
(*            Strategiespiel Explode Plus                 *)
(*                 Turbo Pascal ab 5.5                    *)
(*             (c) 1991 Patrick Filipaj                   *)
(* ------------------------------------------------------ *)
{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V-}

PROGRAM Explode2;

{$DEFINE BGILINK}

(* Der Schalter "BGILINK" setzt die bedingte Compilierung fr das
   Einlinken der BGI-Treiber und des Triplex-Vektorfonts. Wenn Sie
   von dieser Mglichkeit Gebrauch machen mchten, mssen Sie die
   Units "Drivers" und "Fonts" compilieren, die zum Lieferumfang
   von Turbo Pascal gehren. Genauere Informationen ber das Linken
   des Grafikpakets und der Zeichenstz finden Sie in den Quellcodes
   der beiden Units. Bitte beachten Sie, da das Einbinden der
   Treiber und des Vektorfonts die Gre des EXE-Files um zirka
   30 kByte aufblht!

   Wenn der Schalter "BGILINK" nicht gesetzt ist (lschen Sie dazu
   einfach die Zeile "{$DEFINE BGILINK}"), wird das Grafikpaket
   auf herkmmliche Art und Weise installiert. Bitte beachten Sie,
   da "InitGraph" die BGI-Treiber und Vektorfonts in dem Verzeichnis
   sucht, da mittels der Umgebungsvariable "BGIPATH" definiert ist.
   Um diesen Pfad zu definieren, geben Sie ihn einfach auf der
   Kommandozeile an:
   SET BGIPATH = {PFAD}

   Beispiel:
   SET BGIPATH = C:\TP\BGI

   Wenn das Programm keine entsprechende  Variable im Umgebungsbereich
   findet, sucht es die Treiber im aktuellen Verzeichnis. *)

USES  Graph,Crt,
{$IFDEF BGILINK}
      Drivers,Fonts,
{$ENDIF}
      Dos;

TYPE
  Location   = RECORD
                 X, Y : SHORTINT;
               END;
  Zelle      = RECORD                { symbolisiert 1 Spielfeld }
                 Farbe : BYTE;
                 Wert  : BYTE;
               END;
  Verbund    = ARRAY[-1..6,-1..6] OF Zelle;
  Spieler    = PROCEDURE(Zahl:BYTE);
  GroundFeld = ARRAY[1..10] OF INTEGER;
  CursorFeld = ARRAY[1..10] OF INTEGER;
  WurfelFeld = ARRAY[1..14] OF INTEGER;

VAR
  Feld              : Verbund;        { Spielflche, 6x6 Felder }
  Position          : ARRAY[1..2] OF Location;
  Name              : ARRAY[1..2] OF STRING[17];
  SpielerA,SpielerB : Spieler;
  Winner            : STRING;
  Farbe             : ARRAY [0..3] OF BYTE;
  F                 : BYTE;              { Vergrsserungsfaktor }
  Visual            : SHORTINT;          { aktive Graphikseite  }
  GraphDriver       : INTEGER;
  GraphMode         : INTEGER;
  Mouse             : BOOLEAN;      { Wenn Maus vorhanden: TRUE }
  Regs              : Registers;                { Hilfsvariable }

CONST
  Wait = 50;
  UrWurfel : WurfelFeld =
  (141, 153,  148, 149,  148, 141,  144, 134,
   137, 138,  137, 146,  141, 153);

  UrCursor : CursorFeld =
  (139, 160,  155, 151,  146, 135,  130, 144,  139, 160);

  UrGround : GroundFeld =
  (139, 159,  234, 106,  181, 011,  086, 064,  139, 159);

PROCEDURE Ende;
BEGIN
  CloseGraph;
  Halt;
END;

PROCEDURE ShowMouse;
{ Macht Mauspfeil auf dem Bildschirm sichtbar                   }
BEGIN
  Regs.AX := 1;
  Intr($33, Regs);
END;

PROCEDURE HideMouse;
{ Macht Mauspfeil unsichtbar                                    }
BEGIN
  Regs.AX := 2;
  Intr($33, Regs);
END;

PROCEDURE PutMouse(X, Y : WORD);
{ Setzt den Mauszeiger an eine bestimmte Position               }
BEGIN
  Regs.AX := 4;
  Regs.CX := X;
  Regs.DX := Y;
  Intr($33, Regs);
END;

FUNCTION MausVorhanden : BOOLEAN;
{ Testet, ob Maus angeschlossen ist, fhrt Mausreset durch      }
BEGIN
  Regs.AX := 0;
  Intr($33, Regs);
  MausVorhanden := (Regs.AX <> 0);
END;

PROCEDURE SetMouseScreen(Seite : BYTE);
{ Bestimmt den aktuellen Mausbildschirmseite, hnlich den       }
{ verschiedenen Bildschirmseiten bei den Videokarten            }
BEGIN
  Regs.AX := $1D;
  Regs.BX := Seite;
  Intr($33, Regs);
END;

PROCEDURE SpielBeginn;
VAR ch : CHAR;
    n  : BYTE;
BEGIN
  TextBackground(0);
  TextColor(7);
  ClrScr;
  GotoXY(18, 1);
  WriteLn('* * * * * * * * * * * * * * * * * * * * * *');
  GotoXY(18, 2);
  WriteLn('* * * *   E X P L O D E   P L U S   * * * *');
  GotoXY(18, 3);
  WriteLn('* * * * * * * * * * * * * * * * * * * * * *');
  GotoXY(18, 8);
  WriteLn('* * (c) 1991  Patrick Filipaj & toolbox * *');
  GotoXY(18, 17);
  Write('Computerspieler: "PC1" = alte, "PC2" = neue Strategie');
  GotoXY(18, 14);
  Write('Name Spieler A: '); ReadLn(Name[1]);
  GotoXY(18, 15);
  Write('Name Spieler B: '); ReadLn(Name[2]);
  IF Name[1] = '' THEN Name[1] := ' ';
  IF Name[2] = '' THEN Name[2] := ' ';
  FOR n := 1 TO Length(Name[1]) DO
    Name[1][n] := UpCase(Name[1][n]);
  FOR n := 1 TO Length(Name[2]) DO
    Name[2][n] := UpCase(Name[2][n]);
  WriteLn;
  IF MausVorhanden THEN BEGIN
    GotoXY(18, 19);
    Write('Soll mit der Maus gespielt werden? <J>/<N>  ');
    REPEAT UNTIL KeyPressed;
    ch := ReadKey;
    Mouse := ch IN ['Y', 'y', 'J', 'j', #13];
  END;
END;

PROCEDURE Abort(Message : STRING);
BEGIN
  WriteLn;
  WriteLn(Message, ^G);
  Halt(2);
END;

PROCEDURE InitBildschirm;
{ Initialisiert Graphikmodus, setzt Vergrsserungsfaktor,       }
{ setzt Textattribute (TextStyle ...)                           }
CONST
  NoGrafics = 'Konnte Grafik nicht initialisieren!';
BEGIN
  DetectGraph(GraphDriver, GraphMode);
  CASE GraphDriver OF
    1, 2 : BEGIN
             F := 1;
             Farbe[1] := 1;
             Farbe[2] := 2;
             Farbe[3] := 3;
           END;
    3, 9 : BEGIN
             F := 2;
             Farbe[1] := 2;
             Farbe[2] := 4;
             Farbe[3] := 7;
           END;
    ELSE   Abort('(M)CGA-, EGA256- oder VGA-Karte erforderlich');
  END;
  GraphMode := 1;
{$IFDEF BGILINK}
{ bedingte Compilierung: BGI-Treiber und Vektorfont linken }
  CASE GraphDriver OF
    CGA,
    MCGA:     IF RegisterBGIDriver(@CGADriverProc) < 0 THEN
                Abort(NoGrafics);
    EGA,
    VGA:      IF RegisterBGIDriver(@EGAVGADriverProc) < 0 THEN
                Abort(NoGrafics);
    HercMono: IF RegisterBGIDriver(@HercDriverProc) < 0 THEN
                Abort(NoGrafics);
  ELSE
    Abort('(M)CGA-, EGA256- oder VGA-Karte erforderlich');
  END;
  IF RegisterBGIFont(@SmallFontProc) < 0 THEN
    Abort('Konnte Vektorschrift nicht initialisieren!');
{$ENDIF}
  InitGraph(GraphDriver, GraphMode, GetEnv('BGIPATH'));
  IF GraphResult <> 0 THEN
    Abort(NoGrafics);
  SetTextStyle(SmallFont, HorizDir, 5);
  SetTextJustify(LeftText, CenterText);
  Visual := 0;
END;

PROCEDURE InitTabelle(VAR Tabelle : Verbund);
{ Setzt alle Felder auf 0 und belegt sie mit neutraler Farbe }
VAR
  i,j : BYTE;
BEGIN
  FOR i := 0 TO 5 DO BEGIN
    FOR j := 0 TO 5 DO BEGIN
      Tabelle[i,j].Wert  := 0;
      Tabelle[i,j].Farbe := Farbe[3];
    END;
  END;
END;

FUNCTION Total(Tabelle : Verbund; Color : BYTE) : BYTE;
{ Ermittelt Anzahl der Felder mit der Farbe "Color"             }
VAR
  X, Y, C : SHORTINT;
BEGIN
  C := 0;
  FOR X := 0 TO 5 DO BEGIN
    FOR Y := 0 TO 5 DO BEGIN
      IF Tabelle[X,Y].Farbe = Color THEN Inc(C);
    END;
  END;
  Total := C;
END;

FUNCTION PointTotal(Tabelle : Verbund; Color : BYTE) : BYTE;
{ Ermittelt die Summe aller Feldwerte mit der in "Color"        }
{ festgelegten  Farbe                                           }
VAR
  X, Y, C : SHORTINT;
BEGIN
  C := 0;
  FOR X := 0 TO 5 DO BEGIN
    FOR Y := 0 TO 5 DO BEGIN
      IF Tabelle[X,Y].Farbe = Color
        THEN Inc(C,Tabelle[X,Y].Wert);
    END;
  END;
  PointTotal := C;
END;

PROCEDURE ShowTabelle(CursorNr : INTEGER);
{ Gibt aktuelles Spielfeld auf dem Bildschirm aus               }
VAR
  X, Y , i : BYTE;
  Ground   : GroundFeld;
  Cursor   : CursorFeld;
  Wurfel   : WurfelFeld;
  Hohe     : BYTE;
BEGIN
  IF (GraphDriver = CGA)              { Bei CGA wird Bildschirm-}
    THEN Port[$3D8]:=Port[$3D8] XOR 8 { ausgabe unterdrckt,    }
    ELSE SetActivePage(Visual XOR 1); { sonst aktuelle Graphik- }
  SetColor(0);                        { seite gewechselt        }
  SetFillStyle(SolidFill, 0);
  Bar(84*F, 0, F*236, F*160);
  SetFillStyle(SolidFill, 3);
  Ground := GroundFeld(UrGround);             { Kopie erstellen }
  FOR i := 1 TO 10 DO Ground[i] := Ground[i]*F;
  FillPoly(5, Ground);
  FOR i := 0 TO 6 DO BEGIN  { Spielfeldlinien werden gezeichnet }
    Line(F*(139-i*9), F*(160-i*16), F*(235-i*9), F*(106-i*16));
    Line(F*(85+i*16), F*(64-i*9), F*(139+i*16), F*(160-i*9));
  END;
  IF CursorNr IN [1, 2] THEN BEGIN
    Cursor := CursorFeld(UrCursor);           { Kopie erstellen }
    FOR i := 1 TO 5 DO BEGIN    { Cursorkoordinaten verschieben }
      Cursor[i*2-1] := Cursor[i*2-1]+Position[CursorNr].X*16;
      Cursor[i*2]   := Cursor[i*2] + Position[CursorNr].X*-9;
      Cursor[i*2-1] := Cursor[i*2-1]+Position[CursorNr].Y*-9;
      Cursor[i*2]   := Cursor[i*2] + Position[CursorNr].Y*-16;
    END;
    FOR i := 1 TO 10 DO Cursor[i] := Cursor[i]*F;
    SetFillStyle(1, 0);
    FillPoly(5, Cursor);
  END;
  FOR X := 5 DOWNTO 0 DO BEGIN
    FOR Y := 5 DOWNTO 0 DO BEGIN
      SetFillStyle(SolidFill, Feld[X, Y].Farbe);
      SetColor(1);
      FOR Hohe := 1 TO Feld[X, Y].Wert DO BEGIN
        Wurfel := WurfelFeld(UrWurfel);       { Kopie erstellen }
        FOR i := 1 TO 7 DO BEGIN  { Wrfelkoordinaten verschieb.}
          Wurfel[i*2-1] := Wurfel[i*2-1] + X *  16;
          Wurfel[i*2]   := Wurfel[i*2]   + X *  -9;
          Wurfel[i*2-1] := Wurfel[i*2-1] + Y *  -9;
          Wurfel[i*2  ] := Wurfel[i*2  ] + Y * -16 - 8*(Hohe-1);
        END;
        FOR i := 1 TO 14 DO Wurfel[i] := Wurfel[i]*F;
        FillPoly(7, Wurfel);
        SetColor(0);
{  nachfolgend werden die Kanten des Wrfels nachgezeichnet     }
        Line(Wurfel[1],Wurfel[2],Wurfel[3],Wurfel[4]);
        Line(Wurfel[3],Wurfel[4],Wurfel[5],Wurfel[6]);
        Line(Wurfel[5],Wurfel[6],Wurfel[7],Wurfel[8]);
        Line(Wurfel[7],Wurfel[8],Wurfel[9],Wurfel[10]);
        Line(Wurfel[9],Wurfel[10],Wurfel[11],Wurfel[12]);
        Line(Wurfel[13],Wurfel[14],Wurfel[11],Wurfel[12]);
        Line(Wurfel[1],Wurfel[2],Wurfel[1],Wurfel[2]-F*8);
        Line(Wurfel[5],Wurfel[6],Wurfel[1],Wurfel[2]-F*8);
        Line(Wurfel[9],Wurfel[10],Wurfel[1],Wurfel[2]-F*8);
      END;
    END;
  END;
  IF GraphDriver = CGA
  THEN Port[$3D8]:=Port[$3D8] XOR 8    { Bildschirmaufbau       }
  ELSE BEGIN                           { wieder aktivieren;     }
    Visual := Visual XOR 1;            { Bei VGA sichtbare Gra- }
    SetVisualPage(Visual);             { phikseite wechseln     }
  END;
END;

PROCEDURE PutText(s1, s2 : STRING; TextFarbe : BYTE);
{ Hilfsprozedur fr die Ausgabe von Spielkommentaren            }
VAR
  i : INTEGER;
BEGIN
  SetFillStyle(SolidFill, 0);
  FOR i := 1 TO 2 DO BEGIN
    SetColor(0);
    Bar(0, F*161, F*319, 50+149*F);
    SetColor(TextFarbe);
    OutTextXY(10, 20+152*F, s1);
    OutTextXY(10, 35+152*F, s2);
    IF (GraphDriver = CGA) THEN Port[$3D8]:=Port[$3D8] XOR 8
    ELSE SetActivePage(Visual XOR 1);
  END;
END;

PROCEDURE TastaturEingabe(CursorNummer : BYTE);
{ Fragt nach neuer Cursorposition, bei <ESC> Spielende          }
VAR
  X, Y : SHORTINT;
  Chr  : CHAR;
BEGIN
  X := Position[CursorNummer].X;
  Y := Position[CursorNummer].Y;
  REPEAT
    ShowTabelle(CursorNummer);
    REPEAT
      REPEAT UNTIL KeyPressed;
      Chr:=ReadKey;
      IF Chr=#0 THEN Chr := ReadKey;
    UNTIL Chr IN [#13,#72,#75,#77,#80,#27];
    CASE Chr OF
      #72 : Inc(Y);  #75 : Dec(X);  #77 : Inc(X);
      #80 : Dec(Y);  #27 : Ende;    END;
    IF X > 5 THEN X := 5;
    IF X < 0 THEN X := 0;
    IF Y < 0 THEN Y := 0;
    IF Y > 5 THEN Y := 5;
    Position[CursorNummer].X := X;
    Position[CursorNummer].Y := Y;
  UNTIL Chr = #13;
END;

PROCEDURE MausEingabe(Nr : BYTE);
{ Die Mausposition beim Niederdrcken des linken Buttons wird   }
{ ermittelt; anschliessend wird geprft, ob diese Position auf  }
{ einem der 6x6 Spielfelder liegt                               }
VAR
  X1, Y1 : INTEGER;                     { Absolute Mausposition }
  X2, Y2 : REAL;  { Mausposition nach Drehen in die Orthogonale }
  sa, sb : STRING;
BEGIN
  SetMouseScreen(Visual);
  PutMouse((143 + 16*Position[Nr].X -  9*Position[Nr].Y) * 2,
           (147 -  9*Position[Nr].X - 16*Position[Nr].Y) * F);
  ShowMouse;
  REPEAT
    REPEAT
      Regs.AX := 3;
      Intr($33, Regs);
      IF (KeyPressed AND (ReadKey = #27)) THEN Ende;
    UNTIL (Regs.BX MOD 2) = 1;
    X1 := Regs.CX -139 * 2;
    Y1 := Regs.DX -159 * F;
    X2 := ( X1 * 0.8716 / 2 - Y1 * 0.4903 / F) / 18.3576;
    Y2 := (-X1 * 0.4903 / 2 - Y1 * 0.8716 / F) / 18.3576;
{ In den oberen beiden Zeilen wurden die X- bzw. Y-Koordinaten  }
{ um ca. 30 Grad nach rechts gedreht --> ermglicht einfachere  }
{ Positionsberprfung der Eingabe                              }
    SetActivePage(Visual);
  UNTIL (X2 > 0) AND (X2 < 6)
    AND (Frac(X2) > 0.1) AND (Frac(X2) < 0.9)
    AND (Y2 > 0) AND (Y2 < 6)
    AND (Frac(Y2) > 0.1) AND (Frac(Y2) < 0.9);
{ Im obstehenden 'Rattenschwanz' wurde berprft, ob sich die   }
{ Maus berhaupt im Spielfeld befand                            }
  Position[Nr].X := Trunc(X2);
  Position[Nr].Y := Trunc(Y2);
  HideMouse;
END;

FUNCTION SpielEnde : BOOLEAN;
{ Fragt, ob neues Spiel gestartet werden soll                   }
VAR
  s : STRING;
BEGIN
  s := 'Der Gewinner ist ' + Winner + '.               ';
  PutText(s, 'Noch ein Spiel?  (<J>/<N>)', Farbe[3]);
  REPEAT UNTIL KeyPressed;
  SpielEnde := NOT(ReadKey IN ['y','j','Y','J']);
  CloseGraph;
END;

FUNCTION NoMoreExplosion(VAR Tabelle  : Verbund;
                             Virtuell : BOOLEAN) : BOOLEAN;
VAR
  NoChange : BOOLEAN;
  X, Y     : BYTE;

  PROCEDURE Erhohen;
  { Erhht Nachbarfelder des explodierenden Feldes und belegt   }
  { sie mit der Farbe des explodierten Feldes                   }
  BEGIN
    Inc(Tabelle[X+1,Y].Wert);
    Tabelle[X+1,Y].Farbe := Tabelle[X,Y].Farbe;
    Inc(Tabelle[X-1,Y].Wert);
    Tabelle[X-1,Y].Farbe := Tabelle[X,Y].Farbe;
    Inc(Tabelle[X,Y+1].Wert);
    Tabelle[X,Y+1].Farbe := Tabelle[X,Y].Farbe;
    Inc(Tabelle[X,Y-1].Wert);
    Tabelle[X,Y-1].Farbe := Tabelle[X,Y].Farbe;
  END;

  PROCEDURE Is_Explosion(Subtraktor : SHORTINT);
  { Testet, ob der Explosionsgrenzwert erreicht ist             }
  BEGIN
    IF Tabelle[X,Y].Wert  >= Subtraktor THEN BEGIN
      Erhohen;
      Tabelle[X,Y].Wert   := Tabelle[X,Y].Wert-Subtraktor;
      IF Tabelle[X,Y].Wert = 0 THEN Tabelle[X,Y].Farbe := Farbe[3];
      NoChange            := FALSE;
      IF NOT Virtuell THEN BEGIN
        ShowTabelle(0);
        Delay(Wait * 7);
      END;
    END
  END;

BEGIN
  NoChange := TRUE;
  FOR X:=1 TO 4 DO BEGIN
    FOR Y:=1 TO 4 DO Is_Explosion(4);
  END;
  X := 0;
  FOR Y:=1 TO 4 DO Is_Explosion(3);
  Y := 0;
  Is_Explosion(2);
  Y := 5;
  Is_Explosion(2);
  X := 5;
  FOR Y:=1 TO 4 DO Is_Explosion(3);
  Y := 0;
  Is_Explosion(2);
  Y := 5;
  Is_Explosion(2);
  Y := 0;
  FOR X := 1 TO 4 DO Is_Explosion(3);
  Y := 5;
  FOR X := 1 TO 4 DO Is_Explosion(3);
  NoMoreExplosion := NoChange;
END;

{$B+}
PROCEDURE Explosion(VAR Tabelle : Verbund);
{ Testet, ob Spielende erreicht ist; ruft Funktion              }
{ NoMoreExplosion auf                                           }
BEGIN
  REPEAT
    IF Total(Tabelle,Farbe[2]) = 0 THEN Winner := Name[1];
    IF Total(Tabelle,Farbe[1]) = 0 THEN Winner := Name[2];
  UNTIL (Winner <> '') OR (NoMoreExplosion(Tabelle,FALSE));
END;
{$B-}

PROCEDURE VirExplosion(VAR Tabelle : Verbund);
{ hnlich wie Prozedur Explosion; Explosionen werden jedoch     }
{ in einem virtuellen Feld, nmlich VirFeld, ausgefhrt         }
BEGIN
  REPEAT UNTIL NoMoreExplosion(Tabelle,TRUE)
    OR (Total(Tabelle,Farbe[1]) = 0)
    OR (Total(Tabelle,Farbe[2]) = 0);
END;

{$F+}PROCEDURE Computer1(Zahl:BYTE);{$F-}
{ Simuliert einen Spieler                                       }
VAR
  VirFeld : Verbund;
  X, Y, MaxX, MaxY, MaxWert, Tot : BYTE;
BEGIN
  IF KeyPressed THEN
    IF ReadKey = #27 THEN
      Ende;
  MaxWert := 0;
  MaxX    := 2;
  MaxY    := 2;
  PutText('Der Computer ist am Setzen.','',Farbe[Zahl]);
  FOR X := 0 TO 5 DO BEGIN
    FOR Y := 0 TO 5 DO BEGIN
      VirFeld := Feld;
      IF VirFeld[X,Y].Farbe IN [Farbe[Zahl],Farbe[3]] THEN BEGIN
        Inc(VirFeld[X,Y].Wert);
        VirFeld[X,Y].Farbe := Farbe[Zahl];
        VirExplosion(VirFeld);
        Tot := PointTotal(VirFeld,Farbe[Zahl]);
        IF (Tot > MaxWert) OR
          ((Tot = MaxWert) AND (Random > 0.75)) THEN BEGIN
          MaxWert := Tot;
          MaxX    := X;
          MaxY    := Y;
        END   ELSE BEGIN END;
      END   ELSE BEGIN END;
    END;
  END;
  Position[Zahl].X := MaxX;
  Position[Zahl].Y := MaxY;
  ShowTabelle(Zahl);
  Delay(10 * Wait);
  Inc(Feld[MaxX,MaxY].Wert);
  Feld[MaxX,MaxY].Farbe := Farbe[Zahl];
  ShowTabelle(Zahl);
  Delay(10 * Wait);
  Explosion(Feld);
END;

{$F+}PROCEDURE Mensch(Zahl:BYTE);{$F-}
{ Ruft Prozedur Eingabe auf und testet, ob zurckgelieferte     }
{ Cursorposition zulssig ist                                   }
BEGIN
  PutText(Name[Zahl] + ', Sie sind am Setzen.','',Farbe[Zahl]);
  REPEAT
    IF Mouse THEN MausEingabe(Zahl)
             ELSE TastaturEingabe(Zahl);
  UNTIL Feld[Position[Zahl].X,Position[Zahl].Y].Farbe
                                   IN [Farbe[Zahl],Farbe[3]];
  Inc(Feld[Position[Zahl].X,Position[Zahl].Y].Wert);
  Feld[Position[Zahl].X,Position[Zahl].Y].Farbe :=
                                           Farbe[Zahl];
  IF MausVorhanden THEN ShowTabelle(0)
                   ELSE ShowTabelle(Zahl);
  Delay(5 * Wait);
  Explosion(Feld);
END;

{$F+}PROCEDURE Computer2(Zahl : BYTE);        {$F-}
          { Computerspieler zieht: Verbesserte Version des }
          { Computer-Algorithmus aus dem Heft              }
TYPE
  StackType = RECORD
                x, y : BYTE;
              END;
VAR
  x, y, r : BYTE;
  MinWert : BYTE;
  VirFeld : Verbund;
  Summe : ARRAY[0..5, 0..5] OF BYTE;
  Stack : ARRAY[1..36] OF StackType;
  StackPtr : BYTE;

  PROCEDURE MacheZug(Zahl : BYTE; Feld : Verbund);
  { Kernprozedur der Rechnerstrategie; diese Prozedur           }
  { spielt einen virtuellen Zug fr einen beliebigen            }
  { Spieler durch                                               }
  VAR
    x, y : BYTE;
    VirFeld : Verbund;
    Tot : BYTE;
  BEGIN
    FOR x := 0 TO 5 DO
      FOR y := 0 TO 5 DO BEGIN
        VirFeld := Feld;                   { Spielfeld kopieren }
        IF VirFeld[x,y].Farbe IN [Farbe[Zahl], Farbe[3]] THEN
        BEGIN
        { virtueller Zug, wenn das Feld vom Spieler besetzt ist }
        { oder noch unbelegt ist }
          Inc(VirFeld[x, y].Wert);           { Feldwert erhhen }
          VirFeld[x, y].Farbe := Farbe[Zahl];    { Farbe setzen }
          VirExplosion(VirFeld);        { Check auf Explosionen }
                                            { Minimalauswertung }
          IF Feld[x, y].Farbe IN [Farbe[Zahl], Farbe[3]] THEN
          BEGIN
            Tot := PointTotal(VirFeld, Farbe[Zahl]);
                                     { Summierung des Resultats }
            IF Tot <= MinWert THEN
              MinWert := Tot;
          END;
        END;  { FOR }
      END;
  END;   { MacheZug }

BEGIN
  TextAttr := Farbe[Zahl];
  GotoXY(1, 25);
  PutText('Volon-Tier-Algorithmus setzt.', '', Farbe[Zahl]);

  FOR x := 0 TO 5 DO
    FOR y := 0 TO 5 DO BEGIN
      Summe[x, y] := 255;            { Feldoptimum lschen }
      VirFeld := Feld;                { Spielfeld kopieren }
      IF VirFeld[x, y].Farbe IN [Farbe[Zahl], Farbe[3]] THEN
      BEGIN
        Inc(VirFeld[x, y].Wert);            { eins erhhen }
        VirFeld[x, y].Farbe := Farbe[Zahl]; { +ggf. frben }
        VirExplosion(VirFeld);
        MinWert := 255;
        MacheZug(Zahl XOR 3, VirFeld);
                           { alle Zge des Gegners checken }
        Summe[x, y] := MinWert;  { schlechtestes Ergebnis }
                                 { des Gegners speichern  }
      END;
    END;
                          { Auswertung der Tabelle "Total" }
  MinWert := 255;
  StackPtr := 0;
  FOR x := 0 TO 5 DO
    FOR y := 0 TO 5 DO
      IF Summe[x, y] <= MinWert THEN BEGIN
        IF Summe[x, y] < MinWert THEN
          StackPtr := 1;
        IF Summe[x, y] = MinWert THEN
          Inc(StackPtr);
        Stack[StackPtr].x := x;
        Stack[StackPtr].y := y;
        MinWert := Summe[x, y];
      END;

  r := Random(StackPtr) + 1;
  Position[Zahl].x := Stack[r].x;
  Position[Zahl].y := Stack[r].y;
  ShowTabelle(Zahl);                                    { Zug anzeigen }
  Delay(10 * Wait);
  Inc(Feld[Stack[r].x, Stack[r].y].Wert);
  Feld[Stack[r].x, Stack[r].y].Farbe := Farbe[Zahl];
  ShowTabelle(Zahl);
  Delay(10 * Wait);
  Explosion(Feld);
END;

BEGIN
  Randomize;
  Spielbeginn;
  SpielerA := Mensch;
  IF Name[1] = 'PC1' THEN SpielerA := Computer1;
  IF Name[1] = 'PC2' THEN SpielerA := Computer2;
  SpielerB := Mensch;
  IF Name[2] = 'PC1' THEN SpielerB := Computer1;
  IF Name[2] = 'PC2' THEN SpielerB := Computer2;
  REPEAT
    Position[1].X := 3;    Position[1].Y := 3;
    Position[2].X := 2;    Position[2].Y := 3;
    InitBildschirm;
    InitTabelle(Feld);
    ShowTabelle(0);
    Winner := '';
    SpielerA(1);
    Winner := '';
    REPEAT
      SpielerB(2);
      IF Winner = '' THEN SpielerA(1);
    UNTIL Winner <> '';
  UNTIL SpielEnde;
  Ende;
END.
(* ------------------------------------------------------ *)
(*                Ende von EXPLODE2.PAS                   *)
