/*******************************************************************/
/*                                                                 */
/* Sample source code for the creation of Intermission palette 1   */
/*                                                                 */
/* Copyright (c) 1990,1991 Anthony Andersen                        */
/*                                                                 */
/*******************************************************************/


#include <stdio.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;

typedef struct tagPALETTEENTRY {
    BYTE peRed;
    BYTE peGreen;
    BYTE peBlue;
    BYTE peFlags;
} PALETTEENTRY;

/* Logical Palette */
typedef struct tagLOGPALETTE {
    WORD palVersion;
    WORD palNumEntries;
    PALETTEENTRY palPalEntry[256];   // this is nonstandard but makes things
                                     // easier.
} LOGPALETTE;


unsigned char normal[] = {0xFF,0xCC,0x99,0x66,0x33,0x00};
unsigned char other[] = {0xEE,0xDD,0xBB,0xAA,0x88,0x77,0x55,0x44,0x22,0x11};

int i;

int rcount;
int gcount;

int roffset;
int goffset;
int boffset;

LOGPALETTE lp;

FILE *fp;

void main(void)

{
   rcount = 0;
   gcount = 0;
   roffset = 0;
   goffset = 0;
   boffset = 0;

   lp.palVersion = 0x300;
   lp.palNumEntries = 256;

   for (i=0;i<216;i++) {
      lp.palPalEntry[i].peRed = normal[roffset];
      lp.palPalEntry[i].peGreen = normal[goffset];
      lp.palPalEntry[i].peBlue = normal[boffset];
      lp.palPalEntry[i].peFlags = 0;

      rcount++;
      gcount++;

      boffset++;
      if (boffset == 6) boffset = 0;
      if (gcount == 6) {
         gcount = 0;
         goffset++;
         if (goffset == 6) goffset = 0;
      }
      if (rcount == 36) {
         rcount = 0;
         roffset++;
         if (roffset == 6) roffset = 0;
      }
   }
   for (i=0;i<10;i++) {
      lp.palPalEntry[i+216].peRed = other[i];
      lp.palPalEntry[i+216].peGreen = other[i];
      lp.palPalEntry[i+216].peBlue = other[i];
      lp.palPalEntry[i+216].peFlags = 0;
      
      lp.palPalEntry[i+226].peRed = other[i];
      lp.palPalEntry[i+226].peGreen = 0;
      lp.palPalEntry[i+226].peBlue = 0;
      lp.palPalEntry[i+226].peFlags = 0;
      
      lp.palPalEntry[i+236].peRed = 0;
      lp.palPalEntry[i+236].peGreen = other[i];
      lp.palPalEntry[i+236].peBlue = 0;
      lp.palPalEntry[i+236].peFlags = 0;
      
      lp.palPalEntry[i+246].peRed = 0;
      lp.palPalEntry[i+246].peGreen = 0;
      lp.palPalEntry[i+246].peBlue = other[i];
      lp.palPalEntry[i+246].peFlags = 0;
      
   }

   fp = fopen("color.dat","wb");
   if (fp == NULL) {
      printf("Can't open COLOR.DAT\n");
      return;
   }
   fwrite(&lp,sizeof(LOGPALETTE),1,fp);
   fclose(fp);
   printf("Wrote COLOR.DAT\n");
}

