#include <stdio.h>

FILE *fp;
char filename[100];
char fileroot[100];

void main(int argc,char **argv)

{
	printf("newsaver - creates project for screen saver module for Intermission\n");
	printf("    by Anthony Andersen\n");
	printf("This program is Public Domain\n\n");
	if (argc == 1) {
		printf("usage : newsaver filename\n\n");
		printf("    where : filename is the name of the new screen saver project\n");
		printf("            (no file extension)\n\n");
		return;
	}

	strcpy(fileroot,argv[1]);

/* make file */

	strcpy(filename,fileroot);
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}


	fprintf(fp,"all: %s.imx\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,".c.obj:\n");
	fprintf(fp,"    cl -c -Asnw -Gsw -Ox -Zp -W3 $*.c >$*.err\n");
	fprintf(fp,"\n");
	fprintf(fp,"%s.obj: %s.c %s.h\n",fileroot,fileroot,fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"%s.res: %s.rc %s.dlg\n",fileroot,fileroot,fileroot);
	fprintf(fp,"    rc -r %s.rc\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"libentry.obj: libentry.asm\n");
	fprintf(fp,"   masm -Mx libentry,libentry;\n");
	fprintf(fp,"\n");
	fprintf(fp,"%s.imx: libentry.obj %s.obj %s.def %s.res\n",fileroot,fileroot,fileroot,fileroot);
	fprintf(fp,"    link /align:16 %s libentry, %s.exe,NUL, /NOE /NOD sdllcew libw,%s.def\n",fileroot,fileroot,fileroot);
	fprintf(fp,"    rc -p %s.res\n",fileroot);
	fprintf(fp,"    if exist %s.imx del %s.imx\n",fileroot,fileroot);
	fprintf(fp,"    ren %s.exe %s.imx\n",fileroot,fileroot);
	fprintf(fp,"\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* def file */

	strcpy(filename,fileroot);
	strcat(filename,".def");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"LIBRARY   %s\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"EXETYPE   WINDOWS\n");
	fprintf(fp,"\n");
	fprintf(fp,"CODE	  PRELOAD MOVEABLE DISCARDABLE\n");
	fprintf(fp,"DATA	  PRELOAD SINGLE\n");
	fprintf(fp,"\n");
	fprintf(fp,"HEAPSIZE  1024\n");
	fprintf(fp,"\n");
	fprintf(fp,"EXPORTS\n");
	fprintf(fp,"	WEP                 @1 RESIDENTNAME\n");
	fprintf(fp,"	saverinit           @2\n");
	fprintf(fp,"	saverdraw           @3\n");
	fprintf(fp,"	saverdlgproc        @4\n");
	fprintf(fp,"	LibMain             @5\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* c file */

	strcpy(filename,fileroot);
	strcat(filename,".c");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}


	fprintf(fp,"#include <windows.h>\n");
	fprintf(fp,"\n");
	fprintf(fp,"#include \"%s.h\"\n",fileroot);
	fprintf(fp,"\n");
	fprintf(fp,"#define IDD_CHECKBOX 10\n");
	fprintf(fp,"\n");
	fprintf(fp,"unsigned long seed;\n");
	fprintf(fp,"char buffer[10];\n");
	fprintf(fp,"RECT   rect;\n");
	fprintf(fp,"HBRUSH hbrush;\n");
	fprintf(fp,"int    resbits;\n");
	fprintf(fp,"unsigned colormax;\n");
	fprintf(fp,"\n");
	fprintf(fp,"\n");
	fprintf(fp,"char savername[] = \"%s Saver\";\n",fileroot);
	fprintf(fp,"char profname[] = \"ANTSW.INI\";\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* this is called by the default dll entry code during the  */\n");
	fprintf(fp,"/* load library call - always happens BEFORE any other call */\n");
	fprintf(fp,"/* in the dll.                                              */\n");
	fprintf(fp,"\n");
	fprintf(fp,"int FAR PASCAL LibMain(hModule, wDataSeg, cbHeapSize, lpszCmdLine)\n");
	fprintf(fp,"\n");
	fprintf(fp,"HANDLE	hModule;\n");
	fprintf(fp,"WORD     wDataSeg;\n");
	fprintf(fp,"WORD     cbHeapSize;\n");
	fprintf(fp,"LPSTR    lpszCmdLine;\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"\n");
	fprintf(fp,"   /* set up things here */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	return (1);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* this is called by Windows when the dll is released */\n");
	fprintf(fp,"\n");
	fprintf(fp,"int FAR PASCAL WEP (bSystemExit)\n");
	fprintf(fp,"int  bSystemExit;\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"    /* get rid of things you allocated in the LibMain proc here */\n");
	fprintf(fp,"\n");
	fprintf(fp,"    return (1);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* this is called (probably lots of times) by Intermission */\n");
	fprintf(fp,"/* be careful not to allocate memory in here               */\n");
	fprintf(fp,"\n");
	fprintf(fp,"char FAR * FAR PASCAL saverinit(int far *realize)\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	/* tell enable state */\n");
	fprintf(fp,"\n");
	fprintf(fp,"	*realize = 1; // get realized color table\n");
	fprintf(fp,"\n");
	fprintf(fp,"	return(savername);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* dialog proc for user customization */\n");
	fprintf(fp,"\n");
	fprintf(fp,"BOOL FAR PASCAL saverdlgproc(HWND hdlg,unsigned message,WORD wparam,DWORD lparam)\n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	switch (message) {\n");
	fprintf(fp,"\n");
	fprintf(fp,"	case WM_INITDIALOG:\n");
	fprintf(fp,"		return (TRUE);\n");
	fprintf(fp,"\n");
	fprintf(fp,"	case WM_COMMAND:\n");
	fprintf(fp,"		if (wparam == IDOK) {\n");
	fprintf(fp,"			EndDialog(hdlg,TRUE);\n");
	fprintf(fp,"			return (TRUE);\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else if (wparam == IDCANCEL) {\n");
	fprintf(fp,"			EndDialog(hdlg,FALSE);\n");
	fprintf(fp,"			return (TRUE);\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"      break;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	return (FALSE);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* returns pseudorandom number from 0 to x-1 */\n");
	fprintf(fp,"\n");
	fprintf(fp,"int arand(int x)\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	seed = seed*0x343fd+0x269ec3;\n");
	fprintf(fp,"	return (int)(((seed>>16)&0x7fff)*x>>15);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");
	fprintf(fp,"/* the main drawing routine */\n");
	fprintf(fp,"\n");
	fprintf(fp,"VOID FAR PASCAL saverdraw(HWND hwnd,HDC hdc,HANDLE hinst,HPALETTE hpal,int opcode) \n");
	fprintf(fp,"\n");
	fprintf(fp,"{\n");
	fprintf(fp,"\n");
	fprintf(fp,"	if (!opcode) {\n");
	fprintf(fp,"		/* main drawing loop - see sticks.c */\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else if (opcode == 1) {\n");
	fprintf(fp,"		/* initialize everything */\n");
	fprintf(fp,"		if (GetDeviceCaps(hdc,RASTERCAPS) & RC_PALETTE) {\n");
	fprintf(fp,"			colormax = GetDeviceCaps(hdc,SIZEPALETTE);\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else {\n");
	fprintf(fp,"			resbits = GetDeviceCaps(hdc,BITSPIXEL)*GetDeviceCaps(hdc,PLANES);\n");
	fprintf(fp,"			if (resbits <= 8)	colormax = 1<<(resbits);\n");
	fprintf(fp,"			else colormax = 0xFFFF;\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"\n");
	fprintf(fp,"		GetClipBox(hdc,&rect);\n");
	fprintf(fp,"\n");
	fprintf(fp,"		/* seed the pseudorandom number generator */\n");
	fprintf(fp,"\n");
	fprintf(fp,"		seed = GetTickCount();\n");
	fprintf(fp,"\n");
	fprintf(fp,"		hbrush = GetStockObject(BLACK_BRUSH);\n");
	fprintf(fp,"		FillRect(hdc,&rect,hbrush);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else if (opcode == 2) {\n");
	fprintf(fp,"		/* clean up things allocated from opcode == 1 */\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"\n");
	fprintf(fp,"}\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* res file */

	strcpy(filename,fileroot);
	strcat(filename,".rc");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"#include <windows.h>\n");
	fprintf(fp,"\n");
	fprintf(fp,"RCINCLUDE %s.dlg\n",fileroot);


	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* dlg file */

	strcpy(filename,fileroot);
	strcat(filename,".dlg");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"DIALOGBOX DIALOG LOADONCALL MOVEABLE DISCARDABLE 13, 35, 110, 80\n");
	fprintf(fp,"STYLE WS_DLGFRAME | WS_POPUP\n");
	fprintf(fp,"BEGIN\n");
	fprintf(fp,"    CONTROL \"OK\", 1, \"button\", BS_DEFPUSHBUTTON | WS_TABSTOP | WS_CHILD, 40, 59, 30, 14\n");
	fprintf(fp,"    CONTROL \"%s Screen Saver\", 101, \"static\", SS_CENTER | WS_CHILD, 10, 8, 90, 8\n",fileroot);
	fprintf(fp,"    CONTROL \"by Someone\", 102, \"static\", SS_CENTER | WS_CHILD, 10, 22, 90, 8\n");
	fprintf(fp,"END\n");
	fprintf(fp,"\n");


	fclose(fp);
	printf("created file %s\n",filename);

/* end */

/* header file */

	strcpy(filename,fileroot);
	strcat(filename,".h");
	fp = fopen(filename,"wt");
	if (fp == NULL) {
		printf("ERROR - can't open file %s\n",filename);
		return;
	}

	fprintf(fp,"\n");

	fclose(fp);
	printf("created file %s\n",filename);

/* end */

}

