DECLARE SUB GraphGame (Percentage$)
DECLARE SUB DownAndRight ()
DECLARE SUB DownAndLeft ()
DECLARE SUB UpAndRight ()
DECLARE SUB UpAndLeft ()
DECLARE SUB MemorizeScreen (xPos%, yPos%)
DECLARE FUNCTION CenterPrint% (ToPrint$, Row%, ForeColor%, BackColor%)
DECLARE SUB DownArrow ()
DECLARE SUB LeftArrow ()
DECLARE SUB RightArrow ()
DECLARE SUB UpDateScore (Total%, NumberAdd%)
DECLARE SUB GameOver (GameOv%)
DECLARE SUB UpArrow ()
DECLARE SUB SetUpScreen ()
DECLARE SUB SaveGame ()
DECLARE SUB RestoreGame ()
DECLARE SUB PlayGame ()
DECLARE SUB Frame (left%, right%, top%, bottom%, ForeColor%, BackColor%)

' SNAKE.BAS

' Snake programs.

' Main moduale makes menu and Branches to appropriate Section of Program.
'       all returning to the main menu

' These variables are for sharing among procedures.

COMMON SHARED Dummy%, DummyString$, Done%, Moves%, GameDone%, PercentPrint$
COMMON SHARED PercentDone!, FlagOnce%, xToSave%, yToSave%, GameLoaded%
COMMON SHARED FileToSave$, Dummy$

' List of global variables and descritions
'       Dummy%=Scrap integer variable
'       DummyString$=Scrap string variable
'       Done%=Number of * completed
'       GameDone%=Game is finished?True or False
'       PercentPrint$= The percent to be printed
'       PercentDone!=Percentage completed
'       FlagOnce%=Flag if user only moved once
'       xToSave%, yToSave%=Position to use when saving game
'       GameLoaded%=True or False.  Is a game loaded?
'       FileToSave$=Holds file to save
'       NoGraph%=True or False, is this screen capable of graphing?
'       The ScreenSave arry is to store to screen contents.

DIM SHARED ScreenSave(1 TO 21, 1 TO 80) AS STRING

' Check to see if user wants to use monocrome  Section initiaites the values

' These are shared varables for the color values if they are color
COMMON SHARED ArrowColor%, RestoreArrow%, NumbersDrawn%, StarsDrawn%, NoGraph%
COMMON SHARED StarsDrawnRed%, BlueLine%, YellowPrint%, GreenStar%, GreenScore%
COMMON SHARED TitleCenter%, ByLine%, GameOverLight%, FileIO%
CheckMono% = INSTR(COMMAND$, "/MONO")

' Set values if they are color or mono.
IF CheckMono% <> 0 THEN
        ChoiceColor% = 15
        FrameMenu% = 7
        GameStat% = 15
        ArrowColor% = 15
        RestoreArrow% = 7
        NumbersDrawn% = 7
        StarsDrawn% = 7
        StarsDrawnRed% = 7
        BlueLine% = 7
        YellowPrint% = 7
        GreenStar% = 15
        GreenScore% = 7
        TitleCenter% = 15
        ByLine% = 7
        GameOverLight% = 15
        FileIO% = 15
        MenuLettersForeHigh% = 0
        MenuLettersBackHigh% = 7
ELSE
        ChoiceColor% = 4
        FrameMenu% = 1
        GameStat% = 4
        ArrowColor% = 2
        RestoreArrow% = 14
        NumbersDrawn% = 4
        StarsDrawn% = 14
        StarsDrawnRed% = 4
        BlueLine% = 1
        YellowPrint% = 14
        GreenStar% = 2
        GreenScore% = 2
        TitleCenter% = 9
        ByLine% = 10
        GameOverLight% = 12
        FileIO% = 2
        MenuLettersForeHigh% = 12
        MenuLettersBackHigh% = 7
END IF
BEGIN:
PosOfHighlight% = 1
' ---- Check to see if there is a game loaded.  If so do not reset flag.

IF GameLoaded% = 0 THEN
        FlagOnce% = 0
        Moves% = Moves% + 1
END IF

' These variables have to be reinilized or else second run
GameDone% = 0   ' won't run.
Done% = 0

' --- Procedure to set-up menu

CLS

' ---- Write Menu                   
Dummy% = CenterPrint%("SNAKE", 2, TitleCenter%, 0)
Dummy% = CenterPrint%("By Leon Fu", 3, ByLine%, 0)
COLOR 7
LOCATE 8, 34    ' Position cursor to print first option
COLOR MenuLettersForeHigh%, MenuLettersBackHigh%: PRINT "Play Game"
LOCATE 10, 34: COLOR 7, 0
PRINT "Save Game"
LOCATE 12, 34
PRINT "Restore Game"
LOCATE 14, 34
PRINT "Quit"
LOCATE 16, 34
PRINT "Your Choice:";
COLOR ChoiceColor%
PRINT "(P,S,R,Q)"
Frame 15, 65, 5, 20, FrameMenu%, 0

' Check to see if game is loaded.

IF GameLoaded% <> 0 THEN
        'Frame 33, 45, 22, 24, FrameMenu%, 0
        LOCATE 22, 34: COLOR GameStat%: PRINT "Game Loaded";
END IF

' -- Get users choice
COLOR 7

' --- Set keystroke traping on and music trap on
KEY 15, CHR$(128 + 32) + CHR$(80)
KEY 16, CHR$(128 + 32) + CHR$(72)
ON KEY(11) GOSUB RedrawMenuUp
ON KEY(14) GOSUB RedrawMenuDown
ON KEY(15) GOSUB RedrawMenuDown
ON KEY(16) GOSUB RedrawMenuUp

ON PLAY(2) GOSUB PlayMusic
PLAY ON
FirstLine$ = "MB MS T175 O2G8B-"
Count% = 1
PLAY FirstLine$
PLAY STOP
KEY(11) ON
KEY(14) ON
KEY(15) ON
KEY(16) ON

Choice$ = ""            ' Initizlie Choice$

' -- Loop until user picks right choice

DO UNTIL Choice$ = "P" OR Choice$ = "p" OR Choice$ = "S" OR Choice$ = "s" OR Choice$ = "R" OR Choice$ = "r" OR Choice$ = "Q" OR Choice$ = "q" OR Choice$ = CHR$(13)
        Choice$ = INKEY$
LOOP

SELECT CASE Choice$
        CASE "P", "p"
                KEY(11) OFF
                KEY(14) OFF
                KEY(15) OFF
                KEY(16) OFF
                COLOR 7, 0
                CLS
                PLAY ON
                PlayGame
                PLAY OFF
                KEY(11) ON
                KEY(14) ON
                KEY(15) ON
                KEY(16) ON
                GOTO BEGIN
        CASE "S", "s"
                KEY(11) OFF
                KEY(14) OFF
                KEY(15) OFF
                KEY(16) OFF
                COLOR 7, 0
                CLS
                SaveGame
                KEY(11) ON
                KEY(14) ON
                KEY(15) ON
                KEY(16) ON
                GOTO BEGIN
        CASE "R", "r"
                KEY(11) OFF
                KEY(15) OFF
                KEY(16) OFF
                KEY(14) OFF
                COLOR 7, 0
                CLS
                RestoreGame
                KEY(11) ON
                KEY(14) ON
                KEY(15) ON
                KEY(16) ON
                GOTO BEGIN
        CASE "Q", "q"
                KEY(11) OFF
                KEY(15) OFF
                KEY(16) OFF
                KEY(14) OFF
                COLOR 7, 0
        CASE CHR$(13)
                KEY(11) OFF
                KEY(14) OFF
                KEY(15) OFF
                KEY(16) OFF
                SELECT CASE PosOfHighlight%
                        CASE 1
                                COLOR 7, 0
                                PLAY ON
                                PlayGame
                                PLAY OFF
                                GOTO BEGIN
                        CASE 2
                                COLOR 7, 0
                                SaveGame
                                GOTO BEGIN
                        CASE 3
                                COLOR 7, 0
                                RestoreGame
                                GOTO BEGIN
                        CASE 4
                                COLOR 7, 0
                END SELECT
END SELECT
CLS
END

' This is the error handleing routine mainly for File I/O.
ErrorHandle:
SELECT CASE ERR
        CASE 5
                ' If no monitor, abort graph.
                NoGraph% = -1
                RESUME NEXT
        CASE 53
                ' File not found tell user to try again.
                Dummy% = CenterPrint%("File not found.  Try again.  Press a key to continue...", CSRLIN, 15, 0): BEEP
                DummyString$ = INPUT$(1)
                PRINT
                INPUT "Enter file to save in: ", FileToSave$
                RESUME
        CASE 61
                ' Disk is full.  Tell user about it and retry.

                Dummy% = CenterPrint%("Disk Full.  Press a key to continue...", CSRLIN, 15, 0): BEEP
                DummyString$ = INPUT$(1)
                RESUME
        CASE 71
                ' Disk not ready.  Try again

                Dummy% = CenterPrint%("Disk not ready.  Close drive.  Press a key to continue...", CSRLIN, 15, 0): BEEP
                DummyString$ = INPUT$(1): PRINT
                INPUT "Enter file to save in: ", FileToSave$
                RESUME
        CASE 72
                ' Something wrong with a disk.  Tell user

                Dummy% = CenterPrint%("Something wrong with disk.  Get a new disk.  Press a key to continue...", CSRLIN, 15, 0): BEEP
                DummyString$ = INPUT$(1): PRINT
                INPUT "Enter file to save in: ", FileToSave$
                RESUME
        CASE 75
                ' Path/File access error.

                Dummy% = CenterPrint%("Path/File access error.  Try again...Press a key to continue...", CSRLIN, 15, 0): BEEP
                DummyString$ = INPUT$(1): PRINT
                INPUT "Enter file to save in: ", FileToSave$
                RESUME
        CASE 76
                ' Path not found.

                Dummy% = CenterPrint%("Path not found.  Try again.  Press a key to continue...", CSRLIN, 15, 0): BEEP
                DummyString$ = INPUT$(1): PRINT
                INPUT "Enter file to save in: ", FileToSave$
                RESUME
        CASE ELSE
                ON ERROR GOTO 0
END SELECT

RedrawMenuUp:

SELECT CASE PosOfHighlight%
        CASE 1
                LOCATE 8, 34: COLOR 7, 0
                PRINT "Play Game"
                LOCATE 14, 34
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%
                PRINT "Quit"
                PosOfHighlight% = 4
                RETURN
        CASE 2
                LOCATE 10, 34: COLOR 7, 0
                PRINT "Save Game"
                LOCATE 8, 34    ' Position cursor to print first option
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%: PRINT "Play Game"
                PosOfHighlight% = 1
                RETURN
        CASE 3
                LOCATE 12, 34: COLOR 7, 0
                PRINT "Restore Game"
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%
                LOCATE 10, 34: PRINT "Save Game"
                PosOfHighlight% = 2
                RETURN
        CASE 4
                LOCATE 14, 34: COLOR 7, 0
                PRINT "Quit"
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%
                LOCATE 12, 34: PRINT "Restore Game"
                PosOfHighlight% = 3
                RETURN
        CASE ELSE
                RETURN
END SELECT

RedrawMenuDown:
SELECT CASE PosOfHighlight%
        CASE 1
                LOCATE 8, 34
                COLOR 7, 0
                PRINT "Play Game"
                LOCATE 10, 34
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%
                PRINT "Save Game"
                PosOfHighlight% = 2
                RETURN
        CASE 2
                LOCATE 10, 34
                COLOR 7, 0
                PRINT "Save Game"
                LOCATE 12, 34
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%
                PRINT "Restore Game"
                PosOfHighlight% = 3
                RETURN
        CASE 3
                LOCATE 12, 34
                COLOR 7, 0
                PRINT "Restore Game"
                LOCATE 14, 34
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%
                PRINT "Quit"
                PosOfHighlight% = 4
                RETURN
        CASE 4
                LOCATE 14, 34
                COLOR 7, 0: PRINT "Quit"
                LOCATE 8, 34
                COLOR MenuLettersForeHigh%, MenuLettersBackHigh%
                PRINT "Play Game"
                PosOfHighlight% = 1
                RETURN
        CASE ELSE
                RETURN
END SELECT


PlayMusic:

IF Count% = 1 THEN
        Count% = Count% + 1
        Playing$ = "MB MS T175 O2G8B-8B8O3C8C8C8O2B-8G8G8B-8B8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 2 THEN
        Count% = Count% + 1
        Playing$ = "O3 C8C8C8O2B-8G8G8B-8B8O3C8C8C8O2B-8G8G8B-8B8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 3 THEN
        Count% = Count% + 1
        Playing$ = "O3C8C8C8O2B-8G8O3C8E-8E8F8F8F8E-8C8C8E-8E8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 4 THEN
        Count% = Count% + 1
        Playing$ = "O3F8F8F8E-8C8O2G8B-8B8O3C8C8C8O2B-8G8G8B-8B8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 5 THEN
        Count% = Count% + 1
        Playing$ = "O3C8C8C8O2B-8G8O3C8E8F8G8G8G8F8D8D8G8G8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 6 THEN
        Count% = Count% + 1
        Playing$ = "O3F8F8F8E-8C8O2G8B-8B8O3C8C8C8O2B-8G8G8O3C8O2B-8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 7 THEN
        Count% = Count% + 1
        Playing$ = "O3C8C8C8MLC8C8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 8 THEN
        Count% = Count% + 1
        Playing$ = "MS T175 O2G8B-8B8O3C8C8C8O2B-8G8G8B-8B8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 9 THEN
        Count% = Count% + 1
        Playing$ = "O3 C8C8C8O2B-8G8G8B-8B8O3C8C8C8O2B-8G0G8B-8B8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 10 THEN
        Count% = Count% + 1
        Playing$ = "O3C8C8C8O2B-8G8O3C8E-8E8F8F8F8E-8C8C8E-8E8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 11 THEN
        Count% = Count% + 1
        Playing$ = "O3F8F8F8E-8C8O2G8B-8B8O3C8C8C8O2B-8G8G8B-8B8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 12 THEN
        Count% = Count% + 1
        Playing$ = "O3C8C8C8O2B-8G8O3C8E8F8G8G8G8F8D8D8G8G8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 13 THEN
        Count% = Count% + 1
        Playing$ = "O3F8F8F8E-8C8O2G8B-8B8O3C8C8C8O2B-8G8G8O3C8O2B-8"
        PLAY Playing$
        RETURN
ELSEIF Count% = 14 THEN
        Count% = 1
        Playing$ = "O3C16P16O2B-8G8MLO3C1"
        PLAY Playing$
        RETURN
END IF

FUNCTION CenterPrint% (ToPrint$, Row%, ForeColor%, BackColor%) STATIC

COLOR ForeColor%, BackColor%

LengthOfString% = LEN(ToPrint$)
ColumnStart% = 40 - (LengthOfString% / 2)
LOCATE Row%, ColumnStart%
PRINT ToPrint$;

CenterPrint% = POS(0)   ' Return Current h.poz
END FUNCTION

SUB DownAndLeft

'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move up one to read number

LOCATE yPos% + 1, xPos% - 1
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yello

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                      
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF

' ---- Loop until cursor reaches top of screen or the number of times read
NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times
FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF CSRLIN + 1 = 22 THEN          ' Get out of loop.  At top of screen
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        IF POS(0) - 1 = 0 THEN
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        LOCATE CSRLIN + 1, POS(0) - 1     ' Go one Up.
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos%, xPos%  ' Print star Mark
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%
END SUB

SUB DownAndRight

'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move up one to read number

LOCATE yPos% + 1, xPos% + 1
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yello

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                     
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF

' ---- Loop until cursor reaches top of screen or the number of times read
NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times
FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF CSRLIN + 1 = 22 THEN          ' Get out of loop.  At top of screen
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        IF POS(0) + 1 = 81 THEN
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        LOCATE CSRLIN + 1, POS(0) + 1     ' Go one Up.
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                xPos% = POS(0): yPos% = CSRLIN
                LOCATE yPos% + 1, xPos% - 1
                LOCATE yPos%, xPos%
                xPos% = POS(0): yPos% = CSRLIN
                LOCATE yPos%, xPos%
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos%, xPos%  ' Print star Mark
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%

END SUB

SUB DownArrow

'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move down one to read number

LOCATE yPos% + 1, xPos%
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yellow

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                        
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF

' ---- Loop until cursor reaches top of screen or the number of times read

NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times

IF NumberOfTimes% + CSRLIN > 21 THEN NumberOfTimes% = 21 - CSRLIN + 1

FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF CSRLIN + 1 = 22 THEN          ' Get out of loop.  At bottom of screen
                YesNo% = 0
                EXIT FOR
        END IF
        LOCATE CSRLIN + 1, POS(0)       ' Go one Down
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos%, xPos% ' Print star
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%
END SUB

SUB Frame (left%, right%, top%, bottom%, Forcolor%, BackColor%) STATIC

'    ---- Set color.

COLOR Forcolor%, BackColor%

' This sub program is from Microsoft QuickBasic

' The Frame subprogram draws a rectangular double-line frame on
'       the screen, using"text-graphics" characters from the
'       IBM Extended ASCII character set.

' ---- Draw the four corners.   

' Draw Box

        LOCATE top%, left%: PRINT CHR$(201)
        LOCATE top%, right%: PRINT CHR$(187)
        LOCATE bottom%, left%: PRINT CHR$(200);
        LOCATE bottom%, right%: PRINT CHR$(188);

'       ---- Draw the vertical lines

        FOR vert% = top% + 1 TO bottom% - 1
                LOCATE vert%, left%: PRINT CHR$(186);
                LOCATE vert%, right%: PRINT CHR$(186);
        NEXT vert%

'       ---- Draw the horizontal lines.

        horiz% = right% - left% - 1
        hline$ = STRING$(horiz%, 205)
        LOCATE top%, left% + 1: PRINT hline$
        LOCATE bottom%, left% + 1: PRINT hline$

END SUB

SUB GameOver (GameOv%) STATIC

' This sub Handles everything when game is over.

IF GameOv% = 0 THEN EXIT SUB

Dummy% = CenterPrint%("Game Over.  Press a key to continue...", 24, GameOverLight%, 0)

DummyString$ = ""
DO UNTIL DummyString$ <> ""
        DummyString$ = INKEY$
LOOP

CLS
ScoreToPrint$ = "Your Score:" + STR$(Done%) + " out of 1680"
Dummy% = CenterPrint%(ScoreToPrint$, 1, 7, 0)
PercentToPrint$ = "Percentage Done: " + PercentPrint$
Dummy% = CenterPrint%(PercentToPrint$, 3, 7, 0)
Dummy% = CenterPrint%("Press a key to continue...", 5, 7, 0)

DummyString$ = ""
DO UNTIL DummyString$ <> ""
        DummyString$ = INKEY$
LOOP

IF Done% >= 1680 THEN
        PRINT
        PRINT "I don't beleive you solved the this game!!  Did you really solve it or"
        PRINT "did you cheat?  If you really solved it, then Hurah for you!"
        PRINT "Press a key to continue...": DummyString$ = INPUT$(1)
END IF

' This sub routine Graphs the game on a bar graph.

GraphGame PercentPrint$
GameDone% = -1
GameLoaded% = 0
END SUB

SUB GraphGame (Percentage$) STATIC
' Draw a graph of what happened.

CLS
ON ERROR GOTO ErrorHandle
SCREEN 2

' Check to see if screen is Ok
IF NoGraph% <> 0 THEN
        Dummy% = CenterPrint%("Sorry, your monitor does not support graphs.  Press a key to continue...", 12, 7, 0)
        DO
                Dummy$ = INKEY$
        LOOP WHILE Dummy$ = ""
        NoGraph% = 0
        EXIT SUB
END IF

LINE (170, 87)-(470, 102), , B
StripUntil% = INSTR(Percentage$, ".")
Percentage$ = LEFT$(Percentage$, StripUntil% - 1)
Pev = INT(VAL(Percentage$)) / 100
LineSpec% = 170 + (300 * Pev)
LINE (170, 87)-(LineSpec%, 102), , BF
LOCATE 10, 30
PRINT "Graph of Percent Done"
LOCATE 15, 31
PRINT "Percent Done: "; LEFT$(RTRIM$(LTRIM$(Percentage$)), 2) + "%"
Dummy$ = INPUT$(1)
SCREEN 0
END SUB

SUB LeftArrow
 
'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move up one to read number

LOCATE yPos%, xPos% - 1
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yellow

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                        
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF
' ---- Loop until cursor reaches top of screen or the number of times read

NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times
FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF POS(0) - 1 = 0 THEN          ' Get out of loop.  At left of screen
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        LOCATE CSRLIN, POS(0) - 1     ' Go one Left
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos%, xPos% ' Print star
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

' Update Score and number of moves.
UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%
END SUB

SUB MemorizeScreen (xPos%, yPos%) STATIC

' This Sub program memorizes the screen for storage.
FOR I% = 1 TO 21
        FOR J% = 1 TO 80
                ScreenSave(I%, J%) = CHR$(SCREEN(I%, J%))
        NEXT J%
NEXT I%

xToSave% = xPos%
yToSave% = yPos%

'       Set GameLoaded to true.
GameLoaded% = -1
END SUB

SUB PlayGame STATIC

' This sub is the actual game.

SetUpScreen             ' ---- Set up screen for play

GetAnotherKey:
IF GameDone% <> 0 THEN
        GameDone% = 0
        Setting% = 0
        EXIT SUB
END IF
CursorValue$ = ""       ' ---- Initilize CursorValue$

DO WHILE CursorValue$ = ""
        CursorValue$ = INKEY$
LOOP

IF UCASE$(CursorValue$) = "S" THEN
        IF Setting% = 0 THEN
                PLAY STOP
                yPos% = CSRLIN
                xPos% = POS(0)
                LOCATE 24, 8
                PRINT "OFF";
                LOCATE yPos%, xPos%
                Setting% = 1
        ELSE
                PLAY ON
                yPos% = CSRLIN
                xPos% = POS(0)
                LOCATE 24, 8
                PRINT "ON ";
                LOCATE yPos%, xPos%
                Setting% = 0
        END IF
END IF

' ---- If at top line,can't go up so, return.
' ---- All these are for user protection

IF CursorValue$ = "8" AND CSRLIN = 1 THEN GOTO GetAnotherKey
IF CursorValue$ = "2" AND CSRLIN = 21 THEN GOTO GetAnotherKey
IF CursorValue$ = "4" AND POS(0) = 1 THEN GOTO GetAnotherKey
IF CursorValue$ = "6" AND POS(0) = 80 THEN GOTO GetAnotherKey
IF CursorValue$ = "1" AND POS(0) = 1 THEN GOTO GetAnotherKey
IF CursorValue$ = "1" AND CSRLIN = 21 THEN GOTO GetAnotherKey
IF CursorValue$ = "7" AND CSRLIN = 1 THEN GOTO GetAnotherKey
IF CursorValue$ = "7" AND POS(0) = 1 THEN GOTO GetAnotherKey
IF CursorValue$ = "9" AND POS(0) = 80 THEN GOTO GetAnotherKey
IF CursorValue$ = "9" AND CSRLIN = 1 THEN GOTO GetAnotherKey
IF CursorValue$ = "3" AND CSRLIN = 21 THEN GOTO GetAnotherKey
IF CursorValue$ = "3" AND POS(0) = 80 THEN GOTO GetAnotherKey

SELECT CASE CursorValue$
        CASE "8"
                UpArrow
                GOTO GetAnotherKey
        CASE "7"
                UpAndLeft
                GOTO GetAnotherKey
        CASE "9"
                UpAndRight
                GOTO GetAnotherKey
        CASE "2"
                DownArrow
                GOTO GetAnotherKey
        CASE "1"
                DownAndLeft
                GOTO GetAnotherKey
        CASE "3"
                DownAndRight
                GOTO GetAnotherKey
        CASE "4"
                LeftArrow
                GOTO GetAnotherKey
        CASE "6"
                RightArrow
                GOTO GetAnotherKey
        CASE CHR$(27)
                xPos% = POS(0): yPos% = CSRLIN
                Dummy% = CenterPrint%("Please Wait...", 25, 15, 0)
                MemorizeScreen xPos%, yPos%
                Setting% = 0
                EXIT SUB
        CASE ELSE
                GOTO GetAnotherKey
END SELECT
GameDone% = 0
Setting% = 0
END SUB

SUB RestoreGame STATIC

CLS
' File to save

TryAgain:
ON ERROR GOTO ErrorHandle       ' Turn on error traping

NothingEnter:
INPUT "Type NONE to exit.  Enter file to retreive: ", FileToSave$
FileToSave$ = UCASE$(FileToSave$)
IF FileToSave$ = "" THEN
        GOTO NothingEnter
ELSEIF FileToSave$ = "NONE" THEN
        GameLoaded% = 0
        EXIT SUB
END IF

OPEN FileToSave$ FOR INPUT AS #1       ' Open file
LINE INPUT #1, Test$
ON ERROR GOTO 0
IF Test$ <> "This is a snake file." THEN
        PRINT "This is not a saved file."
        GOTO TryAgain
END IF
Dummy% = CenterPrint%("Restoring...Please wait", 25, FileIO%, 0)

FOR I% = 1 TO 21
        LINE INPUT #1, LineInputs$
        FOR J% = 1 TO 80
                SingleNum% = VAL(MID$(LineInputs$, J%, 1))
                ScreenSave(I%, J%) = RTRIM$(LTRIM$(STR$(SingleNum%)))
        NEXT J%
NEXT I%
' Get cursor postions and number of moves

LINE INPUT #1, XPosString$
LINE INPUT #1, XPosString$: xToSave% = VAL(XPosString$)
LINE INPUT #1, YPosString$: yToSave% = VAL(YPosString$)
LINE INPUT #1, NumberMoves$: Moves% = VAL(NumberMoves$)

' Set GameLoaded% to true and close file
CLOSE #1
GameLoaded% = -1
END SUB

SUB RightArrow
 
'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move right one to read number

LOCATE yPos%, xPos% + 1
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yellow

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                       
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF

' ---- Loop until cursor reaches top of screen or the number of times read

NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times

' Test to see if at the right of screen, if so, go only to it.
                                                                    
IF (NumberOfTimes% - 1) + POS(0) > 80 THEN NumberOfTimes% = 80 - POS(0) + 1

FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF POS(0) + 1 = 81 THEN          ' Get out of loop.  At left of screen
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        LOCATE CSRLIN, POS(0) + 1     ' Go one Left
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos%, xPos% ' Print star
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%
END SUB

SUB SaveGame STATIC

' This sub saves the game

' No game loaded

IF GameLoaded% = 0 THEN
        Dummy% = CenterPrint%("No Game Loaded", 22, GameOverLight%, 0)
        Dummy% = CenterPrint%("Press a key to continue...", 24, GameOverLight%, 0)
        Dummy$ = INPUT$(1)
        EXIT SUB
END IF

CLS
' File to save

NothingEntered:
INPUT "Type NONE to exit.  Enter file to save in: ", FileToSave$
FileToSave$ = UCASE$(FileToSave$)

IF FileToSave$ = "" THEN
        GOTO NothingEntered
ELSEIF FileToSave$ = "NONE" THEN
        GameLoaded% = 0
        EXIT SUB
END IF

ON ERROR GOTO ErrorHandle       ' Turn on error traping

OPEN FileToSave$ FOR OUTPUT AS #1       ' Open file
Dummy% = CenterPrint%("Saving...Please wait", 25, FileIO%, 0)
PRINT #1, "This is a snake file."       ' Identify file as snake ifle.

FOR I% = 1 TO 21
        FOR J% = 1 TO 80  'note here 79 not 80
                 PRINT #1, ScreenSave(I%, J%);
        NEXT J%
        PRINT #1, ""
NEXT I%

' Print cursor positions to files.
PRINT #1, ""
PRINT #1, RTRIM$(LTRIM$(STR$(xToSave%)))
PRINT #1, RTRIM$(LTRIM$(STR$(yToSave%)))
PRINT #1, RTRIM$(LTRIM$(STR$(Moves%)))
' Close file
CLOSE #1
END SUB

SUB SetUpScreen STATIC

CLS : COLOR NumbersDrawn%   ' Draw Numbers in Red

RANDOMIZE TIMER

' --- Fill screen with Random Numbers
' --- This section decides if a game is loaded.  If it is, do not make
' --- Random numbers.
IF GameLoaded% = 0 THEN
        FOR I% = 1 TO 1680
                RandomNo1% = INT(RND * 9) + 1
                Number$ = STR$(RandomNo1%)
                PrintNum$ = RTRIM$(LTRIM$(Number$))
                PRINT PrintNum$;
        NEXT I%
ELSE
        FOR I% = 1 TO 21
                FOR J% = 1 TO 80
                        Numbers$ = ScreenSave(I%, J%)
                        IF Numbers$ = "0" OR Numbers$ = "*" THEN
                                COLOR StarsDrawn%: PRINT "*"; : COLOR StarsDrawnRed%
                        ELSE
                                PRINT Numbers$;
                        END IF
                NEXT J%
        NEXT I%
END IF

' ------ Draw Blue Seperation Line

COLOR BlueLine%: LOCATE 22, 1: PRINT STRING$(80, 196)

'       ----- Randomly pick a cursor position

xPos% = INT(RND * 79) + 1
yPos% = INT(RND * 21) + 1       ' Seperation line at 22

'       ----- Write Percent Done  and Number Done on the status line.
LOCATE 23, 1
COLOR 7
PRINT "Percent Done:"
LOCATE 23, 40: PRINT "Number Done:"
Dummy% = CenterPrint%("Number of moves: ", 24, 7, 0)
Dummy% = CenterPrint%("ESC to Exit", 25, 15, 0)
LOCATE 24, 1: PRINT "Sound: ON";
'       ----- Move to cursor position chosen randomly and pick star

IF GameLoaded% = 0 THEN
        LOCATE yPos%, xPos%
        COLOR YellowPrint%: PRINT "*": LOCATE yPos%, xPos%
ELSE
        LOCATE yToSave%, xToSave%: COLOR GreenStar%: PRINT "*": LOCATE yToSave%, xToSave%: UpDateScore 0, 0
END IF
'       ----- Screen Set-up done.
END SUB

SUB UpAndLeft

'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move up one to read number

LOCATE yPos% - 1, xPos% - 1
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yello

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                        
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF

' ---- Loop until cursor reaches top of screen or the number of times read
NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times

FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF CSRLIN - 1 = 0 THEN          ' Get out of loop.  At top of screen
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        IF POS(0) - 1 = 0 THEN
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        LOCATE CSRLIN - 1, POS(0) - 1     ' Go one Up.
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                xPos% = POS(0): yPos% = CSRLIN
                LOCATE yPos% + 1, xPos% + 1
                PRINT "*"
                LOCATE yPos%, xPos%
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        LOCATE CSRLIN + 1, POS(0) + 1
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos% - 1, xPos% - 1' Print star
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%
END SUB

SUB UpAndRight

'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move up one to read number

LOCATE yPos% - 1, xPos% + 1
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yello

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                       
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF

' ---- Loop until cursor reaches top of screen or the number of times read
NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times
FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF CSRLIN - 1 = 0 THEN          ' Get out of loop.  At top of screen
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        IF POS(0) + 1 = 81 THEN
                YesNo% = 0
                NumberOfTimes% = I%
                EXIT FOR
        END IF
        LOCATE CSRLIN - 1, POS(0) + 1     ' Go one Up.
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                xPos% = POS(0): yPos% = CSRLIN
                LOCATE yPos% + 1, xPos% - 1
                PRINT "*"
                LOCATE yPos%, xPos%
                xPos% = POS(0): yPos% = CSRLIN
                LOCATE yPos%, xPos%
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        LOCATE CSRLIN + 1, POS(0) - 1
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos% - 1, xPos% + 1' Print star
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%

END SUB

SUB UpArrow
 
'   ----- Save current position
xPos% = POS(0)
yPos% = CSRLIN

'   ----- Print Star to reset the green star

PRINT "*": LOCATE yPos%, xPos%

'  ------ Move up one to read number

LOCATE yPos% - 1, xPos%
ReadNumber% = SCREEN(CSRLIN, POS(0), 0)

'  ------ Save Screen Position again and print star to reset previous to yello

xPos% = POS(0)
yPos% = CSRLIN
PRINT "*": LOCATE yPos%, xPos%

RealNum$ = CHR$(ReadNumber%)   ' Read Number at cursor
                                         
' If star then Game is over. "Ate himself"

IF RealNum$ = "*" THEN
        GameOver -1
        EXIT SUB
END IF

' ---- Loop until cursor reaches top of screen or the number of times read
NumberOfTimes% = VAL(RealNum$)          ' Get Real Number of times

IF CSRLIN < NumberOfTimes% THEN NumberOfTimes% = CSRLIN

FOR I% = 1 TO NumberOfTimes% - 1        ' Loop -1 because already a star there
        IF CSRLIN - 1 = 0 THEN          ' Get out of loop.  At top of screen
                YesNo% = 0
                EXIT FOR
        END IF
        LOCATE CSRLIN - 1, POS(0)       ' Go one Up.
        ReadNumber% = SCREEN(CSRLIN, POS(0), 0) ' Check to see if there is a star.
        RealValue$ = CHR$(ReadNumber%)      ' Convert ASCII value of star to real value
        IF RealValue$ = "*" THEN
                YesNo% = -1
                EXIT FOR
        END IF                          ' If star, exit loop
        xPos% = POS(0): yPos% = CSRLIN  ' Save postition of star
        PRINT "*": LOCATE yPos%, xPos% ' Print star
NEXT I%

xPos% = POS(0)
yPos% = CSRLIN

' Reset to green to yellow, put cursor back.

LOCATE yPos%, xPos%: COLOR ArrowColor%: PRINT "*": LOCATE yPos%, xPos%: COLOR RestoreArrow%

UpDateScore -1, NumberOfTimes%: Moves% = Moves% + 1
GameOver YesNo%
END SUB

SUB UpDateScore (Total%, NumberAdd%) STATIC

'     ------ Save Cursor Position

xPos% = POS(0)
yPos% = CSRLIN


'     ------  This SubProgram Updates to score on the Percent done.
IF Total% = 0 THEN      'Check to see if program wants to read whole screen or just part.

        Done% = 0       ' ----- Initilize variable because of STATIC

        '       ----- Goto begining of screen

        LOCATE 1, 1

        '       ----- Read each screen position.  If it is a star, add it to Done%

        FOR Row% = 1 TO 21
                FOR Column% = 1 TO 80
                        IfFilled% = SCREEN(Row%, Column%)
                        IF IfFilled% = 42 THEN Done% = Done% + 1
                NEXT Column%
        NEXT Row%
ELSE    ' Or else do a quick update.  Much faster, not as reliable.
        IF FlagOnce% = 0 THEN
                Done% = Done% + NumberAdd% + 1
                FlagOnce% = -1
        ELSE
                Done% = Done% + NumberAdd%
        END IF
END IF

        '       ----- Calculate percentage of done
PercentDone! = Done% / 1680
NumberPercent! = PercentDone! * 100
PercentPrint$ = RTRIM$(LTRIM$(STR$(NumberPercent!))) + "%"
LOCATE 23, 16: PRINT "                   ": LOCATE 23, 16: COLOR GreenScore%: PRINT PercentPrint$: LOCATE 23, 53: IF GameLoaded% <> 0 THEN PRINT RTRIM$(LTRIM$(STR$(Done%))) ELSE PRINT RTRIM$(LTRIM$(STR$(Done%)))
LOCATE 24, 49: PRINT RTRIM$(LTRIM$(STR$(Moves%)));
COLOR YellowPrint%

'       ----- Put cursor back where it was.

LOCATE yPos%, xPos%
END SUB

