UNIT menu;

(*
   ------------------------------------------------------------------------
   AUTOR:   Martin Kochloefl
            Kreuzstr. 2
            8052 Moosburg          Tel. 08761-1247
   ------------------------------------------------------------------------
   REV:                       2.02  11.02.1991
   DATEI:                     MENU.PAS
   SPRACHE:                   TURBO PASCAL 6.0
   EINZUBINDENDE UNITS:       CRT
                              SCREEN.PAS in Datei SCREEN.PAS
   UNIT GEHRT ZUM PROGRAMM:  SUPERLOTTO in Datei SLOTTO.PAS

   LETZTE NDERUNG: Dokumentation des Units
                    TP6.0 und ARJ-Archiv
   ------------------------------------------------------------------------

   Das UNIT menu beinhaltet ein Auswahlmen zur Darstellung in einer
   beliebigen Zeile und Spalte.
   Das Men kann bis zu 15 Eintrge aufnehmen, kann jedoch ohne Probleme
   vergrssert werden. Alle Menpunkte knnen sich ber mehrere Zeilen
   erstrecken, die Hinweise zu den einzelnen Menpunkten werden immer eine
   Zeile tiefer dargestellt. Es gibt von mir noch eine wesentlich grere
   Unit zur Mendarstellung, die auch vertikale Men darstellt und mit
   Fenstern arbeitet, jedoch ist diese noch nicht dokumentiert und ist mit
   OOPS von TP 5.5 geschrieben und damit noch sicher nicht jedem zugnglich.
   Deshalb hier nur eine abgespeckte Version, die jedoch vielen Anforderungen
   bereits vollkommen gengt.

   Alle Parameter des Mens werden ber den RECORD menuerec festgelegt:

   namen [1..maxmenue] = die jeweilige Bezeichnung des Menpunktes
   melde [1..maxmenue] = die Erluterung eines jeden Menpunktes
                         (beides mit 60 Zeichen vorgegeben, was jedoch jeder-
                          zeit verndert werden kann)
   anzahl              = Anzahl der Menpunkte
   zeile,spalte        = die linke obere Ecke, wo das Men beginnen soll
   wahl                = Ausgabeparameter, der dem gewhlten Menpunkt
                         als Nummer entpricht. Als Eingabeparameter
                         wird direkt der Menpunkt hervorgehoben.

   Die Bedienung des Men erfolgt direkt ber Cursorbewegungen links
   und rechts, bzw. nach oben und unten, sowie mit der Leertaste und
   Backspace.
   Eine Auswahl wird mit <ENTER> oder direkt ber den hell dargestellten
   Buchstaben getroffen.
   Ein Menabbruch erfolgt mit <ESC>, wobei automatisch der letzte Men-
   punkt als Wahl getroffen wird. Der letzte Menpunkt sollte also immer
   ein ENDE beinhalten.
   Die Direktbuchstaben zum jeden Menpunkt werden automatisch ermittelt,
   und zwar so, da jeder Buchstabe mglichst nur einmal vorkommt.
*)

INTERFACE

USES
   crt, screen ;

CONST
      maxmenue = 15;

TYPE
      menuerec = RECORD            (* Menueauswahl *)
                   namen, melde  : ARRAY[1..maxmenue] OF STRING[60];
                   wahl, anzahl,
                   zeile, spalte : BYTE;
                 END;

PROCEDURE menue(VAR m : menuerec);

IMPLEMENTATION

   PROCEDURE menue;

   VAR
       j,                    (* zuletzt hervorgehobener Menpunkt *)
       i,                    (* hervorgehobener Menpunkt *)
       k, s1, z1 : INTEGER;  (* Hilfsvariablen *)
       ch              : CHAR;
       spezial, ende   : BOOLEAN;  (* Spezial ist Merker fr Doppelcode *)
       spalte, zeile   : ARRAY[1..maxmenue] OF INTEGER;
                                   (* errechnete Zeile und Spalte eines
                                      jeden Menpunktes *)
       setofnamen      : SET OF CHAR; (* Errechnete Buchstaben zur Direkt-
                                         anwahl eines Menpunktes *)
       hset            : CHAR;
       buchst          : ARRAY[1..maxmenue] OF BYTE;
                                   (* Hilfsvariablen fr setofnamen *)

      PROCEDURE setze;
      (* Berechnung der Bildschirmposition fr jeden Menpunkt und des
         Buchstabens zur Direktanwahl *)

      VAR
          i, j : INTEGER;

      BEGIN
         setofnamen := [];
         m.wahl := ABS(m.wahl);
         z1 := m.zeile;
         s1 := m.spalte;
         FOR i := 1 TO m.anzahl
         DO BEGIN
            j := 1;
            REPEAT
               hset := UPCASE(m.namen[i][j]);
               buchst[i] := j;
               INC(j);
            UNTIL NOT(hset IN setofnamen) OR (j > LENGTH(m.namen[i]));
            IF (hset IN setofnamen) AND (j > LENGTH(m.namen[i]))
            THEN BEGIN
               hset := UPCASE(m.namen[i][1]);
               buchst[i] := 1;
            END;
            (* Berechnung der Direktanwahl fr die Menpunkte *)

            zeile[i] := z1;
            spalte[i] := s1;
            s1 := s1 + LENGTH(m.namen[i]) + 2;
            IF s1 > 78
            THEN BEGIN
               s1 := 3;
               z1 := SUCC(z1);
               zeile[i] := z1;
               spalte[i] := s1;
               s1 := s1 + LENGTH(m.namen[i]) + 2;
            END;
            (* Berechnung der Bildschirmposition eines Menpunktes *)

            setofnamen := setofnamen + [hset];
            (* alle erlaubten Buchstaben *)

         END;
      END;

      PROCEDURE snormal;
      (* schreibt einen gerade nicht angewhlten Menpunkt *)

      BEGIN
         bwn(spalte[j], zeile[j], ' ' + m.namen[j] + ' ');
         setsymbol(spalte[j] + buchst[j], zeile[j],
                   ord(m.namen[j][buchst[j]]), f);
      END;

      PROCEDURE srevers;
      (* schreibt einen hervorgehobenen Menpunkt *)

      BEGIN
         bwr(spalte[i], zeile[i], rb, ' ' + m.namen[i] + ' ');
      END;

   BEGIN
      setze;
      FOR j := 1 TO m.anzahl
      DO snormal;
      (* schreibt alle Menpunkte auf den Bildschirm *)

      i := m.wahl;
      (* der erste hervorgehobene Menpunkt *)

      j := m.anzahl;
      (* der zuletzt hervorgehobene Menpunkt *)

      ende := FALSE;
      REPEAT
         snormal;
         (* Schreibt den zuletzt angewhlten Menpunkt als normal *)

         srevers;
         (* Schreibt den gerade angewhlten Menpunkt als hervorgehoben *)

         j := i;
         (* speichert den angewhlten Menpunkt als zuletzt angewhlt *)

         bwn(SUCC(m.spalte), SUCC(z1),
             COPY(m.melde[i] + leerzeile, 1, 77 - m.spalte));
         (* schreibt den Hinweistext zum gerade hervorgehobenen Menpunkt *)

         REPEAT
            ch := readkey;
            (* wartet auf Tastendruck *)

            spezial := (ORD(ch) = 0); (* SPEZIAL= SONDERTASTEN NUMMERNBLOCK *)
            IF spezial                (*          ODER FUNKTIONSTASTEN      *)
            THEN ch := readkey;
            (* Bei Doppelcodes: Auslesen des zweiten Codes *)

            IF (ORD(ch) IN [8, 13, 27, 32])
            THEN spezial := TRUE;
            (* Macht weitere Sondertasten, die kein Doppelcode sind
               zum Spezialcode *)

         UNTIL (spezial AND (ORD(ch) IN [8, 13, 27, 32, 72, 75, 77, 80]))
                OR (NOT(spezial) AND (UPCASE(ch) IN setofnamen)) ;
         (* Schleife bis ein erlaubter Tastendruck erfolgt
            dieser mu entweder ein erlaubtes Steuerzeichen (spezial)
            oder ein erlaubter Buchstabe sein *)

         CASE ORD(ch) OF
            13 : BEGIN
                    m.wahl := i;
                    ende := TRUE;
                    (* ENTER-TASTE *)
                 END;
            27 : BEGIN
                    m.wahl := m.anzahl;
                    ende := TRUE;
                    (* ESC-TASTE *)
                 END;
            8, 72, 75 : i := PRED(i);   (* CURSOR LINKS,OBEN oder BACKSPACE *)
            32, 77, 80 : i := SUCC(i);  (* CURSOR RECHTS,UNTEN oder SPACE   *)
         ELSE IF UPCASE(ch) IN setofnamen  (* SONST-FALL mit erlaubten *)
            THEN BEGIN                     (* Tastendruck *)
               k := 1;
               REPEAT
                  IF UPCASE(ch) = UPCASE(m.namen[k][buchst[k]])
                  THEN BEGIN
                     m.wahl := k;
                     i := k;
                     ende := TRUE;
                  END;
                  k := k + 1;
               UNTIL (ende OR (k > m.anzahl));
            END;
            (* wertet einen erlaubten Tastendruck aus *)

         END;
         (* Komplett-Auswertung des Tastendruckes ber CASE *)

         IF i > m.anzahl THEN i := 1;
         IF i < 1 THEN i := m.anzahl;
         (* sorgt fr ein rotieren der Menpunkte *)

      UNTIL ende ;
      (* Schleife bis ein Menpunkt angewhlt ist *)
      snormal;
      srevers;
   END;

BEGIN
END.
