.model tiny
.code
xsize = 10
ysize = 20
count = 21
line  = 29
;
;cup_offset=640+80-(xsize+4)*2
        org 100h
start:
        jmp main
; glass0[bx+si]
keys    label word
        db 20H,32H,34H,35H,36H,38H,1bH
keys_length = $ - keys

key_table label word
        dw offset drop_shape
        dw offset move_down
        dw offset move_left
        dw offset rotate
        dw offset move_right
        dw offset dummy_move
        dw offset exit

vga_font label word
 db 07Eh,0C3h,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0C3h,07Eh; 0E0
 db 07Fh,080h,095h,0AAh,095h,0AAh,095h,0AAh,095h,0AAh,095h,0AAh,095h,0AAh,080h,07Fh; 0E1
 db 0FEh,001h,055h,0A9h,055h,0A9h,055h,0A9h,055h,0A9h,055h,0A9h,055h,0A9h,001h,0FEh; 0E2
ega_font label word
 db 07Eh,0C3h,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0BDh,0C3h,07Eh; 0E0
 db 07Fh,080h,095h,0AAh,095h,0AAh,095h,0AAh,095h,0AAh,095h,0AAh,080h,07Fh; 0E1
 db 0FEh,001h,055h,0A9h,055h,0A9h,055h,0A9h,055h,0A9h,055h,0A9h,001h,0FEh; 0E2
font_ptr    dw 0
font_length dw 0
first_char  db 0e0H
second_char db 0e1H
cga         db 0
exit_flag   db 0
cup_offset  dw 0  ;pointer  to screen cup
glass1      dw 0  ;pointer  to cup object
row         dw 0  ;pointer  to row table
buffer db       'Score:     '
end_of_buffer label word
db ' '
db 0
level_poster db 'Level:    ',0

side          dw 0    ;size of dropping matrix side
xd            dw 0
yd            dw 0

vseg          dw 0b800H
v_mode        db 0
current_shape db 0
current_color db 0
next_shape    db 0
next_color    db 0
drop          db 0
counter       db count
speed         db 0
score         dw 0
level         db 1
lines         db line

shape0 label byte
       db 3
       db 0fH,0fH,0fH
       db 0  ,0fH,0
       db 0  ,0  ,0
shape1 label byte
       db 3
       db 0  , 0 ,0
       db 0fh, 0 ,0
       db 0fh,0fh,0fh
shape2 label byte
       db 3
       db 0  ,0  ,0
       db 0  ,0  ,0fh
       db 0fh,0fh,0fh
shape3 label byte
       db 2
       db 0fh,0fh
       db 0fh,0fh
shape4 label byte
       db 3
       db 0  ,0fh,0
       db 0  ,0fh,0fh
       db 0  ,0  ,0fh
shape5 label byte
       db 3
       db 0  ,0fh,0
       db 0fh,0fh,0
       db 0fh,0  ,0
shape6 label byte
       db 4
       db 0,0,0,0
       db 0fh,0fh,0fh,0fh
       db 0,0,0,0
       db 0,0,0,0

shape_table label word
       dw offset shape0
       dw offset shape6
       dw offset shape2
       dw offset shape3
       dw offset shape4
       dw offset shape5
       dw offset shape1

tshape label word
       db 3
       db 0fH,0fH,0fH
       db 0  ,0fH,0
       db 0  ,0  ,0
       db 16 dup (0)
tmpshape db 0,5 dup(5 dup (0))
deltax dw 0
deltas dw 0
deltay dw 0

main:
     call  init_game
again:
     mov byte ptr drop,0
     mov ax,offset tshape
     push ax
     call init_shape
     add sp,2
     call display_score
key_loop:
     cmp byte ptr drop,1
     je again
     call getch
     or ax,ax
     je no_key
     mov di,offset keys
     cld
     mov cx,keys_length
repne scasb
     jne no_key
     dec di
     sub di,offset keys
     mov bx,di
     shl bx,1
     add bx,offset key_table
     call word ptr [bx]
no_key:
     sti
     hlt

     cmp byte ptr drop,1
     je  again
     dec byte ptr counter
     jnz key_loop
     mov al,level
     sub al,11
     neg al
     shl al,1
     shl al,1
     shl al,1
     add al,7
     mov byte ptr counter,al

     call move_down
     jmp key_loop

drop_shape proc near
     cmp byte ptr drop,1
     je ds_ret
     call move_down
     jmp drop_shape
ds_ret:
     ret
endp
show_cup proc near
       push es
       mov ax,vseg
       mov es,ax
       mov di,cup_offset

       mov si,glass1
       mov cx,ysize+1
       mov ah,20h
       cld
outher_loop:
       push cx
       push di
       mov cx,xsize+4
inner_loop:
       lodsb
       cmp al,44h
       jne cont_n0
       add di,4
       jmp inn_c0
cont_n0:
       and al,0fH
       xchg ah,al
       stosw
       stosw
       xchg ah,al
inn_c0:
       loop inner_loop
       pop di
       add di,160
       pop cx
       loop outher_loop
       pop es
       ret
endp
rotate proc near
;si = pointer on rotated shape
       push cs
       pop ds
       mov si,offset tshape
       cld
       xor ah,ah
       lodsb
       mov side,ax
       mov di,offset tmpshape
       stosb
       push di
       mov cx,25
       mov al,0
       rep stosb
       pop di
       add si,side
       dec si

       mov cx,side
loop_2:
       push cx
       push si
       mov cx,side
loop_1:
       lodsb
       dec si
       add si,side
       stosb
       loop loop_1
       pop si
       dec si
       pop cx
       loop loop_2
       xor ax,ax
       mov deltaX,ax
       mov deltaY,ax
       mov deltaS,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tmpshape
       push ax
       call check_place
       add sp,6
       or al,al
       jnz dont_rotate
       mov di,offset tshape
       mov si,offset tmpshape
       cld
       mov cx,25
       rep movsb
       call drawing
dont_rotate:
       ret
endp
show_box proc near
;bp+4 == x
;bp+6 == y
       push bp
       mov bp,sp
       push es
       push bx
       push di
       mov ax,vseg
       mov es,ax
       mov di,cup_offset
       mov ax,[bp+6]
       mov bl,0a0H
       mul bl
       add di,ax
       mov ax,[bp+4]
       shl ax,1
       shl ax,1
       add di,ax
       mov ah,current_color
       mov al,second_char
       cld
       stosw
       inc al
       stosw
       pop di
       pop bx
       pop es
       pop bp
       ret
endp
clear_box proc near
       push bp
       mov bp,sp
       push es
       push bx
       push di
       mov ax,vseg
       mov es,ax
       mov di,cup_offset
       mov ax,[bp+6]
       mov bl,0a0H
       mul bl
       add di,ax
       mov ax,[bp+4] ;x coords
       shl ax,1
       shl ax,1
       add di,ax
       mov ah,0
       mov al,' '
       cld
       stosw
       stosw
       pop di
       pop bx
       pop es
       pop bp
       ret
endp
check_place proc near
;bp+4 == pointer to shape
x_place = [bp+6]
y_place = [bp+8]
	push bp
	mov bp,sp
        call xor_put
        or ax,ax
        jz cp_right
        call xor_put
        mov ax,1
cp_right:
	pop bp
        ret
endp
xor_put proc near
;bp+4 == pointer to shape
x_place = [bp+6]
y_place = [bp+8]
      mov si,[bp+4]
      xor dx,dx
      cld
      lodsb
      xor ah,ah
      mov side,ax
      mov bx,y_place
      push bx
      shl bx,1
      add bx,row
      mov bx,[bx]
      add bx,glass1
      mov di,x_place
      mov cx,side
entry:
      push cx
      mov cx,side

xp2:
      lodsb
      or al,al
      jz not_add
      or al,80H
not_add:
      xor [bx+di],al
      mov al,[bx+di]
      and al,0c0H
      cmp al,0c0H
      jne not_override
      inc dx
not_override:
      inc di
      loop xp2

      pop cx
      pop bx
      inc bx
      push bx
      shl bx,1
      add bx,row
      mov bx,[bx]
      add bx,glass1
      mov di,x_place
      loop entry
      pop bx
      mov ax,dx
      ret
endp

redraw proc near
;bp+4 == pointer on shape
x_place = [bp+6]
y_place = [bp+8]
        push bp
        mov bp,sp
        mov si,[bp+4]
        cld
        lodsb
        xor ah,ah
        add ax,deltaS   ;correct size
        mov side,ax
        mov ax,deltaX
        sub x_place,ax   ;correct x coord.
        mov ax,deltaY
        sub y_place,ax   ;correct y coord.
        mov bx,y_place

        shl bx,1
        add bx,row
        mov bx,[bx]
        add bx,glass1
        mov cx,side
        add cx,deltaY
r1:

        push cx
	mov di,x_place
        mov cx,side
r2:
        mov al,[bx+di]
        test al,40H
        jnz background
        test al,80H
        jnz draw_or_stay
        test al,0fH
        jz background    ;must be cleared
        mov ax,y_place
        push ax
        push di
        call clear_box
        add sp,4
        mov byte ptr [bx+di],0  ;cleared
        jmp background
draw_or_stay:
        test al,0fH
        jnz draw
        mov al,current_color
        or al,80H
        xor [bx+di],al
        jmp background
draw:
        mov ax,y_place
        push ax
        push di
        call show_box
        add sp,4
        xor byte ptr [bx+di],80H
background:
        inc di
        loop r2
        inc word ptr y_place
        mov bx,y_place
        shl bx,1
        add bx,row
        mov bx,[bx]
        add bx,glass1
        pop cx
        loop r1
        pop bp
        ret
endp
move_left proc near
       dec word ptr xd
       xor ax,ax
       mov deltaY,ax
       mov deltaX,ax
       inc ax
       mov deltaS,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tshape
       push ax
       call check_place
       add sp,6
       or ax,ax
       jnz ml_failure
       call drawing
       jmp ml_ret
ml_failure:
       inc word ptr xd
ml_ret:
       ret
endp
move_right proc near
       inc word ptr xd
       xor ax,ax
       mov deltaY,ax
       inc ax
       mov deltaX,ax
       mov deltaS,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tshape
       push ax
       call check_place
       add sp,6
       or ax,ax
       jnz mr_failure
       call drawing
       jmp mr_ret
mr_failure:
       dec word ptr xd
mr_ret:
       ret
endp
move_down proc near
       inc byte ptr yd
       xor ax,ax
       mov deltaX,ax
       mov deltaS,ax
       inc ax
       mov deltaY,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tshape
       push ax
       call check_place
       add sp,6
       or ax,ax
       jnz md_failure
       call drawing
       jmp md_ret
md_failure:
       call into_back
       mov byte ptr drop,1
       call scan_line
md_ret:
       ret

endp
dummy_move proc near
       ret
endp
init_shape proc near
; bp+04 shape pointer
           push bp
           mov  bp,sp
           call random
           cmp  ax,7
           jne  init_cnt0
           dec  ax
init_cnt0:
           push ax
           add ax,3
           add score,ax
           pop ax
           shl  ax,1
           mov  bx,ax
           call random
           cmp  ax,0
           jne  init_cnt
           inc  ax
init_cnt:
           xor  al,8h
           mov  current_color,al
           mov  di,[bp+04]
           mov  si,shape_table[bx]
           cld
           lodsb
           stosb
           mov  cl,al
           mul  cl
           mov  cl,al
           xor  ch,ch
      rep  movsb
           mov  si,[bp+04]
           mov  di,si
           cld
           lodsb
           xor  ah,ah
           mov  side,ax
           stosb
           mov  cl,al
           mul  cl
           mov  cx,ax
           mov  ah,current_color
i_s_0:
           lodsb
           and  al,ah
           stosb
           loop i_s_0
           mov  ax,xsize
           shr  ax,1
           mov  cs:xd,ax
           xor  bx,bx
           mov  yd,bx
           push bx
           push ax
           mov  ax,[bp+4]
           push ax
           call check_place
           add  sp,6
           or   ax,ax
           jz   ok
           call exit
ok:
           call drawing
           pop  bp
           ret
endp
into_back proc near
           dec word ptr yd
           mov si,offset tshape
           cld
           lodsb
           xor ah,ah
           mov side,ax
           mov cx,ax
ib1:
           push cx
           mov bx,yd
           shl bx,1
           add bx,row
           mov bx,[bx]
           mov di,xd
           add bx,glass1

           mov cx,side
ib3:
           mov al,[bx+di]
           test al,0fH
           jz ib2
           and al,0fH
	   or al,40H
           mov [bx+di],al
ib2:
           inc di
           loop ib3
           inc yd
           pop cx
           loop ib1
           ret
endp
drawing proc near
     mov ax,yd
     push ax
     mov ax,xd
     push ax
     mov ax,offset tshape
     push ax
     call redraw
     add sp,6
     ret
endp
getch proc near
     mov ah,1
     int 16H
     jz extended
     mov ah,0
     int 16H
     or al,al
     jz extended
     xor ah,ah
     ret
extended:
     xor ax,ax
     ret
endp
exit proc near
     push cs
     pop  ds
sss:
     mov ah,1
     int 16H
     jz get_key
     mov ah,0
     int 16H
     jmp sss
get_key:
     mov ah,0
     int 16h

     cmp byte ptr cga,1
     je set_old_mode
     mov dx,3c4H
     mov al,3
     out dx,al
     inc dx
     xor al,al
     out dx,al
set_old_mode:
     mov  al,v_mode
     xor  ah,ah
     int  10h
     xor ax,ax
     mov ds,ax
     xor byte ptr ds:[417H],20H
     push cs
     pop  ds
     mov al,0
     out 40H,al
     out 40H,al
     int 20H
endp
scan_line proc near
     mov yd,ysize-1    ;from 14th rows
     mov xd,ysize-1
     mov cx,ysize
sl2:
     push cx
     mov bx,yd
     shl bx,1
     add bx,row
     mov bx,[bx]
     add bx,glass1
     mov cx,ysize
     mov di,2

     mov cx,10
     xor ah,ah
sl1:
     mov al,[bx+di]
     and al,40H
     shr al,1
     shr al,1
     add ah,al
     inc di
     loop sl1
     or ah,ah
     pop cx
     je end_scan
     push cx
     dec word ptr yd
     pop cx
     loop sl2
end_scan:
     mov ax,yd
     inc ax
     jnz sl3
     mov yd,ax
sl3:

     mov cx,ysize
     sub cx,yd
sl5:
     push cx
     mov bx,xd
     shl bx,1
     add bx,row
     mov bx,[bx]
     add bx,glass1
     mov di,2

     mov cx,10
     xor ah,ah
sl4:
     mov al,[bx+di]
     and al,40H
     shr al,1
     shr al,1
     add ah,al
     inc di
     loop sl4
     cmp ah,0a0H
     jne sl6      ;next line will checked
     call video_scroll
     call glass_scroll
     inc word ptr yd
     mov ax,yd
     cmp ax,xd
     jne not_bonus
     add word ptr score,100
not_bonus:
     add word ptr score,10
     dec byte ptr lines
     jns curr_level
     mov byte ptr lines,line
     cmp byte ptr level,10
     je curr_level
     inc byte ptr level
curr_level:
     call display_score
sl7:
     pop cx
     loop sl5
     jmp sl8     ;end of scan
sl6:
     dec word ptr xd
     jmp sl7
sl8:
     ret
endp
display_score proc near

     mov ax,score
     xor dx,dx
     mov si,offset end_of_buffer
     mov cx,10
     call bin_to_asc

     mov al,level
     aam
     add ax,3030H
     mov bx,ax
     mov al,ah
     mov ah,9
     push es
     mov es,word ptr vseg
     mov si,offset level_poster
     mov di,8+320
     push di
     push ax
     cld
leve:
     lodsb
     or al,al
     je show_score
     stosw
     jmp leve
show_score:
     pop ax
     stosw
     mov al,bl
     stosw
     pop di
     add di,160
     mov si,offset buffer
scor:
     lodsb
     or al,al
     je end_of_show
     stosw
     jmp scor
end_of_show:
     pop es
     ret
endp
video_scroll proc near
     mov cx,yd
     xchg ch,cl
     add ch,4
     mov cl,80-xsize*2
     shr cl,1
     mov dx,cx
     add dl,xsize*2-1
     mov ax,xd
     sub ax,yd
     add dh,al
     mov ax,701H
     mov bh,0
     int 10H
     ret
endp
glass_scroll proc near
     mov bx,xd
     shl bx,1
     add bx,row
     mov di,[bx]
     add di,glass1
     mov si,di
     dec si
     add di,13
     std
     mov ax,xd
     sub ax,yd
     mov cl,ysize
     mul cl
     mov cx,ax
     rep movsb
     ret
endp
;
;
;      AX - random number in interlive 0-7
random proc near
       push ds
       xor  ax,ax
       mov  ds,ax
       mov  si,046ch
       cld
       lodsw
       and  ax,7
       pop  ds
       ret
random endp

init_game proc near
      call get_display
      cmp al,3
      je ega
      cmp al,7
      jae ega
;cga or monochrome
      sub byte ptr first_char,30H
      sub byte ptr second_char,30H
      mov byte ptr cga,1
      jmp init_video
ega:
      mov ah,1
      cmp al,7
      jb eg1
      mov ah,4
      mov word ptr font_ptr,offset vga_font
      mov word ptr font_length,16
      jmp set_font
eg1:
      mov word ptr font_ptr,offset ega_font
      mov word ptr font_length,14
set_font:
      mov al,ah
      mov ah,11h
      mov bl,1
      int 10H

      call char_gen
init_video:
     mov  ah,0fh
     int  10h
     cmp  al,07
     jne  color
     sub  vseg,800h
color:
     mov ah,0
     int 10h
     mov v_mode,al
      mov dx,3c4H
      mov al,3
      out dx,al
      inc dx
      mov al,101B
      out dx,al

     xor ax,ax
     mov ds,ax
     or byte ptr ds:[417H],20H
     push cs
     pop ds
     call decompress
     mov  ax,1c04h
     mov  bh,xsize
     mov  bl,ysize
     mov  cl,4
     call init_cup
     call show_cup
     call display_score
     mov al,0
     out 40H,al
     mov al,16H
     out 40H,al
     ret
init_game endp

; Call with  DX:AX = signed 32 bit value
;	     CX    = radix
;            SI    = last byte of area to store resulting string
;	             (make sure enough room is available to store
;		      the string in the radix you have selected.)
;
; Destroys AX, BX, CX, DX, and SI.
;
bin_to_asc proc near

	mov	byte ptr [si],'0'
        or      dx,dx
        pushf
        jns     bin1
        not     dx
        not     ax
        add     ax,1
        adc     dx,0
bin1:


        mov     bx,ax
        or      bx,dx
        jz      bin3
        call    divide
        add     bl,'0'
        cmp     bl,'9'
        jle     bin2
        add     bl,'A'-'9'-1
bin2:   mov     [si],bl
        dec     si
        jmp     bin1
bin3:
        popf
        jns     bin4

	mov	byte ptr [si],'-'
bin4:   ret
bin_to_asc endp
;
;
; General purpose 32 bit by 16 bit unsigned divide.
; This must be used instead of the plain machine unsigned divide
; for cases where the quotient may overflow 16 bits (for example,
; dividing 100,000 by 2).  If called with a zero divisor, this
; routine returns the dividend unchanged and gives no warning.
;
; Call with DX:AX = 32 bit dividend
;           CX    = divisor
;
; Returns   DX:AX = quotient
;           BX    = remainder
;	    CX    = divisor (unchanged)
;
divide  proc    near
        jcxz    div1
        push    ax
        mov     ax,dx
        xor     dx,dx
        div     cx
        mov     bx,ax
        pop     ax
        div     cx
        xchg    bx,dx
div1:   ret
divide  endp
char_gen        proc near
        push    es
        push    ds
        push    di
        push    si

        ;--- enable memory for write into plane 2

        mov     dx,03c4h                ; sequencer enable map 2 for write
        mov     al,2
        out     dx,al
        inc     dx
        mov     al,4
        out     dx,al

        dec     dx                      ; sequencer no chaining
        mov     al,4
        out     dx,al
        inc     dx
        mov     al,6
        out     dx,al

        mov     dx,03ceh                ; graphics use data from processor
        mov     al,1
        out     dx,al
        inc     dx
        mov     al,0
        out     dx,al

        dec     dx                      ; graphics read and write modes
        mov     al,5
        out     dx,al
        inc     dx
        mov     al,0
        out     dx,al

        dec     dx                      ; graphics address mapped to a000
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,05h
        out     dx,al

        dec     dx                      ; graphics enable 8 bits per write
        mov     al,8
        out     dx,al
        inc     dx
        mov     al,0ffh
        out     dx,al

        ;--- load the character generator into plane 2

        mov     ax,0a000h               ;point to segment a000
        mov     es,ax
        mov     ax,0e0H                 ;compute offset into char gen plane
        mov     cl,5                    ;as index * bytes_per_char
        shl     ax,cl                   ;which is index * 32
        mov     di,ax                   ;copy offset in char gen plane into di
	add 	di,4000H
        mov     si,font_ptr             ;fetch pointer to new characters
        mov     cx,3                    ;fetch number of characters to copy
fill_plane:
	push 	cx
        mov     cx,font_length
        cld
        rep     movsb                   ;copy the data
	mov	al,0
        mov     cx,32
        sub     cx,font_length
	rep	stosb
	pop 	cx
	loop 	fill_plane

        ;--- restore sequencer and graphics controller

        mov     dx,03c4h                ; enable plane 0 & 1 for write
        mov     al,2
        out     dx,al
        inc     dx
        mov     al,03h
        out     dx,al

        dec     dx                      ; sequencer even/odd & text
        mov     al,4
        out     dx,al
        inc     dx
        mov     al,3
        out     dx,al

        mov     dx,3ceh                 ; graphics read and write modes
        mov     al,5
        out     dx,al
        inc     dx
        mov     al,10h
        out     dx,al
        dec     dx

        xor     ax,ax
        mov     es,ax
        test    byte ptr es:[487H],2
        jnz     wcg_set_b000

        mov     dx,3ceh                 ;map display buffer to b800
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,0eh
        out     dx,al
        jmp     wcg_done
wcg_set_b000:
        mov     dx,3ceh                 ;map display buffer to b000
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,0ah
        out     dx,al

        ;--- clean up and exit
wcg_done:
        pop     si
        pop     di
        pop     ds
        pop     es
        ret
endp
;************************************************************************
; Using BIOS to determine display type, and save type in AX             *
; Exit: AX - Display type                                               *
;       0 => None                                                       *
;       3 => Enhanced Display (or Multi-scan)                           *
;       4 => Color Display                                              *
;       5 => Monochrome Display                                         *
;       7 => VGA Monochrome                                             *
;       8 => VGA Color (or Multi-scan)                                  *
;************************************************************************

get_display proc near
        mov     ax,1a00h                ;first look for vga by trying fn=1a
        int     10h
        cmp     al,1ah                  ;there is no vga if al not 1a
        jne     vga_not_in              ;...so go look for ega
        mov     al,bl                   ;return primary display info
        jmp     type_found

vga_not_in:
        mov     ah,12h                  ;select function 12hex
        mov     bl,10h                  ;       subfunction 10hex
        int     10h                     ;call bios to get display type
        mov     al,5                    ;assume that mono is attached
        or      bh,bh                   ;was display mono (bh = 1)?
        jnz     type_found              ;...yes, we are done
                                        ;...no, must look at switches
        mov     al,3                    ;assume enhanced display
        cmp     cl,9h                   ;is switch 'off on on off'?
        je      type_found              ;...yes, we are done
        cmp     cl,3                    ;is switch 'off off on on'?
        je      type_found              ;...yes, we are done
        mov     al,4                    ;...no, must be color display
type_found:
        xor     ah,ah                   ;clear ah
        ret
endp
;    enter
;        ax - cup offset in to scrreen ah-x,al-y
;        bx - cup size                 bh-x,bl-y
;        cl - max matrix size
;
init_cup proc near
         push ax
         push bx
         push cx

         mov  dx,ax
         xor  ah,ah
         mov  ch,160
         mul  ch

         mov  ch,dh
         shl  ch,1

         add  al,ch
         adc  ah,0
         sub  cl,2
         mov  ch,cl
         shl  ch,1
         sub  al,ch
         sbb  ah,0
         mov  cup_offset,ax  ;save cup offset into screen
         mov  ax,dx
         mov  dx,offset last_code
         mov  di,dx
         add  dl,ch
         add  dl,bh
         adc  dh,0
         mov  glass1,dx      ;save offset to work cup
         xor  ch,ch
         call init_one_line

         mov  dx,cx
         mov  cl,bl
         xor  ch,ch
init_l0:                ; init standart  glass space
         push cx
         mov  cx,dx
         call init_one_line
         pop  cx
         loop init_l0
         mov  cx,dx
init_l1:                ; init last lines
         push cx
         mov  cx,dx
         shl  cx,1
         add  cl,bh
         adc  ch,0
         cld
         mov  al,44h
     rep stosb
         pop  cx
         loop init_l1
         mov  row,di
         mov  ax,0
         mov  cx,dx
         push dx
         shl  cx,1
         add  cl,bh
         adc  ch,0
         mov  dx,cx
         pop  cx
         add  cl,bl
init_l2:
         stosw
         add  ax,dx
         loop init_l2

         pop  ax
         pop  bx
         pop  cx
         ret
init_cup endp

init_one_line proc near
              push cx
              cld
              mov  al,44h
          rep stosb
              mov  cl,bh
              push ax
              xor  al,al
          rep stosb
              pop  ax
              pop  cx
              push cx
          rep stosb
              pop  cx
              ret
init_one_line endp
decompress proc near
        push es
        mov ax,0501H
        int 10H
        mov ax,vseg
        mov es,ax
        mov di,1
        mov si,offset attrib
        mov cx,638
        call decomp
        mov di,0
        mov cx,794
        mov si,offset char
        call decomp
        mov ax,0500H
        int 10H
        pop es
        ret
endp
decomp proc near
        jcxz end_decomp
        lodsb
        cmp al,80H
        jne one_char
        lodsb           ;counter
        push cx
	xor ah,ah
        mov cx,ax
        lodsb           ;char
aa1:
         stosb
        inc di
        loop aa1
        pop cx
        sub cx,3
        jmp decomp
one_char:
        stosb
        inc di
        dec cx
        jmp decomp
end_decomp:
        ret
endp
attrib label word
       org 638+offset attrib
char label word
       org 794+offset char
last_code label byte
end start