/*************************************************************************/
/*                                 UTILS.C                              */
/*                      Library of misc. functions                      */
/*                                                                      */
/*    Includes: POS(), WRITE_CH(), GET_SEED(), FIND_CHR(), LETRGEN(),   */   
/*                     TONE(), WRITE_STR(), BELL(), BLATT()             */
/*                                                                      */
/*                                    by                                */
/*                                M_Cooper                              */
/*                             3138 Foster Ave.                         */
/*                         Baltimore, MD 21224-3434                     */
/************************************************************************/




#include <stdio.h>
#include <stdlib.h>

                
/**************************************************************************/
/*                                 POS.C                                  */  
/*                    Function to set cursor position                     */
/*                    Needs args x = row,  y = column                     */
/**************************************************************************/

void cur_pos(column,row)
int column,row;

{
short int  fn = 2;    /* function #2: set cursor position */
short int page0 = 0;
REGS reg;

reg.byte.ah = fn;    /*        */
reg.byte.al = 0;
reg.byte.bh = page0;
reg.byte.dh = row;  
reg.byte.dl = column;  

bios(0x10,&reg);    /* Call BIOS (INT 010) */

}

/**************************************************************************/
/*                              WRITE_CH.C                                */  
/*          Function to write character & attribute under cursor          */
/*    Needs args x = char., y = attribute, z = how many times to write    */
/*                                                                        */
/* Attributes: 0x07=normal, 0x01=underlined, 0x70=reverse, 0x0=invisible  */
/**************************************************************************/

void write_ch(chara,attr,times)
char chara;
int attr,times;

{
int  fn = 9;    /* function #9: write character and attribute under cursor */
int page0 = 0;
REGS reg;

reg.byte.ah = fn;    /*        */
reg.byte.bh = page0;
reg.byte.al = chara;
reg.byte.bl = attr;
reg.byte.ch = 0;
reg.byte.cl = times;

bios(0x10,&reg);    /* Call BIOS (INT 010) */
}

/*********************************************************************/
/*                            GET_SEED                               */  
/*     Returns 4-digit random seed from BIOS time (up to 5959)       */
/*********************************************************************/

int get_seed()

{
char  *time, *gettime(),time$[5];
int j;

time = gettime();

*(time$) = *(time + 3);
*(time$ + 1) = *(time + 4);
*(time$ + 2) = *(time + 6);
*(time$ + 3) = *(time + 7);
*(time$ + 4) = '\0';

     j = atoi(time$);

     return (j);

}

/*************************************************************************/
/*                             FIND_CHR                                  */
/*      Function that finds position of a character within a string      */
/*          Arguments: string -      chr - character to locate           */
/*  Returns (int) position of character in string, or -1 if not present  */
/*************************************************************************/

int find_chr(string,chr)
char string[],chr;
{
char *ptr, *index(), *offset;
ptr = index(string, chr);

if ((int)ptr == 0) return(-1);    /*Character not there*/


offset = ptr - string;
return((int)offset);
}


/*************************************************************************/
/*      Function to choose set of letters at random from alphabet        */     
/*                               LETRGEN.C                               */ 
/*      Takes arguments: num = no. of letters, letters[] = string        */
/*             Returns random string array of 'num' letters              */
/*************************************************************************/

char letrgen(num)
int num;

{
static char alphabet[] = "ansrtmlkprbcidsidzewuetfeyerefegtghhitrcitidi\
jataolamnanovnwosolnospaqierabrsadstgtitlueuvneoxymr";


char *letters;
int i;
double f;
double drand();

srand(get_seed());

for (i=0; i<=num; i++)
    {
     f = drand(96);
     *(letters+i) = *(alphabet +(int)f);
     if ( *(letters+i) == 'q' )
          if(i == num)
             *(letters+i-1)='u';
          else
             {*(letters+i+1) = 'u'; i++; }
      else; 
                                  }

*(letters+num+1) = '\0';

return (letters);
}
/***************************************************************************/

/**************************************************************************/
/*Sound subroutine               TONE                                     */
/*Calls sound(FREQ, DURATION)      library function                       */
/*Needs arguments FREQ and DURATION passed to it                          */
/*                                                                        */
/*FREQ = frequency in Hz [integer betw. 37 and 32767 (decimal)            */
/*DURATION = # of clock ticks (18.2 ticks/sec) [integer betw 37 and 32767 */
/**************************************************************************/

void tone(FREQ,DURATION)
int FREQ,DURATION;

{


sound(FREQ,DURATION);

return;
}

/***************************************************************************/
/*                                  TWO_TONE                               */
/*Produces 'two-tone' sound                                No arguments    */
/***************************************************************************/

void two_tone()

{
int fr,dur;

tone(700,3);

tone(450,2);

}

/**************************************************************************/
/*                                     BELL                               */
/*Produces a succession of 'beep' tones                                   */
/*Takes 'times' as argument [# of times to beep]                          */
/**************************************************************************/

void bell(times)
int times;

{
int i;

for (i = 1; i <= times; i++)
tone(380,3);

return;
}

/**************************************************************************/
/*                                   BLATT                                */
/*                         Produces a "Bronx Cheer"                       */
/*                         [use with error routine]                       */
/**************************************************************************/

void blatt()

{ tone(42,6); 
  tone(34,4);
  return;    }


/**************************************************************************/
/*                             WRITE_STR()                                */
/*   Writes argument string w/attribute (advancing cursor as it writes)   */
/*                   Equiv. of INT 0x10, function 0x19 on AT              */
/* Arguments:       text = pointer to text string                         */
/*                  attribute                                             */
/*                  x = column                                            */
/*                  y = row                                               */
/**************************************************************************/

/**/

void write_str(text,attribute,x,y)
char *text;
int attribute,x,y;

{
int i;     /* counter in loop */
int z = 1 ;  /* times to write the character */
int z1;


z1 = strlen(text);

for(i = 0; i < z1; i++) {
poscurs(y, x+i);
write_ch(*(text+i), attribute, 1); }
}

