/*************************************
 *  ATOMIA - a very simple adventure *
 *  Translated from Atom Basic just  *
 *    for the heck (hack?) of it     *
 *				     *
 *  (c) Magnus Olsson 1984, 1992     *
 *      All rights reserved	     *
 *************************************/

#ifdef __TURBOC__
#include <conio.h>
#endif

#ifdef THINK_C
#include <console.h>
#include <WindowMgr.h>
#endif

#include <stdio.h>
#include <stdarg.h>
#include "atomia.h"

CHAR db [0x9800 - 0x8200];
static char dir [] = { 'U','D','N','S','E','W' };

#ifdef __TURBOC__
static struct text_info ti;
#endif


void expand (unsigned p, int m)

{
   int a;

   while ((a = DB (p++)) != '\r')
      if (a >= '[') {
	 unsigned q = 0x9100;

	 do {
	    while (DB (q++) != '\r')
	       ;
	 } while (DB (q) != '\r' && DB (q) != a);
	 expand (q + 1,m + 1);
      }
      else if (a)
	 outchar (a);

   if (m == 0)
      outchar ('\n');
}


void fexpand (FILE *f,unsigned p, int m)

{
   int a;

   while ((a = DB (p++)) != '\r')
      if (a >= '[') {
	 unsigned q = 0x9100;

	 do {
	    while (DB (q++) != '\r')
	       ;
	 } while (DB (q) != '\r' && DB (q) != a);
	 fexpand (f,q + 1,m + 1);
      }
      else if (a)
	 foutc (a,f);

   if (m == 0)
      foutc ('\n',f);
}


void expand_abbrev (int c,unsigned buf)

{
   DB (buf) = c;
   DB (buf + 1) = '\r';
   expand (buf,0);
}



void describe (int object, unsigned a)


{
/*  2890oP."A" */

   if (object)
      outs ("A");

/*  2900s?B=A;B?1=13;A=B;LI.C;R. */

   expand_abbrev (a,0x97f0);
}



unsigned describe_room (unsigned p, CHAR *f, unsigned h)

{
   unsigned q,d,e;

/*  2000pQ=!(#9080+2*P) */

   q = DB (0x9080 + 2 * p) + 256 * DB (0x9081 + 2 * p);

/*  2001 IFF?H=99ORP<12ORP=16OR(P>18A.P<24)G.2010 */
/*  2005 P.'"IT'S TOO DARK TO SEE ANYTHING"';G.m */

   if (f [h] == 99 || p < 12 || p == 16 || p > 18 && p < 24) {

/*  2010 A=Q+7;P.'"YOU ARE ";LI.C */
/*  2020 D=1;F.E=0TOH;IFE?F<>P;G.2040 */
/*  2030 IFD;P.'"YOU CAN SEE:"';D=0 */
/*  2035 A=#B0+E;GOS.o */
/*  2040 N. */

      outs ("\nYOU ARE ");
      expand (q + 7,0);
      outs ("\n");
      d = 1;
      for (e = 0; e <= h; ++e)
	 if (f [e] == p) {
	    if (d) {
	       outs ("\nYOU CAN SEE:\n");
	       d = 0;
	    }
	    describe (TRUE,0xb0 + e);
	 }
   }
   else
      outs ("\nIT\'S TOO DARK TO SEE ANYTHING\n");

/*  2190 R. */
   return (q);
}


int compareJ (char *b, char *s)
/* Does the same as "LINK J" */

{
   char *b1, *s1;

   while (1) {
      b1 = b++;
      s1 = s;

      if (*b1 == '\0')
	 return (FALSE);

      while (*s1++ == *b1++)
	 if (*s1 == '\0')
	    return (TRUE);
   }
}


void read_data ()

{
   FILE *f;

   if (! (f = fopen ("atomia.dat",READ_BINARY_MODE))) {
      fprintf (stderr,"Couldn\'t open data file\n");
      exit (1);
   }
   if (fread (&db,sizeof (CHAR),sizeof (db),f) != sizeof (db)) {
      fprintf (stderr,"Error reading data file\n");
      exit (2);
   }
   fclose (f);
}


void divide (char *b,char *s)
/* b = first word of original b; s = rest of b */

{
   while (*b != ' ')
      if (*b++ == '\0') {
	 *s = '\0';
	 return;
      }
   *b++ = '\0';
   while (*s++ = *b++)
      ;
}


int dump (void)

{
   FILE *f;
   unsigned c,i,j,p,q;

   if (! (f = fopen ("atomia.dmp",WRITE_TEXT_MODE))) {
      fprintf (stderr,"COULDN\'T OPEN FILE ATOMIA.DMP\n");
      return (99);
   }

   puts ("DUMPING DATA BASE TO\nFILE ATOMIA.DMP\n");
   for (i = 0x8200; i < 0x9800; i += 16) {
      fprintf (f,"%X : ",i);
      for (j = 0; j <= 15; ++j)
	 fprintf (f,"%02X ",DB (i + j));
      fprintf (f," |  ");
      for (j = 0; j <= 15; ++j)
	 putc ((c = DB (i + j)) >= ' ' && c < 127 ? c : '.',f);
      putc ('\n',f);
   }
   fclose (f);

   if (! (f = fopen ("atomia.db",WRITE_TEXT_MODE))) {
      fprintf (stderr,"COULDN\'T OPEN FILE ATOMIA.DB\n");
      return (99);
   }

   puts ("WRITING ROOM DESCRIPTIONS TO\nFILE ATOMIA.DB\n");

   q = 0;
   for (p = 1; q < 0x8f80; ++p) {
      q = DB (0x9080 + 2 * p) + 256 * DB (0x9081 + 2 * p);

      fprintf (f,"Room #%2d at %x:\n",p,q);
      fputs ("Exits: ",f);
      for (i = 1; i <= 6; ++i)
         if (DB (q + i))
            fprintf (f,"%c:%3d  ",dir [i - 1],DB (q + i));
      fprintf (f,"\nDescription:\nYOU ARE ");
      fexpand (f,q + 7,0);
      fprintf (f,"\n\n");
   }
   fclose (f);
   return (0);
}


void init (void)

{
#ifdef THINK_C
   FILE *con;
   WindowPtr wp;
   short wide = 230, high = 270;
   
   console_options.txFont = 0;
   console_options.txSize = 12;
   console_options.ncols = 32;
   console_options.nrows = 16;
   console_options.pause_atexit = TRUE;
   console_options.title="\015ATOMIA AKORNY";
   con = fopenc ();
   csetmode (C_ECHO,con);
   (void) freopenc (con,(FILE *) stdin);
   (void) freopenc (con,(FILE *) stdout);
   cshow (con);
   wp = FrontWindow ();
   SizeWindow (wp,wide,high,TRUE); 
#endif

#ifdef __TURBOC__
   gettextinfo (&ti);
   textmode (BW40);
#endif
}


int emulate (void)

{
   char cmd [80];
   int exit_code = 0;

   outs ("ACORN ATOM\n\n");
   while (TRUE) {
      outchar ('>');
      ins (cmd);
      if (EQS (cmd,"RUN")) {
	 exit_code = play ();
	 if (exit_code)
	    goto quit;
      }
      else if (EQS (cmd,"DUMP")) {
	 exit_code = dump ();
	 if (exit_code)
	    goto quit;
      }
      else if (EQS (cmd,"BYE"))
	 goto quit;
      else
	 outs ("\007\nERROR 94\n");
   }
quit:
#ifdef __TURBOC__
   textmode (ti.currmode);
#endif
   return (exit_code);
}



void main (int argc, char **argv)

{
   read_data ();
   init ();

   exit (emulate ());
}


