#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

void BGIfont_Load()
{
	 int errorcode1, errorcode3;

	 errorcode1 = registerbgifont(triplex_font);
	 errorcode3 = registerbgidriver(EGAVGA_driver);

	 if (errorcode1 < 0 || errorcode3 < 0)
	 {
			printf("Graphics error: %s\n", grapherrormsg(errorcode3));
			printf("Press any key to halt:");
			exit(1);
	 }
}

void Init_Graph(void)
{
	 int gd = VGA, gm = VGAHI;
	 struct palettetype pal;
	 int color, xmax, ht, y = 0, j;

	 BGIfont_Load();
	 initgraph(&gd, &gm, "");

	 ht = getmaxy()/32;
	 xmax = getmaxx();

	 getpalette(&pal);

   for (color = 0; color < pal.size; color++)
				 setrgbpalette(pal.colors[color], color*4, color*1, color*4);

	 for (color = 0; color < pal.size; color++)
	 {
				 setfillstyle(SOLID_FILL, color);
				 bar(0, y, xmax, y+ht);
				 y += ht;
	 }
	 for (color--; color > 0; color--)
	 {
				 setfillstyle(SOLID_FILL, color);
				 bar(0, y, xmax, y+ht);
				 y += ht;
	 }
}

void text(int i)
{
	 settextstyle(TRIPLEX_FONT, HORIZ_DIR, 4);
	 setcolor(i);
	 outtextxy(175, 205, "BLUE MABLE V 1.0");
	 settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	 setcolor(i+1);
	 outtextxy(244, 255, "* SEO RO COMPUTER *");
}

void Draw_Board()
{
	 int i = 7, flag = 0;
	 do {
			text(i);
			if (i >= 13) flag = 1;
			if (i <= 7 ) flag = 0;
			if (flag == 1) i--;
			else i++;
			delay(80);
	 } while (!bioskey(1));
	 text(0);
}

void end(int x, int y, int z)
{
	 struct palettetype pal;
	 int color;

	 getpalette(&pal);

	 for (color = 0; color < pal.size; color++)
				 setrgbpalette(pal.colors[color], color*x, color*y, color*z);

	 setallpalette(&pal);
	 delay(500);
}

void main(void)
{
	 Init_Graph();
	 Draw_Board();
	 getch();
	 do {
		 end(4, 1, 1);
		 end(1, 4, 1);
		 end(1, 1, 4);
		 end(4, 1, 4);
	 } while (!bioskey(1));
	 closegraph();
}