{***************************************************************************}
{* RAND2.PAS                                                               *}
{* Externer Zufallsgenerator fr PC-Backgammon Pro                         *}
{* Programmiersprache: Turbo-Pascal, Autor: Michael Schellong              *}
{*                                                                         *}
{* Dieses Beispiel-Programm soll Ihnen demonstrieren, wie Sie in Pascal    *}
{* eigene Zufallsgeneratoren fr PC-Backgammon Pro V2.0 schreiben knnen.  *}
{* Der externe Zufallsgenerator wird von PC-Backgammon Pro zur Ermittlung  *}
{* der Wrfelaugen aufgerufen. Als Parameter wird dem Generator ein Zeiger *}
{* auf einen 32 Byte langen Speicherbereich bergeben, den er fr seine ei-*}
{* genen Zwecke frei verwenden kann. Beispielsweise knnen hier Variablen- *}
{* Inhalte gespeichert werden, die beim nchsten Aufruf wieder bentigt    *}
{* werden. Beim ersten Aufruf des Generators haben smtliche Bytes des     *}
{* Speicherbereichs einen Wert von 0xFF.                                   *}
{* Als Programmbeendigungs-Code muss die ermittelte Zufallszahl (im Bereich*}
{* von 1 bis 6) zurckgeliefert werden.                                    *}
{***************************************************************************}

Program Rand2;
Uses Dos;

Type
	LongPtr=^LongInt;

Var
	W: LongInt;
	CubeVal:Integer;
	PoolPtr: Pointer;


{******************************************}
{* Initialisierung des Zufallsgenerators  *}
{******************************************}
Procedure InitMyRand;
Var
	Year, Month, Day, Dummy: Word;
	Hour, Minute, Second: Word;
Begin
	{ Aktuelles Datum und Uhrzeit ermitteln }
	GetDate(Year, Month, Day, Dummy);
	GetTime(Hour, Minute, Second, Dummy);

	{ Ungefhr die Sekunden seit dem 1.1.1980 berechnen
	  und Zufallsgenerator damit initialisieren }

	W:=(Year-1980)*31557600+
	   (Month-1)*2592000+
	   (Day-1)*86400;

	W:=W+Hour*3600+Minute*60+Second;
	W:=W mod 716397;
End;

{****************************************************}
{* Ermittelt eine Zufallszahl im Bereich 0..Range-1 *}
{****************************************************}
Function MyRand(Range: Integer): Integer;
Begin
	W:=(W*431+1237) mod 716397;
	MyRand:=Trunc(Range*(W/716397));
End;

{****************************************************}
{* Ermittelt den als Aufrufparameter bergebenen    *}
{* Zeiger.                                          *}
{* Fr die etwas kompliziertere Vorgehensweise kann *}
{* ich leider nichts. Die Ursache liegt in dem spr-*}
{* lichen Angebot von Pascal an Stringkonvertie-    *}
{* rungs-Funktionen.                                *}
{****************************************************}
Function GetParamPtr:Pointer;
Var
	S:String;

{****************************************************}
{* Diese lokale Funktion wandelt eine ASCII-Hex-Zif-*}
{* fer in ihren binren Wert um.                    *}
{****************************************************}
Function _HexDigitAsc2Bin(C:Char):Byte;
Begin
	C:=UpCase(C);
	If (C>='A') And (C<='F') Then
		_HexDigitAsc2Bin:=Ord(C)-Ord('A')+$0A
	Else
		if (C>='0') And (C<='9') Then
			_HexDigitAsc2Bin:=Ord(C)-Ord('0')
		else _HexDigitAsc2Bin:=0;
End;

{****************************************************}
{* Diese lokale Funktion wandelt ein 4 Zeichen      *}
{* langes ASCII-Hex-Wort in seinen binren Wert um. *}
{****************************************************}
Function _HexWordAsc2Bin(S: String):Word;
Var
	W:Word;
	I:Integer;

Begin
	W:=0;
	For I:=1 To 4 Do
		W:=W*$10+_HexDigitAsc2Bin(S[I]);
	_HexWordAsc2Bin:=W;
End;

Begin
	{1. Aufrufparameter holen (Format XXXX:YYYY)}
	S:=ParamStr(1);

	{Segment und Offset konvertieren und in
	 Pointer umwandeln}
	GetParamPtr:=Ptr(_HexWordAsc2Bin(S),
					 _HexWordAsc2Bin(Copy(S,6,4)));
End;


Begin

	If ParamCount<1 Then
		halt(0);

	{Pointer auf Pool ermitteln}
	PoolPtr:=GetParamPtr;


	if LongPtr(PoolPtr)^=-1 Then
	{Beim 1. Aufruf Zufallsgenerator initialisieren}
		InitMyRand
	Else
	{Zwischengespeicherte Variable W holen}
		W:=LongPtr(PoolPtr)^;

	{Wrfelwert ermitteln}
	CubeVal:=MyRand(6)+1;

	{Variable W fr den nchsten Aufruf im Pool speichern}
	LongPtr(PoolPtr)^:=W;

	Halt(CubeVal);
End.
