PROGRAM Spiel;

USES    Crt, Dos;

TYPE    Bildschirm             = ARRAY[1..25,1..80,0..1] OF CHAR;

VAR     screen                 : ^Bildschirm;
        regs                   : Registers;
        hgc                    : Bildschirm ABSOLUTE $B000:0;
        cga                    : Bildschirm ABSOLUTE $B800:0;
        links, breite, schiff,
        schiffzahl, sx, sy     : BYTE;
        lauf, punkte, taste,
        extra                  : INTEGER;
        sch                    : BOOLEAN;
        hc, ok                 : CHAR;

  FUNCTION Scan : INTEGER;
  VAR ch : CHAR;
  BEGIN
    ch:=ReadKey;
    IF (ch=#0) AND KEYPRESSED THEN
    BEGIN
      ch:=ReadKey;
      scan:=6912+ORD(ch)
    END
    ELSE scan:=ORD(ch)
  END;

  PROCEDURE Print(x, y : BYTE; text : STRING);
  VAR lauf : BYTE;
  BEGIN
    FOR lauf:=1 TO LENGTH(text) DO screen^[y,lauf+x-1,0]:=text[lauf]
  END;

  PROCEDURE Initial;
  BEGIN
    Intr($11,regs);
    IF (regs.ax AND $0030)=$0030 THEN
    BEGIN
     screen:=@hgc;
     hc:=#9
    END                          ELSE
    BEGIN
     screen:=@cga;
     hc:=#112
    END;
    RANDOMIZE;
    CLRSCR;
    Print(65,1,'Punkte :');
    Print(61,2,'');
    Print(66,4,'Hllenfahrt');
    Print(65,5,'~~~~~~~~~~~~~');
    Print(63,6,'2/1990  J.Siedekum');
    Print(63,9,'Erkmpfen Sie sich');
    Print(63,10,'Ihren Weg durch');
    Print(63,11,'das Hhlensystem !');
    Print(63,13,'Steuern :  <- ->');
    Print(63,14,'Feuern  : <SPACE>');
    screen^[16,63,1]:=#120;
    Print(64,16,'-Treffer : 10 P.');
    screen^[17,63,1]:=hc;
    Print(64,17,'-Treffer : 20 P.');
    Print(63,18,'Fehlschu :-50 P.');
    Print(63,20,'Extraschiff :');
    Print(69,21,'alle 300 P.');
    Print(61,23,'');
    Print(67,24,'Schiffe')
   END;

  PROCEDURE Start;
  VAR lauf, laufy : BYTE;
  BEGIN
    links:=20;
    breite:=20;
    schiff:=30;
    punkte:=0;
    extra:=300;
    schiffzahl:=6;
    sch:=FALSE;
    FOR lauf:=1 TO schiffzahl-1 DO screen^[25,78-2*lauf,0]:=#239;
    screen^[25,schiff,0]:=#239;
    FOR laufy:=25 DOWNTO 1 DO
    BEGIN
      FOR lauf:=1 TO 20-laufy DIV 2 DO screen^[laufy,lauf,1]:=#120;
      FOR lauf:=21-laufy DIV 2 TO 40+laufy DIV 2 DO screen^[laufy,lauf,1]:=#15;
      FOR lauf:=41+laufy DIV 2 TO 60 DO screen^[laufy,lauf,1]:=#120
    END;
    GOTOXY(73,1); WRITE(punkte:5);
    ok:=ReadKey
  END;

  PROCEDURE Highscore(punkte : INTEGER);
  TYPE Satz       = RECORD
                     name : STRING[20];
                     pkt  : INTEGER
                    END;
       Liste      = ARRAY[1..10] OF Satz;
  VAR  datei      : FILE OF Liste;
       tab        : Liste;
       hilf, lauf : BYTE;

    PROCEDURE Tabelle_ausgeben;
    VAR lauf : BYTE;
    BEGIN
      FOR lauf:=1 TO 10 DO
      BEGIN
        GOTOXY(10-lauf DIV 10,10+lauf);
        WRITE(lauf,'. ',tab[lauf].name);
        GOTOXY(34,10+lauf);
        WRITE(tab[lauf].pkt:5,' Punkte')
      END
    END;

  BEGIN
    ASSIGN(datei,'HF.HSC');
    {$I-} RESET(datei); {$I+}
    IF IOResult = 0 THEN
    BEGIN
      READ(datei,tab);
      SEEK(datei,0)
    END
                    ELSE
    BEGIN
      REWRITE(datei);
      FOR lauf:=1 TO 10 DO
      BEGIN
        tab[lauf].name:='';
        tab[lauf].pkt :=0
      END
    END;
    IF punkte<tab[10].pkt THEN Tabelle_ausgeben
                          ELSE
    BEGIN
      lauf:=10;
      hilf:=1;
      REPEAT
        lauf:=lauf-1;
        IF tab[lauf].pkt>=punkte THEN hilf:=lauf+1
      UNTIL (hilf<>1) OR (lauf<=1);
      FOR lauf:=10 DOWNTO hilf+1 DO tab[lauf]:=tab[lauf-1];
      tab[hilf].name:='';
      tab[hilf].pkt:=punkte;
      Tabelle_ausgeben;
      GOTOXY(13,10+hilf);
      READLN(tab[hilf].name);
      WRITE(datei,tab)
    END;
    CLOSE(datei)
  END;

  PROCEDURE Treffer;
  VAR hilf : CHAR;
  BEGIN
    hilf:=screen^[sy,sx,1];
    screen^[sy,sx,0]:=#32;
    screen^[sy,sx,1]:=#15;
    sch:=FALSE;
    IF hilf=hc THEN
    BEGIN
      SOUND(500);
      DELAY(10);
      SOUND(1000);
      DELAY(20);
      SOUND(500);
      DELAY(10);
      punkte:=punkte+20
    END        ELSE { hilf=#120 }
    BEGIN
      SOUND(1000);
      DELAY(40);
      punkte:=punkte+10
    END;
    NOSOUND
  END;

  PROCEDURE Scrollen;
  VAR lauf, laufy : BYTE;
  BEGIN
    links:=links+RANDOM(1+(40-links) DIV 4)-RANDOM(1+links DIV 4);
    breite:=breite+RANDOM(1+breite*(40-breite) DIV 70)-breite DIV 5;
    FOR laufy:=25 DOWNTO 2 DO
      FOR lauf:=4 TO 57 DO screen^[laufy,lauf,1]:=screen^[laufy-1,lauf,1];
    FOR lauf:=4 TO links DO screen^[1,lauf,1]:=#120;
    IF RANDOM(TRUNC(punkte)+12000)>12000 THEN
      FOR lauf:=links+1 TO links+breite DO screen^[1,lauf,1]:=hc
                                         ELSE
      FOR lauf:=links+1 TO links+breite DO screen^[1,lauf,1]:=#15;
    FOR lauf:=links+breite+1 TO 57 DO screen^[1,lauf,1]:=#120;
    IF sch THEN
    BEGIN
      screen^[sy,sx,0]:=#32;
      sy:=sy-1;
      IF sy>0 THEN
      BEGIN
        screen^[sy,sx,0]:=#248;
        IF screen^[sy,sx,1]<>#15 THEN Treffer
      END     ELSE
      BEGIN
        SOUND(50);
        DELAY(40);
        punkte:=punkte-50;
        sch:=FALSE;
        NOSOUND
      END
    END
  END;

  PROCEDURE Schuss;
  BEGIN
    sch:=TRUE;
    sx:=schiff;
    screen^[24,sx,0]:=#248;
    sy:=24
  END;

  PROCEDURE Zusatzschiff;
  BEGIN
    screen^[25,78-2*schiffzahl,0]:=#239;
    schiffzahl:=schiffzahl+1;
    extra:=extra+300;
    SOUND(500);
    DELAY(10);
    SOUND(1000);
    DELAY(10);
    SOUND(2000);
    DELAY(20);
    SOUND(1000);
    DELAY(10);
    SOUND(500);
    DELAY(10);
    NOSOUND
  END;

  PROCEDURE Schiff_kaputt;
  VAR hilf, position : BYTE;
      lauf           : INTEGER;
  BEGIN
    screen^[25,schiff,0]:=#177;
    schiffzahl:=schiffzahl-1;
    screen^[25,78-2*schiffzahl,0]:=#32;
    FOR lauf:=100 DOWNTO 1 DO
    BEGIN
      SOUND(10*lauf);
      DELAY(10)
    END;
    hilf:=0;
    REPEAT
      hilf:=hilf+1
    UNTIL screen^[24,hilf,1]<>#120;
    position:=hilf;
    REPEAT
      hilf:=hilf+1
    UNTIL screen^[24,hilf,1]=#120;
    NOSOUND;
    screen^[25,schiff,0]:=#32;
    IF schiffzahl>0 THEN
    BEGIN
      schiff:=position+(hilf-position) DIV 2;
      screen^[25,schiff,0]:=#239
    END;
    REPEAT
      taste:=Scan
    UNTIL (taste<>32) AND ((taste<6984) OR (taste>6992))
  END;

BEGIN
  Initial;
  REPEAT
    Start;
    REPEAT
      punkte:=punkte+1;
      GOTOXY(73,1); WRITE(punkte:5);
      Scrollen;
      IF NOT sch THEN DELAY(6);
      IF punkte>extra THEN Zusatzschiff;
      IF screen^[25,schiff,1]<>#15 THEN Schiff_kaputt
                                   ELSE
        FOR lauf := 1 TO 2 DO
        BEGIN
          IF KEYPRESSED THEN
          BEGIN
            taste:=Scan;
            screen^[25,schiff,0]:=#32;
            CASE taste OF
               32 : IF NOT sch THEN Schuss;
             6987 : IF schiff>2 THEN schiff:=schiff-1;
             6989 : IF schiff<59 THEN schiff:=schiff+1;
            END;
            screen^[25,schiff,0]:=#239
          END;
          IF punkte<2000 THEN DELAY((2039-punkte)DIV 40)
        END
    UNTIL schiffzahl<=0;
    WINDOW(2,1,59,25);
    CLRSCR;
    GOTOXY(19,3); WRITE('G A M E   O V E R   !');
    GOTOXY(24,8); WRITE('Highscore :');
    Highscore(punkte);
    GOTOXY(20,23); WRITE('Noch einmal (J/N) ?');
    REPEAT
      ok:=ReadKey;
      ok:=UPCASE(ok)
    UNTIL ok IN ['J','N'];
    CLRSCR;
    WINDOW(1,1,80,25)
  UNTIL ok='N';
  CLRSCR
END.
