PROGRAM Life;

CONST   X = 50; XArray = 51;
        Y = 25; YArray = 26;
        N = 2;

TYPE    Zeichen      = ARRAY[0..XArray,0..YArray] OF BYTE;
        Zeichendatei = FILE OF Zeichen;
        Byte_menge   = SET OF BYTE;
        String12     = STRING[12];
        String64     = STRING[64];
        String80     = STRING[80];
        Bildschirm   = ARRAY[1..25,1..80,0..1] OF CHAR;

VAR     screen       : ^Bildschirm;
        bildspeicher : ARRAY[1..N] OF Bildschirm;
        mal          : BYTE;
        hgc          : Bildschirm ABSOLUTE $B000:0;
        cga          : Bildschirm ABSOLUTE $B800:0;
        karte        : INTEGER;
        posy         : ARRAY[1..25] OF INTEGER;
        posx         : ARRAY[1..80] OF INTEGER;
        text         : STRING[80];
        dateiname    : String12;
        path         : String64;
        zeidat       : Zeichendatei;
        cursor_anf,
        cursor_end,
        antwort      : BYTE;
        wunsch       : CHAR;
        lauf, lauf2  : INTEGER;

 PROCEDURE Print(x, y : BYTE; text : String80);
 VAR lpos : BYTE;
 BEGIN
  FOR lpos:=1 TO LENGTH(text) DO mem[karte:posy[y]+posx[lpos+x-1]]:=ORD(text[lpos])
 END;

 PROCEDURE SaveScreen;
 BEGIN
  IF mal<=N THEN
  BEGIN
   bildspeicher[mal]:=screen^;
   mal:=mal+1
  END
 END;

 PROCEDURE RestScreen;
 BEGIN
  IF mal>1 THEN
  BEGIN
   mal:=mal-1;
   screen^:=bildspeicher[mal]
  END
 END;

 PROCEDURE Get_Cursor;
 VAR regs : RECORD
             al,ah,bl,bh,cl,ch : BYTE;
            END;
 BEGIN
  WITH regs DO
  BEGIN
   ah:=3;
   bh:=0;
   Intr($10,regs);
   cursor_anf:=ch;
   cursor_end:=cl
  END
 END;

 PROCEDURE Cursor(anfangszeile, endzeile : BYTE);
 VAR regs : RECORD
             al,ah,bl,bh,cl,ch : BYTE;
            END;
 BEGIN
  WITH regs DO
  BEGIN
   ch:=anfangszeile;
   cl:=endzeile;
   ah:=1;
   Intr($10,regs)
  END
 END;

 PROCEDURE Rahmen(x, y, breite, hoehe : BYTE; ch : CHAR);
 VAR lauf, xh, yh : BYTE;

  PROCEDURE Eins;
  BEGIN
   mem[karte:posy[y]+posx[x]]:=218;
   FOR lauf:=1 TO breite-2 DO mem[karte:posy[y]+posx[x+lauf]]:=196;
   mem[karte:posy[y]+posx[x+breite-1]]:=191;
   FOR lauf:=1 TO hoehe-2 DO
   BEGIN
    mem[karte:posy[y+lauf]+posx[x]]:=179;
    mem[karte:posy[y+lauf]+posx[x+breite-1]]:=179
   END;
   mem[karte:posy[y+hoehe-1]+posx[x]]:=192;
   FOR lauf:=1 TO breite-2 DO mem[karte:posy[y+hoehe-1]+posx[x+lauf]]:=196;
   mem[karte:posy[y+hoehe-1]+posx[x+breite-1]]:=217
  END;

  PROCEDURE Zwei;
  BEGIN
   mem[karte:posy[y]+posx[x]]:=201;
   FOR lauf:=1 TO breite-2 DO mem[karte:posy[y]+posx[x+lauf]]:=205;
   mem[karte:posy[y]+posx[x+breite-1]]:=187;
   FOR lauf:=1 TO hoehe-2 DO
   BEGIN
    mem[karte:posy[y+lauf]+posx[x]]:=186;
    mem[karte:posy[y+lauf]+posx[x+breite-1]]:=186
   END;
   mem[karte:posy[y+hoehe-1]+posx[x]]:=200;
   FOR lauf:=1 TO breite-2 DO mem[karte:posy[y+hoehe-1]+posx[x+lauf]]:=205;
   mem[karte:posy[y+hoehe-1]+posx[x+breite-1]]:=188
  END;

 BEGIN { Hauptprozedur }
  xh:=WhereX;
  yh:=WhereY;
  WINDOW(x,y,x+breite-1,y+hoehe-1);
  CLRSCR;
  WINDOW(1,1,80,25);
  GOTOXY(xh,yh);
  CASE ch OF
    '','' : Eins;
    '','' : Zwei
   ELSE
    BEGIN
     FOR lauf:=0 TO breite-1 DO mem[karte:posy[y]+posx[x+lauf]]:=ORD(ch);
     FOR lauf:=1 TO hoehe-2 DO
     BEGIN
      mem[karte:posy[y+lauf]+posx[x]]:=ORD(ch);
      mem[karte:posy[y+lauf]+posx[x+breite-1]]:=ORD(ch)
     END;
     FOR lauf:=0 TO breite-1 DO mem[karte:posy[y+hoehe-1]+posx[x+lauf]]:=ORD(ch)
    END
  END
 END;

 FUNCTION Scan : INTEGER;
 VAR scanlow, scanhigh : CHAR;
 BEGIN
  READ(KBD,scanlow);
  IF (scanlow=#27) AND KEYPRESSED THEN
  BEGIN
   scanhigh:=scanlow;
   READ(KBD,scanlow);
   scan:=ORD(scanhigh)*256+ORD(scanlow)
  END
  ELSE scan:=ORD(scanlow)
 END;

 PROCEDURE BalkenMenu(x, y, anzahl, laenge, abstand : BYTE; VAR wahl : BYTE);
 VAR taste : INTEGER;

  PROCEDURE Normal;
  BEGIN
   FOR lauf:=1 TO laenge DO mem[karte:posx[x+lauf-1]+posy[y+abstand*(wahl-1)]+1]:=15
  END;

  PROCEDURE Invers;
  BEGIN
   FOR lauf:=1 TO laenge DO mem[karte:posx[x+lauf-1]+posy[y+abstand*(wahl-1)]+1]:=120
  END;

  PROCEDURE Oben;
  BEGIN
   Normal;
   IF wahl>1 THEN wahl:=wahl-1 ELSE wahl:=anzahl;
   Invers
  END;

  PROCEDURE Unten;
  BEGIN
   Normal;
   IF wahl<anzahl THEN wahl:=wahl+1 ELSE wahl:=1;
   Invers
  END;

 BEGIN { Hauptprozedur }
  Invers;
  REPEAT
   taste:=Scan;
   CASE taste OF
    6984 : Oben;
    6992 : Unten
   END
  UNTIL (taste IN [13, 27, 32]) OR ((taste>=6971) AND (taste<=6969+anzahl));
  Normal;
  IF taste=27 THEN wahl:=anzahl;
  IF (taste>=6971) AND (taste<=6969+anzahl) THEN wahl:=taste-6970
 END;

 PROCEDURE JaNein;
 BEGIN
  REPEAT
   READ(KBD,wunsch);
   wunsch:=UPCASE(wunsch)
  UNTIL wunsch IN ['J','N']
 END;

 PROCEDURE Initial;
 VAR regs : RECORD
             ax,bx,cx,dx,bp,si,di,ds,es,flags : INTEGER;
            END;
     test : BOOLEAN;
 BEGIN
  regs.ax:=$0F00;
  Intr($10,regs);
  test:=(regs.ax and 255)=7;
  IF test THEN
  BEGIN
   karte:=$B000;
   screen:=Addr(hgc)
  END     ELSE
  BEGIN
   karte:=$B800;
   screen:=Addr(cga)
  END;
  FOR lauf:=0 TO 24 DO posy[lauf+1]:=lauf*160;
  FOR lauf:=0 TO 79 DO posx[lauf+1]:=2*lauf;
  mal:=1;
  Get_Cursor;
  Cursor(16,16);
  dateiname:='DATEI.LIF';
  antwort:=1;
  CLRSCR;
  Rahmen(1,1,61,22,'');
  Print(6,3,'L I F E   Version 2.11   - 30.05.1990  J.Siedekum -');
  Print(5,4,'');
  Print(7,6,'Datei : DATEI.LIF');
  Print(22,9,'H-A-U-P-T-M-E-N-');
  Print(21,10,'~~~~~~~~~~~~~~~~~~~');
  Print(7,12,'Neue Datei bearbeiten........................<F1>');
  Print(7,14,'Lebewesen beobachten.........................<F2>');
  Print(7,16,'Datei lschen ...............................<F3>');
  Print(7,18,'Beenden.....................................<ESC>')
 END;

 PROCEDURE Menu(x, y, anzahl, breite : BYTE; VAR wahl : BYTE);
 CONST Laenge = 12;
 VAR   lauf   : BYTE;
       taste  : INTEGER;

  PROCEDURE Normal;
  BEGIN
   FOR lauf:=1 TO Laenge DO
    mem[karte:posx[x+lauf+(Laenge+3)*((wahl-1) MOD breite)-1]+posy[y+((wahl-1) DIV breite)]+1]:=15
  END;

  PROCEDURE Invers;
  BEGIN
   FOR lauf:=1 TO Laenge DO
    mem[karte:posx[x+lauf+(Laenge+3)*((wahl-1) MOD breite)-1]+posy[y+((wahl-1) DIV breite)]+1]:=120
  END;

  PROCEDURE Oben;
  BEGIN
   Normal;
   wahl:=wahl-breite;
   Invers
  END;

  PROCEDURE Links;
  BEGIN
   Normal;
   wahl:=wahl-1;
   Invers
  END;

  PROCEDURE Rechts;
  BEGIN
   Normal;
   wahl:=wahl+1;
   Invers
  END;

  PROCEDURE Unten;
  BEGIN
   Normal;
   wahl:=wahl+breite;
   Invers
  END;

  PROCEDURE Escape;
  BEGIN
   Normal;
   wahl:=0
  END;

 BEGIN
  wahl:=1;
  Invers;
  REPEAT
   taste:=Scan;
   CASE taste OF
      27 : Escape;
    6984 : IF wahl>breite THEN Oben;
    6987 : IF wahl>1 THEN Links;
    6989 : IF wahl<Anzahl THEN Rechts;
    6992 : IF wahl<=Anzahl-breite THEN Unten
   END
  UNTIL taste IN [13,27];
  Normal
 END;

 PROCEDURE Dir(name : String64; VAR datei : String12);
 CONST Breite             = 3;
 TYPE  Registerport       = RECORD
                             ax,bx,cx,dx,bp,di,si,ds,es,flags : INTEGER;
                            END;
       Parkplatz          = STRING[50];
       Dateienfeld        = ARRAY[1..100] OF String12;
 VAR   ok                 : CHAR;
       anzahl, lauf, wahl : BYTE;
       text               : String80;
       feld               : Dateienfeld;
       register           : Registerport;
       fcb_parkplatz      : Parkplatz;

  FUNCTION First(pfad : String64) : String12;
  VAR firstname : String12;
  BEGIN
   WITH register DO
   BEGIN
    fcb_parkplatz[0]:=CHR(44);
    pfad:=pfad+#0;
    ax:=$1A00;
    ds:=SEG(fcb_parkplatz[1]);
    dx:=OFS(fcb_parkplatz[1])+1;
    MSDOS(register);
    ax:=$4E00;
    cx:=$10;
    ds:=SEG(pfad);
    dx:=OFS(pfad)+1;
    MSDOS(register);
    IF lo(ax)=0 THEN
     BEGIN
      firstname:=COPY(fcb_parkplatz,32,12);
      IF POS(#46,firstname) IN [0,1] THEN
       First:=COPY(firstname,1,POS(#0,firstname)-1)
                                     ELSE
       First:=COPY(firstname,1,POS(#46,firstname)+3);
     END
    ELSE First:='...'
   END
  END;

  FUNCTION Next : String12;
  VAR nextname : String12;
  BEGIN
   WITH register DO
   BEGIN
    fcb_parkplatz[0]:=CHR(44);
    ax:=$4F00;
    MSDOS(register);
    IF lo(ax)=0 THEN
     BEGIN
      nextname:=COPY(fcb_parkplatz,32,12);
      IF POS(#46,nextname) IN [0,1] THEN
       Next:=COPY(nextname,1,POS(#0,nextname)-1)
                                    ELSE
       Next:=COPY(nextname,1,POS(#46,nextname)+3)
     END
    ELSE Next:='...'
   END
  END;

  PROCEDURE Sortieren(anzahl : BYTE; VAR feld : Dateienfeld);
  VAR i, j : BYTE;

   PROCEDURE Tausch(VAR erster_satz, zweiter_satz : String12);
   VAR hilf : String12;
   BEGIN
    hilf:=erster_satz;
    erster_satz:=zweiter_satz;
    zweiter_satz:=hilf
   END;

  BEGIN
   FOR i:=1 TO anzahl-1 DO
    FOR j:=anzahl DOWNTO i+1 DO
     IF feld[i]>feld[j] THEN Tausch(feld[i],feld[j])
  END;

 BEGIN
  anzahl:=0;
  datei:=First(name);
  IF datei<>'...' THEN
  REPEAT
   anzahl:=anzahl+1;
   feld[anzahl]:=datei;
   datei:=Next
  UNTIL (datei='...') OR (anzahl>=Breite*15);
  IF anzahl>1 THEN Sortieren(anzahl,feld);
  SaveScreen;
  Rahmen(3,5,15*Breite+1,((anzahl-1) DIV Breite)+3,'');
  Print(19,5,'Zurck : ESC');
  IF anzahl=0 THEN
  BEGIN
   Print(5,6,'kein Eintrag');
   READ(KBD,ok);
   datei:='...'
  END
              ELSE
  BEGIN
   FOR lauf:=1 TO anzahl DO
   BEGIN
    text:=feld[lauf];
    Print(5+((lauf-1) MOD Breite)*15,6+((lauf-1) DIV Breite),text)
   END;
   Menu(5,6,anzahl,Breite,wahl);
   IF wahl=0 THEN datei:='...' ELSE datei:=feld[wahl]
  END;
  RestScreen
 END;

 PROCEDURE Editor(x, y, laenge : BYTE; erlaubt : Byte_menge; path : String64; VAR str : String12);
 VAR taste : INTEGER;
     lauf  : BYTE;
     neu   : String12;
 BEGIN
  str:='';
  GOTOXY(x,y);
  FOR lauf:=1 TO 12 DO mem[karte:posy[WhereY]+posx[x+lauf-1]+1]:=120;
  Cursor(cursor_anf+1,cursor_end);
  REPEAT
   taste:=Scan;
   IF taste IN [97..122] THEN taste:=taste-32;
   CASE taste OF
         8 : IF WhereX>x THEN
             BEGIN
              DELETE(str,LENGTH(str),1);
              mem[karte:posy[Wherey]+posx[WhereX-1]]:=32;
              GOTOXY(WhereX-1,WhereY)
             END;
        27 : str:='';
    45..95 : IF (taste IN erlaubt) AND (LENGTH(str)<laenge) THEN
             BEGIN
              str:=str+CHR(taste);
              mem[karte:posy[WhereY]+posx[WhereX]]:=taste;
              GOTOXY(WhereX+1,WhereY)
             END;
      6971 : BEGIN
              FOR lauf:=1 TO 12 DO mem[karte:posy[WhereY]+posx[x+lauf-1]+1]:=15;
              Cursor(16,16);
              Dir(path,neu);
              IF neu<>'...' THEN
              BEGIN
               str:=neu;
               EXIT
              END;
              FOR lauf:=1 TO 12 DO mem[karte:posy[WhereY]+posx[x+lauf-1]+1]:=120;
              Cursor(cursor_anf+1,cursor_end)
             END
   END
  UNTIL taste IN [13,27];
  FOR lauf:=1 TO 12 DO mem[karte:posy[WhereY]+posx[x+lauf-1]+1]:=15;
  Cursor(16,16)
 END;

 PROCEDURE Dateiname_aendern;
 VAR neue_datei : String12;
     text       : String80;
 BEGIN
  SaveScreen;
  Rahmen(6,5,34,7,'');
  Print(11,5,'Neue Datei bearbeiten');
  Print(9,7,'Neue Datei :         .LIF');
  Print(9,8,'(ESC : Zurck zum Hauptmen)');
  Print(9,9,'( F1 : Inhaltsverzeichnis  )');
  neue_datei:='*.LIF';
  Editor(22,7,8,[45,48..57,65..90,95,97..122],'*.LIF',neue_datei);
  IF neue_datei='' THEN
  BEGIN
   RestScreen;
   EXIT
  END;
  IF POS('.',neue_datei)=0 THEN neue_datei:=neue_datei + '.LIF';
  dateiname:=neue_datei;
  RestScreen;
  text:=dateiname;
  FOR lauf:=LENGTH(text) TO 11 DO text:=text + ' ';
  Print(15,6,text)
 END;

 PROCEDURE Lebewesen(VAR pdatei : Zeichendatei);
 VAR laufh, laufv, taste, taktzaehler : INTEGER;
     auto                             : BOOLEAN;
     satz                             : Zeichen;

  PROCEDURE Setzen;
  BEGIN
   IF mem[karte:posy[WhereY]+posx[WhereX]]=250
    THEN mem[karte:posy[WhereY]+posx[WhereX]]:=254
    ELSE mem[karte:posy[WhereY]+posx[WhereX]]:=250
  END;

  PROCEDURE Null;
  BEGIN
   taktzaehler:=0;
   Print(68,20,'0    ')
  END;

  PROCEDURE Loeschen;
  BEGIN
   Null;
   FOR laufh:=1 TO X DO
    FOR laufv:=1 TO Y DO mem[karte:posy[laufv]+posx[laufh]]:=250
  END;

  PROCEDURE Automatik;
  BEGIN
   IF auto=FALSE THEN
   BEGIN
    auto:=TRUE;
    Print(72,23,'an ');
    Cursor(1,12)
   END           ELSE
   BEGIN
    auto:=FALSE;
    Print(72,23,'aus');
    Cursor(cursor_anf,cursor_end)
   END
  END;

  PROCEDURE LinksOben;
  BEGIN
   IF (WhereX>1) AND (WhereY>1) THEN GOTOXY(WhereX-1,WhereY-1)
  END;

  PROCEDURE Oben;
  BEGIN
   IF WhereY>1 THEN GOTOXY(WhereX,WhereY-1)
  END;

  PROCEDURE RechtsOben;
  BEGIN
   IF (WhereX<X) AND (WhereY>1) THEN GOTOXY(WhereX+1,WhereY-1)
  END;

  PROCEDURE Links;
  BEGIN
   IF WhereX>1 THEN GOTOXY(WhereX-1,WhereY)
  END;

  PROCEDURE Rechts;
  BEGIN
   IF WhereX<X THEN GOTOXY(WhereX+1,WhereY)
  END;

  PROCEDURE LinksUnten;
  BEGIN
   IF (WhereX>1) AND (WhereY<Y) THEN GOTOXY(WhereX-1,WhereY+1)
  END;

  PROCEDURE Unten;
  BEGIN
   IF WhereY<Y THEN GOTOXY(WhereX,WhereY+1)
  END;

  PROCEDURE RechtsUnten;
  BEGIN
   IF (WhereX<X) AND (WhereY<Y) THEN GOTOXY(WhereX+1,WhereY+1)
  END;

  PROCEDURE Speichern;
  BEGIN
   FOR laufh:=1 TO X DO
    FOR laufv:=1 TO Y DO
     IF mem[karte:posy[laufv]+posx[laufh]]=254 THEN satz[laufh,laufv]:=1
                                               ELSE satz[laufh,laufv]:=0
  END;

  PROCEDURE Takt;
  VAR hilfsfeld : ARRAY[1..X,1..Y] OF BYTE;
      zaehler   : BYTE;
      text      : String80;
  BEGIN
   Speichern;
   FOR laufh:=1 TO X DO
    FOR laufv:=1 TO Y DO
     BEGIN
      zaehler:=0;
      zaehler:=  satz[laufh-1,laufv-1]
                +satz[laufh-1,laufv  ]
                +satz[laufh-1,laufv+1]
                +satz[laufh  ,laufv-1]
                +satz[laufh  ,laufv+1]
                +satz[laufh+1,laufv-1]
                +satz[laufh+1,laufv  ]
                +satz[laufh+1,laufv+1];
      IF satz[laufh,laufv]=1 THEN
       IF (zaehler=2) OR (zaehler=3) THEN hilfsfeld[laufh,laufv]:=1
                                     ELSE hilfsfeld[laufh,laufv]:=0
                             ELSE
       IF zaehler=3 THEN hilfsfeld[laufh,laufv]:=1
                    ELSE hilfsfeld[laufh,laufv]:=0
     END;
   taktzaehler:=taktzaehler+1;
   STR(taktzaehler,text);
   Print(68,20,text);
   FOR laufh:=1 TO X DO
    FOR laufv:=1 TO Y DO
     IF hilfsfeld[laufh,laufv]=1 THEN mem[karte:posy[laufv]+posx[laufh]]:=254
                                 ELSE mem[karte:posy[laufv]+posx[laufh]]:=250
  END;

 BEGIN
  {$I-} RESET(pdatei); {$I+}
  IF IOResult<>0 THEN
   BEGIN
    REWRITE(pdatei);
    FOR lauf:=0 TO XArray DO
     FOR lauf2:=0 TO YArray DO
      satz[lauf,lauf2]:=0;
    WRITE(pdatei,satz)
   END ELSE READ(pdatei,satz);
  auto:=FALSE;
  taktzaehler:=0;
  SaveScreen;
  CLRSCR;
  Rahmen(54,1,25,17,'');
  Print(55,1,'Lebewesen beobachten');
  Print(56,3,' <ESC>  Letztes Men');
  Print(56,5,'<ENTER> Setzen');
  Print(56,7,'  F 1   Lschen');
  Print(56,9,'  F 2   Automatik');
  Print(56,11,'  F 3   Nchster Takt');
  Print(56,13,'  F 4   Leben');
  Print(56,15,'  F 5   Speichern');
  Rahmen(58,19,17,3,'');
  Print(61,20,'Takt : 0');
  Rahmen(54,22,25,3,'');
  Print(58,23,'Automatik ist aus');
  FOR laufh:=1 TO X DO
   FOR laufv:=1 TO Y DO
     IF satz[laufh,laufv]=1 THEN mem[karte:posy[laufv]+posx[laufh]]:=254
                            ELSE mem[karte:posy[laufv]+posx[laufh]]:=250;
  Cursor(cursor_anf,cursor_end);
  REPEAT
   taste:=Scan;
   CASE taste OF
      13 : Setzen;
      48 : Null;
    6971 : Loeschen;
    6972 : Automatik;
    6973 : Takt;
    6974 : BEGIN
            Cursor(16,16);
            REPEAT
             Takt
            UNTIL KEYPRESSED;
            IF auto THEN Cursor(1,12) ELSE Cursor(cursor_anf,cursor_end)
           END;
    6983 : LinksOben;
    6984 : Oben;
    6985 : RechtsOben;
    6987 : Links;
    6989 : Rechts;
    6991 : LinksUnten;
    6992 : Unten;
    6993 : RechtsUnten
   END;
   IF (auto=TRUE) AND (taste<=6993) AND (taste>=6983) THEN Setzen
  UNTIL (taste=27) OR (taste=6975);
  Cursor(16,16);
  Speichern;
  IF taste=6975 THEN
  BEGIN
   SEEK(pdatei,0);
   WRITE(pdatei,satz)
  END;
  CLOSE(pdatei);
  RestScreen
 END;

 PROCEDURE Datei_loeschen(VAR pdatei : Zeichendatei);
 BEGIN
  SaveScreen;
  Rahmen(6,7,51,5,'');
  Print(24,7,'Datei lschen');
  {$I-} RESET(pdatei); {$I+}
  IF IOResult<>0 THEN
   BEGIN
    Print(9,9,'Keine Datei vorhanden, keine Datei gelscht !');
    DELAY(2400)
   END
  ELSE
   BEGIN
    Print(8,9,'Soll die gesamte Datei gelscht werden (J/N) ?');
    GOTOXY(54,9);
    Cursor(cursor_anf,cursor_end);
    JaNein;
    Cursor(16,16);
    IF wunsch='J' THEN
    BEGIN
     Print(8,9,'            Datei wird gelscht !             ');
     CLOSE(pdatei);
     ERASE(pdatei);
     DELAY(1200)
    END
   END;
  RestScreen
 END;

BEGIN { Hauptprogramm }
 Initial;
 REPEAT
  Balkenmenu(7,12,4,49,2,antwort);
  ASSIGN(zeidat,dateiname);
  CASE antwort OF
   1 : Dateiname_aendern;
   2 : Lebewesen(zeidat);
   3 : Datei_loeschen(zeidat);
   4 : BEGIN
        SaveScreen;
        Rahmen(14,8,35,5,'');
        Print(27,8,'Beenden');
        Print(19,10,'Programm beenden (J/N) ?');
        GOTOXY(43,10);
        Cursor(cursor_anf,cursor_end);
        JaNein;
        Cursor(16,16);
        RestScreen
       END
  END
 UNTIL (antwort=4) AND (wunsch='J');
 CLRSCR;
 Cursor(cursor_anf,cursor_end)
END.
