#include <conio.h>
#include <dos.h>

#include "Timer.h"

#define SOUNDER 0x61
/* SOUNDER bit values */
#define MAKE_NOISE 0x02
#define USE_TIMER2 0x01

static void Sleep(unsigned Time) { /* Use BIOS's 18.2 Hz clock */
   union REGS R;
   R.h.ah = 0; int86(0x1a, &R, &R); Time += R.x.dx;
   do {
      R.h.ah = 0; int86(0x1a, &R, &R);
   } while (R.x.dx < Time);
}

void Sound(unsigned Pitch, unsigned Duration) {
   int Delay;
   if (Pitch <= 10) { Sleep(Duration); return; }
   Delay = (int)(FREQ/Pitch);
   outp(SOUNDER, inp(SOUNDER) | (MAKE_NOISE | USE_TIMER2));
   outp(T_CONTROL, CHANNEL2 | LSB_MSB | MODE3 | BINARY);
   outp(TIMER2, Delay&0xff); outp(TIMER2, Delay >> 8);
   Sleep(Duration);
   outp(SOUNDER, inp(SOUNDER) & ~(MAKE_NOISE | USE_TIMER2));
}
