;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Boot Tris installation program v1.0                                      ;;
;;  Started 15/2/1993 by MAK-TRAXON's Prophet                                ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Use: INSTBOOT d:              where d is A or B                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


progseg         segment public
                assume cs:progseg,ds:progseg;es:progseg;ss:progseg

; MASM-compatible header for EXE2BINable prog

                org 0
offs0           label byte
o0              equ offset offs0
                ; used for address calculations during assembly

by              equ byte ptr
wo              equ word ptr
jmps            equ jmp short
                ; some handy shortcuts

buffer          = (offset bootris-o0) + 512
                                ; address of read buffer

dosdatalen      equ 30h         ; length of data to copy from original
                                ; boot sector
dosdataoffs     equ 2h          ; offset where to copy it

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MAIN PROG ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                org 100h

entpt:          cld
                mov si,81h      ; start of cmd line
scancmd:        lodsb           ; get char
                cmp al,' '
                jz scancmd
                cmp al,9
                jz scancmd      ; skip blanks and tabs

                and al,0dfh     ; -> upper case
                mov bl,al
                lodsb           ; get next char
                cmp al,':'      ; is ':' ?
                jnz wrongarg    ; if not, args are not OK
                sub bl,'A'
                jc wrongarg     ; if drive < A, error
                cmp bl,1
                jna argOK       ; if drive > B, error
wrongarg:       mov ah,9
                mov dx,offset msgargerror
                int 21h         ; print a message
                mov ax,4c01h
                int 21h
argOK:          mov ax,bx
                cbw             ; clear ah
                push ax         ; save drive
                xor dx,dx
                mov cx,1
                mov bx,buffer
                int 25h         ; read boot sector of specified drive
                inc sp
                inc sp          ; int 25h leaves 2 bytes garbage on the stack
                jc diskerror
                mov si,buffer + dosdataoffs
                mov di,(offset bootris) + dosdataoffs
                mov cx,dosdatalen
                cld
                rep movsb       ; copy DOS data from boot sector new sector
                pop ax          ; drive number
                mov bx,offset bootris
                mov cx,1
                xor dx,dx
                int 26h         ; write new sector
                inc sp
                inc sp          ; int 26h leaves 2 bytes garbage on the stack
                jc diskerror
                mov ax,4c00h
                int 21h         ; everything OK, exit to DOS

diskerror:      mov ah,9
                mov dx,offset msgdiskerror
                int 21h         ; complain
                mov ax,4c01h
                int 21h         ; exit to DOS

msgargerror     db 'Boot Tris installer, by MAK-TRAXON''s Prophet'
                db 0dh,0ah,0dh,0ah
                db 'Use : INSTBOOT d:          where d is A or B'
                db 0dh,0ah,'$'

msgdiskerror    db 'Boot Tris installer, by MAK-TRAXON''s Prophet'
                db 0dh,0ah,0dh,0ah
                db 'Disk error !'
                db 0dh,0ah,'$'

bootris         label byte
                ; the binary file bootris.bin must be copied here with
                ; the command COPY /B INSTBOOT.COM + BOOTRIS.BIN
                ; after assembly

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  END  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

progseg         ends
                end entpt

