.MODEL  SMALL
.386
STACK 2048
LOCALS

;Mercury2 by Albert Ma 			(ama@athena.mit.edu)
;with contributions by Stefan Strack
;
;set /ddebugging=1 for debugging
;set /ddebugging=0 for no debugging

direct	=	0		;addressing modes
immediate =	1
indirect =	2
predec	=	3

modea	=	0
modeb	=	1
op	=	2		;structure of cells
debugi	=	3		;used when debugging = 1
;format of debugi (bits)
;7  copy?
;6
;5
;4
;3
;2  multiple break?
;1  break?
;0  trace?
a	=	4
b	=	6


addm	MACRO	dest,source,max,label	;add dest,source mod max
	add	dest,source		;dest is a register
	cmp	max,dest
	ja	label
	sub	dest,max
label:
	ENDM

addm2	MACRO	dest,source,max,label,label2 ;add dest,source mod max
	add	dest,source		;dest is a register
	jc	label2
	cmp	max,dest
	ja	label
label2:
	sub	dest,max
label:
	ENDM

decmr	MACRO	dest,label		;decrement dest mod cells
	dec	dest			;dest is a register
	jns	label
	mov	dest,[cells1]
label:
	ENDM

decmm	MACRO	dest,label,register	;decrement dest mod cells
	dec	word ptr dest		;dest is a memory location
	jns	label
	mov	register,[cells1]
	mov	word ptr dest,register
label:
	ENDM

print	MACRO	v1,v2		;print the string$
	mov	dx,v1 v2
	mov	ah,9
	int	21h
	ENDM

print2	MACRO	v1,v2		;print the string$ assume ah=9
	mov	dx,v1 v2
	int	21h
	ENDM

linefeed MACRO
	print	OFFSET line$	;go to the next line
	ENDM

linefeed2 MACRO
	print2	OFFSET line$	;go to the next line assume ah=9
	ENDM

maxlines =	1024		;arbitrary
maxcells =	8192		;don't increase
mincells =	2000		;arbitrary not too small
maxmaxprocs =	16383		;don't increase
maxrounds =	65535		;don't increase else change program
maxdist =	7000		;arbitrary not too big
minmindist =	100
varspc	=	1024		;arbitrary
maxfilesize =	16384		;arbitrary
lf	=	0Ah
cr	=	0Dh
tab	=	09h
ctrlz	=	1Ah
commandtail =	80h		;location of command line
blocklen =	3		;location of number of paragraphs
				;DOS allocated for us in MCB
proglen =	800h		;space allocated for program
				;data, and stack in paragraphs

requiredmem =	2000h+proglen	;number of paragraphs needed

;-----------------------------------------------------
.DATA
cells	dw	8000		;default size of core
	dw	0		;need zeros here to make cells dword
cells1	dw	7999		;coresize-1

if debugging
rounds 	dw	1
else
rounds	dw	100		;default number of rounds to play
endif

cycles	dd	80000		;default cycles until tie
maxprocs dw	8000		;default maximum number of processes
maxlen	dw	100		;default maximum length of program
mindist dw	100		;default minimum distance between programs
disp	db	1		;will we display list?
dump	db	0		;will we core dump?

end1	dw	0		;start of execution
end2	dw	0
file1	dw	0		;location of filenames on command line
file2	dw	0
by$	db	' by $'
author1 db	'Anonymous',lf,53 dup (0),lf
author2 db	'Anonymous',lf,53 dup (0),lf
len$	db	'length $'

filenum db	0		;which file are we working on?

nolab$	db	'EQU define needs a label$'
toolong$ db	'Program too long$'
syntaxerr$ db	'Syntax error$'
parenerr1$ db	'Parentheses left open$'
parenerr2$ db	'Too many closing parentheses$'
comerr$	db	'Expecting command in second field$'
modeerr$ db	'Addressing mode not supported for command$'
argerr2$ db	'Command requires two operands$'
argerr1$ db	'Directive requires exactly one operand$'
argerr$ db	'Expecting operand$'
overflow$ db	'Integer overflow error$'
divide0$ db	'Division by zero error$'
notfound$ db	'Label or equate undefined$'
recur$	db	'Recursive reference$'
twolab$ db	'Constant redefined$'

errmsg$ db	' in line $'
errmsg2$ db	' evaluating constant $'
offile$ db	' of file $'

.DATA?
name1	db	64 dup (?)
name2	db	64 dup (?)
program1 db	maxlines*8 dup (?)
program2 db	maxlines*8 dup (?)
len1	dw	?		;length of program
len2	dw	?

coreptr dw	?		;put segment pointer to core
pstack	dw	?		;put segment pointer to stack

tempcell dq	?		;used for everything

;----------------------------------------------------------
;MAIN
;check processor type and parse command line
;----------------------------------------------------------
.DATA
inst$	db	'Corewars interpreter ',??date,' ',??time
if debugging
	db	' (debugging version)'
endif
        db      lf,cr,'MERCURY2 [options] path1 [path2]',cr,lf,lf
	db	'Options:',cr,lf
if debugging
	db	'-R #   rounds to play [1]           -L #   max. length of program [100]',cr,lf
else
	db	'-R #   rounds to play [100]         -L #   max. length of program [100]',cr,lf
endif
	db	'-S #   size of core [8000]          -D #   min. distance between programs [100]',cr,lf
	db	'-C #   cycles until tie [80000]     -B     brief mode (no source listing)',cr,lf
	db	'-P #   max. processes [8000]        -U     output core dump after results',cr,lf,lf
	db	'Keys:',cr,lf
	db	'[space]   display current status    [esc]  exit program',cr,lf
if debugging
	db	's         step trough trace         t      step and force trace',cr,lf
        db      '[Enter]   back to normal            d      disable/enable debugging',cr,lf,lf
	db	'Debugging commands:',cr,lf
	db	';debug			turn on debugging [default]',cr,lf
	db	';debug static		same but MOV doesn''t copy debug status',cr,lf
	db	';debug off		turn off debugging',cr,lf
	db	';trace			turn on trace',cr,lf
	db	';trace off		turn off trace [default]',cr,lf
	db	';break			stop execution here and display trace',cr,lf
	db	';break once		break then clear debug status'
endif

line$	db	cr,lf,'$'
err386$ db	'MERCURY2 requires at least a 386 processor.$'
memerr$ db	'MERCURY2 requires 160K of free memory.$'

.CODE
main	PROC
	mov	ax,dgroup	;initialize dataseg
	mov	ds,ax
	cld			;direction forward
check32:
	pushf
	pop	ax
	and	ah,01111111b	;clear high bit
	or	ah,01000000b	;set bit 14
	push	ax
	popf
	pushf
	pop	ax
	and	ah,11000000b	;isolate bits 14 and 15
	cmp	ah,01000000b	;386 and above set like this
	je	checkmemory
	mov	dx,offset err386$ ;too bad
	jmp	show
checkmemory:
	mov	ax,es
	dec	ax
	mov	fs,ax		;get fs to point to mcb
	mov	ax,fs:[blocklen] ;see how much memory we have
	cmp	ax,requiredmem
	jae	nomemerr
	mov	dx, offset memerr$ ;too bad
	jmp	show

nomemerr:
	mov	ax,fs		;allocate our far segments
	add	ax,proglen
	mov	[coreptr],ax
	add	ax,1000h	;64K for core
	mov	[pstack],ax
	mov	si,commandtail
	mov	di,offset params
	mov	cx,32		;32*4=128=maxlen of command line
@@move: 			;copy command line into params
	lods	dword ptr es:[si] ;copy 4 bytes at a time
	mov	[di],eax
	add	di,4
	loop	@@move
	mov	si,offset params+1 ;set stream to point to params
parse:
	lodsb			;get a character
parse2:
	cmp	al,tab		;ignore tabs
	je	parse
	cmp	al,'/'
	je	@@options
	cmp	al,'-'
	je	@@options
	cmp	al,cr		;command lines are supposed to end in cr
	je	@@done
	cmp	al,' '
	je	parse		;ignore spaces
	jb	help		;error on control chars
	mov	[file2],si	;must then be a filename.  store it
	inc	[filenum]
	cmp	[filenum],2	;are we on the right file?
	je	@@skip
	ja	help		;too many filenames
	mov	[file1],si	;oops try that again
@@skip:
	lodsb
	cmp	al,' '
	ja	@@skip		;search for first whitespace or control
	mov	byte ptr [si-1],0 ;DOS wants 0 at end of filename
	jmp	parse2		;we saved that space or control char so parse it
@@done:
	mov	al,[filenum]	;get number of files found
	dec	al
	js	help		;no files in command line
	dec	[file1]		;fix these
	dec	[file2]
	or	al,al		;check if there is a second file
	jnz	initfiles
	mov	[file2],0	;no second file
	jmp	initfiles

@@options:
	lodsb
	and	al, 11011111b	;convert to uppercase
	cmp	al,'R'		;rounds
	jne	@@notrounds
	call	getnum		;translate ASCII to dword
	jc	help
	mov	[rounds],ax
	test	eax,0FFFF0000h	;make sure high word zero
	jnz	help
	or	ax,ax		;make sure low word not zero
	jz	help
	jmp	parse
@@notrounds:
	cmp	al,'S'		;core size
	jne	@@notsize
	call	getnum
	jc	help
	mov	[cells],ax
	cmp	eax,maxcells	;check range
	ja	help
	cmp	eax,mincells
	jb	help
	dec	ax
	mov	[cells1],ax	;put size-1 into memory
	jmp	parse
@@notsize:
	cmp	al,'C'		;cycles
	jne	@@notcycles
	call	getnum
	jc	help
	mov	[cycles],eax
	or	eax,eax 	;can't be zero
	jz	help
	jmp	parse
@@notcycles:
	cmp	al,'L'
	jne	@@notlength
	call	getnum
	jc	help
	mov	[maxlen],ax
	cmp	eax,maxlines
	ja	help
	or	ax,ax
	jz	help		;can't be zero
	jmp	parse
@@notprocs:
	cmp	al,'D'
	jne	@@notdist
	call	getnum
	jc	help
	mov	[mindist],ax
	cmp	eax,maxdist
	ja	help
	cmp	ax,minmindist
	jb	help
	jmp	parse
@@notdist:
	cmp	al,'B'
	jne	@@notbrief
	mov	byte ptr [disp],0
	jmp	parse
@@notbrief:
	cmp	al,'U'
	jne	help
	mov	byte ptr [dump],1
	jmp	parse
@@notlength:
	cmp	al,'P'
	jne	@@notprocs
	call	getnum
	jc	help
	mov	[maxprocs],ax
	cmp	eax,maxmaxprocs
	ja	help
	or	ax,ax
	jnz	parse		;can't be zero
help:				;help instructions
	mov	dx,offset inst$
;----------------------------------
;SHOW
;display message and quit
;Entry: dx - pointer to string
;Exit: fall through to exit
;----------------------------------
show:
	mov	ah,9		;display message and error code
	int	21h
;----------------------------------
;Exit: yes exit
;----------------------------------
exit:
	mov	ax, 4C01h	;exit with error
	int	21h
leave:				;exit with no error
	mov	ax,4C00h
	int	21h
	ENDP
;----------------------------------------------
;INITFILES	read in files and call compiler
;----------------------------------------------
.DATA
io$	db	'File I/O error',cr,lf,'$'
long$	db	'File too long',cr,lf,'$'
broken$ db	'Error processing file '
which$	db	'1',cr,lf,'$'
found$	db	'Errors found :$'

.CODE
initfiles PROC
	mov	ax,dgroup
	mov	es,ax			;initialize es
	mov	[filenum],1
	mov	dx,[file1]
	mov	[place],offset program1
	jmp	@@skip
@@open2:
	mov	dx,[file2]
	mov	[place],offset program2
	mov	[file1],dx		;for easy access
	or	dx,dx			;if zero then no second file, quit
	jz	leave
@@skip:
	mov	si,dx
@@skip2:
	mov	di,offset name1
	cmp	[filenum],1
	je	@@gname
	mov	di,offset name2
@@gname:
	lodsb
	stosb
	cmp	al,'\'
	je	@@skip2 		;if the stuff was path then remove
	cmp	al,'.'
	je	@@endname
	or	al,al
	jnz	@@gname
@@endname:
	mov	byte ptr [di-1],lf	;lf terminated string

	mov	ax,3D00h		;DOS open-file read-only
	int	21h
	jnc	@@opened
	call	docrash
	jmp	help
@@opened:
	mov	bx,ax
	mov	word ptr [tempcell],ax	;store handle for later use
	mov	ah,3Fh			;read file
	mov	cx,maxfilesize
	mov	dx,offset filebuf
	int	21h
	pushf				;save carry
	push	ax			;save ax
	mov	bx,word ptr [tempcell]
	mov	ah,3Eh			;close file
	int	21h
	pop	ax			;restore bytes read
	popf				;restore the carry flag from read
	jnc	@@noerr1
	call	docrash
	mov	dx,offset io$		;I/O error
	jmp	show
@@noerr1:
	cmp	ax,maxfilesize-1	;if read maxfilesize-1 then
	jb	@@noerr2
	call	docrash
	mov	dx,offset long$ 	;file too long
	jmp	show
@@noerr2:
	add	ax,offset filebuf	;dumb hack to fix c-Z bug
	mov	bx,ax
	cmp	byte ptr [bx-1],ctrlz
	jne	@@nocz
	dec	bx			;overwrite that ctrl Z
@@nocz:
	mov	byte ptr [bx],lf	;make sure lf at end of file
	mov	byte ptr [bx+1],0	;make sure 0 at end
	call	compile
	cmp	[errors],0
	jz	@@good
	print	offset found$		;print message telling # of errors
	mov	ax,[errors]
	call	printnum
	linefeed
	jmp	exit
@@good:
	inc	[filenum]		;do next file
	cmp	[filenum],2
	jne	@@was2

	cmp	[disp],0		;list?
	jz	@@open2
	mov	bl,lf			;lf terminated string
	mov	si,offset name1
	call	print3
	print	offset by$
	mov	bl,lf			;lf terminated string
	mov	si,offset author1
	call	print3
	linefeed
	print	offset len$
	mov	ax,[len1]
	call	printnum
	linefeed
	mov	cx,[cellnum]
	mov	bp,offset program1
	mov	bx,[end1]
	call	printprog
	jmp	@@open2
@@was2:
	cmp	[disp],0
	jz	interpret
	xor	ah,ah			;wait for key before printing out
	int	16h
	mov	bl,lf
	mov	si,offset name2
	call	print3
	print	offset by$
	mov	bl,lf
	mov	si,offset author2
	call	print3
	linefeed
	print	offset len$
	mov	ax,[len2]
	call	printnum
	linefeed
	mov	cx,[cellnum]
	mov	bp,offset program2
	mov	bx,[end2]
	call	printprog
	jmp	interpret
docrash:
	mov	al,[filenum]
	add	al,'0'
	mov	[which$],al		;indicate which file crashed us
	print	offset broken$
	ret
	ENDP
;----------------------------------------------
;Error: error message generator
;Entry: dx- pointer to error string
;Exit: errors incremented.  Everything stable
;----------------------------------------------
.DATA?
errors	dw	?

.CODE
error	PROC
	pusha
	mov	ah,9			;print the message
	int	21h
	print2	offset errmsg$		;tell what line
	mov	ax,[linenum]
	call	printnum
	print	offset offile$		;tell what file
	mov	si,[file1]
	xor	bl,bl			;tell print3 to stop at 0
	call	print3
	linefeed
	mov	si,[lineloc]		;display the line
	mov	bl,lf			;tell print3 to stop at lf
	call	print3
	linefeed
	popa
	inc	errors			;one more error
	stc
	ret
	ENDP
;-------------------------------------------------
;Error2  displays [dx] in file...
;Error3  evaluating constant [[tempcell]]
;Entry:dx error msg.  [tempcell] points to text
;Exit:ax screwed up.  si screwed up
;-------------------------------------------------
Error2	PROC
	mov	ah,9
	int	21h
	print2	offset offile$
	mov	si,[file1]
	xor	bl,bl
	call	print3
	linefeed
	inc	[errors]
Error3:
	print	offset errmsg2$
	mov	si,word ptr [tempcell]
@@loop:
	call	getchar 		;print variable name
	cmp	al,'_'
	je	@@doit
	cmp	al,'0'
	jb	@@doh
	cmp	al,'9'
	jbe	@@doit
	cmp	al,'A'
	jb	@@doh
	cmp	al,'Z'
	ja	@@doh
@@doit:
	mov	dl,al
	mov	ah,2
	int	21h
	jmp	@@loop
@@doh:
	linefeed			;done printing
	stc
	ret
	ENDP

;--------------------------------------------------------------
;compile phase 1
;gather all labels and equates
;format of variables:	varname (unterminated)
;			0 label or 1 equate
;			cellnum or textpointer
;			0 to end variables
;fill in author and name info  might be used in future version
;do partial assembly format of programx:
;modea	 0
;modeb	 1
;op	 2
;a	 4   0 or pointer to expra
;b	 6   0 or pointer to exprb
;
;create debugtable: (used when error in pass 2)
;call evaluate to evaluate expression after END
;--------------------------------------------------------------
.DATA
commandlist db  'EQU SPL JMP JMZ JMN DJN '
	db	'SUB SLT MOV CMP ADD DAT END '
debugf	db	0
tracef	db	0
breakf	db	0
traced	db	0

.DATA?					;cellnum must follow errors
cellnum dw	?			;general storage of cell number
waslab	db	?			;label on line?
	db	?			;to keep alignment
vartop	dw	?			;top of variables
linenum dw	?
lineloc dw	?			;pointer to beginning of line
place	dw	?			;where we store next cell

.CODE
compile PROC
	xor	eax,eax
	mov	dword ptr [debugf],eax

if debugging
	mov	[debugf],0FFh
endif

	mov	dword ptr [errors],eax	;errors=cellnum=0
	mov	[linenum],1
	mov	si,offset filebuf
	mov	[vartop],offset variables
@@doline:
	mov	[waslab],0		;indicate no label, yet
	mov	[lineloc],si
	call	getchar
	cmp	al,lf
	je	@@nextline
	or	al,al
	jz	pass2
	cmp	al,';'
	jne	@@notcom1
	mov	cx,8
	mov	di,offset tempcell	;store the first 6 chars of comment
@@loop1:
	call	getchar
	stosb
	loop	@@loop1
	cmp	dword ptr [tempcell],'EMAN' ;does it say name?
	jne	@@notname
	sub	si,4
@@loop99:
	lodsb
	cmp	al,' '
	je	@@loop99
	dec	si
	cmp	[filenum],1
	jne	@@don2
	mov	di,offset name1
	jmp	@@copyskip		;ignore the rest of the line
@@don2:
	mov	di,offset name2
	jmp	@@copyskip
@@notname:
	cmp	dword ptr [tempcell],'HTUA'
	je	@@restaut
	cmp	dword ptr [tempcell],'UBED'
	je	@@restdeb
	cmp	dword ptr [tempcell],'CART'
	je	@@resttrace
	cmp	dword ptr [tempcell],'AERB'
	je	@@restbreak
@@goback:
	sub	si,8			;unget the six characters
	jmp	@@skiprest
@@restaut:
	cmp	word ptr [tempcell+4],'RO'
	jne	@@goback
	sub	si,2
@@loop98:
	lodsb
	cmp	al,' '
	je	@@loop98
	dec	si
	cmp	[filenum],1
	jne	@@doa2
	mov	di,offset author1
	jmp	@@copyskip
@@doa2:
	mov	di,offset author2
@@copyskip:
	mov	cx,63
@@copyskip2:
	lodsb
	stosb
	cmp	al,lf
	je	@@nextline
	loop	@@copyskip2
@@skiprest:				;read until newline
	lodsb
	cmp	al,lf
	jne	@@skiprest
	jmp	@@nextline
@@restdeb:
	cmp	dword ptr [tempcell+4],'TS G'
	jne	@@notdynamic
	mov	[debugf],01111111b	;debugging but no copy	
	jmp	@@skiprest
@@notstatic:
	cmp	byte ptr [tempcell+4],'G'
	jne	@@goback
	sub	si,3
	mov	[debugf],11111111b	;debugging with copy
	jmp	@@skiprest
@@notdynamic:
	cmp	dword ptr [tempcell+4],'FO G'
	jne	@@notstatic
	mov	[debugf],0		;no debugging
	jmp	@@skiprest
@@resttrace:
	cmp	dword ptr [tempcell+4],'FO E'
	jne	@@notoff
	mov	[tracef],0
	jmp	@@skiprest
@@notoff:
	cmp	byte ptr [tempcell+4],'E'
	jne	@@goback
	sub	si,3
	mov	[tracef],81h
	jmp	@@skiprest
@@restbreak:
	cmp	dword ptr [tempcell+4],'NO K'
	jne	@@notonce
	mov	[breakf],10000010b
	jmp	@@skiprest
@@notonce:
	cmp	byte ptr [tempcell+4],'K'
	jne	@@goback
	sub	si,3
	mov	[breakf],10000110b
	jmp	@@skiprest

@@notcom1:
	cmp	al,' '
	je	@@scaninst
	call	@@checkop
	jnc	@@isop
	call	getvname		;check for duplicate name
	jnc	@@redef
	mov	di,[vartop]
	call	getchar
	cmp	al,'A'
	jb	syntaxerr
	cmp	al,'Z'
	ja	syntaxerr
	stosb
	inc	[waslab]		;indicate there is a label in line
@@lloop:
	call	getchar
	cmp	al,' '
	je	@@ldone
	cmp	al,':'
	je	@@ldone
	cmp	al,lf
	je	@@ldone2
	cmp	al,';'
	je	@@ldone2
	cmp	al,'_'
	je	@@lstore
	cmp	al,'0'
	jb	syntaxerr
	cmp	al,'Z'
	ja	syntaxerr
	cmp	al,'9'
	jbe	@@lstore
	cmp	al,'A'
	jb	syntaxerr
@@lstore:
	stosb
	jmp	@@lloop
@@ldone2:
	dec	si
@@ldone:
	xor	al,al
	stosb
	mov	ax,[cellnum]
	stosw
	mov	[vartop],di
@@scaninst:
	call	getchar
	cmp	al,' '
	je	@@scaninst
	cmp	al,lf
	je	@@nextline
	cmp	al,';'
	je	@@skiprest
	call	@@checkop
	jc	@@comerr
@@isop:					;yes! we have a command
	cmp	cl,12
	je	@@isequ
	or	cl,cl
	jz	@@isend
	dec	cx
	mov	bx,[place]

if debugging				;put in debuginfo
	or	ch,[breakf]
	or	ch,[tracef]
	and	ch,[debugf]
	mov	[breakf],0		;clear it
endif

	mov	word ptr [bx+op],cx	;store opcode
	mov	ax,[cellnum]
	cmp	[maxlen],ax
	je	@@toolong
	shl	ax,1
	mov	di,ax
	add	di,offset debugt1
	mov	cx,[linenum]
	mov	[di],cx			;store linenum in debugt1
	mov	di,ax
	add	di,offset debugt2
	mov	cx,[lineloc]
	mov	[di],cx			;store lineloc in debugt2
	inc	[cellnum]
@@loopo1:
	call	getchar			;scan for first operand
	cmp	al,' '
	je	@@loopo1
	cmp	al,';'
	je	@@argerr
	cmp	al,lf
	je	@@argerr
	mov	cx,3			;found first operand
	cmp	al,'<'			;which addressing mode is it?
	je	@@doit
	dec	cx
	cmp	al,'@'
	je	@@doit
	dec	cx
	cmp	al,'#'
	je	@@doit
	dec	cx
	dec	si
@@doit:
	mov	byte ptr [bx+modea],cl
	mov	word ptr [bx+a],si
@@loopo2:
	call	getchar			;scan for second operand
	cmp	al,';'
	je	@@nosec
	cmp	al,lf
	je	@@nosec
	cmp	al,','
	jne	@@loopo2
@@loopo22:
	call	getchar			;found second operand
	cmp	al,' '
	je	@@loopo22
	mov	cx,3			;which mode is it?
	cmp	al,'<'
	je	@@doit2
	dec	cx
	cmp	al,'@'
	je	@@doit2
	dec	cx
	cmp	al,'#'
	je	@@doit2
	dec	cx
	dec	si
@@doit2:
	mov	byte ptr [bx+modeb],cl
	mov	word ptr [bx+b],si
	add	[place],8		;point to next cell
	jmp	@@skiprest
@@nosec:
	mov	byte ptr [bx+modeb],immediate ;no second op found
	mov	word ptr [bx+b],0	;assume #0
	dec	si			;ungetchar
	add	[place],8		;point to next cell
	jmp	@@skiprest

@@isend:
	lodsb
	cmp	al,lf
	je	pass2
	cmp	al,';'
	je	pass2
	cmp	al,' '
	je	@@isend
	cmp	al,tab
	je	@@isend
	cmp	al,cr
	je	@@isend
	dec	si
	push	[cellnum]		;save
	mov	[cellnum],0		;eval with respect to cell 0
	call	evaluate		;evaluate operand to find start
	pop	[cellnum]		;restore
	jc	pass2			;we'll just ignore error
	lodsb				;make sure no second operand
	cmp	al,','
	je	@@oneop 		;error!
	cmp	[filenum],1
	jne	@@end2
	mov	[end1],dx
	jmp	pass2
@@end2:
	mov	[end2],dx
	jmp	pass2

@@checkop:
	mov	di,offset tempcell	;store 4 chars in tempcell
	stosb
	call	getchar
	stosb
	call	getchar
	stosb
	call	getchar
	stosb
	mov	eax,dword ptr [tempcell]
	mov	cx,13			;number of commands
	mov	di,offset commandlist
	repne	scasd			;compare to list
	jne	@@notop
	clc
	ret
@@notop:
	mov	si,[lineloc]
	stc
	ret
@@isequ:
	cmp	[waslab],1
	jne	@@needlab
	mov	di,[vartop]
	mov	byte ptr [di-3],1	;indicate equ
	mov	word ptr [di-2],si
	jmp	@@skiprest
@@needlab:
	mov	dx,offset nolab$
	jmp	error

@@oneop:
	mov	dx,offset argerr1$
	jmp	error

@@nextline:
	inc	[linenum]
	jmp	@@doline
@@comerr:
	mov	dx,offset comerr$
	jmp	error
@@redef:
	mov	dx,offset twolab$
	jmp	error
@@argerr:
	mov	dx,offset argerr$
	jmp	error
@@toolong:
	mov	dx,offset toolong$
	jmp	error
	ENDP
;---------------------------------------------
;compile pass 2
;check addressing modes and number of operands
;call evaluate on every expr in each cell
;---------------------------------------------
.DATA
start$	db	'START$'
ctogo	equ	tempcell+6

.CODE
pass2   PROC
	mov	cx,[cellnum]
	mov	word ptr [ctogo],cx	;save cells to go
	mov	[cellnum],0
	cmp	[filenum],1
	jne	@@is2
	mov	di,offset program1
	mov	[len1],cx
	jmp	@@doline
@@is2:
	mov	di,offset program2
	mov	[len2],cx
@@doline:				;get debug info just in case
	mov	bx,[cellnum]
	shl	bx,1			;get pointer into tables
	mov	ax,[bx+debugt1]
	mov	[linenum],ax
	mov	ax,[bx+debugt2]
	mov	[lineloc],ax

;DAT			only # and <
;ADDCMPMOVSLTSUB	no # in B
;DJNJMNJMZJMPSPL	no # in A

	mov	al,[di+op]		;check addressing modes
	mov	bx,[di+modea]
	or	al,al
	jne	@@notdat
	shr	bl,1
	jnc	@@aerr			;no direct or indirect

@@dataokay:
	shr	bh,1
	jc	@@evala
	jmp	@@aerr
@@notdat:
	cmp	al,6
	jae	@@type2
	cmp	bh,immediate
	jne	@@evala
	jmp	@@aerr
@@type2:
	cmp	bl,immediate
	jne	@@evala
@@aerr:
	mov	dx,offset modeerr$
	call	error
@@evala:
	mov	si,[di+a]		;get address of expr
	call	evaluate		;calculate
	mov	[di+a],dx		;store result
@@evalb:
	cmp	word ptr [di+b],0	;is there a second operand?
	jz	@@checkvalid
	mov	si,[di+b]
	call	evaluate
	mov	[di+b],dx
	jc	@@nextline
	lodsb
	cmp	al,','			;did evaluation terminate at , ?
	jne	@@nextline		;no, good
	mov	dx,offset argerr2$	;third operand error
	call	error
@@nextline:
	inc	[cellnum]
	add	di,8			;point to next cell
	dec	word ptr [ctogo]	;decrease count of cells to go
	jnz	@@doline
	ret				;return to initfiles!!!!
@@checkvalid:
	mov	al,[di+op]		;no second op, check inst
	or	al,al
	jnz	@@notswap
	mov	bx,[di+modea]		;is dat
	xchg	bl,bh			;swap modes
	mov	[di+modea],bx		;write back
	mov	ax,[di+a]		;swap exprs
	mov	[di+b],ax
	mov	word ptr [di+a],0
	jmp	@@nextline
@@notswap:
	cmp	al,9			;is it jmp or spl?
	jae	@@nextline		;no error
	mov	dx, offset argerr2$
	call	error
	jmp	@@nextline
	ENDP
;--------------------------------------------------
;Evaluate  evaluate expr ending in LF , ;
;Entry:  si- pointer to text
;Exit:edx- result.  ebx unchanged.
;     everything else undefined
;     si points to LF , or ; di unchanged
;     if no success everything undefined
;--------------------------------------------------
.DATA?
openp	dw	?		;number of unclosed parentheses encountered

.CODE
Evaluate PROC
	mov	[openp],0	;no open parentheses yet
	push	di
	call	evaluate2
	pop	di
	jc	@@die
	mov	eax,edx
	cdq			;convert eax into eax:edx pair
	idiv	dword ptr [cells] ;mod it
	test	dx,8000h	;test high bit of dx
	jz	@@okay1
	add	edx,dword ptr [cells] ;change sign of dx
@@okay1:
	clc
@@die:
	ret

Evaluate2:
	call	getterm
	jc	@@die
evaluate3:
	mov	al,[si]			;load character
	cmp	al,lf
	je	@@okay1
	cmp	al,';'
	je	@@okay1
	cmp	al,','
	je	@@okay1
	cmp	al,'+'
	je	@@isplus
	cmp	al,'-'
	je	@@isminus
	cmp	al,')'
	jne	syntaxerr
	dec	[openp]			;is close
	jns	@@okay1
	mov	dx,offset parenerr2$	;indicate too many closing parens
	jmp	error
@@isplus:
	inc	si			;next char
	push	edx			;get next term
	call	getterm
	pop	eax
	jc	@@die
	add	edx,eax 		;add them together
	jno	evaluate3		;continue if no overflow
	jmp	overflow
@@isminus:
	inc	si			;next char
	push	edx			;get next term
	call	getterm
	pop	eax
	jc	@@die
	sub	eax,edx			;subtract second from first
	mov	edx,eax			;move into edx
	jno	evaluate3		;continue if no overflow
	jmp	overflow

getterm:
	call	getunit
	jc	@@die
getterm2:
	mov	al,[si]			;get char
	cmp	al,'*'
	je	@@ismul
	cmp	al,'/'
	jne	@@okay1
	inc	si			;is divide
	push	edx			;get next unit
	call	getunit
	mov	ecx,edx
	pop	eax
	jc	@@die
	cdq
	jcxz	divide0
	idiv	ecx			;divide first term by second
	mov	edx,eax
	jmp	getterm2
divide0:
	mov	dx,offset divide0$
	jmp	error
@@ismul:
	inc	si			;is multiply
	push	edx			;get next unit
	call	getunit
	pop	eax
	jc	@@die
	imul	edx,eax			;multiply together
	jno	getterm2
	jmp	overflow

getunit:
	call	getchar			;get next character
	cmp	al,' '
	je	getunit
	cmp	al,'+'
	je	getunit
	cmp	al,'-'
	je	@@isneg
	cmp	al,'('
	je	@@isopen
	dec	si			;ungetchar
	cmp	al,'0'			;digit?
	jb	syntaxerr
	cmp	al,'9'
	jbe	@@isdig
	cmp	al,'A'			;label?
	jb	syntaxerr
	cmp	al,'Z'
	ja	syntaxerr
	push	[openp]			;label
	call	getvar			;get value of label
	pop	[openp]
	jc	@@die2
	jmp	@@skipwhite
@@isneg:
	call	getunit			;recurse
	jc	@@die2
	neg	edx			;flip sign
	clc
	ret
@@isopen:
	inc	[openp]
	call	evaluate2		;recurse to evaluate
	jc	@@die2
	lodsb
	cmp	al,')'			;check if ) ended evaluation
	je	@@skipwhite
	mov	dx,offset parenerr1$
	jmp	error
@@isdig:
	call	getnum			;get number
	jc	overflow		;if error than was overflow
	test	eax,80000000h		;check size
	jnz	overflow		;too big
	mov	edx,eax
@@skipwhite:				;skip over trailing whitespace
	call	getchar
	cmp	al,' '
	je	@@skipwhite
	dec	si
	clc
@@die2:
	ret

syntaxerr:
	mov	dx,offset syntaxerr$	;write syntax error
	jmp	error
overflow:
	mov	dx,offset overflow$
	jmp	error
	ENDP

;---------------------------------------------------
;Getvar  get value of label or equate.
;Entry:es and ds point to dseg. si points to varname
;Exit:edx value.  si points to char after varname if success.
;other regs undefined
;---------------------------------------------------
.CODE
getvar	PROC
	call	getvname		;scan for name in table
	jc	@@notfound
	xchg	si,di			;more useful the other way
	lodsb
	or	al,al
	jz	@@islab 		;easy
	cmp	al,1
	je	@@isequ 		;hard
	mov	dx,offset recur$
	call	error2			;terminate assembly
	jmp	exit
@@islab:
	lodsw
	sub	ax,[cellnum]		;relative to current cell
	movsx	edx,ax
	clc
	xchg	si,di			;switch it back
@@done:
	ret
@@isequ:
	lodsw
	push	si
	mov	byte ptr [si-3],2	;set this to check for recursion
	mov	si,ax
	push	di
	call	evaluate		;recurse it!
	pop	si			;this is right.  swapping back
	pop	di
	mov	byte ptr [di-3],1	;reset it
	jnc	@@done
	call	error3			;terminate assembly
	jmp	exit
@@notfound:
	mov	dx,offset notfound$
	call	error
	call	error3
	ret				;nonterminal error
	ENDP
;-------------------------------------------------
;Getvname  search for varname at [si] in variables
;Entry:  si filebuf
;Exit:	si points to byte after varname if success
;	si points to first char if no success
;	di points to vartype if success
;	cf sucess or failure
;	[tempcell] points to varname (si)
;	ax undefined
;-------------------------------------------------
getvname PROC
	mov	word ptr [tempcell],si	;save it
	mov	di,offset variables	;point to beginning
@@start:
	cmp	[vartop],di		;are we at end?
	je	@@error
@@loop:
	mov	ah,[di] 		;at end of varname?
	cmp	ah,3
	jb	@@maybe 		;yes, check source string
	inc	di			;advance pointer
	call	getchar 		;get character from source
	cmp	al,ah			;same?
	je	@@loop
@@loop2:				;different skip to end of varname
	mov	al,[di]
	cmp	al,3
	jb	@@next
	inc	di
	jmp	@@loop2
@@next:
	mov	si,word ptr [tempcell]	;set back to beginning
	add	di,3			;advance past info
	jmp	@@start
@@maybe:
	mov	al,[si] 		;check if next byte in source
	cmp	al,'_'			;looks like continuation of
	je	@@next			;a variable name
	cmp	al,'0'
	jb	@@yes
	cmp	al,'9'
	jbe	@@next
	and	al,11011111b		;to upper case
	cmp	al,'A'
	jb	@@yes
	cmp	al,'Z'
	jbe	@@next
@@yes:
	clc
	ret
@@error:
	stc
	ret
	ENDP
;------------------------------------------------------
;Interpreter	the fun starts here
;ds should be dgroup
;df should be clear
;------------------------------------------------------
.DATA
stepflag =	tempcell+7
wins$	db	' wins',cr,lf,'$'
tie$	db	'tie',cr,lf,'$'
	ALIGN	4
timer_adr dd	0000046Ch	;location of system time
round	dw	0
win1	dw	0
win2    dw      0
ties	dw	0
jmptable dw	offset opdat, offset opadd, offset opcmp, offset opmov
	dw	offset opslt, offset opsub, offset opdjn, offset opjmn
	dw	offset opjmz, offset opjmp, offset opspl
.DATA?
oldint9off dw	?		;put old vector offset here
oldint9seg dw	?		;put old vector segment here
stackt1 dw	?		;top of stack
stackt2 dw	?		;must follow stackt1
processes1 dw	?
processes2 dw	?
curcycle dd	?
seed	dd	?
cells8	dw	?
c2m	dw	?		;cells+1-2*mindist

.CODE
interpret PROC

;------------------------------
;install int9 interrupt handler
	mov	ax,3509h		;ask for current int9 vector
	int	21h
	mov	[oldint9off],bx		;save it
	mov	[oldint9seg],es
	mov	ax,cs
	mov	ds,ax
	mov	dx,offset int_9
	mov	ax,2509h
	int	21h
	mov	ax,dgroup
	mov	ds,ax
;-------------------------------
;gets the 32-bit system time
	les	bx,[timer_adr]		;setup ds and bx to read
	mov	ebx,es:[bx]
	mov	[seed],ebx

	mov	es,[coreptr]		;get location of core
	mov	fs,[pstack]
	mov	ax,[cells]		;calculate cells+1-2*mindist
	sub	ax,[mindist]
	sub	ax,[mindist]
	inc	ax
	mov	[c2m],ax
	mov	ax,[cells]
	shl	ax,3
	mov	[cells8],ax
	mov	byte ptr [stepflag],0
	mov	[tracef],0

newround:
	xor	eax,eax
	xor	di,di
	mov	cx,16384		;clear core 4 bytes at a time
	rep	stosd			;eax->[es:di] di+=4
	mov	dword ptr [stackt1],80000002h	;2->stackt1  8000->stackt2
	mov	[curcycle],eax		;initialize variables each round
	mov	[filenum],al
	inc	ax
	mov	[processes1],ax
	mov	[processes2],ax

	mov	cx,[len1]		;copy program1 into cell0
	mov	si,offset program1
@@copy1:
	mov	eax,[si]		;copy one cell
	mov	es:[di],eax
	mov	eax,[si+4]
	mov	es:[di+4],eax
	add	si,8
	add	di,8
	dec	cx
	jnz	@@copy1

;--------------------------------------
;get a random number between 0..cells-1
	mov	eax,1103515245
	mul	[seed]
	add	eax,12345		;we now have random 64 bit sequence
	mov	[seed],eax
	xor	ecx,ecx
	mov	cx,[c2m]
	mul	ecx			;multiply to get into range
	add	dx,100			;add offset
	mov	ax,dx
	add	ax,[end2]		;set to start at cell offset end2
	mov	fs:[8000h],ax		;push onto stack2
	mov	si,offset program2	;point to start of program
	mov	cx,[len2]
	mov	di,dx
	shl	di,3
@@copy2:
	mov	eax,[si]		;copy one cell
	mov	es:[di],eax
	mov	eax,[si+4]
	mov	es:[di+4],eax
	add	si,8
	add	di,8
	inc	dx			;increment cell number
	cmp	[cells],dx		;if cells then dest=0
	jne	@@cont
	xor	di,di
@@cont:
	dec	cx
	jnz	@@copy2

	mov	cx,1			;load initial info for player1
	mov	edi,80020002h
	mov	bp,[end1]
	
	mov	si,bp
	shl	si,3			;get cell location into si
	mov	dx,es:[si]		;dx holds modes
	mov	ebx,es:[si+a]		;bx holds opa and opb
	mov	si,es:[si+op]		;fetch inst

if debugging
	call	trace1
endif	

	shl	si,1
	jmp	word ptr cs:[si+jmptable] ;execute command
	ENDP

if debugging
trace1	PROC
	test	[tracef],80h		;check for no trace
	jnz	@@notrace
	test	si,0200h		;test for break flag
	jz	@@notbreak
	mov	byte ptr [stepflag],1	;begin step
	test	si,0400h		;test for multiple break
	jnz	@@istrace
	push	si
	mov	si,bp
	shl	si,3
	and	byte ptr es:[si+debugi],11111001b ;turn off future breaks
	pop	si
	jmp	@@istrace
@@notbreak:
	cmp	byte ptr [tracef],0
	jnz	@@istrace
	test	si,0100h		;test for trace
	jz	@@notrace
@@istrace:
	in	al,21h
	pushad
	or	al,2			;set bit one
	out	21h,al
	mov	word ptr [tempcell+4],bp
	mov	ax,bp
	call	printnum
	shl	bp,3			;debugging
	call	prcell
	popad
	mov	[traced],1
	out	21h,al
@@notrace:
	and	si,0FFh			;strip debug info
	ret
	ENDP

trace2	PROC
	cmp	[traced],1
	jne	@@nostop
	in	al,21h
	pushad
	or	al,2			;set bit one
	out	21h,al	
	mov	ah,2
	mov	dl,tab			;print tab
	int	21h
	mov	ah,2
	mov	dl,tab			;print tab
	int	21h
	mov	bp,word ptr [tempcell+4]
	mov	al,[filenum]
	and	ax,0FFh			;just low byte
	inc	ax
	call	printnum
	shl	bp,3			;debugging
	call	prcell
	linefeed
	popad
	mov	[traced],0
	out	21h,al

@@wait2:
	cmp	byte ptr [stepflag],0
	jz	@@nostop
	mov	byte ptr [stepflag],1
@@wait:
	hlt				;wedge the processor
	cmp	byte ptr [stepflag],1
	je	@@wait
	cmp	byte ptr [stepflag],0
	jz	@@nostop
	mov	byte ptr [stepflag],1
@@nostop:
	ret
endif
	ENDP
;-----------------------------------------------------------
;refer to ICWS '88 standard to understand the following code
opdat	PROC
	cmp	dl,predec
	jne	@@nota
	addm	bx,bp,[cells],@@skip1
	shl	bx,3
	decmm	es:[bx+b],@@nota,ax
	cmp	dh,predec
	jne	@@godie
	ror	ebx,16			;swap words in ebx
	addm	bx,bp,[cells],@@skip2
	shl	bx,3
	decmm	es:[bx+b],@@godie,ax
					;label godie
	dec	cx
	jnz	doneinst2

if debugging
	call	trace2
endif

	cmp	[filenum],1
	je	@@is2

if debugging
	test	[tracef],080h
	jnz	@@skip
	in	al,21h
	pusha
	or	al,2			;set bit one
	out	21h,al
	mov	bl,lf
	mov	si,offset name2
	call	print3
	print	offset wins$
	popa
	out	21h,al
@@skip:
endif

	inc	[win2]
	inc	[round]
	mov	ax,[round]
	cmp	[rounds],ax		;are we done yet?
	jne	newround
	jmp	finish
@@is2:

if debugging
	test	[tracef],080h
	jnz	@@skipb
	in	al,21h
	pusha
	or	al,2			;set bit one
	out	21h,al
	mov	bl,lf
	mov	si,offset name1
	call	print3
	print	offset wins$
	popa
	out	21h,al
@@skipb:
endif

	inc	[win1]
	inc	[round]
	mov	ax,[round]
	cmp	[rounds],ax		;are we done yet?
	jne	newround
	jmp	finish
	ENDP
;-------------
opcmp	PROC
	cmp	dl,immediate
	je	@@immediate
	addm	bx,bp,[cells],@@skip1
	shl	bx,3
	cmp	dl,direct
	je	@@direct
	mov	si,es:[bx+b]
	cmp	dl,indirect
	je	@@indirect
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@indirect:
	shl	si,3
	addm2	bx,si,[cells8],@@direct,@@docara
					;label direct
	mov	eax,es:[bx]
if debugging
	and	eax,00FFFFFFh		;turn off debug byte
endif
	mov	dword ptr [tempcell],eax
	mov	eax,es:[bx+4]
	ror	ebx,16
	addm	bx,bp,[cells],@@skip4
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
					;label directb
	cmp	es:[bx+4],eax
	jne	doneinst
	mov	eax,es:[bx]
if debugging
	and	eax,00FFFFFFh;		;turn off debug byte
endif
	cmp	eax,dword ptr [tempcell]
	jne	doneinst
	inc	bp			;skip the next instruction
	cmp	[cells],bp
	jne	doneinst
	mov	bp,1
	jmp	skipincr
@@immediate:
	mov	ax,bx
	ror	ebx,16
	addm	bx,bp,[cells],@@skip7
	shl	bx,3
	cmp	dh,direct
	je	@@directi
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indi
	decmr	si,@@skip8
	mov	es:[bx+b],si
@@indi:
	shl	si,3
	addm2	bx,si,[cells8],@@directi,@@docari
	cmp	es:[bx+b],ax
	jne	doneinst
	inc	bp			;skip the next instruction
	cmp	[cells],bp
	jne	doneinst
	mov	bp,1
	jmp	skipincr
	ENDP
;-------------
opadd	PROC
	cmp	dl,immediate
	je	@@immediate
	addm	bx,bp,[cells],@@skip1
	shl	bx,3
	cmp	dl,direct
	je	@@direct
	mov	si,es:[bx+b]
	cmp	dl,indirect
	je	@@indirect
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@indirect:
	shl	si,3
	addm2	bx,si,[cells8],@@direct,@@docara
					;label direct
	mov	eax,es:[bx+4]
	ror	ebx,16
	addm	bx,bp,[cells],@@skip4
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
					;label directb
	add	eax,es:[bx+4]
	mov	si,[cells]
	cmp	si,ax
	ja	@@skipa
	sub	ax,si
@@skipa:
	ror	eax,16
	cmp	si,ax
	ja	@@skipb
	sub	ax,si
@@skipb:
	ror	eax,16
	mov	es:[bx+4],eax
	jmp	doneinst
@@immediate:
	mov	ax,bx
	ror	ebx,16
	addm	bx,bp,[cells],@@skip7
	shl	bx,3
	cmp	dh,direct
	je	@@directi
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indi
	decmr	si,@@skip8
	mov	es:[bx+b],si
@@indi:
	shl	si,3
	addm2	bx,si,[cells8],@@directi,@@docari
					;label directi
	add	ax,es:[bx+b]
	mov	si,[cells]
	cmp	si,ax
	ja	@@skipai
	sub	ax,si
@@skipai:
	mov	es:[bx+b],ax
	jmp	doneinst
	ENDP
;------------
opsub	PROC
	cmp	dl,immediate
	je	@@immediate
	addm	bx,bp,[cells],@@skip1
	shl	bx,3
	cmp	dl,direct
	je	@@direct
	mov	si,es:[bx+b]
	cmp	dl,indirect
	je	@@indirect
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@indirect:
	shl	si,3
	addm2	bx,si,[cells8],@@direct,@@docara
					;label direct
	mov	eax,es:[bx+4]
	ror	ebx,16
	addm	bx,bp,[cells],@@skip4
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
					;label directb
	mov	si,[cells]
	sub	es:[bx+a],ax
	jns	@@skip8
	add	es:[bx+a],si
@@skip8:
	ror	eax,16
	sub	es:[bx+b],ax
	jns	doneinst
	add	es:[bx+b],si
	jmp	doneinst
@@immediate:
	mov	ax,bx
	ror	ebx,16
	addm	bx,bp,[cells],@@skip7
	shl	bx,3
	cmp	dh,direct
	je	@@directi
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indi
	decmr	si,@@skip9
	mov	es:[bx+b],si
@@indi:
	shl	si,3
	addm2	bx,si,[cells8],@@directi,@@docari
	;label directi
	sub	es:[bx+b],ax
	jns	doneinst
	mov	ax,[cells]
	add	es:[bx+b],ax
	jmp	doneinst
	ENDP
;-------------
opslt	PROC
	mov	ax,bx			;sacrfice one cycle on nonimmediate
	cmp	dl,immediate		;to save a lot of bytes
	je	@@immediate
	addm	bx,bp,[cells],@@skip1
	shl	bx,3
	cmp	dl,direct
	je	@@direct
	mov	si,es:[bx+b]
	cmp	dl,indirect
	je	@@indirect
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@indirect:
	shl	si,3
	addm2	bx,si,[cells8],@@direct,@@docara
					;label direct
	mov	ax,es:[bx+b]
@@immediate:
	ror	ebx,16
	addm	bx,bp,[cells],@@skip4
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
	;label directb
	cmp	es:[bx+b],ax
	jbe	doneinst
	inc	bp			;skip the next instruction
	cmp	[cells],bp
	jne	doneinst
	mov	bp,1
	jmp	skipincr
	ENDP
;----------------
opjmz	PROC
	addm	bx,bp,[cells],@@skip1
	mov	ax,bx
	cmp	dl,direct
	je	@@direct
	shl	bx,3
	mov	si,es:[bx+b]
	cmp	dl,predec
	jne	@@inda
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@inda:
	addm	ax,si,[cells],@@direct
	;label direct
	ror	ebx,16
	cmp	dh,immediate
	jne	@@notim
	or	bx,bx
	jnz	doneinst
	mov	bp,ax
	jmp	skipincr
@@notim:
	addm	bx,bp,[cells],@@skip3
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
					;label directb
	cmp	word ptr es:[bx+b],0
	jnz	doneinst
	mov	bp,ax
	jmp	skipincr
	ENDP
;----------------
opjmn	PROC
	addm	bx,bp,[cells],@@skip1
	mov	ax,bx
	cmp	dl,direct
	je	@@direct
	shl	bx,3
	mov	si,es:[bx+b]
	cmp	dl,predec
	jne	@@inda
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@inda:
	addm	ax,si,[cells],@@direct
	;label direct
	ror	ebx,16
	cmp	dh,immediate
	jne	@@notim
	or	bx,bx
	jz	doneinst
	mov	bp,ax
	jmp	skipincr
@@notim:
	addm	bx,bp,[cells],@@skip3
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
	;label directb
	cmp	word ptr es:[bx+b],0
	jz	doneinst
	mov	bp,ax
	jmp	skipincr
	ENDP
;----------------
opdjn	PROC
	addm	bx,bp,[cells],@@skip1
	mov	ax,bx
	cmp	dl,direct
	je	@@direct
	shl	bx,3
	mov	si,es:[bx+b]
	cmp	dl,predec
	jne	@@inda
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@inda:
	addm	ax,si,[cells],@@direct
					;label direct
	cmp	dh,immediate
	jne	@@notim
	mov	si,bp
	shl	si,3
	dec	word ptr es:[si+b]	;decrement current inst
	jz	doneinst
	jns	@@notneg
	mov	bx,[cells1]
	mov	es:[si+b],bx
@@notneg:
	mov	bp,ax
	jmp	skipincr
@@notim:
	ror	ebx,16
	addm	bx,bp,[cells],@@skip3
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
					;label directb
	dec	word ptr es:[bx+b]
	jz	doneinst
	jns	@@notneg
	mov	si,[cells1]
	mov	es:[bx+b],si
	mov	bp,ax
	jmp	skipincr
	ENDP
;----------------
opspl	PROC
	mov	ax,bp
	inc	ax
	cmp	[cells],ax
	jne	@@skip
	xor	ax,ax
@@skip:
	mov	fs:[di],ax
	add	di,2
	inc	cx			;waste a few cycles on nonsplit spl
	cmp	[maxprocs],cx		;to save a lot of bytes
	je	opdat
	ENDP	;fall through
;-------------
opjmp	PROC
	mov	ax,bp
	addm	bp,bx,[cells],@@skip4
	cmp	dl,direct
	je	@@dob
	mov	bx,bp
	shl	bx,3
	mov	si,es:[bx+b]
	cmp	dl,predec
	jne	@@inda
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@inda:
	addm	bp,si,[cells],@@dob
					;label dob
	cmp	dh,predec
	jne	skipincr
	ror	ebx,16			;swap words in ebx
	addm	bx,ax,[cells],@@skip2
	shl	bx,3
	dec	word ptr es:[bx+b]
	jns	skipincr
	mov	ax,[cells1]
	mov	es:[bx+b],ax
	jmp	skipincr
	ENDP
;-------------
opmov	PROC
	cmp	dl,immediate
	je	@@immediate
	addm	bx,bp,[cells],@@skip1
	shl	bx,3
	cmp	dl,direct
	je	@@direct
	mov	si,es:[bx+b]
	cmp	dl,indirect
	je	@@indirect
	decmr	si,@@skip2
	mov	es:[bx+b],si
@@indirect:
	shl	si,3
	addm2	bx,si,[cells8],@@direct,@@docara
	;label direct
	mov	eax,es:[bx]
	mov	dword ptr [tempcell],eax
	mov	eax,es:[bx+4]
	ror	ebx,16
	addm	bx,bp,[cells],@@skip4
	shl	bx,3
	cmp	dh,direct
	je	@@directb
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indb
	decmr	si,@@skip5
	mov	es:[bx+b],si
@@indb:
	shl	si,3
	addm2	bx,si,[cells8],@@directb,@@docarb
					;label directb
	mov	es:[bx+4],eax
	mov	eax,dword ptr [tempcell]

if debugging
	test	eax,80000000h		;copy bit
	jnz	@@skip
	and	eax,00FFFFFFh		;turn off debug byte
@@skip:
endif

	mov	es:[bx],eax
	jmp	doneinst
@@immediate:
	mov	ax,bx
	ror	ebx,16
	addm	bx,bp,[cells],@@skip7
	shl	bx,3
	cmp	dh,direct
	je	@@directi
	mov	si,es:[bx+b]
	cmp	dh,predec
	jne	@@indi
	decmr	si,@@skip8
	mov	es:[bx+b],si
@@indi:
	shl	si,3
	addm2	bx,si,[cells8],@@directi,@@docari
	mov	es:[bx+b],ax
	ENDP			;fall through
;--------------
doneinst PROC
	inc	bp		;next instruction is at bp+1
	cmp	[cells],bp
	jne	skipincr
	xor	bp,bp
skipincr:
	mov	fs:[di],bp
	add	di,2
doneinst2:

if debugging
	call	trace2
endif

	ror	edi,16			;swap stackb2's
	xor	[filenum],1		;flip low bit
	jz	@@was2
	mov	[processes1],cx		;save all info for 1
	mov	si,[stackt2]		;load new info for 2
	mov	cx,[processes2]
	mov	bp,fs:[si]
	add	si,2
	mov	[stackt2],si
	mov	si,bp

	shl	si,3			;get cell location into si
	mov	dx,es:[si]		;dx holds modes
	mov	ebx,es:[si+a]		;bx holds opa and opb
	mov	si,es:[si+op]		;fetch inst

if debugging
	call	trace1
endif	

	shl	si,1
	jmp	word ptr cs:[si+jmptable] ;execute command
@@was2:
	inc	[curcycle]
	mov	eax,[curcycle]
	cmp	[cycles],eax		;are we done yet?
	je	@@dotie
	mov	[processes2],cx		;save all info for 2
	mov	si,[stackt1]		;load new info for 1
	mov	cx,[processes1]
	mov	bp,fs:[si]
	add	si,2
	mov	[stackt1],si
	mov	si,bp

	shl	si,3			;get cell location into si
	mov	dx,es:[si]		;dx holds modes
	mov	ebx,es:[si+a]		;bx holds opa and opb
	mov	si,es:[si+op]		;fetch inst

if debugging
	call	trace1
endif	

	shl	si,1
	jmp	word ptr cs:[si+jmptable] ;execute command
@@dotie:

if debugging
	test	[tracef],080h
	jnz	@@skip3
	in	al,21h
	push	ax
	or	al,2			;set bit one
	out	21h,al
	print	offset tie$
	pop	ax
	out	21h,al
@@skip3:
endif

	inc	[ties]
	inc	[round]
	mov	ax,[round]
	cmp	[rounds],ax		;are we done yet?
	jne	newround
finish:
	in	al,21h
	push	ax
	or	al,2			;set bit one
	out	21h,al
	linefeed
	call	prresults

	cmp	[dump],1
	jne	@@ret
	linefeed
	xor	bp,bp			;do core dump			
@@cdump:
	cmp	dword ptr es:[bp],0	;don't display blank cell
	jne	@@dumpit
	cmp	dword ptr es:[bp+4],0
	je	@@cdumpn
@@dumpit:
	mov	ax,bp
	shr	ax,3
	call	printnum
	call	prcell
	linefeed
@@cdumpn:
	add	bp,8
	jnz	@@cdump
@@ret:
	pop	ax
	out	21h,al
;----------------------------------------
;Remint  - unchain int_9 handler and quit
;----------------------------------------
remint:
	cli
	in	al,21h
	push	ax
	or	al,2			;set bit one
	out	21h,al
	push	ds
	lds	dx,dword ptr [oldint9off] ;get old vector
	mov	ax,2509h
	int	21h			;install back
	pop	ds
	pop	ax
	out	21h,al
	sti
	jmp	leave
	ENDP

;-------------------------------------
;PrResults  print the results
;-------------------------------------
.DATA
results$ db	'Results: $'
.CODE
prresults PROC
	mov	bl,lf
	mov	si,offset name1
	call	print3
	print	offset by$
	mov	bl,lf
	mov	si,offset author1
	call	print3
	linefeed
	mov	bl,lf
	mov	si,offset name2
	call	print3
	print	offset by$
	mov	bl,lf
	mov	si,offset author2
	call	print3
	linefeed
	print	offset results$
	mov	ax,[win1]
	call	printnum
	mov	dl,' '
	mov	ah,2
	int	21h
	mov	ax,[win2]
	call	printnum
	mov	dl,' '
	mov	ah,2
	int	21h
	mov	ax,[ties]
	call	printnum
	linefeed
	ret
	ENDP

;------------------------------------------------
;Int_9	custom keyboard interrupt handler
;  huge hassle for a small increase in speed
;------------------------------------------------

.DATA
round$	db	'Round number: $'
cycle$	db	'Cycle number: $'
proc$	db	'Processes active: $'

.CODE
int_9	PROC
	cli
	push	ax
	in	al,60h
	cmp	al,57		;space scan code
	je	@@isspace
	cmp	al,1		;escape scan code
	je	@@isesc
	cmp	al,1Ch
	je	@@isreturn
	cmp	al,1Fh
	je	@@iss
	cmp	al,14h
	je	@@ist
        cmp     al,20h
        je      @@isd
@@reset:
	call	@@fixints
	pop	ax
	iret

@@fixints:
	in	al,61h		;reset the keyboard controller
	mov	ah,al
	or	al,80h
	out	61h,al
	mov	al,ah
	jmp	SHORT $+2	;flush the prefetch cache for I/O delay
	jmp	SHORT $+2
	out	61h,al
	mov	al,20h		;reset interrupt controller
	out	20h,al
	ret

@@isesc:
	call	@@fixints
	jmp	remint
@@isspace:
	in	al,21h
	pushad
	or	al,2		;set bit one
	out	21h,al
	linefeed
	print2	offset round$	;print round number
	mov	ax,[round]
	inc	ax
	call	printnum
	linefeed
	print2	offset cycle$	;print current cycle
	mov	eax,[curcycle]
	call	printnuml
	linefeed
	call	prresults
	print	offset proc$	;print processes active
	mov	ax,[processes1]
	call	printnum
	mov	dl,' '
	mov	ah,2
	int	21h
	mov	ax,[processes2]
	call	printnum
	linefeed
	popad
	out	21h,al
	jmp	@@reset
@@isreturn:
	mov	byte ptr [stepflag],0
	mov	[tracef],0
	jmp	@@reset
@@iss:
	inc	byte ptr [stepflag]
	mov	[tracef],0
	jmp	@@reset
@@ist:
	inc	byte ptr [stepflag]
	mov	[tracef],1
	jmp	@@reset
@@isd:
        xor     [tracef],80h
        cmp     byte ptr [stepflag],0
        je      @@reset
        inc     byte ptr [stepflag]
	jmp	@@reset
	ENDP

;-------------------------------
;printnum - print unsigned int
;printnuml - print unsigned long
;entry: unsigned int eax
;exit: cx=0, ebx=10, ax=200h
;screws up: dx
;-------------------------------
printnum PROC
	and	eax,0FFFFh	;just use low word
printnuml:
	xor	cx,cx
	mov	ebx,10
@@loop:
	xor	edx,edx
	div	ebx		;get lowest digit
	push	dx		;push onto stack to get in reverse order
	inc	cx		;increment digit count
	or	eax,eax 	;if zero goto @@loop
	jnz	@@loop
@@loop2:
	pop	dx
	add	dl,'0'		;put in ascii
	mov	ah,2
	int	21h		;writechar
	loop	@@loop2
	ret
	ENDP
;-----------------------------------------
;Print3 - print string
;Entry: si - string.  bl string terminator
;Exit: si points to terminator
;  ax screwed up.
;-----------------------------------------
print3	PROC
	mov	ah,2		;indicate output char
@@more:
	mov	dl,[si] 	;fetch char
	cmp	bl,dl		;check if terminator
	je	@@done		;yes
	inc	si		;point to next char
	cmp	dl,cr		;don't print this
	je	@@more
	int	21h		;print char
	jmp	@@more
@@done:
	ret
	ENDP
;---------------------------------------
;Getnum
;read number at ds:si
;entry: si
;exit: eax number, cf error
;	ebx-?  ecx-10  edx=0
;      everything undefined if error
;si points to first nondigit if no error
;---------------------------------------
getnum	PROC
	xor	eax,eax		;initialize all regs
	xor	ebx,ebx
	mov	ecx,10
@@skip:
	call	getchar 	;getchar will convert tabs to spaces
	cmp	al,' '
	je	@@skip
	cmp	al,'9'		;first nonspace must be digit
	ja	@@error
	sub	al,'0'		;fetch value
	jb	@@error
@@loop:
	mov	bl,[si] 	;get character
	cmp	bl,'9'		;check range
	ja	@@noerr 	;stop (no error) on nondigit
	sub	bl,'0'		;fetch value
	jb	@@noerr
	inc	si		;point to next character
	mul	ecx		;eax=eax*10
	jo	@@error 	;error on overflow
	add	eax,ebx 	;add current digit
	jnc	@@loop		;error on overflow
@@error:
	stc
	ret
@@noerr:
	clc
	ret
	ENDP

;-----------------------------------------------------
;Getchar
;get next character in stream and upcase if neccessary
;tabs and carriage returns converted to space
;control chars other than lf and 0 will crash program
;input: si
;ouput:si<-si+1, al
;-----------------------------------------------------
Getchar PROC
	lodsb
	cmp	al,'a'
	jb	@@checkwhite
	and	al,11011111b	;assume we don't get anything past 'z'
@@exit:
	ret
@@checkwhite:
	cmp	al,cr
	je	@@makespace
	cmp	al,tab
	je	@@makespace
	cmp	al,lf
	je	@@exit
	cmp	al,0
	je	@@exit
	cmp	al,' '
	jae	@@exit
	call	docrash
	jmp	exit
@@makespace:
	mov	al,' '
	ret
	ENDP

;------------------------------------
;PrCell  print the contents of a cell
;Entry: es:bp points to cell
;Exit: nothing changed
;------------------------------------
prcell	proc
	pushad
	mov	ah,2
	mov	dl,tab			;print tab
	int	21h
	mov	bx,11
	sub	bl,es:[bp+op]
	shl	bl,2
	mov	edx,[bx+offset commandlist] ;get command string
	mov	cx,3			;print command
@@loop:
	int	21h
	shr	edx,8
	loop	@@loop
	mov	dl,tab
	int	21h
	mov	bl,byte ptr es:[bp+modea] ;print first operand
	mov	cx,word ptr es:[bp+a]
	call	@@printfield
	mov	dl,tab
	int	21h
	mov	dl,','
	int	21h
	mov	bl,byte ptr es:[bp+modeb] ;print second operand
	mov	cx,word ptr es:[bp+b]
	call	@@printfield
	popad
	ret

@@printfield:
	cmp	bl,direct
	je	@@skip
	cmp	bl,immediate
	jne	@@try2
	mov	dl,'#'
	jmp	@@skip2
@@try2:
	cmp	bl,indirect
	jne	@@try3
	mov	dl,'@'
	jmp	@@skip2
@@try3:
	mov	dl,'<'
@@skip2:
	int	21h
@@skip:
	mov	ax,cx
	jmp	printnum
	ENDP

;------------------------------------
;printprog  print an entire program
;Entry: bp:programx  cx:lenx  bx:endx
;------------------------------------
printprog PROC
	mov	word ptr [tempcell],0	;store
@@loop:
	cmp	word ptr [tempcell],bx	;are we at start of execution?
	jne	@@skip
	print	offset start$		;print start
@@skip:
	call	prcell			;print the machine code
	linefeed
	add	bp,8
	inc	word ptr [tempcell]
	loop	@@loop
	linefeed
	ret
	ENDP

;-------------------------------------------
.DATA?
;these variables share space with the core and are overwritten
variables db	varspc dup (?)
filebuf db	maxfilesize dup (?)
params	db	128 dup (?)
debugt1 dw	maxlines dup (?)	;store linenumbers here
debugt2 dw	maxlines dup (?)	;store line addresses here

	END	main
