'/\
'   -+-     David Joffe '93/02/02                       
' Doiley II   http://www.scorpioncity.com/                
'   -+-                                                 
'                                              
' This is one of the earliest things I wrote; back in high 
' when I had just started programming. It runs on QBasic.  
' I am adding comments; hope someone finds it useful.      
'                                 - David (March 1997)     
' Oh yes - my best time is 19 seconds.                     
'\/

' Set default variable type to integer, for speed.
DEFINT A-Z

DECLARE SUB delay (ticks!)

' Data. rand is the 4x4 grid of letters. I have no idea why I called
' it rand.
DIM rand(4, 4), grid(100, 100) AS STRING * 1
DIM high(10) AS STRING * 39, hight(10)

' Initialize random number generator with TIMER as the seed.
RANDOMIZE TIMER

' If cannot open hi-score file, creates new one.
ON ERROR GOTO MakeNewHighScoreList

' Try open hi-score file.
OPEN "doiley2.hst" FOR INPUT AS #1
  FOR i = 1 TO 10
    INPUT #1, high$(i)
    INPUT #1, hight(i)
  NEXT i
CLOSE

' Reset error handler to QBasic's default.
ON ERROR GOTO 0

WIDTH 80, 25: CLS : COLOR 15, 9

'===== Draw opening screen: ======================================
PRINT "  " + STRING$(74, 205) + "  "
PRINT "ͻ" + SPACE$(70) + "ͻ"
PRINT " ͼ" + SPACE$(70) + "ͼ "
FOR i = 1 TO 17
  PRINT "" + SPACE$(78) + ""
NEXT i
PRINT " ͻ" + SPACE$(70) + "ͻ "
PRINT "ͼ" + SPACE$(70) + "ͼ"
PRINT "  " + STRING$(74, 205) + "  "
COLOR 14, 0
LOCATE 2, 31: PRINT "" + STRING$(18, 205) + ""
LOCATE , 11: PRINT "" + STRING$(19, 205) + "  "; : COLOR 12: PRINT "Welcome to ..."; : COLOR 14: PRINT "  ͻ"
LOCATE , 11: PRINT ""; : COLOR 13: PRINT " ͻ"; : COLOR 14: PRINT "          ͼ"; : COLOR 13: PRINT "    "; : COLOR 14: PRINT ""
LOCATE , 11: PRINT ""; : COLOR 13: PRINT "                "; CHR$(2); "  ͻ                                 "; : COLOR 14: PRINT ""
LOCATE , 11: PRINT ""; : COLOR 13: PRINT "        ͻ ͻ     ͻ                       "; : COLOR 14: PRINT ""
LOCATE , 11: PRINT ""; : COLOR 13: PRINT "                   ͼ                       "; : COLOR 14: PRINT ""
LOCATE , 11: PRINT ""; : COLOR 13: PRINT " ͼ ͼ   ͼ ͹     "; : COLOR 14: PRINT ""
LOCATE , 11: PRINT ""; : COLOR 13: PRINT " " + STRING$(36, 205) + "                    "; : COLOR 14: PRINT ""
LOCATE , 11: PRINT "" + STRING$(58, 205) + ""
COLOR 0, 9: LOCATE 11, 13: PRINT STRING$(60, 178)
FOR i = 4 TO 10
  LOCATE i, 71: PRINT ""
NEXT i
SOUND 65, .5
delay .5
COLOR 14, 0
LOCATE 14, 21: PRINT "" + STRING$(37, 205) + ""
LOCATE , 21: PRINT "              "; : COLOR 10: PRINT "ver 2.00"; : COLOR 14: PRINT "               "
LOCATE , 21: PRINT "" + SPACE$(37) + ""
LOCATE , 21: PRINT "      "; : COLOR 13: PRINT "(C) Djoffe Software 1993 "; : COLOR 14: PRINT "      "
LOCATE , 21: PRINT "" + SPACE$(37) + ""
LOCATE , 21: PRINT "          "; : COLOR 12: PRINT CHR$(15) + " David Joffe " + CHR$(15); : COLOR 14: PRINT "            "
LOCATE , 21: PRINT "" + STRING$(37, 205) + ""
COLOR 0, 9: LOCATE 21, 23: PRINT STRING$(39, 178)
FOR i = 15 TO 20
  LOCATE i, 60: PRINT ""
NEXT i
SOUND 65, .5: delay .5
'=================================================================
' Wait for keypress
WHILE INKEY$ = "": WEND

COLOR 1, 15
FOR i = 2 TO 21
   ' print string of solid blocks ()
   LOCATE i, 11: PRINT STRING$(62, 219)
   IF i = 13 THEN SOUND 65, .5: delay .45
NEXT i
SOUND 65, .5: delay .5

IntroScreen:
COLOR 14, 0
LOCATE 3, 14: PRINT "" + STRING$(51, 205) + ""
LOCATE , 14: PRINT ""; : COLOR 10: PRINT " ͻ"; : COLOR 13: PRINT "  ͻ                                "; : COLOR 10: PRINT "  ͻ "; : COLOR 14: PRINT ""
LOCATE , 14: PRINT ""; : COLOR 10: PRINT " ͼ"; : COLOR 13: PRINT "      ͻ   ͻ  ͻ ͻ ͻ "; : COLOR 10: PRINT "  ͼ "; : COLOR 14: PRINT ""
LOCATE , 14: PRINT "    "; : COLOR 13: PRINT "                         ͻ "; : COLOR 14: PRINT "      "
LOCATE , 14: PRINT "    "; : COLOR 13: PRINT "  ͼ ͼ     ͼ     ͼ  "; : COLOR 14: PRINT "      "
LOCATE , 14: PRINT "    "; : COLOR 13: PRINT " " + STRING$(19, 205) + " "; : COLOR 14: PRINT "      "
LOCATE , 14: PRINT "" + SPACE$(51) + ""
LOCATE , 14: PRINT ""; : COLOR 12: PRINT SPACE$(15) + "1.  Play Doiley II                 "; : COLOR 14: PRINT " "
LOCATE , 14: PRINT "" + SPACE$(51) + ""
LOCATE , 14: PRINT ""; : COLOR 12: PRINT SPACE$(15) + "2.  View High Scores                "; : COLOR 14: PRINT ""
LOCATE , 14: PRINT "" + SPACE$(51) + ""
LOCATE , 14: PRINT ""; : COLOR 12: PRINT SPACE$(15) + "3.  Instructions                    "; : COLOR 14: PRINT ""
LOCATE , 14: PRINT "" + SPACE$(51) + ""
LOCATE , 14: PRINT ""; : COLOR 12: PRINT SPACE$(15) + "4.  Quit                            "; : COLOR 14: PRINT ""
LOCATE , 14: PRINT ""; : COLOR 10: PRINT " ͻ                                           ͻ "; : COLOR 14: PRINT ""
LOCATE , 14: PRINT ""; : COLOR 10: PRINT " ͼ        "; : COLOR 9: PRINT "(C) Djoffe Software 1993"; : COLOR 10: PRINT "           ͼ "; : COLOR 14: PRINT ""
LOCATE , 14: PRINT "" + STRING$(51, 205) + ""
COLOR 0, 9: LOCATE 20, 16: PRINT STRING$(52, 178)
FOR i = 4 TO 19
  LOCATE i, 67: PRINT ""
NEXT i
SOUND 65, .5: delay .5

HaveWonTrue = 0

' Intro here, I think, should actually be "Menu"
IntroLoop:
  ' read keyboard
  a$ = INKEY$
  SELECT CASE a$
    CASE "": GOTO IntroLoop
    CASE "1": GOTO PlayDoiley
    CASE "2": GOTO HighScoreDraw
    CASE "3": GOTO Instructions
    CASE "4": GOTO QuitDoiley
  END SELECT
GOTO IntroLoop

Instructions:
  GOSUB ClearScreen
  COLOR 14, 0
  LOCATE 2, 10: PRINT "ͻ " + STRING$(52, 205) + " ͻ"
  LOCATE , 10: PRINT "ͼ "; : COLOR 13: PRINT "          ͻ          ͻ                      "; : COLOR 14: PRINT "  ͼ"
  LOCATE , 10: PRINT "ͼ"; : COLOR 13: PRINT "               ͻ ͻ     ͻ             "; : COLOR 14: PRINT " ͻ"
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "                             ͼ                  "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "              ͼ ͼ   ͼ ͹              "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "            " + STRING$(32, 205) + "              "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 12: PRINT "                         ver 2.00                           "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 10: PRINT "                   (C) Djoffe Software                      "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT "" + SPACE$(60) + ""
  LOCATE , 10: PRINT ""; : COLOR 11: PRINT "    " + STRING$(52, 45) + "    "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 11: PRINT "     The aim of Doiley is to arrange the letters in the     "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 11: PRINT "    grid in alphabetical order. Use the keys to position    "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 11: PRINT "     the cursor over the piece you would like to shift.     "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 11: PRINT "        Then hit your 'Shuffle' button and the piece        "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 11: PRINT "                   will slide into place.                   "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 11: PRINT "    " + STRING$(52, 45) + "    "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT "ͻ" + SPACE$(52) + "ͼ"
  LOCATE , 10: PRINT "ͻ " + SPACE$(52) + " ͻ"
  LOCATE , 10: PRINT "ͼ " + STRING$(52, 205) + " ͼ"
  COLOR 0, 9: LOCATE 21, 12: PRINT STRING$(62, 178)
  FOR i = 3 TO 20
    LOCATE i, 72: PRINT ""
  NEXT i
  SOUND 65, .5
  COLOR 9, 0
 
  gr = 15
  ' Here is an example of bad programming. When I first started
  ' programming, the value of meaningful identifier names hadn't
  ' quite sunk in yet :-)
LoopiDeLoop:
    ' Waits for keypress while animating little blue block
    a$ = INKEY$
    LOCATE 19, gr: PRINT " ": LOCATE 19, 80 - gr + 1: PRINT " "
    gr = gr + 1
    IF gr = 41 THEN gr = 15
    LOCATE 19, gr: PRINT "": LOCATE 19, 80 - gr + 1: PRINT ""
    delay .01
    IF a$ <> "" THEN
      GOSUB ClearScreen
      GOTO IntroScreen
    END IF
GOTO LoopiDeLoop

' Hmmm... seems I spent most the time in this program drawing fancy
' screens.
QuitDoiley:
  GOSUB ClearScreen
  COLOR 14, 0
  LOCATE 2, 10: PRINT "ͻ " + STRING$(52, 205) + " ͻ"
  LOCATE , 10: PRINT "ͼ                    Quitting ...                      ͼ"
  LOCATE , 10: PRINT "ͼ"; : COLOR 13: PRINT "          ͻ          ͻ                      "; : COLOR 14: PRINT " ͻ"
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "                   ͻ ͻ     ͻ                  "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "                             ͼ                  "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "              ͼ ͼ   ͼ ͹              "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "            " + STRING$(32, 205) + "              "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 10: PRINT "                         ver 2.00                           "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 9: PRINT "                   (C) Djoffe Software                      "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT "" + SPACE$(60) + ""
  LOCATE , 10: PRINT ""; : COLOR 12: PRINT "  ͻ                           ͻ            ͻ   "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 12: PRINT "  ͹ͻͻ       ͻ      ͻ  ͻͻ  ͼ   "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 12: PRINT "            ͹ͼͼ    ͼͼ           "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 12: PRINT "                  ͼ                                     "; : COLOR 14: PRINT ""
  t$ = SPACE$(22) + ""
  LOCATE , 10: PRINT "" + SPACE$(19) + "             ͻ" + t$
  LOCATE , 10: PRINT "" + SPACE$(19) + "         ͻ  " + t$
  LOCATE , 10: PRINT "" + SPACE$(19) + " ͹       " + t$
  LOCATE , 10: PRINT "ͻ                ͼ      ͼ " + SPACE$(18) + "ͼ"
  LOCATE , 10: PRINT "ͻ                             ͼ" + SPACE$(18) + " ͻ"
  LOCATE , 10: PRINT "ͼ " + STRING$(52, 205) + " ͼ"
  COLOR 0, 9: LOCATE 22, 12: PRINT STRING$(62, 178)
  FOR i = 3 TO 21
    LOCATE i, 72: PRINT ""
  NEXT i
  SOUND 65, .5
QuitLoop:
    a$ = INKEY$
    SELECT CASE a$
      CASE "": GOTO QuitLoop
      CASE "Y", "y"
        COLOR 1, 15
        FOR i = 2 TO 22
          LOCATE i, 10: PRINT STRING$(64, 219)
        NEXT i
        SOUND 65, .5
        COLOR 15, 0: CLS
        t$ = "        "
        PRINT t$ + "" + STRING$(58, 205) + ""
        PRINT t$ + "" + SPACE$(19) + "Thank you for playing" + SPACE$(18) + ""
        PRINT t$ + "       ͻ          ͻ                       "
        PRINT t$ + "            ͻ ͻ     ͻ                     "
        PRINT t$ + "                      ͼ                     "
        PRINT t$ + "       ͼ ͼ   ͼ ͹          "
        PRINT t$ + "      " + STRING$(32, 205) + "" + SPACE$(19) + ""
        PRINT t$ + "         From all of us here at Djoffe Software,          "
        PRINT t$ + "" + SPACE$(19) + "HAVE A NICE DAY!" + SPACE$(23) + ""
        PRINT t$ + "" + STRING$(58, 205) + ""
        PRINT
        ' Addition March 1997:
        COLOR 15, 0
        PRINT t$ + ""
        COLOR 14, 0
        PRINT t$ + "  ۲  Notes added March 1997:  ۲ "
        COLOR 10, 0
        PRINT t$ + "  Djoffe Software is no more; due to people's "
        PRINT t$ + "  general inability to pronounce it correctly."
        COLOR 12, 0
        PRINT t$ + "  It is now called DJ Software.               "
        COLOR 11, 0
        PRINT t$ + " -- Author info: -----------------------------"
        COLOR 9, 0
        PRINT t$ + "   David Joffe                               "
        PRINT t$ + "   http://www.scorpioncity.com/              "
        COLOR 15, 0
        PRINT t$ + ""
        END
      CASE "N", "n"
        COLOR 1, 15
        FOR i = 2 TO 22
          LOCATE i, 10: PRINT STRING$(64, 219)
        NEXT i
        SOUND 65, .5: delay .5
        GOTO IntroScreen
    END SELECT
GOTO QuitLoop

PlayDoiley:
  GOSUB ClearScreen
  COLOR 14, 0
  LOCATE 7, 15: PRINT "" + STRING$(49, 205) + ""
  LOCATE , 15: PRINT " ͻ              ͻ                 "
  LOCATE , 15: PRINT " ͻ ͻ             ͻ    "
  LOCATE , 15: PRINT " ͼ     ͼ               ͹   "
  LOCATE , 15: PRINT "            ͻ                      ͼ   "
  LOCATE , 15: PRINT "              ͻ ͻ  ͹" + SPACE$(18) + ""
  LOCATE , 15: PRINT "            ͼ       ͼ               "
  LOCATE , 15: PRINT "" + STRING$(49, 205) + ""
  COLOR 0, 9: LOCATE 15, 17: PRINT STRING$(51, 178)
  FOR i = 8 TO 15
    LOCATE i, 66: PRINT ""
  NEXT i
  SOUND 65, .5: delay .5

  ' Create grid unshuffled
  tel = 1
  FOR i = 1 TO 4
    FOR z = 1 TO 4
      rand(i, z) = tel
      tel = tel + 1
      NEXT z
  NEXT i
 
  ' This .. um .. er .. shuffles the grid.
  x = 4: y = 4
  FOR i = 1 TO 2000
RandomANumber:
    num = INT(RND * 4) + 1
    ' Generate a random direction to shuffle space
    SELECT CASE num
      CASE 1: xd = 1: yd = 0
      CASE 2: xd = -1: yd = 0
      CASE 3: xd = 0: yd = 1
      CASE 4: xd = 0: yd = -1
    END SELECT
Shuffle:
    IF x + xd > 4 OR y + yd > 4 OR x + xd < 1 OR y + yd < 1 THEN GOTO RandomANumber
    SWAP rand(x, y), rand(x + xd, y + yd)
    x = x + xd: y = y + yd
  NEXT i

  ' Get the space back to the corner
  WHILE x < 4
    SWAP rand(x, y), rand(x + 1, y): x = x + 1
  WEND
  WHILE y < 4
    SWAP rand(x, y), rand(x, y + 1): y = y + 1
  WEND

  GOSUB ClearScreen
  COLOR 14, 0
  LOCATE 3, 8: PRINT "ͻ"
  FOR ii = 1 TO 3
    FOR i = 1 TO 3
      LOCATE , 8: PRINT "                                    "
    NEXT i
    LOCATE , 8: PRINT "Ķ"
  NEXT ii
  FOR i = 1 TO 3
    LOCATE , 8: PRINT "                                    "
  NEXT i
  LOCATE , 8: PRINT "ͼ"
  COLOR 0, 9: LOCATE 20, 10: PRINT STRING$(41, 178)
  FOR i = 4 TO 19
    LOCATE i, 49: PRINT ""
  NEXT i

  LOCATE 16, 40: PRINT ""; : COLOR 13, 0: PRINT "Ŀ"; : COLOR 0, 9: PRINT ""
  LOCATE , 40: PRINT ""; : COLOR 13, 0: PRINT ""; : COLOR 0, 9: PRINT "   "; : COLOR 13, 9: PRINT ""; : COLOR 0, 9: PRINT " "
  LOCATE , 40: PRINT ""; : COLOR 13, 0: PRINT ""; : COLOR 13, 9: PRINT ""; : COLOR 0, 9: PRINT " "

  SOUND 65, .5: delay .5

  COLOR 14, 0
  LOCATE 12
  t$ = ""
  LOCATE , 55: PRINT "" + t$ + ""
  FOR i = 1 TO 6
    LOCATE , 55: PRINT "                "
  NEXT i
  LOCATE , 55: PRINT "" + t$ + ""
  COLOR 10
  LOCATE 13, 56: PRINT "ͻ          "
  LOCATE , 56: PRINT "  ͻͻ  "
  LOCATE , 56: PRINT "ͼͼ ͹"
  LOCATE , 56: PRINT "ͼ"
  LOCATE , 56: PRINT "              "
  LOCATE , 56: PRINT ""

  COLOR 0, 9: LOCATE 20, 57: PRINT STRING$(18, 178)
  FOR i = 13 TO 20
    LOCATE i, 73: PRINT ""
  NEXT i
  SOUND 65, .5: delay .5

  COLOR 14, 0
  LOCATE 3, 55: PRINT "" + t$ + ""
  LOCATE , 55: PRINT "  Your Time:    "
  LOCATE , 55: PRINT "" + t$ + ""
  FOR i = 1 TO 3
  LOCATE , 55: PRINT "                ": NEXT i
  LOCATE , 55: PRINT "" + t$ + ""
  Speed = -1: GOSUB SpeedUpDate
  COLOR 0, 9: LOCATE 10, 57: PRINT STRING$(18, 178)
  FOR i = 4 TO 10
    LOCATE i, 73: PRINT ""
  NEXT i
  SOUND 65, .5: delay .5

  COLOR 15, 0
  FOR i = 5 TO 17 STEP 4
     FOR z = 13 TO 43 STEP 10
       grid$(i, z) = CHR$(rand((i - 1) / 4, (z - 3) / 10) + 64)
       LOCATE i, z: IF grid$(i, z) <> "P" THEN PRINT grid$(i, z)
     NEXT z
  NEXT i

  grid$(17, 43) = " "
  COLOR 0, 9: LOCATE 17, 43: PRINT " "

  x = 17: y = 43
  p = 17: t = 43
  winner = 0: Speed = 0: HaveWonTrue = 0
  t$ = TIME$

MainLoop:
    ' Stop counting seconds at 1000
    IF Speed < 1000 THEN GOSUB ChkTime
    a$ = INKEY$
    SELECT CASE a$
      CASE "": GOTO MainLoop
      ' left
      CASE CHR$(0) + "K": xd = 0: yd = -10: GOTO UpdateCursor
      ' right
      CASE CHR$(0) + "M": xd = 0: yd = 10: GOTO UpdateCursor
      ' up
      CASE CHR$(0) + "H": xd = -4: yd = 0: GOTO UpdateCursor
      ' down
      CASE CHR$(0) + "P": xd = 4: yd = 0: GOTO UpdateCursor
      ' escape
      CASE CHR$(27): GOSUB ClearScreen: GOTO IntroScreen
      CASE " ": GOTO Swop
    END SELECT
  GOTO MainLoop

UpdateCursor:
  IF Speed < 1000 THEN GOSUB ChkTime
  IF x + xd > 17 OR x + xd < 5 OR y + yd > 43 OR y + yd < 13 THEN GOTO MainLoop
  GOSUB ChkStateOfCursor
  x = x + xd: y = y + yd
  IF grid$(x, y) = " " THEN
    COLOR 0, 9
    LOCATE x - 1, y - 3: PRINT ""; : COLOR 13, 0: PRINT "Ŀ"; : COLOR 0, 9: PRINT ""
    LOCATE x, y - 3: PRINT ""; : COLOR 13, 0: PRINT ""; : COLOR 0, 9: PRINT "   "; : COLOR 13, 9: PRINT ""; : COLOR 0, 9: PRINT " "
    LOCATE x + 1, y - 3: PRINT ""; : COLOR 13, 0: PRINT ""; : COLOR 13, 9: PRINT ""; : COLOR 0, 9: PRINT " "
  ELSE
    COLOR 13, 0: LOCATE x - 1, y - 2: PRINT "Ŀ"
    LOCATE x, y - 2: PRINT "": LOCATE x, y + 2: PRINT ""
    LOCATE x + 1, y - 2: PRINT ""
  END IF

' All these GOTO's are BAD PROGRAMMING!!!
GOTO MainLoop

ChkStateOfCursor:
  IF grid$(x, y) <> " " THEN
    LOCATE x - 1, y - 2: PRINT "     "
    LOCATE x, y - 2: PRINT " ": LOCATE x, y + 2: PRINT " "
    LOCATE x + 1, y - 2: PRINT "     "
  END IF
  IF grid$(x, y) = " " THEN
    COLOR 0, 9

    LOCATE x - 1, y - 2: PRINT ""
    LOCATE x, y - 2: PRINT ""
    LOCATE x, y + 2: PRINT " "
    LOCATE x + 1, y - 2: PRINT "    "
  END IF
RETURN

Swop:
  IF Speed < 1000 THEN GOSUB ChkTime
  IF grid$(x - 4, y) = " " THEN SWAP grid$(x - 4, y), grid$(x, y): xd = -4: yd = 0: GOTO Redraw
  IF grid$(x + 4, y) = " " THEN SWAP grid$(x + 4, y), grid$(x, y): xd = 4: yd = 0: GOTO Redraw
  IF grid$(x, y - 10) = " " THEN SWAP grid$(x, y - 10), grid$(x, y): xd = 0: yd = -10: GOTO Redraw
  IF grid$(x, y + 10) = " " THEN SWAP grid$(x, y + 10), grid$(x, y): xd = 0: yd = 10: GOTO Redraw
GOTO MainLoop

Redraw:
  IF Speed < 1000 THEN GOSUB ChkTime
  COLOR 0, 9
  LOCATE x - 1, y - 3: PRINT ""; : COLOR 13, 0: PRINT "Ŀ"; : COLOR 0, 9: PRINT ""
  LOCATE x, y - 3: PRINT ""; : COLOR 13, 0: PRINT ""; : COLOR 0, 9: PRINT "   "; : COLOR 13, 9: PRINT ""; : COLOR 0, 9: PRINT " "
  LOCATE x + 1, y - 3: PRINT ""; : COLOR 13, 0: PRINT ""; : COLOR 13, 9: PRINT ""; : COLOR 0, 9: PRINT " "
  COLOR 15, 0
  LOCATE x + xd - 1, y + yd - 4: PRINT "         "
  LOCATE x + xd, y + yd - 4: PRINT "    "; grid$(x + xd, y + yd); "    "
  LOCATE x + xd + 1, y + yd - 4: PRINT "         "

  ' Check if puzzle is solved
  count = 0: count2 = 0
  FOR i = 5 TO 17 STEP 4
    FOR z = 13 TO 43 STEP 10
      count2 = count2 + 1
      IF (ASC(grid$(i, z)) = count2 + 64) OR (i = 17 AND z = 43 AND grid$(i, z) = " ") THEN count = count + 1
    NEXT z
  NEXT i
  IF count = 16 THEN GOTO YouHaveWon
GOTO MainLoop

' Update the time taken display
SpeedUpDate:
  COLOR 12, 0
  Speed = Speed + 1
  sprint$ = STR$(Speed)
  lsprint = LEN(sprint$)
  sprint$ = RIGHT$(sprint$, lsprint - 1)
  lsprint = LEN(sprint$)
  FOR i = 1 TO lsprint
    sy = 67 - ((lsprint - i) * 5)
    LOCATE 6
    SELECT CASE MID$(sprint$, i, 1)
      CASE "0"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "  "
        LOCATE , sy: PRINT "ͼ"
      CASE "1"
        LOCATE , sy: PRINT " ͻ "
        LOCATE , sy: PRINT "   "
        LOCATE , sy: PRINT " "
      CASE "2"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "ͼ"
        LOCATE , sy: PRINT "ͼ"
      CASE "3"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT " ͹"
        LOCATE , sy: PRINT "ͼ"
      CASE "4"
        LOCATE , sy: PRINT "   "
        LOCATE , sy: PRINT "   "
        LOCATE , sy: PRINT ""
      CASE "5"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "ͼ"
      CASE "6"
        LOCATE , sy: PRINT "   "
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "ͼ"
      CASE "7"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "   "
        LOCATE , sy: PRINT "   "
      CASE "8"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "͹"
        LOCATE , sy: PRINT "ͼ"
      CASE "9"
        LOCATE , sy: PRINT "ͻ"
        LOCATE , sy: PRINT "͹"
        LOCATE , sy: PRINT "ͼ"
    END SELECT
  NEXT i
RETURN

ChkTime:
  t2$ = TIME$
  ' If TIME$ hasn't changed:
  IF t$ = t2$ THEN RETURN
  ' If TIME$ has changed:
  t$ = t2$: GOSUB SpeedUpDate
RETURN

YouHaveWon:
  COLOR 1, 15
  FOR i = 2 TO 22
    LOCATE i, 8: PRINT STRING$(67, 219)
  NEXT i
 
  ' Check if you've made the high score list
  ' If so, insert your score
  HaveWonTrue = 0
  FOR i = 1 TO 10
    IF Speed <= hight(i) THEN
      HaveWonTrue = i
      ' Move all other scores below yours one down
      FOR j = 9 TO i STEP -1
        high$(j + 1) = high$(j)
        hight(j + 1) = hight(j)
      NEXT j
      hight(i) = Speed
      EXIT FOR
    END IF
  NEXT i
GOTO HighScoreDraw

' Handler that creates default high score table
MakeNewHighScoreList:
  OPEN "doiley2.hst" FOR OUTPUT AS #1
    FOR i = 1 TO 10: PRINT #1, CHR$(34) + "Joe Schmuck" + CHR$(34): PRINT #1, 999: NEXT i
  CLOSE
RESUME

HighScoreDraw:
  GOSUB ClearScreen
  COLOR 14, 0
  LOCATE 2
  LOCATE , 10: PRINT "" + STRING$(59, 205) + ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "  ͻ                   ͻ                      "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "                                                      "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "   ͹ ͻ ͻ                 ͻ ͻ ͻ   "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "        ͼ ͻ                     ͼ ͻ   "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT ""; : COLOR 13: PRINT "  ͼ  ͼ                 ͼ    "; : COLOR 14: PRINT ""
  LOCATE , 10: PRINT "" + STRING$(46, 196) + "Ķ"
  LOCATE , 10: PRINT "" + SPACE$(46) + "            "
  FOR i = 1 TO 9
    LOCATE , 10: PRINT ""; : COLOR 12: PRINT " " + STR$(i) + "." + SPACE$(42); : COLOR 14: PRINT "            "
  NEXT i
  LOCATE , 10: PRINT ""; : COLOR 12: PRINT " 10." + SPACE$(42); : COLOR 14: PRINT "            "
  LOCATE , 10: PRINT "" + SPACE$(46) + "            "
  LOCATE , 10: PRINT "" + STRING$(46, 205) + "ͼ"
  COLOR 12, 0
 
  FOR i = 1 TO 10
    ' If most recent high score list, then hi-lite it green
    IF i = HaveWonTrue THEN COLOR 10 ELSE COLOR 12
    LOCATE i + 9, 61: PRINT hight(i)
    COLOR 12, 0
    IF i <> HaveWonTrue THEN LOCATE i + 9, 16: PRINT high$(i)
  NEXT i
 
  COLOR 0, 9: LOCATE 22, 12: PRINT STRING$(61, 178)
  FOR i = 3 TO 21
    LOCATE i, 71: PRINT ""
  NEXT i
 
  SOUND 65, .5: delay .5
  IF HaveWonTrue <> 0 THEN
    COLOR 10, 0: LOCATE HaveWonTrue + 9, 15: PRINT SPACE$(41)
    LOCATE HaveWonTrue + 9, 15: INPUT " ", high$(HaveWonTrue)
    ' Save high score list
    OPEN "doiley2.hst" FOR OUTPUT AS #1
      FOR i = 1 TO 10: PRINT #1, CHR$(34) + high$(i) + CHR$(34): PRINT #1, hight(i): NEXT i
    CLOSE
    COLOR 12, 0: LOCATE HaveWonTrue + 9, 16: PRINT high$(HaveWonTrue)
    LOCATE HaveWonTrue + 9, 61: PRINT hight(HaveWonTrue)
  END IF
  ' Wait for keypress
  WHILE INKEY$ = "": WEND
  GOSUB ClearScreen
GOTO IntroScreen

ClearScreen:
  COLOR 1, 15
  FOR i = 2 TO 22
    LOCATE i, 6: PRINT STRING$(70, 219)
  NEXT i
  SOUND 65, .5: delay .5
RETURN

SUB delay (ticks!)
s! = TIMER
f:
d! = TIMER: IF d! < s! + ticks! THEN GOTO f
END SUB

