; =====================================
; ===  ELFISH INSTALLATION PROGRAM  ===
; ===            06-23-93           ===
; =====================================
@prod = "ELFISH"         ; name of the product
@path = "C:\ELFISH"      ; starting destination subdirectory
@source = "DATA"         ; source subdirectory
@prefix = "XX"           ; DLL-prefix
@bakext = "EF~"          ; BAK-file name extension
@mode480 = 1
; =====================================
#HEADER 640x480 EL-FISH INSTALLATION PROGRAM
#AIUTO  << ELFISH >>
#VERSION (C) AnimaTek (RUSSIA) *** 1993
; =====================================
#DISKNAME ^
ELFISH.$09    "Install Disk # 1"
ELFISH.$05    "Disk # 2"
VIEWER.$03    "Disk # 3"
MELONHED.$02  "Disk # 4"
ELFISH.$04    "Disk # 5"
#
#FULLLIFT
; =====================================
:START
@PACKMODE = 4         ; starting packing bitmode:
		      ; xx1 - regular VGA
		      ; x1x - HI-resolution SVGA
		      ; 1xx - sound-card support

#GOSUB HARDWARE_TEST  ; test mouse , i386, i387, VGA, and RAM > 3700K.
		      ; Changes @PACKMODE
; =====================================
#AIUTO KEYS:  - select; \"Enter\" - confirm

:START1
#TEXT 0 3 53

~GREETINGS!
~Welcome to the El-Fish
~Installation Program

~You are installing the 640 x 480 screen
~mode El-Fish version.

~ATTENTION !
~Be sure that your video card supports this mode
~and contains at least 1 megabyte (MB) of video RAM. 

#
#MENU 0 -1 0 [ WHAT DO YOU WANT TO DO? ]
     START THE INSTALLATION
     ABORT THE INSTALLATION
#
#TEXTOFF
#IF @reply = 0 GOTO START1
#IF @reply = 27 #ABORT
#IF @reply = 2 #ABORT
#IF @reply = 27 GOTO START1

#GOSUB ASKOFMODE

; ===== Greating and Ask for User name
:ENTRY_OWNER
#PROMPT ""
#GETLINE @owner 0 3 57 [ EL-FISH ]

~GREETINGS!
~Welcome to the El-Fish
~Installation Program

~Please introduce yourself by entering
~your name below.
~The name you enter will identify you as
~the author of each fish, tank or object
~you create in El-Fish.

#

#PROMPT ""
#IF @reply = 27 #ABORT
#IF @reply = 27 goto ENTRY_OWNER
#if @owner = "" goto ENTRY_OWNER

; ==== Checking of the video-card presence
@PACKMODE += 8
#if @PACKMODE & 1 GOTO INSTALL_PREPARE

; =====================================
; ===     Installation Process      ===
; =====================================
:INSTALL_PREPARE
#IF @PACKMODE ^ 1 @PACKMODE += 4
#IF @PACKMODE & 1 @PACKMODE -= 4

#IF @PACKMODE & 4 GOTO hiinstall
  @message = INSTALLING REGULAR RESOLUTION VERSION
#GOTO TAKE_DESTINAT
:hiinstall
  @message = INSTALLING HIGH-RESOLUTION VERSION

; ==== Take the distination Subdirectory
:TAKE_DESTINAT
#PROMPT EL-FISH DESTINATION PATH
#AIUTO @message
#BEEP

; === Get destination path
:GET_DST_PATH
#GETPATH @path 0 3 0 [ ENTER EL-FISH PATH ]

~Please enter the drive and directory
~where you want El-Fish to be
~installed, then press "Enter".

~To stop the installation, press "Escape".

#
#if @reply=27 #ABORT
#if @reply=27 GOTO GET_DST_PATH

#CHECKDIR @path
; Returns -1 - incorr subdir name
; 0 - O.K.
; 1 - subdir is just exist

#IF @reply = 0 GOTO RUN_INSTALLATION
#IF @reply = -1 GOTO ILLEGAL_SUBDIR

#AIUTO KEYS:  - select; \"Enter\" - confirm

#TEXT 0 3 53

~This directory already exists!

#
#MENU 0 -1 0 [ WHAT DO YOU WANT TO DO? ]
 CHOOSE ANOTHER DIRECTORY
 OVERWRITE THIS DIRECTORY
 ABORT THE INSTALLATION
#
#TEXTOFF
#IF @reply = 3 #ABORT
#IF @reply = 3 GOTO TAKE_DESTINAT
#IF @reply = 1 GOTO TAKE_DESTINAT
#IF @reply = 2 GOTO RUN_INSTALLATION
#ABORT

:ILLEGAL_SUBDIR
#AIUTO KEYS:  - select; \"Enter\" - confirm

#TEXT 0 3 53

~This El-Fish PATH is ILLEGAL!

#
#MENU 0 -1 0 [ WHAT DO YOU WANT TO DO? ]
 CHOOSE ANOTHER DIRECTORY
 ABORT THE INSTALLATION
#
#TEXTOFF
#IF @reply = 2 #ABORT
#GOTO TAKE_DESTINAT


; ======== INSTALLATION EXECUTING
:RUN_INSTALLATION
#PROMPT "INSTALLING EL-FISH"
#AIUTO KEYS: Press \"Esc\" to abort

#MKDIR ; make path directory
#TEXT 0 0 0

~COPYING
~RECONFIG.EXE

#
#COPY #"INST_480.EXE"  >RECONFIG.EXE
#TEXTOFF

#TEXT 0 0 0

~COPYING
~INFO.EXE

#
#COPY #"INFO.EXE"  >
#TEXTOFF

#TEXT 0 0 0

~COPYING
~BOOTDISK.COM

#
#COPY #"BOOTDISK.COM"  >
#TEXTOFF

#TEXT 0 0 0

~COPYING
~AUTOEXEC.000

#
#COPY #"AUTOEXEC.000"  >
#TEXTOFF

#TEXT 0 0 0

~COPYING
~CONFIG.000

#
#COPY #"CONFIG.000"  >
#TEXTOFF

#TEXT 0 0 0

~COPYING
~CONFIG.001

#
#COPY #"CONFIG.001"  >
#TEXTOFF

#TEXT 0 0 0

~COPYING
~BOOTSTAC.COM

#
#COPY #"BOOTSTAC.COM"  >
#TEXTOFF

#TEXT 0 0 0

~COPYING
~READ.ME

#
#COPY #"READ.ME"  >
#TEXTOFF

; ----------
#CHDIR @path

#UNPACK 100000 ELFISH.PKD

; =====================================
; == Final Post-installational Dialogue
; =====================================
@message KEYS:  Choose the proper card and press \"Enter\"
#GOSUB  CHOOSE_SOUNDCARD
#GOSUB  CHOOSE_VIDEOCARD
#PROMPT ""

#GOSUB  MAKE_AUTOEXEC
#GOSUB  MAKE_CONFIGSYS

; ==== End of Work
:FINISH
#CHDIR                ; change final directory
#SETUP "ELFISH.INS"   ; write the ELFISH.INS user name

#BEEP

#IF @errors = 0 GOTO Final
#DELETE "INSTALL.ERR"
;#TOFILE "INSTALL.ERR"
;
;            Installation of El-Fish is complete.
;         You may need to modify your AUTOEXEC.BAT or
;         CONFIG.SYS files for El-Fish to run properly.
;               See the Addendum for details.
;
;#

;#PROMPT "WARNING!!! "@errors" ERROR DETECTED"
;#FILELIST 67 20 "INSTALL.ERR"
#GOSUB SEE_READ_ME_FILE
#EXIT
;-------------------------

; ==== Final Message
:Final
#PROMPT "FINish... I mean, FIniSH"
#TEXT ^ 0 3 67

~El-Fish has successfully installed.
~If you have any problem running EL-FISH
~on your computer the READ.ME file can help you.

~Don't smell fish--PLAY EL-FISH.

~Press any key to continue.

#

#GOSUB SEE_READ_ME_FILE

; #RESTART  ; reboot system
:quit
#EXIT

;Ŀ
;   SUBRUUTINES:   Hardware Testing On Entry          
;
:HARDWARE_TEST
; === check mouse driver
#if @mouse > 0 GOTO MSOK
#text ^ 0 0 0

~WARNING!!!
~There is no mouse driver installed.
~El-Fish requires a mouse.
~Please install a mouse and driver
~before starting El-Fish.

#
:MSOK

; === check cpu80386-card presence
#if @is386 > 0 GOTO CPUOK
#text ^ 0 0 0

~WARNING!!!
~El-Fish requires a 386 or higher
~microprocessor to run.
~You cannot run El-Fish on this computer.

#
#ABORT
:CPUOK

; === check VGA-card presence
#if @isvga > 0 GOTO VGAOK
#text ^ 0 0 0

~WARNING!!!
~El-Fish requires VGA graphics to run.
~You cannot run El-Fish on this computer.

#
#ABORT
:VGAOK

; === check minimal RAM-size
#if @ramsize > 3600 GOTO RAMOK
#text ^ 0 0 0

~WARNING!!!
~El-Fish requires 4MB RAM to run.
~You cannot run El-Fish on this computer.

#
#ABORT
:RAMOK

; === Check math-coprocessor presence
; #if @is87 > 0 GOTO OKi87
; :OKi87

#RETURN ;HARDWARE_TEST

;Ŀ
;     Ask for Normal / HI-resolution mode choice      
;
:ASKOFMODE
#VIDEOTEST
#if @reply ! 0 #RETURN;

#TEXT ^ 0 3 53

~Sorry !
~Your video card isn't supported by El-Fish
~for the 640 x 480 DOS screen resolution !!!
~Please run INSTALL.EXE for REGULAR resolution.
~Installation will be aborted !

#
#TEXTOFF
#EXIT
#RETURN

;Ŀ
;       Correction of the AUTOEXEC.BAT - file         
;
:MAKE_AUTOEXEC
; Specification of the suspicial keywords
;#KEYWORDS  "\r
;WARNING!!! El-Fish may not be compatible with the following\n\r
;  program(s) in your AUTOEXEC.BAT file:"
;  EMM386
;  386MAX
;#
#AUTOEXEC  ^ ;<= not correct an AUTOEXEC.BAT file but search
	     ; for keywords only
#IF @reply = 0 #RETURN
@errors = @errors + 1;
#TOFILE  "INSTALL.ERR"
  WARNING!!! Your AUTOEXEC.BAT file has been modified.
  Your original AUTOEXEC has been saved as AUTOEXEC.OLD
#
#IF @reply = 0 #RETURN
#TOFILE  "INSTALL.ERR"
    Your PATH statement is too long.
    Please change it to have less then 128 characters.
#
#RETURN ;

;Ŀ
;         Correction of the CONFIG.SYS - file         
;
:MAKE_CONFIGSYS
; Specification of the suspicial keywords
;#KEYWORDS "\r
;WARNING!!! El-Fish may not be compatible with the following\n\r
;  program(s) in your CONFIG.SYS file:"
;  EMM386
;  386MAX
;#

#CONFIGSYS ^ 20 32
#IF @reply = 0 #RETURN

#TEXT  0 3 53

~For EL-FISH to run properly,
~your CONFIG.SYS file needs to be changed so
~that FILES = 20 and BUFFERS = 32.
~EL-FISH can make this change for you or
~you can change it manually later.

#
#MENU 0 -1 25 [ ? ]
  LET EL-FISH MAKE CHANGE
     CHANGE MANUALLY
#
#TEXTOFF
#IF @reply ! 1 GOTO NO_CONFIG_SYS

#CONFIGSYS 20 32

:NO_CONFIG_SYS
#RETURN ;

;Ŀ
;                   Read.ME file observing            
;
:SEE_READ_ME_FILE
#FILELIST 67 20 "READ.ME"
#RETURN ;

; ==== DONE-MESSAGE
:DONE
  #TEXT |800 0 0 39

~D O N E

  #
#RETURN  ;DONE

; ==== MUST-ANSWER MESSAGE
:MUST_ANSWER
#BEEP
#TEXT |2000 0 0 53

~Please choose a card first!

#
#RETURN  ;MUST_ANSWER

; Ŀ
;              Sound-card installation                 
; 
:CHOOSE_SOUNDCARD
  #PROMPT INSTALLING THE SOUND DRIVER
  #BEEP
  #SOUNDTEST
  #SOUNDCARD ^ SYSTEM
  #IF @reply ! 0 GOTO SOUND_DONE
  #GOSUB MUST_ANSWER
  #GOTO CHOOSE_SOUNDCARD
  #RETURN
  :SOUND_DONE
  @reply = 0;
;  #GOSUB DONE
#RETURN  ;CHOOSE_SOUNDCARD

; Ŀ
;              Video-card installation                 
; 
:CHOOSE_VIDEOCARD
  #IF @PACKMODE & 1 #RETURN
  #VIDEOTEST
  #IF @reply = 1 GOTO video_choice
  #PROMPT Select your graphics card
  #AIUTO KEYS:  - select; \"Enter\" - confirm; \"Escape\" - autodetect
  #TEXT  0 9 69
~The Install Program could not identify your graphics card.
~Above are some cards that may be compatible with yours.

~Press "Escape" for AUTODETECT, finish the installation
~and see if El-Fish works.
~If El-Fish doesn't work, run RECONFIG.EXE from
~the ELFISH directory of your hard disk, and try
~another card.
~You may have to experiment and try a few cards.
~If you choose VESA, you may have to install
~a VESA driver v1.2 before running El-Fish.
  #
  :video_choice
  #PROMPT

  #VIDEOCARD
  #TEXTOFF
  #IF @reply ! 0 GOTO VIDEO_DONE
  #GOSUB MUST_ANSWER
  #GOTO CHOOSE_VIDEOCARD
  #RETURN
  :VIDEO_DONE
  #SETUP "ELFISH.INS"   ; write the ELFISH.INS user name
  @reply = 0;
;  #GOSUB DONE
#RETURN  ;CHOOSE_VIDEOCARD

; =====================================
; ===   END of ELFISH INSTALLATION  ===
; =====================================
#END
