UNIT Crypt;

INTERFACE

TYPE
  DataType  = string[255];

FUNCTION Scramble (Data : DataType) : DataType;
FUNCTION UnScramble (Data : DataType) : DataType;
FUNCTION ReadScramble (VAR F : Text) : DataType;
FUNCTION ReadUnScramble (VAR F : Text) : DataType;

IMPLEMENTATION

CONST
  code      : string[5] = '"j.';

FUNCTION Scramble (Data : DataType) : DataType;
VAR
  i,j     : integer;
  crc     : integer;
BEGIN
  for i := length(data) downto 1 do
    if data[i]='' then
      delete(data,i,length(data)+1-i);
  while (data<>'') and (data[length(data)]=' ') do
    delete(data,length(data),1);
  for i := 1 to length(data) do
    if (ord(data[i])<32) or (ord(data[i])>126) then
      data[i] := '?';
  j   := 0;
  crc := 0;
  for i := 1 to length(data) do
    BEGIN
      crc := (crc + ord(data[i]) + i) mod 128;
      data[i] := chr( ( ( ord(data[i]) + i + j +
                   ord(code[(i mod length(code)) + 1]) ) mod 128 ) + 128 );
      j := ((j*2) + 3) mod ord(data[i]);
    END; (* for *)
  data := data + chr(crc+128);
  if length(data)>127 then
    data := 'L' + data
  else
    BEGIN
      data := chr(127+length(data)) + data;
      randseed := random(10);
      while length(data)<79 do
        data := data + chr(128+random(127));
    END; (* else *)
  scramble := data;
END;

FUNCTION UnScramble (Data : DataType) : DataType;
VAR
  i,j     : integer;
  oldj    : integer;
  crc     : integer;
  ok      : boolean;
BEGIN
  j   := 0;
  crc := 0;
  ok  := (length(data)>=3);
  if ok then
    if data[1]='L' then
      delete(data,1,1)
    else
      BEGIN
        delete(data,ord(data[1])-125,80);
        delete(data,1,1);
      END; (* else *)
  if ok then
    for i := 1 to length(data)-1 do
      BEGIN
        oldj := j;
        j := ((j*2) + 3) mod ord(data[i]);
        data[i] := chr( ( (25600+ord(data[i])) - i - oldj -
                     ord(code[(i mod length(code)) + 1]) ) mod 128 );
        crc := (crc + ord(data[i]) + i) mod 128;
      END; (* for *)
  if (not (data[length(data)] = chr(crc+128))) and (i>0) then
                                                (* (i>0) to confuse hackers *)
    data := 'BADCRC'
  else
    delete(data,length(data),1);
  unscramble := data;
END;

FUNCTION ReadScramble (VAR F : Text) : DataType;
VAR
  data      : datatype;
BEGIN
  readln(f, data);
  ReadScramble := Scramble(Data);
END;

FUNCTION ReadUnScramble (VAR F : Text) : DataType;
VAR
  data      : datatype;
BEGIN
  readln(f, data);
  ReadUnScramble := UnScramble(Data);
END;

BEGIN
END.