UNIT Detect;

INTERFACE

CONST
  (* VideoAdapter *)
  MDPA      = 1;
  CGA       = 2;
  EGA       = 3;
  MCGA      = 4;
  VGA       = 5;
  (* SVGAType *)
  NoSVGA    = 0;
  ATI       = 1;
  (* SVGAMemory *)
  SVGA256k  = 256;
  SVGA512k  = 512;
  SVGA1024k = 1024;
  (* MouseCompatibility *)
  NoMouse   = 0;
  None      = 1;
  Partial   = 2;
  Full      = 3;

FUNCTION VideoAdapter : Word;
FUNCTION SVGAType : Word;
FUNCTION SVGAMemory : Word;
FUNCTION MouseButtons : Word;
FUNCTION MouseCompatibility : Word;

IMPLEMENTATION

USES DOS;

FUNCTION Found6845 (address : word) : boolean;
VAR
  realval   : byte;
  randval   : byte;
  tests     : word;
  result    : boolean;
BEGIN
  port[address] := $F;
  realval := port[address+1];

  tests := 0;
  result := true;

  REPEAT
    randval := random(256);
    port[address+1] := randval;
    if port[address+1]<>randval then
      result := false;
    inc(tests);
  UNTIL tests=16;

  port[address+1] := realval;
  found6845 := result;
END;

FUNCTION VideoAdapter : Word;
VAR
  regs      : registers;
  result    : word;
BEGIN
  result := 0;

  (* Check to see if we're in a monochrome mode *)
  if (mem[$40:$49]=7) or (mem[$40:$49]=$F) then
    result := MDPA;

  (* Check to see if the video adapter will identify itself *)
  if result=0 then
    BEGIN
      regs.ax := $1A00;
      intr($10,regs);
      if regs.al=$1A then
        BEGIN
          if regs.bl in [$1,$5,$7,$B] then
            result := MDPA;
          if regs.bl = $2 then
            result := CGA;
          if regs.bl = $4 then
            result := EGA;
          if regs.bl in [$A,$C] then
            result := MCGA;
          if regs.bl = $8 then
            result := VGA;
        END; (* if *)
    END; (* if *)

  (* Check to see if it supports any extended BIOS functions *)
  if result=0 then
    BEGIN
      regs.ah := $12;
      regs.bl := $10;
      intr($10,regs);
      if regs.bl<>$10 then
        result := EGA;
    END; (* if *)

  (* Otherwise, identify it by the location of its 6845 *)
  if result=0 then
    BEGIN
      if found6845($3B4) then
        result := MDPA;
      if found6845($3D4) then
        result := CGA;
    END; (* if *)

  VideoAdapter := result;
END;

FUNCTION SVGAType : Word;
VAR
  regs      : registers;
  id        : string;
  i         : word;
BEGIN
  (* Check for VGA *)
  if VideoAdapter <> VGA then
    BEGIN
      SVGAType := NoSVGA;
      exit;
    END; (* if *)

  (* Check to see if it is an ATI 18800-based VGA *)
  id := '';
  for i := 1 to 9 do
    id := id + chr(mem[$C000:$30+i]);
  if (id='761295520') and ( (chr(mem[$C000:$40])='3') and
                            (chr(mem[$C000:$41])='1') ) then
    BEGIN
      SVGAType := ATI;
      exit;
    END; (* if *)

  SVGAType := NoSVGA;
END;

FUNCTION SVGAMemory : Word;
VAR
  extreg    : word;
  result    : word;
  temp      : integer;
BEGIN
  extreg := memw[$C000:$10];

  CASE SVGAType OF
    NoSVGA    : result := NoSVGA;
    ATI       : BEGIN (* ATI 18800-based VGA *)
                  port[extreg] := $BB;
                  temp := port[extreg+1];
                  if (temp and $20 = $20) then
                    result := SVGA512k
                  else
                    result := SVGA256k;
                END;
  END; (* case *)

  SVGAMemory := result;
END;

FUNCTION MouseButtons : Word;
VAR
  int33vec  : pointer;
  buttons   : word;
  regs      : registers;
BEGIN
  getintvec($33,int33vec);
  regs.ax := 0;
  buttons := 0;
  if int33vec<>nil then
    BEGIN
      intr($33,regs);
      buttons := regs.bx;
    END; (* if *)
  if regs.ax=65535 then
    MouseButtons := buttons
  else
    MouseButtons := 0;
END;

FUNCTION MouseCompatibility : Word;
VAR
  vecseg    : word;
  vecofs    : word;
  oldb      : word;
  oldc      : word;
  oldd      : word;
  basic     : boolean;
  fully     : boolean;
  regs      : registers;
BEGIN
  if MouseButtons=0 then
    MouseCompatibility := NoMouse
  else
    BEGIN
      (* save the old values *)
      regs.ax := $1B;
      intr($33,regs);
      oldb := regs.bx;
      oldc := regs.cx;
      oldd := regs.dx;
      (* determine whether it is at all compatible *)
      regs.ax := $24;
      intr($33,regs);
      basic := (regs.ch in [0..5]);
      (* find the compatibility level *)
      regs.ax := $1A;
      regs.bx := 255;
      regs.cx := 255;
      regs.dx := 255;
      intr($33,regs);
      regs.ax := $1B;
      regs.bx := 256;
      regs.cx := 256;
      regs.dx := 256;
      intr($33,regs);
      vecseg := memw[0:$33*4+2];
      vecofs := memw[0:$33*4+0];
      basic := basic and (regs.bx<>256) and (regs.cx<>256);
      fully := basic and
                    (regs.bx=100) and (regs.cx=100) and (regs.dx=100) and
                    (meml[vecseg-1:vecofs+3]=1919117645);
      (* reset the old values *)
      regs.ax := $1A;
      regs.bx := oldb;
      regs.cx := oldc;
      regs.dx := oldd;
      intr($33,regs);
      (* return a value *)
      if fully then
        MouseCompatibility := full
      else if basic then
        MouseCompatibility := partial
      else
        MouseCompatibility := none;
    END; (* else *)
END;

BEGIN
END.