{$A-}
UNIT Fade;

INTERFACE

TYPE
  paltype   = array[0..15,0..2] of byte;

CONST
  defaultpalette : paltype = ( ($00,$00,$00),    (*  0 *)
                               ($00,$00,$2A),    (*  1 *)
                               ($00,$2A,$00),    (*  2 *)
                               ($00,$2A,$2A),    (*  3 *)
                               ($2A,$00,$00),    (*  4 *)
                               ($2A,$00,$2A),    (*  5 *)
                               ($2A,$15,$00),    (*  6 *)
                               ($2A,$2A,$2A),    (*  7 *)
                               ($15,$15,$15),    (*  8 *)
                               ($15,$15,$3F),    (*  9 *)
                               ($15,$3F,$15),    (* 10 *)
                               ($15,$3F,$3F),    (* 11 *)
                               ($3F,$15,$15),    (* 12 *)
                               ($3F,$15,$3F),    (* 13 *)
                               ($3F,$3F,$15),    (* 14 *)
                               ($3F,$3F,$3F) );  (* 15 *)

VAR
  palette   : paltype;
  lit       : boolean;
  fades     : boolean;

PROCEDURE SetPalette;
PROCEDURE InitPalette;
PROCEDURE FadeIn;
PROCEDURE FadeOut;
PROCEDURE BlackOut;
PROCEDURE SingleFadeIn (i : integer);
PROCEDURE SingleBlackOut (i : integer);
PROCEDURE ColorsOn;
PROCEDURE FindFadeInc;

IMPLEMENTATION

USES CRT, DOS;

VAR
  fadeinc   : word;

PROCEDURE SetPalette;
VAR
  regs      : registers;
  palpoint  : array[0..16] of byte;
  i         : integer;
BEGIN
  if not fades then
    exit;

  (* wait for vertical retrace interval *)
  while port[$3DA] and 8 <> 8 do;

  (* set first 16 DAC entries *)
  regs.ah := $10;
  regs.al := $12;
  regs.bx := $00;
  regs.cx := $10;
  regs.es := seg(palette);
  regs.dx := ofs(palette);
  intr($10,regs);
END;

PROCEDURE InitPointers;
VAR
  regs      : registers;
  palpoint  : array[0..16] of byte;
  i         : integer;
BEGIN
  (* make palette pointers point to first 16 DAC entries *)
  regs.ah := $10;
  regs.al := $02;
  for i := 0 to 15 do
    palpoint[i] := i;
  palpoint[16] := 0;
  regs.es := seg(palpoint);
  regs.dx := ofs(palpoint);
  intr($10,regs);
END;

PROCEDURE FadeOut;
VAR
  i         : integer;
  fadeamount: integer;
  oldpal    : paltype;
  red       : longint;
  green     : longint;
  blue      : longint;
BEGIN
  if not (fades and lit) then exit;
  oldpal := palette;
  for fadeamount := fadeinc-1 downto 0 do
    BEGIN
      for i := 0 to 15 do
        BEGIN
          red   := oldpal[i,0];
          green := oldpal[i,1];
          blue  := oldpal[i,2];
          red   := (red   * fadeamount) div fadeinc;
          green := (green * fadeamount) div fadeinc;
          blue  := (blue  * fadeamount) div fadeinc;
          palette[i,0] := round(red);
          palette[i,1] := round(green);
          palette[i,2] := round(blue);
        END; (* for *)
      setpalette;
    END; (* for *)
  palette := oldpal;
  lit     := false;
END;

PROCEDURE FadeIn;
VAR
  i         : integer;
  fadeamount: integer;
  oldpal    : paltype;
  red       : longint;
  green     : longint;
  blue      : longint;
BEGIN
  if (not fades) or lit then exit;
  oldpal := palette;
  for fadeamount := 1 to fadeinc do
    BEGIN
      for i := 0 to 15 do
        BEGIN
          red   := oldpal[i,0];
          green := oldpal[i,1];
          blue  := oldpal[i,2];
          red   := (red   * fadeamount) div fadeinc;
          green := (green * fadeamount) div fadeinc;
          blue  := (blue  * fadeamount) div fadeinc;
          palette[i,0] := round(red);
          palette[i,1] := round(green);
          palette[i,2] := round(blue);
        END; (* for *)
      setpalette;
    END; (* for *)
  palette := oldpal;
  lit     := true;
END;

PROCEDURE SingleFadeIn (i : integer);
VAR
  fadeamount: integer;
  oldpal    : paltype;
  red       : longint;
  green     : longint;
  blue      : longint;
BEGIN
  if not fades then exit;
  oldpal := palette;
  for fadeamount := 1 to fadeinc do
    BEGIN
      red   := oldpal[i,0];
      green := oldpal[i,1];
      blue  := oldpal[i,2];
      red   := (red   * fadeamount) div fadeinc;
      green := (green * fadeamount) div fadeinc;
      blue  := (blue  * fadeamount) div fadeinc;
      palette[i,0] := round(red);
      palette[i,1] := round(green);
      palette[i,2] := round(blue);
      setpalette;
    END; (* for *)
  palette := oldpal;
  lit     := true;
END;

PROCEDURE SingleBlackOut (i : integer);
VAR
  oldpal    : paltype;
BEGIN
  oldpal := palette;
  palette[i,0] := 0;
  palette[i,1] := 0;
  palette[i,2] := 0;
  setpalette;
  palette := oldpal;
END;

PROCEDURE BlackOut;
VAR
  oldpal    : paltype;
  p, c      : integer;
BEGIN
  oldpal := palette;
  for p := 0 to 15 do
    for c := 0 to 3 do
      palette[p,c] := 0;
  setpalette;
  palette := oldpal;
  lit     := false;
END;

PROCEDURE ColorsOn;
VAR
  oldpal    : paltype;
BEGIN
  oldpal  := palette;
  palette := defaultpalette;
  setpalette;
  palette := oldpal;
  lit     := true;
END;

PROCEDURE InitPalette;
BEGIN
  initpointers;
  palette := defaultpalette;
  setpalette;
  lit := true;
END;

PROCEDURE FindFadeInc;
VAR
  origtime  : word;
BEGIN
  if not fades then exit;
  fadeinc := 0;
  REPEAT
    origtime := memw[$40:$6C];
    REPEAT
      blackout;
      inc(fadeinc);
    UNTIL abs(memw[$40:$6C]-origtime) > 9;
  UNTIL memw[$40:$6C] > origtime;
END;

BEGIN
  palette := defaultpalette;
  lit := true;
  fadeinc := 8;
END.