;   Assembler routines for Turbo Pascal 4.0 unit JoyStk
;   John Haluska  CIS 74000,1106

DATA    SEGMENT    BYTE PUBLIC
        EXTRN      JoyMaxCt : WORD ;Pascal variable for joystick position
DATA    ENDS

CODE    SEGMENT    BYTE PUBLIC
        ASSUME     CS : CODE, DS : DATA
        PUBLIC     JoyStkPos, JoyStkBtn, JoyStkPresent, GetClkTicks

;-----------------------------------------------------------------------------
;procedure JoyStkPos (N : byte; var X,Y : integer);
;          Return X, Y position of joystick 0 or 1

Y       EQU      DWORD PTR [BP+6]  ;position of X, Y pointers
X       EQU      DWORD PTR [BP+10] ;   on stack
N       EQU      BYTE PTR [BP+14]  ;pointer joystick 0 or 1 input

JoyStkPos        PROC  FAR
        PUSH     BP                ;save BP
        MOV      BP,SP             ;set up stack frame
        MOV      DX,201h           ;game adapter address in DX
        MOV      CX,JoyMaxCt       ;for LOOP to setup constant frame time
        MOV      AL,N              ;get joystick number (0 or 1)
        XOR      DI,DI             ;zero
        XOR      SI,SI             ;  registers
        CLI                        ;disable interrupts
        TEST     AL,1              ;joystick 0 or 1?
        JNE      JSP1              ;jump if joystick 1
        OUT      DX,AL             ;fire one shots on game adapter port
NEXT0:  IN       AL,DX             ;read data from game adapter port
        TEST     AL,1              ;is joystick 0 X axis bit = 1?
        JE       DONEX             ;jump if bit = 0 (done)
        INC      DI                ;increment X counter
DONEX:  TEST     AL,2              ;is joystick 0 Y axis bit = 1?
        JE       DONEY             ;jump if bit = 0 (done)
        INC      SI                ;increment Y counter
DONEY:  LOOP     NEXT0             ;repeat MaxCount times
        JMP      JSP2              ;done with joystick 0
JSP1:   OUT      DX,AL             ;fire one shots on game adapter port
NEXT1:  IN       AL,DX             ;read data from game adapter port
        TEST     AL,4              ;is joystick 1 X axis bit = 1?
        JE       DONEX1            ;jump if bit = 0 (done)
        INC      DI                ;increment X counter
DONEX1: TEST     AL,8              ;is joystick 1 Y axis bit = 1?
        JE       DONEY1            ;jump if bit = 0 (done)
        INC      SI                ;increment X counter
DONEY1: LOOP     NEXT1             ;repeat MaxCount times
JSP2:   STI                        ;enable interrupts
        CMP      DI,JoyMaxCt       ;X axis = MaxCount?
        JNE      JSP3              ;no
        XOR      DI,DI             ;yes, zero output
JSP3:   CMP      SI,JoyMaxCt       ;Y axis = MaxCount?
        JNE      JSP4              ;no
        XOR      SI,SI             ;yes, zero output
JSP4:   MOV      AX,DI             ;move X result to AX
        LES      DI,X              ;load address
        STOSW                      ;ES:DI points to X
        MOV      AX,SI             ;move Y result to AX
        LES      DI,Y              ;ES:DI points to Y
        STOSW                      ;store data
        MOV      SP,BP
        POP      BP                ;restore base pointer
        RET      10                ;remove parameters and return
JoyStkPos        ENDP
;-----------------------------------------------------------------------------
;function JoyStkBtn(Num:byte) : boolean;
;         Return position (true-button pressed or false-button not pressed) for
;         button 16, 32, 64 or 128 corresponding to bit positions 4 to 7.  No
;         contact debounce is provided.

Num     EQU      BYTE PTR [BP+6]   ;pointer for button number (16,32,64,128)

JoyStkBtn        PROC FAR
        PUSH     BP                ;save BP
        MOV      BP,SP             ;set up stack frame
        XOR      CL,CL             ;set return msg to false (off)
        MOV      BL,Num            ;get button number (16, 32, 64, 128)
        MOV      DX,201h           ;game adapter port address
        IN       AL,DX             ;read data from game adapter port
        TEST     AL,BL             ;is bit for button num off (1) or on (0)
        JNE      JSB1              ;jump if on
        MOV      CL,1              ;set return to true (on)
JSB1:   MOV      AL,CL             ;return must be in AL
        MOV      SP,BP             ;
        POP      BP                ;restore base pointer
        RET      2                 ;remove parameters and return
JoyStkBtn        ENDP
;-----------------------------------------------------------------------------
;function JoyStkPresent : boolean;
;         Returns true if a game adapter interface is present

JoyStkPresent    PROC FAR
        XOR      BL,BL             ;set return msg to false (off)
        INT      11h               ;equipment list interrupt
        TEST     AX,1000h          ;test game adapter bit
        JE       PR1               ;jump if 0
        MOV      BL,1              ;set return msg to true (on)
PR1:    MOV      AL,BL             ;return must be in AL
        RET
JoyStkPresent    ENDP
;-----------------------------------------------------------------------------
;function GetClkTicks : longint;
;         Return DOS time in ticks (18.2/sec) in DX,AX.  The ticks/second is
;         1193180/65535.  The midnight value is 1573040.
;         Ref: Programmer's Guide To PC, Peter Norton, ISBN 0-914845-46-2, p223

GetClkTicks      PROC FAR
        XOR      AX,AX             ;zero register
        MOV      ES,AX
        CLI                        ;disable interrupts
        MOV      AX,ES:[046Ch]     ;low order ticks
        MOV      DX,ES:[046Eh]     ;high order ticks
        STI                        ;enable interrupts
        RET
GetClkTicks      ENDP
;-----------------------------------------------------------------------------

CODE    ENDS
        END
