{$S-,R-,V-,D-}

unit JoyStk;                {Joystick routines for Turbo Pascal 4.0}
                            {John Haluska, CIS 74000,1106}
interface

const
  BtnA1 = 16;  BtnA2 = 32;   {for joystick buttons }
  BtnB1 = 64;  BtnB2 = 128;
var
  JoyMaxCt : word;           {max count for joystick postion output }
                             {set by procedure InitJoyMaxCt }

procedure JoyStkPos (N : byte; var X,Y : integer);

function JoyStkBtn (Num:byte) : boolean;

function JoyStkPresent : boolean;

function GetClkTicks : longint;

procedure JoyStkCal (N : byte; var X,Y : integer);

implementation

{$L JOYSTK.OBJ}
{$F+}
procedure JoyStkPos (N : byte; var X,Y : integer); external;
         {Return X, Y position of joystick 0 or 1}

function JoyStkBtn (Num:byte) : boolean; external;
        {Return position (true-button pressed or false-button not pressed)
         for button 16, 32, 64 or 128 corresponding to bit positions 4 - 7.
         No contact debounce is provided.}

function JoyStkPresent : boolean; external;
        {Returns true if a game adapter interface is present.}

function GetClkTicks : longint; external;
        {Return DOS time in ticks (18.2/sec).  The ticks/second is
         1193180/65535.  The midnight value is 1573040.
         Ref: Programer's Guide To PC, Peter Norton, ISBN 0-914845-46-2, p223}
{$F-}
procedure InitJoyMaxCt;
        {Determine JoyMaxCt as a function of processor speed.}
  var
    I,J,T3   : word;
    T1,T2    : longint;
  begin
    repeat
      I := 0;
      T1 := GetClkTicks;
      for J := 1 to 65535 do I := I + 1;
      T2 := GetClkTicks;
    until T2 > T1;    {prevent error if counter rollover at midnight}
    T3 := T2 - T1;
    JoyMaxCt := 5000 div T3;
  end;

procedure JoyStkCal (N : byte; var X,Y : integer);
         {Return X, Y position of joystick N (0 or 1) when any joystick
          button is pressed.  Joystick button is contact debounced by waiting
          55 - 110 milliseconds.}
  var
    Ts, Tl   : longint;
  begin
    repeat
      JoyStkPos(N, X, Y);
    until JoyStkBtn(BtnA1) or JoyStkBtn(BtnA2) or JoyStkBtn(BtnB1)
          or JoyStkBtn(BtnB2);
    Ts := GetClkTicks;
    repeat
      repeat
        Tl := GetClkTicks - Ts;
      until Tl >= 2;            {55 -110 ms delay for switch contact bounce}
    until not(JoyStkBtn(BtnA1) or JoyStkBtn(BtnA2) or JoyStkBtn(BtnB1)
          or JoyStkBtn(BtnB2));
  end;

begin
  InitJoyMaxCt;     {Intialize max count}
end.
