PROCEDURE DrawFloor (Building : Word;
                     Level    : Word;
                     MaxLevel : Word;
                     Wall     : Byte;
                 VAR Screen   : ScrnArray;
                     Dir      : DirArray;
                     Man      : Person;
                 VAR Covering : CovrArray;
                     Enemy    : Person;
                 VAR EnCover  : CovrArray;
                 VAR Jump     : Boolean;
                 VAR Sensor   : SensArray;
                 VAR Bomb     : FireData;
                 VAR Potion   : FireData);
VAR
  Count     : Position;
  Count2    : Word;
  Count3    : DiraIndex;
  Maze      : MazeArray;
  Grid      : GridArray;
  MazeMax   : Word;
  Rnd       : Word;
  Rnd2      : Word;
  Temp      : Position;
  Temp2     : Position;
  Loop      : DirCoord;
  Adj       : Real;
  SensOk    : Boolean;
  MaxCan    : Word;
  Hard      : Boolean;

  PROCEDURE RecurseFill (o : overindex; d : downindex; cs, ct : byte);
  BEGIN
    screen[o,d] := ct;
    if (o>1)  then if (screen[o-1,d]=cs) then recursefill(o-1,d,cs,ct);
    if (o<40) then if (screen[o+1,d]=cs) then recursefill(o+1,d,cs,ct);
    if (d>1)  then if (screen[o,d-1]=cs) then recursefill(o,d-1,cs,ct);
    if (d<25) then if (screen[o,d+1]=cs) then recursefill(o,d+1,cs,ct);
  END;

BEGIN
  (* Clear Screen to Black *)
  for count.o := 1 to 40 do
    for count.d := 1 to 25 do
      BEGIN
        screen[count.o,count.d]    := Black;
        fuseunder[count.o,count.d] := falseunder;
      END; (* for *)

  (* Draw Horizontal Lines *)
  for count2 := 0 to 6 do
    BEGIN
      count.d := count2 * 4 + 1;
      for count.o := 2 to 38 do
        screen[count.o,count.d] := wall
    END; (* for *)

  (* Draw Vertical Lines *)
  for count2 := 0 to 9 do
    BEGIN
      count.o := count2 * 4 + 2;
      for count.d := 2 to 24 do
        screen[count.o,count.d] := wall
    END; (* for *)

  (* Change Corners *)
  screen[2,1]   := Green;
  screen[3,1]   := Green;
  screen[37,1]  := Green;
  screen[38,1]  := Green;
  screen[2,25]  := Green;
  screen[3,25]  := Green;
  screen[37,25] := Green;
  screen[38,25] := Green;
  screen[2,2]   := Green;
  screen[38,2]  := Green;
  screen[2,24]  := Green;
  screen[38,24] := Green;

  (* Draw Stairs *)
  for count2 := 4 to 17 do
    BEGIN
      count.o := count2 * 2;
      for count.d := 22 to 24 do
        screen[count.o,count.d] := Brown
    END; (* for *)

  (* Clear Entry and Exit *)
  for count.o := 3 to 5 do
    screen[count.o,21] := 0;
  for count.o := 35 to 37 do
    screen[count.o,21] := 0;

  (* Clear Maze Grid *)
  for count.o := 1 to 9 do
    for count.d := 1 to 5 do
      grid[count.o,count.d] := 0;

  (* Initialize Maze Generator Variables *)
  grid[5,3] := 1;
  maze[1].o := 6;
  maze[1].d := 3;
  grid[6,3] := 2;
  maze[2].o := 4;
  maze[2].d := 3;
  grid[4,3] := 2;
  maze[3].o := 5;
  maze[3].d := 2;
  grid[5,2] := 2;
  maze[4].o := 5;
  maze[4].d := 4;
  grid[5,4] := 2;
  mazemax   := 4;

  (* Maze Algorhythm *)
  for count2 := 1 to 44 do
    BEGIN
      (* find two suitable blocks *)
      rnd := random(mazemax)+1;
      REPEAT
        rnd2   := random(4);
        temp.o := maze[rnd].o + dir[rnd2].o;
        temp.d := maze[rnd].d + dir[rnd2].d
      UNTIL ((temp.o in [1..9]) and (temp.d in [1..5])
            and (grid[temp.o,temp.d]=1));
      (* connect them *)
      temp.o  := temp.o * 4;
      temp.d  := temp.d * 4 - 1;
      temp2.o := maze[rnd].o * 4;
      temp2.d := maze[rnd].d * 4 - 1;
      if (temp.o>temp2.o) then Exchange(temp.o,temp2.o,sizeof(temp.o));
      if (temp.d>temp2.d) then Exchange(temp.d,temp2.d,sizeof(temp.d));
      for count.d := temp.d-1 to temp2.d+1 do
        for count.o := (temp.o-1) to (temp2.o+1) do
          screen[count.o,count.d] := Black;
      (* adjust maze data *)
      temp := maze[rnd];
      grid[temp.o,temp.d] := 1;
      maze[rnd] := maze[mazemax];
      dec(mazemax);
      for count3 := 1 to 4 do
        BEGIN
          temp2.o := temp.o + dir[count3].o;
          temp2.d := temp.d + dir[count3].d;
          if ((temp2.o in [1..9]) and (temp2.d in [1..5])
             and (grid[temp2.o,temp2.d]=0))
          then
            BEGIN
              grid[temp2.o,temp2.d]:=2;
              inc(mazemax);
              maze[mazemax] := temp2
            END; (* if *)
        END; (* for *)
    END; (* for *)

  (* erase some walls on upper levels *)
  hard := (maxlevel = 0) or (minscore > 0);
  if (level<maxlevel) and (not hard) then
    for count2 := 1 to ((maxlevel-level)*5) do
      BEGIN
        (* erase a horizontal wall *)
        temp.o := random(9)*4+3;
        temp.d := random(4)*4+5;
        if (temp.o=35) then
          temp2.o := temp.o + 2
        else
          temp2.o := temp.o + 3;
        for count.o := temp.o to temp2.o do
          screen[count.o,temp.d] := Black;
        (* erase a vertical wall *)
        temp.o := random(8)*4+6;
        temp.d := random(5)*4+2;
        if (temp.d=18) then
          temp2.d := temp.d + 2
        else
          temp2.d := temp.d + 3;
        for count.d := temp.d to temp2.d do
          screen[temp.o,count.d] := Black;
      END; (* for *)

  if (hard) then
    for count2 := 1 to (11-level) do
      BEGIN
        (* erase a horizontal wall *)
        temp.o := random(9)*4+3;
        temp.d := random(4)*4+5;
        if (temp.o=35) then
          temp2.o := temp.o + 2
        else
          temp2.o := temp.o + random(5) + 2;
        for count.o := temp.o to temp2.o do
          screen[count.o,temp.d] := Black;
        (* erase a vertical wall *)
        temp.o := random(8)*4+6;
        temp.d := random(5)*4+2;
        if (temp.d=18) then
          temp2.d := temp.d + 2
        else
          temp2.d := temp.d + random(5) + 2;
        for count.d := temp.d to temp2.d do
          screen[temp.o,count.d] := Black;
      END; (* for *)

  (* Draw Your Fuse *)
  if jump then
    BEGIN
      screen[40,7]      := LightGray;
      fuseunder[40,7].l := true;
      fuseunder[40,7].r := true;
      fuseunder[40,7].u := false;
      fuseunder[40,7].d := false;
      screen[39,7]      := LightGray;
      fuseunder[39,7].l := true;
      fuseunder[39,7].r := true;
      fuseunder[39,7].u := false;
      fuseunder[39,7].d := false;
    END; (* if *)

  (* Sprinkle Cans of Gasoline *)
  if (building in [1..7]) then
    adj := (building/10 + 0.9)
  else
    adj := 1.7;
  if maxlevel>0 then
    maxcan := round(((10-maxlevel)+level)*adj)
  else
    maxcan := round(level*1.5) + 10;
  if (maxcan>25) then
    maxcan := 25;
  for count2 := 1 to maxcan do
    BEGIN
      temp.o := random(36)+3;
      temp.d := random(19)+2;
      if (((temp.o in [6..34]) or (temp.d in [5..15]))
         and (screen[temp.o,temp.d]=Black)) then
        screen[temp.o,temp.d] := Blue
    END; (* for *)

  (* Make a bomb? *)
  bomb.i := 0;
  if random(10)<ord(def[building,2])-ord('0') then
    BEGIN
      temp.o := random(36)+3;
      temp.d := random(19)+2;
      if (((temp.o in [6..34]) or (temp.d in [5..15]))
         and (screen[temp.o,temp.d]=Black)) then
        BEGIN
          bomb.o := temp.o;
          bomb.d := temp.d;
          bomb.i := 5;
          screen[bomb.o,bomb.d] := Blue;
        END; (* if *)
    END; (* if *)

  (* Make a Potion? *)
  potion.i := 0;
  if random(10)<ord(def[building,3])-ord('0') then
    BEGIN
      temp.o := random(36)+3;
      temp.d := random(19)+2;
      if (((temp.o in [6..34]) or (temp.d in [5..15]))
         and (screen[temp.o,temp.d]=Black)) then
        BEGIN
          potion.o := temp.o;
          potion.d := temp.d;
          potion.i := 1;
          screen[potion.o,potion.d] := White;
        END; (* if *)
    END; (* if *)

  (* Make a Power-Potion? *)
  powpotion.i := 0;
  if random(10)<ord(def[building,13])-ord('0') then
    BEGIN
      temp.o := random(36)+3;
      temp.d := random(19)+2;
      if (((temp.o in [6..34]) or (temp.d in [5..15]))
         and (screen[temp.o,temp.d]=Black)) then
        BEGIN
          powpotion.o := temp.o;
          powpotion.d := temp.d;
          powpotion.i := 1;
          screen[potion.o,potion.d] := 16+Yellow;
        END; (* if *)
    END; (* if *)

  (* Passage To Last Building? *)
  if jump then
    BEGIN
      screen[38,6] := Black;
      screen[38,7] := Black;
      screen[38,8] := Black;
      screen[39,5] := Green;
      screen[39,9] := Green;
      screen[40,5] := Green;
      screen[40,9] := Green;
      jump := False
    END; (* if *)

  (* Gas-Pipe Walls? *)
  for count2 := 1 to ord(def[building,8])-ord('0') do
    BEGIN
      temp.o := random(40)+1;
      temp.d := random(25)+1;
      if screen[temp.o,temp.d]=wall then
        recursefill(temp.o,temp.d,wall,17);
    END; (* for *)

  (* Sensors? *)
  if random(10)<ord(def[building,4])-ord('0') then
    BEGIN
      count2      := 25;
      sensor[3].o := 0;
      sensor[3].d := 0;
      REPEAT
        sensor[0] := sensor[3];
        REPEAT
          sensor[1].o := random(37)+2;
          sensor[1].d := random(21)+1
        UNTIL (screen[sensor[1].o,sensor[1].d]=wall);
        if (random(2)=1) then
          REPEAT
            sensor[2]   := sensor[1];
            sensor[2].o := random(37)+2;
            sensor[0].o := 1;
            dec(count2)
          UNTIL (((screen[sensor[2].o,sensor[2].d]=wall) and
                (abs(sensor[2].o-sensor[1].o)>3)) or (count2=0))
        else
          REPEAT
            sensor[2]   := sensor[1];
            sensor[2].d := random(21)+1;
            sensor[0].d := 1;
            dec(count2)
          UNTIL (((screen[sensor[2].o,sensor[2].d]=wall) and
                (abs(sensor[2].d-sensor[1].d)>3)) or (count2=0));
        if (count2>0) then
          BEGIN
            if ((sensor[2].d<sensor[1].d) or (sensor[2].o<sensor[1].o)) then
              exchange(sensor[2],sensor[1],sizeof(sensor[2]));
            temp   := sensor[1];
            temp.o := temp.o + sensor[0].o;
            temp.d := temp.d + sensor[0].d;
            sensok := True;
            while ((temp.o<>sensor[2].o) or (temp.d<>sensor[2].d)) do
              BEGIN
                if (screen[temp.o,temp.d]<>Black) then
                  sensok := False;
                temp.o := temp.o + sensor[0].o;
                temp.d := temp.d + sensor[0].d
              END; (* while *)
          END; (* if *)
      UNTIL (sensok or (count2=0));
      if (sensok and (count2>0)) then
        BEGIN
          screen[sensor[1].o,sensor[1].d] := Green;
          screen[sensor[2].o,sensor[2].d] := Green
        END (* if *)
      else
        BEGIN
          sensor[0].o := 0;
          sensor[0].d := 0;
          sensor[1]   := sensor[0];
          sensor[2]   := sensor[1]
        END; (* else *)
    END (* else *)
  else
    BEGIN
      sensor[0].o := 0;
      sensor[0].d := 0;
      sensor[1]   := sensor[0];
      sensor[2]   := sensor[1];
      sensor[3]   := sensor[2]
    END; (* if *)

  (* Record What The People Are On Top Of *)
  for loop.o := -1 to 1 do
    for loop.d := -1 to 1 do
      covering[loop.o,loop.d] := screen[loop.o+man.o,loop.d+man.d];
  if (enemy.o > 0) then
    for loop.o := -1 to 1 do
      for loop.d := -1 to 1 do
        encover[loop.o,loop.d] := screen[loop.o+enemy.o,loop.d+enemy.d]
END;


PROCEDURE Move (VAR Man     : Person;
                VAR ManLast : Person;
                VAR Screen  : ScrnArray;
                    Wall    : Byte;
                    Dir     : DirArray;
                VAR Covering: CovrArray;
                VAR Cans    : Word;
                VAR MakeLeak: Boolean;
                    Pickup  : Boolean;
                    Dropped : Boolean;
                VAR Done    : Boolean;
                    PlotOnly: Boolean;
                VAR Jump    : Boolean;
                VAR Building: Word;
                VAR Level   : Word;
                    MaxLevel: Word;
                VAR Bomb    : FireData;
                VAR Invis   : Word;
                VAR Viles   : Word);
VAR
  loop      : dircoord;
  temp      : position;
  temp2     : word;
  result    : boolean;
  left      : overindex;
  right     : overindex;
  i         : integer;
  i2        : integer;
  j         : integer;
  oldpower  : boolean;

    PROCEDURE EraseMan (Man      : Person;
                    VAR Screen   : ScrnArray;
                        Covering : CovrArray);
    VAR
      loop      : dircoord;
      temp      : position;
    BEGIN
      for loop.d := -1 to 1 do
        BEGIN
          temp.d := loop.d + man.d;
          for loop.o := -1 to 1 do
            screen[loop.o+man.o,temp.d] := covering[loop.o,loop.d];
        END; (* for *)
      for loop.d := -1 to 1 do
        BEGIN
          temp.d := loop.d + man.d;
          gotoxy(man.o-1,temp.d);
          for loop.o := -1 to 1 do
            BEGIN
              charcolor(screen[loop.o+man.o,temp.d]);
              CASE screen[loop.o+man.o,temp.d] OF
                black     : write(' ');
                blue      : write(bottle);
                lightgray : BEGIN
                              if ((loop.d+man.d) in [22..24]) and
                                 ((loop.o+man.o) in [7..34]) and
                                 ((loop.o+man.o) mod 2 = 0) then
                                charcolor(FuseOnStair);
                              write(fusepic[
                                            fuseunder[loop.o+man.o,temp.d].u,
                                            fuseunder[loop.o+man.o,temp.d].d,
                                            fuseunder[loop.o+man.o,temp.d].l,
                                            fuseunder[loop.o+man.o,temp.d].r]);
                            END; (* lightgray *)
                else        write(block);
              END; (* case *)
            END; (* for *)
        END; (* for *)
    END;

BEGIN
  (* End Bonus Round *)
  if (bonusround>1) then
    BEGIN
      dec(bonusround);
      if (bonusround=1) then
        for i := 1 to 39 do
          for j := 1 to 25 do
            if (screen[i,j]=white) then
              BEGIN
                charcolor(wall);
                gotoxy(i,j);
                write(wblock);
                screen[i,j] := wall;
              END; (* if *)
    END; (* if *)

  (* Compute Left, Right Bounds *)
  if ((screen[1,5]=Green) and (man.d=7)) then
    left := 1
  else
    left := 2;
  if (man.o>37) then
    right := 39
  else
    right := 38;


  (* Can We Move in the Desired Direction? *)
  if (man.ndi>0) then
    BEGIN
      if (((man.d=23) and ((man.d+dir[man.ndi].d)<>23) and (man.o in [7..35]))
         or ((man.d=20) and ((man.d+dir[man.ndi].d)=21) and (man.o in [7..35]))
         or ((man.o=6) and ((man.o+dir[man.ndi].o)=7) and (man.d in [21..24]))
         or ((man.o=36) and ((man.o+dir[man.ndi].o)=35) and
            (man.d in [21,22,24]))) then
        result := False
      else
        result := True;
      loop.o := -2;
      REPEAT
        inc(loop.o);
        loop.d := -2;
        REPEAT
          inc(loop.d);
          temp.o := man.o + dir[man.ndi].o + loop.o;
          temp.d := man.d + dir[man.ndi].d + loop.d;
          if ((temp.d in [1..25]) and (temp.o in [left..right])) then
            BEGIN
              temp2 := screen[temp.o,temp.d];
              if ((temp2=LightCyan) or (temp2=Green) or
                  (temp2=Wall) or (temp2=17)) then
                result := False
            END (* if *)
          else
            result := False
        UNTIL ((loop.d=1) or (not result))
      UNTIL ((loop.o=1) or (not result));
      if result then
        BEGIN
          man.mo  := dir[man.ndi].o;
          man.md  := dir[man.ndi].d;
          man.ndi := 0;
        END; (* if *)
    END; (* if *)

  (* Can We Continue Moving in the Current Direction? *)
  result := CanMove(man,screen);

  i  := cans;
  i2 := viles;
  oldpower := power;

  if result or dropped or plotonly then
    BEGIN

      (* Erase Man *)
      if not plotonly then
        eraseman(man,screen,covering);

      (* Update Man's Position *)
      if result and not plotonly then
        BEGIN
          man.o  := man.o + man.mo;
          man.d  := man.d + man.md
        END; (* if *)

      (* Save What's There and Turn It Pink *)
      for loop.o := -1 to 1 do
        for loop.d := -1 to 1 do
          BEGIN
            if not plotonly then
              covering[loop.o,loop.d] := screen[loop.o+man.o,loop.d+man.d];
            if ((loop.o+man.o=bomb.o) and (loop.d+man.d=bomb.d)) then
              bomb.i := 0;
            if (covering[loop.o,loop.d]=Blue) then
              if ((pickup and (cans<4)) or (pickup and (cans<5)
                 and (level=ord(def[building,1])-ord('0')))) then
                BEGIN
                  inc(cans);
                  if (fuseunder[loop.o+man.o,loop.d+man.d].u or
                      fuseunder[loop.o+man.o,loop.d+man.d].d or
                      fuseunder[loop.o+man.o,loop.d+man.d].l or
                      fuseunder[loop.o+man.o,loop.d+man.d].r) then
                    covering[loop.o,loop.d] := lightgray
                  else
                    covering[loop.o,loop.d] := Black
                END; (* if *)
            if (covering[loop.o,loop.d]=White) then
              BEGIN
                covering[loop.o,loop.d] := Black;
                if (viles<9999) then
                  inc(viles);
                showviles(viles)
              END; (* if *)
            if (covering[loop.o,loop.d]=16+Yellow) then
              BEGIN
                covering[loop.o,loop.d] := Black;
                power := true;
              END; (* if *)
            if dead then
              screen[loop.o+man.o,loop.d+man.d] := Brown
            else
              screen[loop.o+man.o,loop.d+man.d] := LightMagenta
          END;

      (* Draw the Fuse *)
      if covering[0,0]<>blue then
        covering[0,0] := LightGray;
      fuseunder[man.o,man.d].u := fuseunder[man.o,man.d].u or
                                  (manlast.d<man.d);
      fuseunder[man.o,man.d].d := fuseunder[man.o,man.d].d or
                                  (manlast.d>man.d);
      fuseunder[man.o,man.d].l := fuseunder[man.o,man.d].l or
                                  (manlast.o<man.o);
      fuseunder[man.o,man.d].r := fuseunder[man.o,man.d].r or
                                  (manlast.o>man.o);
      fuseunder[manlast.o,manlast.d].u := fuseunder[manlast.o,manlast.d].u or
                                          (man.d<manlast.d);
      fuseunder[manlast.o,manlast.d].d := fuseunder[manlast.o,manlast.d].d or
                                          (man.d>manlast.d);
      fuseunder[manlast.o,manlast.d].l := fuseunder[manlast.o,manlast.d].l or
                                          (man.o<manlast.o);
      fuseunder[manlast.o,manlast.d].r := fuseunder[manlast.o,manlast.d].r or
                                          (man.o>manlast.o);
      manlast := man;

      (* Add Gas Cans Held *)
      if (invis=0) then
        BEGIN
          if (cans>0) then screen[man.o-1,man.d-1] := Blue;
          if (cans>1) then screen[man.o+1,man.d-1] := Blue;
          if (cans>2) then screen[man.o-1,man.d+1] := Blue;
          if (cans>3) then screen[man.o+1,man.d+1] := Blue;
          if (cans>4) then screen[man.o  ,man.d  ] := Blue;
        END; (* if *)

      (* Plot the Man *)
      for loop.d := -1 to 1 do
        BEGIN
          temp.d := loop.d + man.d;
          GotoXY(man.o-1,temp.d);
          for loop.o := -1 to 1 do
            BEGIN
              if (invis>0) then
                screen[loop.o+man.o,temp.d] := darkgray;
              if power and (screen[loop.o+man.o,temp.d]=lightmagenta) then
                charcolor(yellow)
              else
                charcolor(screen[loop.o+man.o,temp.d]);
              if (loop.o<>0) or (loop.d<>0) then
                Write(Block)
              else
                Write(CBlock)
            END; (* for *)
        END; (* for *)

    END; (* if result or dropped *)

  (* Sound of taking a gas can or a vile *)
  if (i<>cans) and noise then
    for i := 1 to 4 do
      BEGIN
        swap(randseed,oldseed);
        sound(5000+random(5000));
        delay(20);
        swap(randseed,oldseed)
      END; (* for *)
  if ( (i2<>viles) or (oldpower<>power) ) and noise then
    for i := 1 to 100 do
      BEGIN
        sound(i*100);
        delay(1)
      END; (* for *)

  (* If Invisible, Subtract One Turn From Invis *)
  if (invis>0) then
    BEGIN
      dec(invis);
      charcolor(White);
      if ((invis=1) or (invis=4) or (invis=7)) then
        for temp2 := 2 to 3 do
          BEGIN
            gotoxy(1,temp2);
            write(Block)
          END (* for *)
      else if ((invis=0) or (invis=3) or (invis=6)) then
        ShowViles(Viles);
      if (invis=0) then
        Move(Man,ManLast,Screen,Wall,Dir,Covering,Cans,MakeLeak,Pickup,
             Dropped,Done,True,Jump,Building,Level,MaxLevel,Bomb,Invis,Viles);
    END; (* if *)

  (* Is Man Down The Stairs?  If So, Erase *)
  if ((man.o=8) and (man.d=23)) then
    BEGIN
      done := True;
      eraseman(man,screen,covering)
    END; (* if *)

  (* Has Man Jumped?  If So, Erase And Change Building *)
  if ((man.o=2) and (man.d=7)) then
    BEGIN
      jump := True;
      done := True;
      eraseman(man,screen,covering);
      screen[1,7] := LightGray;
      charcolor(LightGray);
      gotoxy(1,7);
      write(#196);
      fuseunder[1,7].u := false;
      fuseunder[1,7].d := false;
      fuseunder[1,7].l := true;
      fuseunder[1,7].r := true;
      level := maxlevel;
    END; (* if *)

  (* Has Man Jumped to Previous Game? *)
  if ((man.o=4) and (man.d=23) and (man.md=1) and
      (building=1) and (level=1) and (maxfire=0) and (prevbld<>0)) then
    BEGIN
      done := True;
      turn := minturn + 11;
      fuselength := minturn;
      eraseman(man,screen,covering);
      level    := maxlevel;
      building := prevbld;
      skill    := prevskill
    END;
END;


PROCEDURE Input (VAR NDir     : DirAIndex;
                 VAR MakeLeak : Boolean;
                     Joystick : Boolean;
                 VAR Cans     : Word;
                 VAR Pickup   : Boolean;
                 VAR Dropped  : Boolean;
                     JoyLeft  : Word;
                     JoyRight : Word;
                     JoyUp    : Word;
                     JoyDown  : Word;
                 VAR NoSpread : Boolean;
                 VAR OldC     : Char;
                 VAR Invis    : Word;
                 VAR Viles    : Word);
VAR
  c         : char;
  cdemo     : integer;
  interpret : boolean;
  x, y      : integer;
  metakeys  : word;

BEGIN
  if joystick and (not demo) then
    BEGIN
      JoyStkPos(0,x,y);
      if ((y<joyup) and (NDir<>1)) then
        NDir := 1
      else if ((x>joyright) and (NDir<>2)) then
        NDir := 2
      else if ((y>joydown) and (NDir<>3)) then
        NDir := 3
      else if ((x<joyleft) and (NDir<>4)) then
        NDir := 4;
      if JoyStkBtn(BtnA2) then
        Pickup := True;
      if (JoyStkBtn(BtnA1) and (cans>0)) then
        BEGIN
          MakeLeak := True;
          dec(cans)
        END; (* if *)
    END; (* if *)
  interpret := False;
  c         := #0;
  if keypressed and (not demo) then
    BEGIN
      REPEAT
        keystroke(c)
      UNTIL ((not keypressed) or (c<>oldc) or
            (((c=' ') or (c=#13) or (c='z') or (c='Z')) and (cans>0)) or
            (((c='+') or (c='x') or (c='X')) and (viles>0)));
      interpret := True;
    END; (* if *)
  if demo then
    BEGIN
      readln(demorf,cdemo);
      c := chr(cdemo);
      readln(demorf,metakeys);
      pickup := ((metakeys and 1) = 1);
      throwing := ((metakeys and 2) = 2);
      interpret := True;
    END; (* if *)
  if demow then
    BEGIN
      writeln(demowf,ord(c));
      metakeys := 0;
      if pickup   then metakeys := metakeys + 1;
      if throwing then metakeys := metakeys + 2;
      writeln(demowf,metakeys);
      interpret := true;
    END;
  if interpret then
    BEGIN
      oldc := c;
      if (not power) or (not throwing) then
        CASE c OF
          '8', 'H' : ndir := 1;
          '6', 'M' : ndir := 2;
          '2', 'P' : ndir := 3;
          '4', 'K' : ndir := 4;
        END (* case *)
      else if (cans>0) and not (dead or done) then
        CASE c OF
          '8', 'H' : BEGIN man.mmo :=  0; man.mmd := -1; makemissile := true; power := false; dec(cans); END;
          '6', 'M' : BEGIN man.mmo :=  1; man.mmd :=  0; makemissile := true; power := false; dec(cans); END;
          '2', 'P' : BEGIN man.mmo :=  0; man.mmd :=  1; makemissile := true; power := false; dec(cans); END;
          '4', 'K' : BEGIN man.mmo := -1; man.mmd :=  0; makemissile := true; power := false; dec(cans); END;
        END; (* case *)
      if (c=#27) then DemoDone := true;
      if (((c='+') or (c='x') or (c='X') or (c='0') or (c='R')) and
         (viles>0) and (not dead) and (not done)) then
        BEGIN
          dec(viles);
          showviles(viles);
          invis := invis + 15;
          Move(Man,ManLast,Screen,Wall,Dir,Covering,Cans,MakeLeak,
               Pickup,Dropped,Done,True,Jump,Building,Level,MaxLevel,
               Bomb,Invis,Viles)
        END; (* if *)
      if (((c=' ') or (c=#13) or (c='z') or (c='Z')) and
         (cans>0) and not (dead or done)) then
        BEGIN
          MakeLeak := True;
          dec(cans);
          if (c<>' ') then
            NoSpread := True
        END; (* if *)
    END; (* if *)
  Dropped := MakeLeak
END;


PROCEDURE MoveEnemy (VAR Enemy   : Person;
                     VAR Screen  : ScrnArray;
                         Wall    : Byte;
                         Dir     : DirArray;
                     VAR EnCover : CovrArray;
                         Building: Word;
                     VAR Level   : Word;
                         MaxLevel: Word;
                     VAR Dead    : Boolean);
VAR
  loop      : dircoord;
  temp      : position;
  temp2     : word;
  temp3     : word;
  result    : boolean;
  left      : overindex;
  right     : overindex;
  check     : dirok;
  shouldfire: boolean;

    PROCEDURE EraseEnemy (Enemy    : Person;
                      VAR Screen   : ScrnArray;
                          EnCover  : CovrArray);
    VAR
      loop      : dircoord;
      temp      : position;
    BEGIN
      for loop.d := -1 to 1 do
        BEGIN
          temp.d := loop.d + enemy.d;
          for loop.o := -1 to 1 do
            if screen[loop.o+enemy.o,temp.d] = lightcyan then
              screen[loop.o+enemy.o,temp.d] := encover[loop.o,loop.d];
        END; (* for *)
      for loop.d := -1 to 1 do
        BEGIN
          temp.d := loop.d + enemy.d;
          gotoxy(enemy.o-1,temp.d);
          for loop.o := -1 to 1 do
            BEGIN
              charcolor(screen[loop.o+enemy.o,temp.d]);
              CASE screen[loop.o+enemy.o,temp.d] OF
                black     : write(' ');
                blue      : write(bottle);
                lightgray : BEGIN
                              if ((loop.d+enemy.d) in [22..24]) and
                                 ((loop.o+enemy.o) in [7..34]) and
                                 ((loop.o+enemy.o) mod 2 = 0) then
                                charcolor(FuseOnStair);
                              write(fusepic[
                                    screen[loop.o+enemy.o,temp.d-1]=lightgray,
                                    screen[loop.o+enemy.o,temp.d+1]=lightgray,
                                    screen[loop.o+enemy.o-1,temp.d]=lightgray,
                                    screen[loop.o+enemy.o+1,temp.d]=lightgray]);
                            END; (* lightgray *)
                else        write(block);
              END; (* case *)
            END; (* for *)
        END; (* for *)
    END;

    FUNCTION Sgn (Number : LongInt) : Integer;
    BEGIN
      if (number>0) then
        sgn := 1
      else if (number=0) then
        sgn := 0
      else
        sgn := -1
    END;

    FUNCTION Opp (Number1, Number2 : LongInt) : Boolean;
    BEGIN
      if ((Number1>0) and (Number2<0)) then
        opp := true
      else if ((Number1<0) and (Number2>0)) then
        opp := true
      else
        opp := false
    END;

BEGIN
  (* Compute Left, Right Bounds *)
  if ((screen[1,5]=Green) and (enemy.d=7)) then
    left := 1
  else
    left := 2;
  if (enemy.o>37) then
    right := 39
  else
    right := 38;

  (* Where Can He Move? *)
  for temp2 := 1 to 4 do
    BEGIN
      if (((enemy.d=23) and ((enemy.d+dir[temp2].d)<>23) and (enemy.o in [7..35]))
         or ((enemy.d=20) and ((enemy.d+dir[temp2].d)=21) and (enemy.o in [7..35]))
         or ((enemy.o=6) and ((enemy.o+dir[temp2].o)=7) and (enemy.d in [21..24]))
         or ((enemy.o=36) and ((enemy.o+dir[temp2].o)=35) and
            (enemy.d in [21,22,24]))) then
        result := False
      else
        result := True;

      (* Check What's One Step Ahead *)
      loop.o := -2;
      REPEAT
        inc(loop.o);
        loop.d := -2;
        REPEAT
          inc(loop.d);
          temp.o := enemy.o + dir[temp2].o + loop.o;
          temp.d := enemy.d + dir[temp2].d + loop.d;
          if ((temp.d in [1..25]) and (temp.o in [left..right])) then
            BEGIN
              temp3 := screen[temp.o,temp.d];
              if (temp3=LightMagenta) then
                BEGIN
                  result := False;
                  dead   := True;
                  Move(Man,ManLast,Screen,Wall,Dir,Covering,Cans,MakeLeak,
                       Pickup,Dropped,Done,True,Jump,Building,
                       Level,MaxLevel,Bomb,Invis,Viles);
                END; (* if *)
              if ((temp3=Green) or (temp3=Wall) or
                  (temp3=17) or (temp3=DarkGray)) then
                result := False
            END
          else
            result := False
        UNTIL ((loop.d=1) or (not result))
      UNTIL ((loop.o=1) or (not result));

      (* Check What's Two Steps Ahead (In a Bigger Circle) *)
      loop.o := -3;
      REPEAT
        inc(loop.o);
        loop.d := -3;
        REPEAT
          inc(loop.d);
          temp.o := enemy.o + dir[temp2].o*2 + loop.o;
          temp.d := enemy.d + dir[temp2].d*2 + loop.d;
          if ((temp.d in [1..25]) and (temp.o in [left..right])) then
            if (screen[temp.o,temp.d] in [4,8,12,14]) or
               ( (screen[temp.o,temp.d]=6) and (temp.d<22) ) then
              result := False
        UNTIL ((loop.d=2) or (not result))
      UNTIL ((loop.o=2) or (not result));

      check[temp2] := result
    END;

  (* Choose A Direction *)
  enemy.ndi := 0;
  if not (done or dead) then
    for temp2 := 1 to 4 do
      if (check[temp2] and (not opp(dir[temp2].o,enemy.mo)) and
         (not opp(dir[temp2].d,enemy.md))) then
        if ((dir[temp2].d = sgn(man.d-enemy.d)) and (dir[temp2].d <> 0)) then
          enemy.ndi := temp2
        else if ((dir[temp2].o = sgn(man.o-enemy.o)) and (dir[temp2].o <> 0)) then
          enemy.ndi := temp2;
  if (enemy.ndi = 0) then
    for temp2 := 1 to 4 do
      if ((dir[temp2].o=enemy.mo) and (dir[temp2].d=enemy.md)
         and check[temp2]) then
        enemy.ndi := temp2;
  if (enemy.ndi = 0) then
    for temp2 := 1 to 4 do
      if (check[temp2] and (dir[temp2].o<>-enemy.mo) and
       (dir[temp2].d<>-enemy.md)) then
        enemy.ndi := temp2;
  if (enemy.ndi = 0) then
    for temp2 := 1 to 4 do
      if check[temp2] then
        enemy.ndi := temp2;
  if (enemy.ndi>0) and check[enemy.ndi] then
    BEGIN
      enemy.mo := dir[enemy.ndi].o;
      enemy.md := dir[enemy.ndi].d;
    END (* if *)
  else
    BEGIN
      enemy.mo := 0;
      enemy.md := 0;
    END; (* else *)

  if (enemy.ndi>0) and check[enemy.ndi] then
    BEGIN

      (* Erase enemy *)
      eraseenemy(enemy,screen,EnCover);

      (* Update enemy's Position *)
      enemy.o  := enemy.o + enemy.mo;
      enemy.d  := enemy.d + enemy.md;

      (* Save What's There and Turn It Light Cyan *)
      for loop.o := -1 to 1 do
        for loop.d := -1 to 1 do
          BEGIN

            EnCover[loop.o,loop.d] := screen[loop.o+enemy.o,loop.d+enemy.d];
            if ((EnCover[loop.o,loop.d] = Blue) or
                (EnCover[loop.o,loop.d] = 16+Yellow) or
                (EnCover[loop.o,loop.d] = White)) then
              if (fuseunder[loop.o+enemy.o,loop.d+enemy.d].u or
                  fuseunder[loop.o+enemy.o,loop.d+enemy.d].d or
                  fuseunder[loop.o+enemy.o,loop.d+enemy.d].l or
                  fuseunder[loop.o+enemy.o,loop.d+enemy.d].r) then
                EnCover[loop.o,loop.d] := lightgray
              else
                EnCover[loop.o,loop.d] := Black;
            if ((loop.o+enemy.o=bomb.o) and (loop.d+enemy.d=bomb.d)) then
              Bomb.I := 0;
            screen[loop.o+enemy.o,loop.d+enemy.d] := LightCyan
          END;

      (* Plot the enemy *)
      charcolor(LightCyan);
      for loop.d := -1 to 1 do
        BEGIN
          temp.d := loop.d + enemy.d;
          GotoXY(enemy.o-1,temp.d);
          for loop.o := -1 to 1 do
            Write(Block)
        END; (* for *)
      GotoXY(enemy.o,enemy.d);
      Write(CBlock)

    END; (* if result *)

  (* Should he throw a gas can? *)
  if (def[building,6]='1') and (maxproj=0) and not (done or dead) then
    BEGIN
      shouldfire := false;
      if (enemy.d=man.d) and (enemy.o-man.o>9) and (enemy.mo=-1) then
        BEGIN
          shouldfire := true;
          for temp.o := man.o to enemy.o do
            if (screen[temp.o,enemy.d]=wall) or
               (screen[temp.o,enemy.d]=blue) then
              shouldfire := false;
        END; (* if *)
      if (enemy.d=man.d) and (man.o-enemy.o>9) and (enemy.mo=1) and
         (enemy.d<21) then
        BEGIN
          shouldfire := true;
          for temp.o := enemy.o to man.o do
            if (screen[temp.o,enemy.d]=wall) or
               (screen[temp.o,enemy.d]=blue) then
              shouldfire := false;
        END; (* if *)
      if (enemy.o=man.o) and (enemy.d-man.d>9) and (enemy.md=-1) then
        BEGIN
          shouldfire := true;
          for temp.d := man.d to enemy.d do
            if (screen[enemy.o,temp.d]=wall) or
               (screen[enemy.o,temp.d]=blue) then
              shouldfire := false;
        END; (* if *)
      if (enemy.o=man.o) and (man.d-enemy.d>9) and (enemy.md=1) then
        BEGIN
          shouldfire := true;
          for temp.d := enemy.d to man.d do
            if (screen[enemy.o,temp.d]=wall) or
               (screen[enemy.o,temp.d]=blue) then
              shouldfire := false;
        END; (* if *)
      if shouldfire then
        BEGIN
          enemy.mmo := enemy.mo;
          enemy.mmd := enemy.md;
          StartMissile(enemy);
        END; (* if *)
    END; (* if *)

  (* Is Enemy Down The Stairs?  If So, Erase *)
  if ((enemy.o=8) and (enemy.d=23)) and done and (not dead) then
    BEGIN
      enemydone := True;
      eraseenemy(enemy,screen,encover)
    END; (* if *)
END;


PROCEDURE Burn (VAR Fire    : FireArray;
                VAR Max     : ListIndex;
                VAR Screen  : ScrnArray;
                VAR OldNum  : ListIndex;
                    Code    : CodeArray;
                VAR MinTurn : Word;
                    Turn    : Word;
                    Building: Word;
                VAR Score   : LongInt;
                VAR Bomb    : FireData;
                VAR Enemy   : Person;
                    Skill   : LongInt);
VAR
  Num       : ListIndex;
  Left      : Integer;
  Temp      : FireData;
  NoProcess : Boolean;
  Radius    : Word;
  ScoreStr  : String[10];
  sct       : word;

    PROCEDURE Plot (Fire    : Firedata;
                VAR Screen  : ScrnArray;
                    Code    : CodeArray;
                VAR Score   : LongInt;
                    Building: Word);
    BEGIN
      if screen[Fire.O,Fire.D] <> green then
        BEGIN
          if (cmdline[cl_VideoTranslation]=maxint) then
            memw[vidseg:vidwidth*2*(Fire.D-1)+2*(Fire.O-1)] :=
                                              Code[Fire.I]*256 + blockv
          else
            BEGIN
              GotoXY(Fire.O,Fire.D);
              charcolor(Code[Fire.I]);
              if Code[Fire.I]=0 then
                write(' ')
              else
                Write(Block)
            END; (* else *)
          Screen[Fire.O,Fire.D] := Code[Fire.I];
        END; (* if *)
      FuseUnder[Fire.O,Fire.D] := falseunder;
      swap(randseed,oldseed);
      if (random(2)=0) and (random(200)<maxfire) then
        BEGIN
          if noise then sound(random((maxfire div 2)+30)+10)
        END
      else
        if noise then
          if sensenoise then
            sound(senseHz)
          else
            sound(audlimit);
      swap(randseed,oldseed);
      if not fire.fuse then
        if (building=0) then
          score := score + 3
        else
          inc(score)
    END;

    PROCEDURE Explosion (Center  : FireData;
                     VAR Fire    : FireArray;
                     VAR MaxFire : ListIndex;
                         Radius  : Word;
                     VAR Screen  : ScrnArray;
                     VAR Bomb    : FireData;
                         Skill   : LongInt);
    VAR
      Temp      : FireData;
      Xadd      : Integer;
      Yadd      : Integer;
      Xcenter   : Integer;
      Ycenter   : Integer;
      RadTemp   : Real;
      I         : Integer;
      R         : word;
    BEGIN
      if noise then
        if sensenoise then
          sound(senseHz)
        else
          sound(audlimit);
      temp.i   := 5;
      temp.fuse:= false;
      xcenter  := center.o;
      ycenter  := center.d;
      radtemp  := skill;
      radius   := round(radius * (1+radtemp/5));
      if (radius>9) or
         ( (def[building,20]<>'0') and (level=floors[building]) ) then
        radius := 9;
      if ((bomb.o=xcenter) and (bomb.d=ycenter)) then
        bomb.i := 0;
      charcolor(white);
      i := sqr(radius)*4 + radius*4 + 1;
      swap(randseed,oldseed);
      for xadd := -radius to radius do
        for yadd := -radius to radius do
          BEGIN
            if noise then
              BEGIN
                if odd(i) then
                  sound(random(1000)+i*5)
                else
                  sound(random(i*5)+500);
                if noise then delay(1)
              END; (* if *)
            dec(i);
            if ((sqrtarr[sqr(xadd)+sqr(yadd)]<radius)
               and ((xcenter+xadd)>1) and ((xcenter+xadd)<39)
               and ((ycenter+yadd)>0) and ((ycenter+yadd)<26)) then
              BEGIN
                temp.o := xadd + xcenter;
                temp.d := yadd + ycenter;
                if (screen[temp.o,temp.d] in [0,2,7,11,16..255]) then
                  BEGIN
                    inc(maxfire);
                    r := random(maxfire)+1;
                    if radius<5 then r := maxfire;
                    fire[maxfire] := fire[r];
                    fire[r]       := temp;
                    screen[temp.o,temp.d] := Yellow;
                    if (directvideo=true) then
                      memw[vidseg:vidwidth*2*(temp.d-1)+2*(temp.o-1)] :=
                                                                   15*256 + 219
                    else
                      BEGIN
                        gotoxy(temp.o,temp.d);
                        write(block)
                      END; (* else *)
                  END (* if *)
              END (* if *)
          END; (* for *)
      if noise then (* was NoSound (for click effect) *)
        if sensenoise then
          sound(senseHz)
        else
          sound(audlimit);
      swap(randseed,oldseed);
    END;


BEGIN
  if (turn=minturn) then
    if (screen[4,23]=LightGray) then
      BEGIN
        inc(max);
        fire[max].o    := 4;
        fire[max].d    := 23;
        fire[max].i    := 2;
        fire[max].fuse := true;
        plot(fire[max],screen,code,score,building)
      END (* if *)
    else if (screen[40,7]=LightGray) then
      BEGIN
        inc(max);
        fire[max].o    := 40;
        fire[max].d    := 7;
        fire[max].i    := 2;
        fire[max].fuse := true;
        plot(fire[max],screen,code,score,building)
      END (* else *)
    else
      inc(minturn);
  if ((OldNum >= Max) or (OldNum < 1)) then
    Num := 1
  else
    Num := OldNum;
  Left := 55;

  While ((Left>0) and ((Num<=Max) or (Max>50))) do
    BEGIN
      if (num>max) then
        num := 1;
      noprocess := False;
      temp.d := fire[num].d-1;
      REPEAT
        temp.o := fire[num].o-1;
        REPEAT
          if ((temp.o in [1..39]) and (temp.d in [1..25])) then
           BEGIN
            sct := screen[temp.o,temp.d];
            if ( not (sct in [0,4,6,8,12,14]) ) then
              if (sct>=32) then
(* 32..255 *)   BEGIN
                         if ((fire[num].i=1) or (random>0.9)) then
                           BEGIN
                             temp.i    := 3;
                             temp.fuse := false;
                             inc(max);
                             fire[max] := temp;
                             plot(fire[max],screen,code,score,building)
                           END; (* if *)
                END
              else if (sct=7) then
(* 7 *)         BEGIN
                         if (random>0.1) then
                           BEGIN
                             if ( not fire[num].fuse ) or (
                                ( abs(fire[num].o-temp.o) + abs(fire[num].d-temp.d) = 1) and
                                ( (fire[num].o<=temp.o) or fuseunder[temp.o,temp.d].r) and
                                ( (fire[num].o>=temp.o) or fuseunder[temp.o,temp.d].l) and
                                ( (fire[num].d<=temp.d) or fuseunder[temp.o,temp.d].d) and
                                ( (fire[num].d>=temp.d) or fuseunder[temp.o,temp.d].u)
                                ) then
                               BEGIN
                                 if (fire[num].i>3) then
                                   temp.i := fire[num].i - 1
                                 else
                                   temp.i := 2;
                                 inc(max);
                                 temp.fuse := true;
                                 fire[max] := fire[num];
                                 fire[num] := temp;
                                 plot(fire[num],screen,code,score,building);
                                 noprocess := True;
                                 if (random<0.1) then
                                   dec(num)
                               END (* if *)
                           END (* if *)
                         else
                           BEGIN
                             if (fire[num].i<5) then
                               inc(fire[num].i)
                           END; (* else *)
                END
              else if (sct=2) then
(* 2 *)         BEGIN
                         if (fuseunder[temp.o,temp.d].u or
                             fuseunder[temp.o,temp.d].d or
                             fuseunder[temp.o,temp.d].l or
                             fuseunder[temp.o,temp.d].r) then
                           if ((fire[num].i=1) or (random>0.9)) then
                             BEGIN
                               temp.i    := 3;
                               temp.fuse := true;
                               inc(max);
                               fire[max] := temp;
                               plot(fire[max],screen,code,score,building)
                             END; (* if *)
                END
              else if (sct=3) then
(* 3 *)         BEGIN
                           temp.i    := 5;
                           temp.fuse := false;
                           inc(max);
                           fire[max] := temp;
                           plot(fire[max],screen,code,score,building)
                END
              else if (sct=11) then
(* 11 *)        BEGIN
                           inc(max);
                           temp.i    := 2;
                           temp.fuse := false;
                           fire[max] := fire[num];
                           fire[num] := temp;
                           plot(fire[num],screen,code,score,building);
                           noprocess := True;
                           enemy.o   := 0;
                           enemy.d   := 0
                END
              else if (sct=13) then
(* 13 *)        BEGIN
                           inc(max);
                           temp.i    := 2;
                           temp.fuse := true;
                           fire[max] := fire[num];
                           fire[num] := temp;
                           plot(fire[num],screen,code,score,building);
                           noprocess := True;
                           dead      := True
                END
              else if (sct in [1,15]) then
(* 1,15 *)      BEGIN
                           temp.i    := 5;
                           temp.fuse := false;
                           inc(max);
                           fire[max] := temp;
                           REPEAT
                             radius := random(10);
                           UNTIL (radius>=ord(def[building,10])-ord('0')) and
                                 (radius<=ord(def[building,11])-ord('0'));
                           if (bonusround>zero) and
                              (screen[temp.o,temp.d]=15) then
                             radius := 1;
                           plot(fire[max],screen,code,score,building);
                           explosion(temp,fire,max,radius,screen,bomb,skill)
                END
              else if (sct=17) then
(* 17 *)        BEGIN
                           temp.i    := 5;
                           temp.fuse := false;
                           inc(max);
                           fire[max] := temp;
                           plot(fire[max],screen,code,score,building);
                           radius := ord(def[building,9])-ord('0');
                           explosion(temp,fire,max,radius,screen,bomb,skill)
                END;
            END; (* if *)
          inc(temp.o)
        UNTIL (noprocess or (temp.o>fire[num].o+1) or (temp.o>40));
        inc(temp.d)
      UNTIL (noprocess or (temp.d>fire[num].d+1));
      if not noprocess then
        BEGIN
          if ((random<0.5) and (fire[num].i>1)) then
            dec(fire[num].i)
          else if (random<0.2) then
            dec(fire[num].i);
          if ((random<0.2) and (fire[num].i<5)) then
            inc(fire[num].i);
          plot(fire[num],screen,code,score,building);
          if (fire[num].i=0) then
            BEGIN
              if (fire[num].d in [22..24]) and
                 (fire[num].o in [7..34]) and
                 (fire[num].o mod 2 = 0) then
                BEGIN
                  screen[fire[num].o,fire[num].d] := brown;
                  charcolor(brown);
                  gotoxy(fire[num].o,fire[num].d);
                  write(block);
                END; (* if *)
              fire[num] := fire[max];
              dec(max)
            END; (* if *)
        END; (* if *)
      inc(num);
      dec(left)
    END; (* while *)
    oldnum := num;

    if maxfire>maxmaxfire then
      maxmaxfire := maxfire;
END;
