{$I-,R-}   { These directives are mandatory }
{$M 16384,0,0}

PROGRAM Pyro22 (Input, Output, Infile, Outfile, Logofile, Demorf, Demowf);

USES getmode, scrnctrl, compid, crypt, fade, instr, dos, crt, joystk;

(*>=============================== VARIABLES ===============================<*)

CONST
  block       = #219;
  wblock      = #177;
  cblock      = #254;
  halfblock   = #221;
  bottle      = #235;
  vile        = #229;
  space       = #32;
  blockv      = 219;
  bottlev     = 235;
  vilev       = 229;
  spacev      = 32;
  FuseOnStair = 6*16 + 7;
  audlimit    = 60000;
  senseHz     = 14825;
  endbld      : word = 19;
  endlev      : word = 10;
  masters     = 113;

TYPE
  listindex = 0..1133;
  sqrtindex = 0..200;
  mazeindex = 0..50;
  bldgindex = 0..30;
  topindex  = 1..10;
  gridindex1= 0..10;
  gridindex2= 0..6;
  fireindex = 0..5;
  diraindex = 0..5;
  titlindex = 1..6;
  sensindex = 0..3;
  dirindex  = -3..3;

  bldgtype  = string[14];
  nametype  = string[20];
  titltype  = string[40];

  position  = RECORD
                o   : overindex;
                d   : downindex
              END;
  dircoord  = RECORD
                o   : dirindex;
                d   : dirindex;
              END;
  firedata  = RECORD
                o   : overindex;
                d   : downindex;
                i   : fireindex;
                fuse: boolean
              END;
  person    = RECORD
                o   : overindex;
                d   : downindex;
                mo  : dirindex;
                md  : dirindex;
                mmo : dirindex;
                mmd : dirindex;
                ndi : diraindex;
              END;
  enemies   = RECORD
                bld : word;
                lev : word;
                name: nametype
              END;
  top       = RECORD
                name : nametype;
                score: longint;
                bld  : longint;
                lev  : word
              END;
  scenarios = RECORD
                name : titltype;
                index: scentype
              END;
  fusedir   = RECORD
                u : boolean;
                d : boolean;
                l : boolean;
                r : boolean;
              END;
  projdata  = RECORD
                o   : overindex;
                d   : downindex;
                mo  : integer;
                md  : integer;
                col : byte;
                ch  : char;
                expl: boolean;
              END;

  leakarray = array[listindex] of position;
  firearray = array[listindex] of firedata;
  codearray = array[fireindex] of byte;
  mazearray = array[mazeindex] of position;
  sensarray = array[sensindex] of position;
  scenarray = array[bldgindex] of scenarios;
  covrarray = array[dirindex,dirindex] of byte;
  gridarray = array[gridindex1,gridindex2] of word;
  fdirarray = array[overindex,downindex] of fusedir;
  titlarray = array[bldgindex,titlindex] of titltype;
  bldgarray = array[bldgindex] of bldgtype;
  flrarray  = array[bldgindex] of word;
  wcarray   = array[bldgindex] of byte;
  dirarray  = array[diraindex] of dircoord;
  enarray   = array[titlindex] of enemies;
  projarray = array[1..10] of projdata;
  dirok     = array[diraindex] of boolean;
  toparray  = array[topindex] of top;
  sqrttype  = array[sqrtindex] of real;
  fusearray = array[false..true,false..true,false..true,false..true] of char;
  secrarray = array[1..2] of titltype;
  defarray  = array[bldgindex] of nametype;

VAR
  vidspeed   : word;
  c          : char;
  lastkey    : char;
  secretmsg  : secrarray;
  fusepic    : fusearray;
  leak       : leakarray;
  fire       : firearray;
  code       : codearray;
  screen     : scrnarray;
  logo       : scrnarray;
  inv        : scrnarray;
  fuseunder  : fdirarray;
  falseunder : fusedir;
  covering   : covrarray;
  encover    : covrarray;
  buildings  : bldgarray;
  floors     : flrarray;
  risks      : flrarray;
  def        : defarray;
  wallcol    : wcarray;
  topten     : toparray;
  populace   : enarray;
  titles     : titlarray;
  sensor     : sensarray;
  dir        : dirarray;
  projectile : projarray;
  maxproj    : word;
  man        : person;
  manlast    : person;
  enemy      : person;
  maxleak    : listindex;
  maxfire    : listindex;
  maxmaxfire : listindex;
  lastfire   : listindex;
  logofile   : logotype;
  scen       : scentype;
  minturn    : word;
  bonusround : word;
  wall       : byte;
  sensetime  : integer;
  zero       : integer;
  minscore   : longint;
  score      : longint;
  total      : longint;
  skill      : longint;
  oldseed    : longint;
  bomb       : firedata;
  potion     : firedata;
  powpotion  : firedata;
  viles      : word;
  building   : word;
  maxbld     : word;
  level      : word;
  maxlevel   : word;
  fuselength : word;
  cans       : word;
  turn       : word;
  lastturn   : word;
  newtime    : word;
  invis      : word;
  elapsed    : longint;
  jumptime   : word;
  joyleft    : word;
  joyright   : word;
  joyup      : word;
  joydown    : word;
  enemytime  : word;
  enemystart : word;
  playing    : boolean;
  demodone   : boolean;
  joystick   : boolean;
  calibrated : boolean;
  pickup     : boolean;
  lastshift  : boolean;
  highspeed  : boolean;
  makeleak   : boolean;
  makemissile: boolean;
  throwing   : boolean;
  dropped    : boolean;
  done       : boolean;
  enemydone  : boolean;
  dead       : boolean;
  quit       : boolean;
  nospread   : boolean;
  jump       : boolean;
  tripped    : boolean;
  untripped  : boolean;
  closed     : boolean;
  demo       : boolean;
  power      : boolean;
  numdemos   : word;
  prevbld    : word;
  prevskill  : longint;
  chist      : string[10];
  page       : integer;
  finished   : boolean;
  nextpage   : boolean;
  secbld     : boolean;
  sensenoise : boolean;
  sqrtarr    : sqrttype;
  infile     : text;
  demorf     : text;
  demowf     : text;
  demow      : boolean;
  toptenname : titltype;
  dl_type    : word;
  dl_zoom    : real;
  dl_o,dl_d  : real;
  scenname   : titltype;
  scencid    : word;

(*>======================== FUNCTIONS AND PROCEDURES========================<*)


{$F+}
PROCEDURE Exchange (VAR var1, var2; count : word); external;
{$L EXCHANGE.OBJ}
{$F-}


PROCEDURE Swap (VAR seed1 : Longint;
                VAR seed2 : Longint);
VAR
  exchange  : longint;
BEGIN
  exchange := seed1;
  seed1    := seed2;
  seed2    := exchange
END;


FUNCTION ReadUnScramble (VAR F : Text) : DataType;
VAR
  temp      : DataType;
BEGIN
  temp := Crypt.ReadUnScramble(F);
  if temp='BADCRC' then
    CheckSumBad;
  ReadUnScramble := temp;
END;


PROCEDURE InitVariables;
VAR
  count     : position;
  count2    : word;
  count3    : longint;
BEGIN
  falseunder.u := false;
  falseunder.d := false;
  falseunder.l := false;
  falseunder.r := false;
  for count.o := 0 to 41 do
    for count.d := 0 to 26 do
      BEGIN
        screen[count.o,count.d]    := 16;
        fuseunder[count.o,count.d] := falseunder;
      END; (* for *)
  for count2 := 0 to 5 do
    BEGIN
      dir[count2].o := 0;
      dir[count2].d := 0
    END; (* for *)
  if (elapsed>0) then
    elapsed := 1190;
  fusepic[false,false,false,false] := #250;
  fusepic[false,false,false,TRUE ] := #196;
  fusepic[false,false,TRUE ,false] := #196;
  fusepic[false,false,TRUE ,TRUE ] := #196;
  fusepic[false,TRUE ,false,false] := #179;
  fusepic[false,TRUE ,false,TRUE ] := #218;
  fusepic[false,TRUE ,TRUE ,false] := #191;
  fusepic[false,TRUE ,TRUE ,TRUE ] := #194;
  fusepic[TRUE ,false,false,false] := #179;
  fusepic[TRUE ,false,false,TRUE ] := #192;
  fusepic[TRUE ,false,TRUE ,false] := #217;
  fusepic[TRUE ,false,TRUE ,TRUE ] := #193;
  fusepic[TRUE ,TRUE ,false,false] := #179;
  fusepic[TRUE ,TRUE ,false,TRUE ] := #195;
  fusepic[TRUE ,TRUE ,TRUE ,false] := #180;
  fusepic[TRUE ,TRUE ,TRUE ,TRUE ] := #197;
  dir[0].o    := -1;
  dir[1].d    := -1;
  dir[2].o    := 1;
  dir[3].d    := 1;
  dir[4].o    := -1;
  dir[5].d    := -1;
  code[0]     := 0;
  code[1]     := 8;
  code[2]     := 6;
  code[3]     := 4;
  code[4]     := 12;
  code[5]     := 14;
  maxleak     := 0;
  maxfire     := 0;
  building    := zero; (* make the EXE file harder to hack *)
  level       := zero;
  cans        := zero;
  viles       := zero;
  invis       := zero;
  wall        := zero;
  score       := zero;
  total       := zero;
  skill       := zero;
  bonusround  := zero;
  lastkey     := ' ';
  chist       := '';
  fuselength  := 25;
  enemytime   := 0;
  enemydone   := False;
  Dead        := False;
  Quit        := False;
  MakeLeak    := False;
  MakeMissile := False;
  Pickup      := False;
  Dropped     := False;
  Jump        := False;
  SecBld      := False;
  SenseNoise  := False;
  Power       := False;

  if cmdline[cl_Code]=scrnctrl.code1 then
    BEGIN
      if (cmdline[cl_Building]>0) and (cmdline[cl_Building]<=endbld) then
        building := cmdline[cl_Building]-1;
      if (cmdline[cl_Skill]>0) and (cmdline[cl_Skill]<maxint) then
        skill := cmdline[cl_Skill];
    END; (* if *)
END;


PROCEDURE Copyright;
VAR
  count1    : word;
  count2    : word;
  count3    : longint;
BEGIN
  msg[0] := 'Pyro';
  msg[1] := 'Version 2.2.4    (C)Copyright Michael O''Brien, 1991-93';
                   { ^version }                            { ^date }
  msg[2] := '                 All Rights Reserved.';
  msg[3] := 'First Release:   12 July 1993';
           { ^version }     { ^date }
  msg[4] := 'PYRO version 2.2.4';
                             { ^version }
  msg[5] := 'Copyright 1991-93, Michael O''Brien.';
                     { ^date }
  msg[6] := 'All rights reserved.';

  count3 := 0;
  for count2 := 1 to 255 do
    for count1 := 1 to 5 do
      if count2 <= length(msg[count1]) then
        count3 := count3 + ord(msg[count1,count2]);

  if count3<>12878 then
           { ^version }
           { ^date }
    checksumbad;

  if cmdline[cl_Copyright]<maxint then
    BEGIN
      directvideo := false;
      checkbreak  := true;
      writeln(msg[0]);
      writeln(msg[1]);
      writeln(msg[2]);
      writeln(msg[3]);
      halt(0);
    END; (* if *)
END;


PROCEDURE ShowViles (Viles : Word);
VAR
  count     : word;

  FUNCTION Pow10 (Exponent : Word) : Word;
  VAR
    result : word;
  BEGIN
    result := 1;
    while (exponent>1) do
      BEGIN
        result   := result * 10;
        exponent := exponent - 1
      END; (* while *)
    pow10 := result;
  END;

  PROCEDURE Digit (Viles   : Word;
                   Divisor : Word);
  BEGIN
    if (viles < divisor) then
      write(' ')
    else
      write((viles mod (divisor*10)) div divisor);
  END;

BEGIN
  charcolor(White);
  if (viles<5) then
    for count := 1 to 4 do
      BEGIN
        gotoxy(1,count);
        if (viles<count) then
          write(space)
        else
          write(vile)
      END (* for *)
  else
    for count := 1 to 4 do
      BEGIN
        gotoxy(1,count);
        digit(viles,pow10(5-count))
      END; (* for *)
END;


PROCEDURE DownShift (VAR Data : Datatype);
VAR
  i       : integer;
BEGIN
  for i := 1 to length(data) do
    if (ord(data[i]) > 139) then
      data[i] := chr(ord(data[i])-139)
END;


PROCEDURE ReadScenario (Scen      : ScenType);
VAR
  count     : word;
  count2    : word;
  errcode   : integer;
BEGIN
  assign(infile,prefix+'S'+Scen);
  reset(infile);
  scenname     := readunscramble(infile);
  val(readunscramble(infile),scencid,errcode);
  val(readunscramble(infile),minscore,errcode);
  val(readunscramble(infile),dl_type,errcode);
  val(readunscramble(infile),dl_zoom,errcode);
  val(readunscramble(infile),dl_o,errcode);
  val(readunscramble(infile),dl_d,errcode);
  secretmsg[1] := readunscramble(infile);
  secretmsg[2] := readunscramble(infile);
  toptenname   := readunscramble(infile);
  val(readunscramble(infile),endbld,errcode);
  val(readunscramble(infile),numdemos,errcode);
  maxbld := endbld;
  for count := 0 to maxbld do
    BEGIN
      buildings[count] := readunscramble(infile);
      for count2 := 1 to 5 do
        titles[count,count2] := readunscramble(infile);
      val(readunscramble(infile),floors[count],errcode);
      val(readunscramble(infile),wallcol[count],errcode);
      if wallcol[count]=FuseOnStair then
        inc(wallcol[count]);
      val(readunscramble(infile),risks[count],errcode);
      def[count] := readunscramble(infile);
      if length(def[count])<>20 then checksumbad;
    END; (* for *)
  endlev := floors[maxbld];
  for count := 1 to 6 do
    BEGIN
      val(readunscramble(infile),populace[count].bld,errcode);
      val(readunscramble(infile),populace[count].lev,errcode);
      populace[count].name := readunscramble(infile)
    END; (* for *)
  for count := 1 to 10 do
    BEGIN
      topten[count].name := readunscramble(infile);
      val(readunscramble(infile),topten[count].score,errcode);
      val(readunscramble(infile),topten[count].bld,errcode);
      val(readunscramble(infile),topten[count].lev,errcode)
    END; (* for *)
  close(infile)
END;


PROCEDURE WriteScenario (Buildings : BldgArray;
                         Floors    : FlrArray;
                         Titles    : TitlArray;
                         MaxBld    : Word;
                         TopTen    : TopArray;
                         Populace  : EnArray;
                         Scen      : ScenType);
VAR
  count     : word;
  count2    : word;
  outfile   : Text;
  convert   : datatype;

  PROCEDURE WriteCon(x : longint);
  BEGIN
    str(x,convert);
    writeln(outfile,scramble(convert));
  END;

BEGIN
  assign(outfile,prefix+'S'+Scen);
  rewrite(outfile);
  writeln(outfile,scramble(scenname));
  writecon(scencid);
  writecon(minscore);
  writecon(dl_type);
  str(dl_zoom:5:4,convert); writeln(outfile,scramble(convert));
  str(dl_o   :5:4,convert); writeln(outfile,scramble(convert));
  str(dl_d   :5:4,convert); writeln(outfile,scramble(convert));
  writeln(outfile,scramble(secretmsg[1]));
  writeln(outfile,scramble(secretmsg[2]));
  writeln(outfile,scramble(toptenname));
  writecon(endbld);
  writecon(numdemos);
  for count := 0 to maxbld do
    BEGIN
      writeln(outfile,scramble(buildings[count]));
      for count2 := 1 to 5 do
        writeln(outfile,scramble(titles[count,count2]));
      writecon(floors[count]);
      writecon(wallcol[count]);
      writecon(risks[count]);
      writeln(outfile,scramble(def[count]));
    END; (* for *)
  for count := 1 to 6 do
    BEGIN
      writecon(populace[count].bld);
      writecon(populace[count].lev);
      writeln(outfile,scramble(populace[count].name))
    END; (* for *)
  for count := 1 to 10 do
    BEGIN
      writeln(outfile,scramble(topten[count].name));
      writecon(topten[count].score);
      writecon(topten[count].bld);
      writecon(topten[count].lev);
    END; (* for *)
  close(outfile)
END;


PROCEDURE WriteName (Buildings : BldgArray;
                     Building  : Word;
                     Level     : Word;
                     MaxLevel  : Word;
                     Populace  : EnArray);
VAR
  name      : bldgtype;
  pos       : position;
  count     : word;
  top       : word;
BEGIN
  name  := buildings[building];
  pos.o := 40;
  top   := 23 - length(name);
  charcolor(LightRed);
  for count := 1 to length(name) do
    BEGIN
      pos.d := count + top;
      gotoxy(pos.o,pos.d);
      write(copy(name,count,1))
    END; (* for *)
  if directvideo then
    BEGIN
      if (maxlevel=0) or (maxlevel>9) then
        mem[vidseg:vidend-2] := 63
      else
        mem[vidseg:vidend-2] := (49+maxlevel)-level;
      mem[vidseg:vidend-1] := mem[vidseg:vidend-1-4*2*vidwidth];
    END; (* if *)
  top := 0;
  for count := 1 to 6 do
    if ((populace[count].lev=level) and (populace[count].bld=building)) then
      top := count;
  if (enemy.o>0) then
    BEGIN
      if (enemystart>0) then
        name := ''
      else if (top>0) then
        name := 'IT''S '+populace[top].name
      else
        name := 'A GUARD';
      pos.o := 1;
      top   := 24-length(name);
      charcolor(lightred);
      for count := 1 to length(name) do
        BEGIN
          pos.d := count + top;
          gotoxy(pos.o,pos.d);
          write(copy(name,count,1))
        END; (* for *)
      if directvideo then
        BEGIN
          mem[vidseg:vidend-2*vidwidth]   := 33;
          mem[vidseg:vidend+1-2*vidwidth] := mem[vidseg:vidend+1-5*2*vidwidth]
        END (* if *)
    END; (* if *)
END;


PROCEDURE ResetToggle (VAR shift, scroll, alt, caps : boolean);
BEGIN
  shift := False;
  scroll:= False;
  alt   := False;
  caps  := False;
END;


PROCEDURE ResetLights;
BEGIN
  asm CLI end;  (* disable interrupts *)
  mem[$0040:$0017] := (mem[$0040:$0017] and (255-16-32-64)) + lights;
  asm STI end;  (* enable interrupts *)
END;


PROCEDURE CheckToggle (VAR shift, scroll, alt, caps : boolean);
VAR
  a, b       : byte;
BEGIN
  a := mem[$0040:$0017];
  b := mem[$0040:$0018];
  ResetLights;

  if ((a and 1)=1) or ((a and 2)=2) then
    shift := True;
  if (cmdline[cl_Pyro21Keys]=0) then
    BEGIN   (* actually Ctrl, not ScrLock *)
      if ((a and 4)=4) then
        scroll := True
    END (* if *)
  else
    BEGIN
      if ((b and 16)=16) then
        scroll := True
    END; (* else *)
  if ((a and 8)=8) then
    alt := True;
  if ((b and 64)=64) then
    caps := True;
END;


PROCEDURE InitTime (VAR LastTurn : Word);
VAR
  Hour      : Word;
  Minute    : Word;
  Second    : Word;
  Hundredth : Word;
BEGIN
  GetTime(Hour,Minute,Second,Hundredth);
  LastTurn := Hundredth
END;


FUNCTION VideoSpeed : Word;
VAR
  i, j      : word;
  t1, t2    : longint;
BEGIN
  if cmdline[cl_NoSpeedTest]=0 then
    videospeed := 0
  else
    BEGIN
      REPEAT
        t1 := meml[$40:$6C];
        REPEAT UNTIL t1<>meml[$40:$6C];
        for j := 1 to 1100 do
          BEGIN
            gotoxy(random(39)+1,random(24)+1);
            charcolor(random(16));
            write(' ');
          END; (* for *)
        t2 := meml[$40:$6C];
      UNTIL t2>t1;
      videospeed := (t2-t1);
    END; (* else *)
  if cmdline[cl_ShowTestSpeed]=0 then
    BEGIN
      CloseScreen(origmode);
      directvideo := false;
      checkbreak  := true;
      writeln;
      writeln('Video Output Speed: ',(t2-t1));
      writeln('Lower numbers indicate better performance.');
      halt(0);
    END; (* if *)
END;


PROCEDURE MoveProjectiles;
VAR
  count, p  : word;
  oncolor   : byte;
BEGIN
  for count := 1 to 1 do
    BEGIN
      p := 0;
      while (p<maxproj) do
        BEGIN
          inc(p);
          if (memw[vidseg:(projectile[p].d-1)*2*vidwidth+projectile[p].o*2-2]=
              ord(projectile[p].ch)+256*projectile[p].col) then
            BEGIN
              gotoxy(projectile[p].o,projectile[p].d);
              charcolor(screen[projectile[p].o,projectile[p].d]);
              CASE (screen[projectile[p].o,projectile[p].d]) OF
                Black     : Write(Space);
                Blue      : Write(Bottle);
                White     : Write(Vile);
                16..255   : Write(WBlock);
                Green     : Write(Block);
                LightGray : if not
                            (fuseunder[projectile[p].o,projectile[p].d].u or
                             fuseunder[projectile[p].o,projectile[p].d].d or
                             fuseunder[projectile[p].o,projectile[p].d].l or
                             fuseunder[projectile[p].o,projectile[p].d].r) then
                              write(block)
                            else
                             BEGIN
                                if (projectile[p].d in [22..24]) and
                                   (projectile[p].o in [7..34]) and
                                   (projectile[p].o mod 2 = 0) then
                                  charcolor(brown*16+lightgray);
                                write(fusepic[
                                  fuseunder[projectile[p].o,projectile[p].d].u,
                                  fuseunder[projectile[p].o,projectile[p].d].d,
                                  fuseunder[projectile[p].o,projectile[p].d].l,
                                  fuseunder[projectile[p].o,projectile[p].d].r]);
                              END; (* else *)
                else        Write(Block);
              END; (* case *)
            END; (* if *)
          projectile[p].o := projectile[p].o + projectile[p].mo;
          projectile[p].d := projectile[p].d + projectile[p].md;
          oncolor := mem[vidseg:(projectile[p].d-1)*2*vidwidth+
                         projectile[p].o*2-1];
          if (not (oncolor in [0,6..8,FuseOnStair]) ) or
              (projectile[p].o in [2,38]) or (projectile[p].d in [1,25]) then
            BEGIN
              if projectile[p].expl then
                BEGIN
                  screen[projectile[p].o,projectile[p].d] :=
                    projectile[p].col;
                  inc(maxfire);
                  fire[maxfire].o    := projectile[p].o;
                  fire[maxfire].d    := projectile[p].d;
                  fire[maxfire].i    := 5;
                  fire[maxfire].fuse := false;
                END; (* if *)
              projectile[p] := projectile[maxproj];
              dec(maxproj);
              dec(p);
            END (* if *)
          else
            BEGIN
              gotoxy(projectile[p].o,projectile[p].d);
              charcolor(projectile[p].col);
              write(projectile[p].ch);
            END; (* else *)
        END; (* while *)
    END; (* for *)
END;


PROCEDURE Refresh (Screen : ScrnArray);
VAR
  count     : position;
  top       : overindex;
  refmsg    : string[4];
  i         : integer;
BEGIN
  for count.d := 1 to 25 do
    BEGIN
      GotoXY(1,count.d);
      if (count.d<24) then
        top := 40
      else
        top := 39;
      for count.o := 1 to top do
        if (level=0) then
          BEGIN
            charcolor(screen[count.o,count.d]);
            if screen[count.o,count.d]=black then
              write(space)
            else
              write(block)
          END (* if *)
        else
          BEGIN
            charcolor(screen[count.o,count.d]);
            CASE (screen[count.o,count.d]) OF
              Black     : Write(Space);
              Blue      : Write(Bottle);
              White     : Write(Vile);
              16+Yellow : BEGIN
                            charcolor(Yellow);
                            write(Vile);
                          END;
              16..255   : Write(WBlock);
              Green     : if (count.o=2) and (count.d=2) and
                             (screen[sensor[1].o,sensor[1].d]=green) then
                            BEGIN
                              charcolor(darkgray*16+green);
                              write(HalfBlock);
                            END (* if *)
                          else
                            Write(Block);
              LightGray : if not (fuseunder[count.o,count.d].u or
                                  fuseunder[count.o,count.d].d or
                                  fuseunder[count.o,count.d].l or
                                  fuseunder[count.o,count.d].r) then
                            write(block)
                          else
                            BEGIN
                              if (count.d in [22..24]) and
                                 (count.o in [7..34]) and
                                 (count.o mod 2 = 0) then
                                charcolor(brown*16+lightgray);
                              write(fusepic[
                                            fuseunder[count.o,count.d].u,
                                            fuseunder[count.o,count.d].d,
                                            fuseunder[count.o,count.d].l,
                                            fuseunder[count.o,count.d].r]);
                            END; (* else *)
              else        Write(Block);
            END; (* case *)
          END; (* else *)
    END; (* for *)

  refmsg := '';
  if demow and (level>0) then refmsg := 'REC'+chr(64+cmdline[cl_RecDemoNum]);
  if demo  and (level>0) then refmsg := 'DEMO';
  if refmsg<>'' then
    for i := 1 to 4 do
      BEGIN
        gotoxy(40,i);
        charcolor(white);
        write(refmsg[i]);
      END; (* for *)
END;


PROCEDURE KeyStroke (VAR C : Char);
VAR
  asc       : integer;
  ack       : integer;
  o, d      : word;
BEGIN
  if not Playing then
    ResetLights;
  c := readkey;
  chist := copy(c+chist,1,10);
  if (chist='8426037417') and (bonusround=zero) and
     (building=10) and (level=3) and (scen='AT') then
    for o := 1 to 39 do
      for d := 1 to 25 do
        if screen[o,d]=wall then
          BEGIN
            charcolor(white);
            gotoxy(o,d);
            write(vile);
            screen[o,d] := white;
            bonusround := 26;
          END; (* if *)
  if (c=#0) then
    BEGIN
      c := readkey;
      asc := -ord(c)
    END (* if *)
  else
    asc := ord(c);
  if ( (asc=-32) or (asc=4) ) and playing then
    BEGIN
      if graphics then
        CharGen(0);
      closescreen(origmode);
      writeln;
      writeln;
      writeln('Type ''EXIT'' to return to your game.');
      if noise then nosound;
      exec(getenv('COMSPEC'),'');
      ack := ioresult;
      origmode := getinitmode;
      initscreen(initmode);
      if Graphics then
        CharGen(1);
      refresh(screen);
    END; (* if *)
  if ( (asc=-31) or (asc=19) ) and (cmdline[cl_NoSound]=maxint) then
    BEGIN
      noise := not noise;
      nosound;
    END; (* if *)
  if ( (asc=-117) or (asc=-16) or (asc=17) ) then
    if (building>0) then
      quit := true
    else
      BEGIN
        FadeOut;
        CloseScreen(origmode);
        BetaTest(true);
        ShareWare;
        if noise then nosound;
        halt(0)
      END; (* else *)
END;


PROCEDURE ClearBuffer;
VAR
  c         : char;
BEGIN
  while keypressed do
    keystroke(c)
END;


PROCEDURE DrawQuitLogo;
BEGIN
  charcolor(Red*16+Yellow);
  gotoxy(16,11);
  write('        ');
  gotoxy(16,12);
  write('  QUIT  ');
  gotoxy(16,13);
  write('        ');
  charcolor(DarkGray*16+Black);
  gotoxy(24,12);
  write(' ');
  gotoxy(24,13);
  write(' ');
  gotoxy(17,14);
  write('        ');
  charcolor(black);
END;


PROCEDURE NewBuilding (VAR Building   : Word;
                       VAR Level      : Word;
                       VAR Wall       : Byte;
                       VAR Cans       : Word);
VAR
  i         : integer;
BEGIN
  if secbld then
    BEGIN
      for i := 1 to maxbld do
        if def[i,1]<>'0' then
          building := i+1;
      if building>maxbld then
        building := maxbld;
    END (* if *)
  else
    inc(building);
  if (cans=5) then
    BEGIN
      cans     := 4;
      building := 0;
      wall     := wallcol[0];
    END; (* if *)
  secbld    := (building = 0);
  wall      := wallcol[building];
  enemytime := zero;
  level     := zero;
END;


PROCEDURE NewLevel (VAR Level      : Word;
                    VAR FuseLength : Word;
                    VAR Man        : Person;
                    VAR Enemy      : Person;
                    VAR Done       : Boolean;
                    VAR MaxFire    : ListIndex;
                    VAR MaxMaxFire : ListIndex;
                    VAR MaxLeak    : ListIndex;
                    VAR MinTurn    : Word;
                    VAR Turn       : Word;
                        Jump       : Boolean;
                        Cans       : Word;
                    VAR Tripped    : Boolean;
                        Populace   : EnArray;
                        Building   : Word);
VAR
  count     : word;
BEGIN
  inc(level);
  if jump then
    BEGIN
      man.o  := 39;
      man.d  := 7;
      man.mo := -1;
      man.md := 0;
      manlast.o := 39;
      manlast.d := 7;
    END (* if *)
  else
    BEGIN
      man.o  := 4;
      man.d  := 23;
      man.mo := 0;
      man.md := -1;
      manlast.o := 4;
      manlast.d := 23;
    END; (* else *)
  man.ndi    := zero;
  enemy.o    := zero;
  enemy.d    := zero;
  enemy.mo   := zero;
  enemy.md   := zero;
  enemy.ndi  := zero;
  maxfire    := zero;
  maxleak    := zero;
  turn       := zero;
  maxmaxfire := zero;
  maxproj    := zero;
  done       := False;
  tripped    := False;
  untripped  := False;
  closed     := False;
  if (fuselength < 7) then
    fuselength := 7;
  if (fuselength < 40) then
    minturn := fuselength
  else
    minturn := 40;
  fuselength := zero;
  enemystart := enemytime;
  enemytime  := zero;
  if (cans>4) then
    cans := 4;
  if enemystart>0 then
    inc(enemystart)
  else
    for count := 1 to 5 do
      if (((building = populace[count].bld) and (level = populace[count].lev))
         or ( ( ( ord(def[building,5])-ord('0') ) > random(25) ) and
              ( jump or not enemydone ) ) or
         ((building=endbld) and (level=endlev))) then
        BEGIN
          enemy.o    := 36;
          enemy.d    := 3;
          enemy.mo   := 0;
          enemy.md   := 1;
          enemy.ndi  := 0;
          enemystart := zero;
          enemydone  := false;
        END; (* if *)
  if enemydone and (not jump) and (enemy.o=0) then
    BEGIN
      enemy.o       := 4;
      enemy.d       := 23;
      enemy.mo      := 0;
      enemy.md      := 1;
      enemy.ndi     := 0;
      enemydone     := false;
    END; (* if *)
END;


PROCEDURE ReactorOne (VAR Screen : ScrnArray);
VAR
  pos     : position;
BEGIN
  for pos.d := 2 to 20 do
    for pos.o := 3 to 37 do
      screen[pos.o,pos.d] := Black;
END;


PROCEDURE ReactorTwo (VAR Screen : ScrnArray;
                          Wall   : Byte);
VAR
  i       : integer;
  pos     : position;
BEGIN
  for pos.d := 5 to 17 do
    for pos.o := 10 to 30 do
      screen[pos.o,pos.d] := wall;
  for pos.d := 6 to 16 do
    for pos.o := 11 to 29 do
      if (random(25)=1) then
        screen[pos.o,pos.d] := Blue
      else
        screen[pos.o,pos.d] := Cyan;
  charcolor(White);
  gotoxy(10,5);
  write('ͻ');
  gotoxy(10,17);
  write('ͼ');
  for i := 6 to 16 do
    BEGIN
      gotoxy(10,i);
      write('');
      gotoxy(30,i);
      write('')
    END; (* for *)
  gotoxy(11,6);
  write('NUCLEAR');
  gotoxy(22,16);
  write('REACTOR');
  charcolor(Blue);
  for pos.d := 6 to 16 do
    for pos.o := 11 to 29 do
      if (sqrtarr[sqr(11-pos.d)+sqr(20-pos.o)]<5) then
        BEGIN
          gotoxy(pos.o,pos.d);
          write(block)
        END; (* if *)
END;


PROCEDURE Spread (VAR Leak     : LeakArray;
                  VAR MaxLeak  : ListIndex;
                  Var Screen   : ScrnArray;
                      Building : Word;
                      NoSpread : Boolean);
VAR
  left      : word;
  num       : listindex;
  temp      : position;
  onstairs  : boolean;
BEGIN
  if (building>2) then
    left := building - 1
  else
    left := 1;
  while ((left>0) and (maxleak>0)) do
    BEGIN
      num := random(maxleak)+1;
      onstairs := ((leak[num].o in [8..35]) and (leak[num].d in [22..24]));
      if ((screen[leak[num].o,leak[num].d]=Cyan) or
        ((screen[leak[num].o,leak[num].d]=LightMagenta) and not NoSpread)) then
        BEGIN
          for temp.o := leak[num].o-1 to leak[num].o+1 do
            for temp.d := leak[num].d-1 to leak[num].d+1 do
              if ((temp.o in [2..38]) and (temp.d in [1..25])) then
                if (((screen[temp.o,temp.d]=Black) and not onstairs) or
                (((screen[temp.o,temp.d]=Black) or
                (screen[temp.o,temp.d]=Brown)) and (temp.d in [22..24]) and
                (temp.o<=leak[num].o) and (temp.o>7))) then
                  BEGIN
                    inc(maxleak);
                    leak[maxleak] := temp;
                    screen[temp.o,temp.d] := Cyan;
                    charcolor(Cyan);
                    GotoXY(temp.o,temp.d);
                    write(Block)
                  END;
          dec(left)
        END (* if *)
      else
        BEGIN
          leak[num] := leak[maxleak];
          dec(maxleak)
        END; (* if *)
    END; (* while *)
END;


PROCEDURE CountFuse (VAR FuseLength : Word;
                         Screen     : ScrnArray);
BEGIN
  if ((screen[8,23]=LightGray) or (screen[1,7]=LightGray)) then
    inc(fuselength);
  if (not enemydone) then
    inc(enemytime);
END;


PROCEDURE ComputeJumpTime (VAR JumpTime : Word;
                               Jump     : Boolean;
                               Building : Word;
                               Level    : Word;
                               MaxLevel : Word);
BEGIN
  if jump then
    jumptime := 33 + (building * 9)
  else
    jumptime := 100 + (building * 10);
  if (building = 0) then
    jumptime := (maxint - 21)
END;


PROCEDURE Passage (Turn    : Word;
                   JumpTime: Word;
               VAR Screen  : ScrnArray;
                   Wall    : Byte;
                   Done    : Boolean;
                   Dead    : Boolean);
VAR
  temp      : position;
  result    : boolean;
BEGIN
  if ((turn=jumptime) and (not done) and (not dead)) then
    BEGIN
      result := true;
      temp.o := 2;
      for temp.d := 6 to 8 do
        if (screen[temp.o,temp.d]<>wall) then
          result := false;
      if result then
        BEGIN
          charcolor(Black);
          for temp.d := 6 to 8 do
            BEGIN
              screen[temp.o,temp.d] := Black;
              gotoxy(temp.o,temp.d);
              write(block)
            END; (* for *)
          charcolor(Green);
          screen[1,5] := Green;
          screen[1,9] := Green;
          gotoxy(1,5);
          write(block);
          gotoxy(1,9);
          write(block)
        END; (* if *)
    END; (* if *)
  if (turn=jumptime+20) then
    BEGIN
      result := true;
      for temp.o := 1 to 2 do
        for temp.d := 6 to 8 do
          if (screen[temp.o,temp.d]<>Black) then
            result := false;
      if ((screen[1,5]<>Green) or (screen[1,9]<>Green)) then
        result := false;
      if result then
        BEGIN
          charcolor(Black);
          temp.o := 1;
          for temp.d := 5 to 9 do
            BEGIN
              screen[temp.o,temp.d] := Black;
              gotoxy(temp.o,temp.d);
              write(block)
            END; (* for *)
          charcolor(Wall);
          temp.o := 2;
          for temp.d := 6 to 8 do
            BEGIN
              screen[temp.o,temp.d] := Wall;
              gotoxy(temp.o,temp.d);
              write(wblock)
            END; (* for *)
        END; (* if *)
    END; (* if *)
END;


PROCEDURE CheckSum (Target : LongInt);
VAR
  Total     : LongInt;
  Loop      : Integer;
  Loop2     : Integer;
BEGIN
  if not directvideo then exit;
  total  := 0;
  for loop2 := 0 to 24 do
    for loop := 0 to 39 do
      if mem[vidseg:loop*2+loop2*vidwidth*2] in [33..127] then
        total := total + mem[vidseg:loop*2+loop2*vidwidth*2];
  if (total<>target) and (cmdline[cl_Code]=scrnctrl.code1) then
    BEGIN
      textcolor(white);
      gotoxy(1,1);
      write(total);
    END (* if *)
  else
    if (total<>target) then CheckSumBad
      else
    if (target<>total) then CheckSumBad; (* redundancy to confuse hackers *)
END;


PROCEDURE Sense (VAR Tripped  : Boolean;
                 VAR Sensor   : SensArray;
                     Man      : Person;
                 VAR Screen   : ScrnArray;
                     Wall     : Byte;
                 VAR SenseTime: Integer);
VAR
  temp      : position;
  temp2     : byte;
BEGIN
  if (man.o<=4) and (man.d<=3) and (not (dead or done or quit)) and
     (closed) and (screen[2,2]=green) and
     (screen[sensor[1].o,sensor[1].d]=green) then
    BEGIN
      tripped   := false;
      untripped := true;
      closed    := false;
      if noise then
        BEGIN
          for temp2 := 0 to 4 do
            BEGIN
              sound(500+random(900));
              delay(15);
            END;
          sound(audlimit);
        END; (* if *)
    END; (* if *)
  sensenoise := false;
  if (tripped and (sensetime>0)) then
    dec(sensetime)
  else
    if noise then sound(audlimit);
  if (tripped and (sensetime=0) and (screen[sensor[1].o,sensor[1].d]=Green))
  then
    BEGIN
      closed      := true;
      sensor[3].o := sensor[3].o + sensor[0].o;
      sensor[3].d := sensor[3].d + sensor[0].d;
      if ((sensor[3].o=sensor[2].o) and (sensor[3].d=sensor[2].d)) then
        tripped := False
      else
        BEGIN
          temp2 := screen[sensor[3].o,sensor[3].d];
          if (temp2 in [Blue,LightCyan,LightMagenta]) or
             ( (abs(sensor[3].o-man.o)<=1) and (abs(sensor[3].d-man.d)<=1)
               and (not dead) and (not done) ) then
            BEGIN
              sensor[3].o := sensor[3].o - sensor[0].o;
              sensor[3].d := sensor[3].d - sensor[0].d
            END (* if *)
          else
            BEGIN
              screen[sensor[3].o,sensor[3].d] := Green;
              charcolor(Green);
              gotoxy(sensor[3].o,sensor[3].d);
              write(block)
            END (* else *)
        END; (* else *)
    END (* if *)
  else
    if ((screen[sensor[1].o,sensor[1].d]=Green) and
        (screen[sensor[2].o,sensor[2].d]=Green)) then
      BEGIN
        temp   := sensor[1];
        REPEAT
          temp.o := temp.o + sensor[0].o;
          temp.d := temp.d + sensor[0].d;
        UNTIL (((temp.o=sensor[2].o) and (temp.d=sensor[2].d))
              or (screen[temp.o,temp.d]<>Black));
        if ((screen[temp.o,temp.d]=LightMagenta) or
           (screen[temp.o,temp.d]=Blue) or
           ((screen[temp.o,temp.d]<>Green) and not tripped)) then
          BEGIN
            tripped := True;
            sensor[3] := sensor[1];
            sensetime := 3;
            if noise then
              BEGIN
                sound(senseHz);
                sensenoise := true;
              END (* if *)
          END (* if *)
        else
          if noise then sound(audlimit)
      END; (* if *)
  if untripped then
    BEGIN
      tripped   := false;
      temp2     := 0;
      sensor[3] := sensor[1];
      REPEAT
        sensor[3].o := sensor[3].o + sensor[0].o;
        sensor[3].d := sensor[3].d + sensor[0].d;
        inc(temp2);
      UNTIL (screen[sensor[3].o,sensor[3].d]<>Green) or
            ( (sensor[3].o=sensor[2].o) and (sensor[3].d=sensor[2].d) );
      if (temp2>1) then
        BEGIN
          sensor[3].o := sensor[3].o - sensor[0].o;
          sensor[3].d := sensor[3].d - sensor[0].d;
          gotoxy(sensor[3].o,sensor[3].d);
          if not (fuseunder[sensor[3].o,sensor[3].d].u or
                  fuseunder[sensor[3].o,sensor[3].d].d or
                  fuseunder[sensor[3].o,sensor[3].d].l or
                  fuseunder[sensor[3].o,sensor[3].d].r) then
            BEGIN
              charcolor(black);
              write(block);
              screen[sensor[3].o,sensor[3].d] := black;
            END (* if *)
          else
            BEGIN
              charcolor(lightgray);
              write(fusepic[fuseunder[sensor[3].o,sensor[3].d].u,
                            fuseunder[sensor[3].o,sensor[3].d].d,
                            fuseunder[sensor[3].o,sensor[3].d].l,
                            fuseunder[sensor[3].o,sensor[3].d].r]);
              screen[sensor[3].o,sensor[3].d] := lightgray;
            END; (* else *)
        END (* if *)
      else
        untripped := false;
    END; (* if *)
END;


PROCEDURE CheckBomb (VAR Screen : ScrnArray;
                     VAR Bomb   : FireData;
                     VAR Maxfire: ListIndex;
                     VAR Fire   : FireArray;
                         Turn   : Word);
VAR
  rnd       : real;
BEGIN
  rnd := maxfire;
  if rnd<=200 then
    rnd := sqrtarr[round(rnd)]/100
  else
    rnd := sqrt(rnd)/100;
  if ((random<rnd) and (screen[bomb.o,bomb.d]=Blue) and (maxfire>20)) then
    BEGIN
      dec(bomb.i);
      CASE bomb.i OF
        4 : charcolor(LightBlue);
        3 : charcolor(Cyan);
        2 : charcolor(LightCyan);
        1 : charcolor(Magenta);
        0 : BEGIN
              charcolor(White);
              inc(maxfire);
              fire[maxfire].o    := bomb.o+1;
              fire[maxfire].d    := bomb.d;
              fire[maxfire].i    := 5;
              fire[maxfire].fuse := false
            END;
      END; (* case *)
      gotoxy(bomb.o,bomb.d);
      write(bottle)
    END; (* if *)
END;


FUNCTION CanMove (Man    : Person;
                  Screen : ScrnArray) : Boolean;
VAR
  loop      : dircoord;
  result    : boolean;
  temp      : position;
  temp2     : word;
  left      : overindex;
  right     : overindex;
BEGIN
  if ((screen[1,5]=Green) and (man.d=7)) then
    left := 1
  else
    left := 2;
  if (man.o>37) then
    right := 39
  else
    right := 38;
  if (((man.d=23) and ((man.d+man.md)<>23) and (man.o in [7..35]))
     or ((man.d=20) and ((man.d+man.md)=21) and (man.o in [7..35]))
     or ((man.o=6) and ((man.o+man.mo)=7) and (man.d in [21..24]))
     or ((man.o=36) and ((man.o+man.mo)=35) and (man.d in [21,22,24]))) then
    result := False
  else
    result := True;
  loop.o := -2;
  REPEAT
    inc(loop.o);
    loop.d := -2;
    REPEAT
      inc(loop.d);
      temp.o := man.o + man.mo + loop.o;
      temp.d := man.d + man.md + loop.d;
      if ((temp.d in [1..25]) and (temp.o in [left..right])) then
        BEGIN
          temp2 := screen[temp.o,temp.d];
          if ((temp2=LightCyan) or (temp2=Green) or
              (temp2=17) or (temp2=Wall)) then
            result := False
        END (* if *)
      else
        result := False
    UNTIL ((loop.d=1) or (not result))
  UNTIL ((loop.o=1) or (not result));
  CanMove := Result
END;


PROCEDURE StartLeak (VAR MakeLeak : Boolean;
                     VAR Covering : CovrArray;
                     VAR Leak     : LeakArray;
                     VAR MaxLeak  : ListIndex;
                         Man      : Person;
                         NoSpread : Boolean);
VAR
  loop      : dircoord;
  justmoved : boolean;
  i         : integer;
BEGIN
  justmoved := canmove(man,screen);
  if (man.ndi<>0) then
    justmoved := true;
  if ((not nospread) or (justmoved)) then
    for loop.o := -1 to 1 do
      for loop.d := -1 to 1 do
        if (covering[loop.o,loop.d]<>LightGray) then
          BEGIN
            covering[loop.o,loop.d] := Cyan;
            inc(maxleak);
            leak[maxleak].o := loop.o + man.o;
            leak[maxleak].d := loop.d + man.d
          END; (* if *)
  if ((not justmoved) and nospread) then
    BEGIN
      loop.o := random(3)-1;
      loop.d := random(3)-1;
      i := 100;
      while (covering[loop.o,loop.d] in [LightGray,Blue]) and (i>0) do
        BEGIN
          loop.o := random(3)-1;
          loop.d := random(3)-1;
          dec(i);
        END; (* while *)
      covering[loop.o,loop.d] := Blue
    END; (* else *)
  makeleak := False
END;


PROCEDURE StartMissile (shooter : person);
BEGIN
  inc(maxproj);
  projectile[maxproj].o   := shooter.o+shooter.mmo;
  projectile[maxproj].d   := shooter.d+shooter.mmd;
  projectile[maxproj].mo  := shooter.mmo;
  projectile[maxproj].md  := shooter.mmd;
  projectile[maxproj].col := 1;
  projectile[maxproj].ch  := bottle;
  projectile[maxproj].expl:= true;
  makemissile := false
END;


PROCEDURE CheckDemoMake;
BEGIN
  demow := false;
  if ( (cmdline[cl_Code]=scrnctrl.code1) or (cmdline[cl_Code]=scrnctrl.code2) )
     and (cmdline[cl_RecDemoNum]<maxint) then
    BEGIN
      Assign(demowf,prefix+scen+chr(cmdline[cl_RecDemoNum]+64));
      ReWrite(demowf);
      Writeln(demowf,Building);
      Writeln(demowf,Level);
      Writeln(demowf,Viles);
      Writeln(demowf,Cans);
      Writeln(demowf,Randseed);
      demow := true
    END; (* if *)
END;


PROCEDURE StartDemoPlay;
VAR
  maxdemo   : word;
BEGIN
  maxdemo := numdemos;
  if (topten[1].score div 50000) + 1 < numdemos then
    maxdemo := (topten[1].score div 50000) + 1;
  FadeOut;
  Assign(demorf,prefix+scen+chr(65+random(maxdemo)));
  Reset(demorf);
  Readln(demorf,Building);
  dec(building);
  NewBuilding(Building,Level,Wall,Cans);
  MaxLevel := Floors[Building];
  Readln(demorf,Level);
  Readln(demorf,Viles);
  Readln(demorf,Cans);
  Readln(demorf,Randseed);
  DemoDone := False;
END;

PROCEDURE CloseDemoMake;
BEGIN
  if demow then
    close(demowf);
  demow := false;
  cmdline[cl_RecDemoNum] := maxint
END;

PROCEDURE CloseDemoPlay;
BEGIN
  if demo then
    close(demorf);
END;

FUNCTION FieldInput (O, D, L, MinLength : Word) : String;
VAR
  i         : integer;
  s         : string;
  c         : integer;
BEGIN
  ResetLights;
  gotoxy(o-1,d);
  charcolor(LightBlue*16+Yellow);
  for i := 1 to l+2 do
    write(' ');
  s := '';
  FadeIn;
  REPEAT
    gotoxy(o,d);
    write(s);
    if (length(s)<l) then
      write('_ ');
    repeat until keypressed;
    c := ord(upcase(readkey));
    if (c=0) then
      c := -ord(readkey);
    if ((c in [32..96]) and (length(s)<l)) then
      s := s + chr(c);
    if (((c=-75) or (c=8)) and (length(s)>0)) then
      delete(s,length(s),1)
  UNTIL ((c=13) and (length(s)>=minlength));
  charcolor(yellow);
  gotoxy(o-1,d);
  for i := 1 to l+2 do
    write(' ');
  gotoxy(o,d);
  write(s);
  charcolor(Black);
  i := length(s);
  while (i>0) and (s[i]=' ') do
    BEGIN
      delete(s,i,1);
      dec(i);
    END; (* while *)
  FieldInput := s;
  ResetLights;
END;

{$I PYRO22.INC}
{$I PYRO22.IN2}
{$I PYRO22.IN3}

(*>============================= MAIN  PROGRAM =============================<*)

BEGIN
  FindParams;
  Copyright;
  BetaTest(false);
  WorkDisk;

  InitScreen(OrigMode);
  InitPalette;
  BlackOut;
  FindFadeInc;
  vidspeed := videospeed;

  zero := -1;   (* used in place of constant 0 to make changing score, *)
  inc(zero);    (* building, etc., harder in compiled EXE file.        *)

  MakeSqrtArray(SqrtArr);
  demo := false; demow := false;
  building := 0; playing := false;

  if FirstRun or (cmdline[cl_Instructions]<maxint) then
    Instructions;

  LoadTopTitle(Logo);
  MakeTitle;
  Scen := PickScenario;

  PrevBld   := zero;
  PrevSkill := zero;

  LoadScenarioTitle(Logo,Scen);
  level := zero;
  if directvideo and (vidspeed<10) then
    CASE dl_type OF
      1    : MakeTitle;
      2    : FireTitle;
      3    : ZoomTitle(dl_o, dl_d, dl_zoom, (dl_zoom>1), false);
      4..5 : ZoomTitle(dl_o, dl_d, dl_zoom, (dl_type=5), true);
    END (* case *)
  else MakeTitle;
  LoadTopTitle(Logo);

  Calibrated := False;
  Elapsed    := 0;
  Demo       := False;
  REPEAT

    if demo then
      demo := false
    else
      PauseUntilClear;
    Randomize;
    Building := zero;
    if graphics then
      chargen(1);

    DrawTitle(Elapsed);
    PressToStart;
    InitTime(LastTurn);
    REPEAT
      InitTime(NewTime);
      if (NewTime>LastTurn) then
        Elapsed := Elapsed + (NewTime - LastTurn);
      LastTurn := NewTime;
      if (abs((elapsed mod 4800)-4400) < 40) then
        Demo := True
      else
        TitleScreens(Elapsed,TopTen);
    UNTIL (KeyPressed or Demo or ( (cmdline[cl_NoJoystick]>0) and
          (JoyStkBtn(BtnA1) or JoyStkBtn(BtnA2)) ) );

    if ((not calibrated) and (not keypressed) and (not demo)) then
      calibrate(JoyLeft,JoyRight,JoyUp,JoyDown,Calibrated)
    else
      if keypressed then
        keystroke(c);

    InitVariables;
    CheckDemoMake;

    REPEAT
      if demo then
        StartDemoPlay
      else
        BEGIN
          if ((level=endlev) and (building=endbld)) then
            BEGIN
              building := zero;
              inc(skill)
            END; (* if *)
          NewBuilding(Building,Level,Wall,Cans);
          MaxLevel := Floors[Building];
          DescribeBuilding(Building,Titles,MaxLevel,Calibrated);
          CheckLevelCheat;
          CheckDemoMake;
        END; (* else *)

      REPEAT
        ComputeJumpTime(JumpTime,Jump,Building,Level,MaxLevel);
        NewLevel(Level,FuseLength,Man,Enemy,Done,MaxFire,MaxMaxFire,
                 MaxLeak,MinTurn,Turn,Jump,Cans,Tripped,Populace,Building);
        DrawFloor(Building,Level,MaxLevel,Wall,Screen,
                  Dir,Man,Covering,Enemy,EnCover,Jump,Sensor,Bomb,Potion);
        ResetToggle(Pickup,HighSpeed,NoSpread,Throwing);
        if not demo then CheckToggle(Pickup,HighSpeed,NoSpread,Throwing);
        if ((def[building,20]<>'0') and (level=floors[building])) then
          BEGIN
            ReactorOne(Screen);
            Refresh(Screen);
            ReactorTwo(Screen,Wall);
            sensor[1].o := 0;
            bomb.o := 0
          END (* if *)
        else
          Refresh(Screen);
        WriteName(Buildings,Building,Level,MaxLevel,Populace);
        ShowViles(Viles);
        FadeIn;
        Move(Man,ManLast,Screen,Wall,Dir,Covering,Cans,MakeLeak,Pickup,
             Dropped,Done,True,Jump,Building,Level,MaxLevel,Bomb,Invis,Viles);
        if (enemy.o>0) and (enemystart=0) then
          MoveEnemy(Enemy,Screen,Wall,Dir,EnCover,Building,Level,MaxLevel,Dead);
        ResetToggle(Pickup,HighSpeed,NoSpread,Throwing);
        if not HighSpeed then
          Wait(LastTurn,Pickup,HighSpeed,NoSpread,Throwing,Building,Skill)
        else
          MoveProjectiles;
        playing := true;
        REPEAT
          inc(turn);
          Input(Man.NDi,MakeLeak,Calibrated,Cans,Pickup,Dropped,JoyLeft,
                JoyRight,JoyUp,JoyDown,NoSpread,LastKey,Invis,Viles);
          if makeleak and (not dead) then
            StartLeak(MakeLeak,Covering,Leak,MaxLeak,Man,NoSpread);
          if makemissile and (not dead) then
            StartMissile(man);
          MoveProjectiles;
          if (((turn=JumpTime) or (turn=JumpTime+20)) and
             (building<maxbld) and
             ((level=1) or (level=ord(def[building,1])-ord('0')))) then
            Passage(Turn,JumpTime,Screen,Wall,Done,Dead);
          if done or dead then
            CountFuse(FuseLength,Screen)
          else
            Move(Man,ManLast,Screen,Wall,Dir,Covering,Cans,MakeLeak,
                 Pickup,Dropped,Done,False,Jump,Building,Level,MaxLevel,
                 Bomb,Invis,Viles);
          if (enemy.o>0) and (turn>=enemystart) and (not enemydone) then
            MoveEnemy(Enemy,Screen,Wall,Dir,EnCover,
                      Building,Level,MaxLevel,Dead);
          Sense(Tripped,Sensor,Man,Screen,Wall,SenseTime);
          if (bomb.i>0) then
            CheckBomb(Screen,Bomb,MaxFire,Fire,Turn);
          Spread(Leak,MaxLeak,Screen,Building,NoSpread);
          MoveProjectiles;
          Burn(Fire,MaxFire,Screen,LastFire,Code,
               MinTurn,Turn,Building,Score,Bomb,Enemy,Skill);
          ResetToggle(Pickup,HighSpeed,NoSpread,Throwing);
          if not demo then
            CheckToggle(Pickup,HighSpeed,NoSpread,Throwing);
          if not HighSpeed then
            Wait(LastTurn,Pickup,HighSpeed,NoSpread,Throwing,Building,Skill)
          else
            MoveProjectiles
        UNTIL ( Quit or (Demo and (DemoDone or Keypressed)) or
                ( (Done or Dead) and (MaxFire=0)
                  and (Turn>MinTurn+10) ) );
        playing := false;
        CloseDemoPlay;
        CloseDemoMake;
        if not (quit or demo) then ShowScore(Score,Total,Screen,Wall,Calibrated,
                                             Quit,Building,Level);
      UNTIL ((Level=MaxLevel) or Dead or Quit or Demo or
            ((building=endbld) and (level=endlev)));
      if not demo then
        BEGIN
          if (building<>prevbld) then
            if (building=0) then
              prevbld := 1
            else
              prevbld := building-1;
          prevskill := skill;
        END; (* if *)
    UNTIL (Dead or Quit or Demo);

    if quit then
      DrawQuitLogo;

    if not demo then
      BEGIN
        TopScore(TopTen,Total,Building,Level,Skill);
        if (total >= topten[10].score) and (total > 0) then
          WriteScenario(Buildings,Floors,Titles,MaxBld,TopTen,Populace,Scen);
      END (* if *)
  UNTIL False;
END.

(*>================================= NOTES =================================<*)
(*   0  Black         floor            |  def[1]  level leading to sec bldg  *)
(*   1  Blue          gas can          |  def[2]  chance of unstable can     *)
(*   2  Green         concrete wall    |  def[3]  chance of potion           *)
(*   3  Cyan          spreading gas    |  def[4]  chance of security door    *)
(*   4  Red           fire             |  def[5]  chance of guard            *)
(*   5  Magenta                        |  def[6]  guards throw gas cans?     *)
(*   6  Brown         fire             |  def[7]  reserved                   *)
(*   7  LightGray     fuse             |  def[8]  chance of gas wall         *)
(*   8  DarkGray      fire             |  def[9]  explosiveness of gas wall  *)
(*   9  LightBlue                      |  def[10] min radius of gas can expl *)
(*  10  LightGreen                     |  def[11] max radius of gas can expl *)
(*  11  LightCyan     enemy            |  def[12] speed of game movement     *)
(*  12  LightRed      fire             |  def[13] chance of power-potion     *)
(*  13  LightMagenta  man              |  def[14] reserved                   *)
(*  14  Yellow        fire             |  def[15] reserved                   *)
(*  15  White         explosion/potion |  def[16] reserved                   *)
(*  16                border           |  def[17] reserved                   *)
(*  16-31             special walls    |  def[18] reserved                   *)
(*  32-255            walls            |  def[19] reserved                   *)
(*>===================================<|  def[20] reactor on bottom floor?   *)
(*  2.0.1  First Beta Test             |>===================================<*)
(*  2.0.2  Sound Added, Faster         |  To release a new version:          *)
(*  2.1.1  First General Release       |  Change PYRO22.CID, PYRO22.REC,     *)
(*  2.1.2  Updated Hall of Fame        |  arm/disarm beta test proc., blank  *)
(*  2.1.3  Updated Hall of Fame        |  high scores, change dates & CRC's  *)
(*  2.2b1  Mono compat., fades, drop   |>===================================<*)
(*         without spilling, new scen. |              PROBLEMS               *)
(*  2.2b2  Graphics, faster, throwing, |  No known bugs at this time.        *)
(*         smarter guards              |                                     *)
(*  2.2    Fixed Monochrome color set  |>===================================<*)
(*         detection routine                                                 *)
(*  2.2.1  Fixed validation codes and incompatibility with IBM 851# monitors *)
(*  2.2.2  Shift works without moving, fixed logic problem with guards       *)
(*  2.2.3  Fixed monitor incompatibilities, new validation codes             *)
(*  2.2.4  Removed shareware reminders, released source code                 *)
(*>================================= NOTES =================================<*)
