UNIT ScrnCtrl;

INTERFACE

CONST
  betaversion           = false;
  sharewareversion      = true;
  code1                 = 16767;
  code2                 = 00919;

  (* Basic user command line switches *)
  cl_Copyright          = 'c';
  cl_Instructions       = 'i';
  cl_InstMode           = 'I';
  cl_OlympicScore       = 'o';
  cl_BWMode             = 'b';  (* 0=B&W, 1=Brighter B&W, 2=Brighter Color, *)
  cl_NoSound            = 's';  (*     3=Monochrome, 4=Microsoft Windows    *)
  cl_NoJoystick         = 'j';  (*     5=Adapters with no dark gray         *)
  cl_Pyro21Keys         = 'k';
  (* Advanced user command line switches *)
  cl_NoSpeedTest        = 'z';  (* 0=Assume Fast Comp., 1=Assume Slow Comp. *)
  cl_ShowTestSpeed      = 'w';
  cl_Adapter            = 'a';  (* 0=CGA, 1=Mono, 2=EGA/VGA *)
  cl_VideoMode          = 'v';  (* 0=Default, (1+)=Mode *)
  cl_NormalBackground   = 'n';
  cl_Stdio              = 'd';
  cl_NoFading           = 'f';
  cl_NoGraphics         = 'g';
  (* Non-user command line switches *)
  cl_NoTamperCheck      = '1';
  cl_FirstRun           = '2';
  cl_BetaTest           = '3';
  cl_VideoTranslation   = '4';
  (* Special codes for testing *)
  cl_Code               = 'C';
  cl_Building           = 'B';
  cl_Skill              = 'S';
  cl_Level              = 'L';
  cl_FuseLength         = 'F';
  cl_Viles              = 'V';
  cl_GasCans            = 'G';
  cl_RecDemoNum         = 'R';
  (* Combination switches *)
  cl_Monochrome         = 'M';
  cl_NoHardwareAccess   = 'H';
  cl_TroubleShoot       = 'T';
  cl_Windows            = 'W';
  cl_DesqView           = 'D';

TYPE
  overindex = 0..47;
  downindex = 0..27;
  ScrnArray = array[overindex,downindex] of byte;
  logotype  = file of scrnarray;
  scentype  = string[3];

VAR
  cmdline   : array['0'..'z'] of integer;
  vidseg    : word;
  vidwidth  : word;
  vidend    : word;
  currcolor : byte;
  msg       : array[0..6] of string[80];
  noise     : boolean;
  graphics  : boolean;
  prefix    : string;
  logofile  : logotype;

PROCEDURE InitScreen (VAR OrigMode : Byte);
PROCEDURE CloseScreen (OrigMode : Byte);
PROCEDURE CharColor (color : integer);
PROCEDURE FindParams;
PROCEDURE BetaTest (display : boolean);
PROCEDURE ShareWare;
PROCEDURE WorkDisk;
PROCEDURE CharGen (level : word);
PROCEDURE CursiveVersionNo (VAR Screen : ScrnArray);
PROCEDURE LoadTopTitle (VAR Screen : ScrnArray);
PROCEDURE MakeVGATitle;
PROCEDURE LoadScenarioTitle (VAR Screen : ScrnArray; Scen : ScenType);
PROCEDURE CheckSumBad;

IMPLEMENTATION

USES getmode, detect, dos, crt, fade, joystk;

PROCEDURE InitScreen (VAR OrigMode : Byte);
CONST
  mode      : array[1..7] of byte = ($12,$11,$10,$A,$3,$1,$7);
VAR
  regs      : registers;
  ack       : byte;
BEGIN
  if cmdline[cl_Adapter]=maxint then
    cmdline[cl_Adapter] := VideoAdapter;

  (* SET VIDEO SEGMENT AND BLACK&WHITE MODE *)
  if (cmdline[cl_Adapter]=MDPA) then
    BEGIN
      VidSeg := $B000;
      cmdline[cl_BWMode] := 3;
      cmdline[cl_VideoTranslation] := 0;
    END (* if *)
  else
    VidSeg := $B800;

  (* CHANGE SCREEN TYPE *)
  regs.ah := 0;
  if (cmdline[cl_VideoMode]<maxint) then
    if (cmdline[cl_VideoMode]>0) then
      regs.al := cmdline[cl_VideoMode]
    else
      regs.al := OrigMode
  else
    if (cmdline[cl_Adapter]=MDPA) then
      regs.al := 7
    else
      regs.al := 1;
  intr($10,regs);

  (* TURN BLINKING BIT OFF *)
  if (cmdline[cl_NormalBackground]=maxint) then
    BEGIN
      if (cmdline[cl_Adapter]=MDPA) then
        BEGIN
          (* MDPA, Hercules: use port 03B8h *)
          ack := mem[$40:$65] and $DF;
          mem[$40:$65] := ack;
          port[$3B8]   := ack;
        END (* if *)
      else if (cmdline[cl_Adapter]=CGA) then
        BEGIN
          (* CGA: use port 03D8h *)
          ack := mem[$40:$65] and $DF;
          mem[$40:$65] := ack;
          port[$3D8]   := ack;
        END (* if *)
      else
        BEGIN
          (* PCjr, EGA, VGA, MCGA: use BIOS call *)
          regs.ah := $10; regs.al := $3; regs.bl := $0; intr($10,regs);
        END; (* if *)
    END; (* if *)

  (* TURN CURSOR OFF *)
  regs.ah := $01;
  regs.ch := $20;
  regs.cl := $20;
  intr($10,regs);

  (* SET UP GLOBAL VARIABLES *)
  ack         := ioresult;
  DirectVideo := (cmdline[cl_Stdio]=maxint);
  CheckBreak  := False;
  CheckSnow   := False;
  fades       := (cmdline[cl_Adapter]=VGA) and (cmdline[cl_NoFading]=maxint)
                                           and (cmdline[cl_STDIO]=maxint);
  graphics    := (cmdline[cl_Adapter]=VGA) and (cmdline[cl_NoGraphics]=maxint)
                                           and (cmdline[cl_BWMode]=maxint)
                                           and (cmdline[cl_VideoMode]=maxint)
                                           and (cmdline[cl_STDIO]=maxint);
  ack         := ioresult;
  ClrScr;
  VidWidth    := memw[$40:$4A];      (* Number of cols. per line *)
  VidEnd      := (VidWidth*2)*24+80; (* Mem Offs of 40x, 25y     *)

  (* IF USING GRAPHICS, LOWER SCREEN RESOLUTION TO 320 X 400 *)
  if graphics then
    BEGIN
      (* set horizontal pixel pan to 0 *)
      ack := port[memw[$40:$63]+6];
      port[$3C0] := $13;
      delay(1);
      port[$3C0] := 0;
      ack := port[memw[$40:$64]+6];
      port[$3C0] := $20;
      (* set clocking mode to 9 *)
      port[$3C4] := 1;
      delay(1);
      port[$3C5] := 9;
      (* turn off CRTC write-protection *)
      port[memw[$40:$63]] := $11;
      port[memw[$40:$63]+1] := port[memw[$40:$63]+1] mod 128;
      (* HORIZONTAL TIMING: *************************************************
         Horizontal Total equals Bandwidth / Horizontal Scan Rate / Char Size
         Horizontal Blanking equals number of characters across
         Horizontal Retrace starts at 10% to 15% after blanking starts
         - computations: -
         Reg 0 - H Total       - 12.58M / 31.5K / 8 = 50
         Reg 2 - H Blank Beg   - 40
         Reg 3 - H Blank End   - 149  (just a guess; it looks good onscreen)
         Reg 4 - H Retrace Beg - 45
      **********************************************************************)
      (* change horizontal total *)
      port[memw[$40:$63]] := 0;
      port[memw[$40:$63]+1] := 50;
      (* change horizontal blanking start *)
      port[memw[$40:$63]] := 2;
      port[memw[$40:$63]+1] := 40;
      (* change horizontal blanking end *)
      port[memw[$40:$63]] := 3;
      port[memw[$40:$63]+1] := 149;
      (* change HRI begin time *)
      port[memw[$40:$63]] := 4;
      port[memw[$40:$63]+1] := 45;
      (* turn on CRTC write-protection *)
      port[memw[$40:$63]] := $11;
      port[memw[$40:$63]+1] := (port[memw[$40:$63]+1] mod 128) + 128;
    END; (* if *)
END;

PROCEDURE CloseScreen(OrigMode : Byte);
VAR
  regs      : registers;
BEGIN
  ClrScr;
  regs.ah := 0;
  regs.al := OrigMode;
  intr($10,regs);
  ClrScr;
  charcolor(11);
  Writeln;
  Writeln;
  Writeln(msg[4]);
  Writeln(msg[5]);
  Writeln(msg[6]);
END;


PROCEDURE CharColor (color : integer);
BEGIN
  if cmdline[cl_NormalBackground]<maxint then
    color := color mod 128;
  if cmdline[cl_BWMode]<=5 then
    if cmdline[cl_BWMode]<=1 then
      if cmdline[cl_BWMode]=0 then
(* 0 *) BEGIN
          if ((color mod 16) = Yellow) then
            color := 15
          else if (color in [Black,32]) then
            color := 0
          else if (color in [White,LightCyan,Magenta]) then
            color := 15
          else if (color in [Blue,DarkGray,33..255]) then
            color := 8
          else if (color in [16..31]) then
            color := 7
          else
            color := 7;
        END
      else
(* 1 *) BEGIN
          if ((color mod 16) = Yellow) then
            color := 15
          else if (color in [Black,32]) then
            color := 0
          else if (color in [White,LightCyan,Magenta]) then
            color := 15
          else if (color in [Blue,DarkGray,33..255]) then
            color := 10
          else if (color in [16..31]) then
            color := 7
          else
            color := 7;
        END
    else
      if cmdline[cl_bwmode]=2 then
(* 2 *) BEGIN
          if (color mod 16) in [1,4,5,8] then
            color := color + 2;
        END
      else if cmdline[cl_bwmode]=3 then
(* 3 *) BEGIN
          if ((color mod 16) = Yellow) then
            color := 9
          else if (color in [Black,32]) then
            color := 0
          else if (color in [White,Magenta,LightCyan,
                             LightMagenta,16..31]) then
            color := 15
          else
            color := 7;
        END
      else if cmdline[cl_bwmode]=4 then
(* 4 *) BEGIN
          if ((color mod 16) = Yellow) and ((color div 16) <> 0) then
            color := 1
          else
            color := 7;
        END
      else
(* 5 *) if (color mod 16) = 8 then
          dec(color)
        else if (color div 16) = 8 then
          color := color - 16;
  if (color=32) then
    color := Black;
  textattr  := color;
  currcolor := color;
END;


PROCEDURE FindParams;
VAR
  count     : integer;
  ch        : char;
  count2    : integer;
  last      : char;
  param     : string;
  value     : longint;
  code      : integer;
  regs      : registers;
  x, y      : integer;
BEGIN
  last := '0';
  for ch := '0' to 'z' do
    cmdline[ch] := maxint;
  if paramcount>0 then
    for count := 1 to paramcount do
      if length(paramstr(count))>0 then
        BEGIN
          param := paramstr(count);
          count2 := 1;
          if param[1]='-' then
            BEGIN
              inc(count2);
              WHILE (count2<=length(param)) and
                    (param[count2] in ['A'..'z']) DO
                BEGIN
                  last := param[count2];
                  cmdline[last] := 0;
                  inc(count2)
                END (* while *)
            END; (* if *)
          if (count2<=length(param)) then
            BEGIN
              param := copy(param,count2,length(param)+1-count2);
              val(param,value,code);
              if code=0 then
                cmdline[last] := value;
            END (* if *)
        END; (* if *)

  (* Interpret Combination Switches *)
  if cmdline[cl_Monochrome] < maxint then
    BEGIN
      if cmdline[cl_Adapter         ]=maxint then cmdline[cl_Adapter         ] := MDPA;
      if cmdline[cl_BWMode          ]=maxint then cmdline[cl_BWMode          ] := 3;
      if cmdline[cl_NoFading        ]=maxint then cmdline[cl_NoFading        ] := 0;
      if cmdline[cl_NoGraphics      ]=maxint then cmdline[cl_NoGraphics      ] := 0;
    END; (* if *)
  if cmdline[cl_NoHardwareAccess] < maxint then
    BEGIN
      if cmdline[cl_Adapter         ]=maxint then cmdline[cl_Adapter         ] := EGA;
      if cmdline[cl_Stdio           ]=maxint then cmdline[cl_Stdio           ] := 0;
      if cmdline[cl_NoTamperCheck   ]=maxint then cmdline[cl_NoTamperCheck   ] := 0;
      if cmdline[cl_NoSound         ]=maxint then cmdline[cl_NoSound         ] := 0;
      if cmdline[cl_NoJoystick      ]=maxint then cmdline[cl_NoJoystick      ] := 0;
      if cmdline[cl_NoFading        ]=maxint then cmdline[cl_NoFading        ] := 0;
      if cmdline[cl_NoGraphics      ]=maxint then cmdline[cl_NoGraphics      ] := 0;
      if cmdline[cl_NormalBackground]=maxint then cmdline[cl_NormalBackground] := 0;
      if cmdline[cl_NoSpeedTest     ]=maxint then cmdline[cl_NoSpeedTest     ] := 1;
    END; (* if *)
  if cmdline[cl_TroubleShoot] < maxint then
    BEGIN
      if cmdline[cl_NormalBackground]=maxint then cmdline[cl_NormalBackground] := 0;
      if cmdline[cl_NoFading        ]=maxint then cmdline[cl_NoFading        ] := 0;
      if cmdline[cl_NoGraphics      ]=maxint then cmdline[cl_NoGraphics      ] := 0;
      if cmdline[cl_NoJoystick      ]=maxint then cmdline[cl_NoJoystick      ] := 0;
      if cmdline[cl_NoTamperCheck   ]=maxint then cmdline[cl_NoTamperCheck   ] := 0;
    END; (* if *)
  if cmdline[cl_DesqView] < maxint then
    BEGIN
      if cmdline[cl_Stdio           ]=maxint then cmdline[cl_Stdio           ] := 0;
      if cmdline[cl_NoFading        ]=maxint then cmdline[cl_NoFading        ] := 0;
      if cmdline[cl_NoGraphics      ]=maxint then cmdline[cl_NoGraphics      ] := 0;
      if cmdline[cl_NormalBackground]=maxint then cmdline[cl_NormalBackground] := 0;
    END; (* if *)
  if cmdline[cl_Windows] < maxint then
    BEGIN
      if cmdline[cl_NoFading        ]=maxint then cmdline[cl_NoFading        ] := 0;
      if cmdline[cl_NoGraphics      ]=maxint then cmdline[cl_NoGraphics      ] := 0;
      if cmdline[cl_NormalBackground]=maxint then cmdline[cl_NormalBackground] := 0;
      if cmdline[cl_NoSound         ]=maxint then cmdline[cl_NoSound         ] := 0;
    END; (* if *)
  if cmdline[cl_Windows] < 3 then
    BEGIN
      if cmdline[cl_Stdio           ]=maxint then cmdline[cl_Stdio           ] := 0;
      if cmdline[cl_BWMode          ]=maxint then cmdline[cl_BWMode          ] := 4;
    END; (* if *)

  (* Interpret Sound Switch *)
  if cmdline[cl_NoSound]<maxint then
    noise := false
  else
    noise := true;

  (* Determine Video Translation *)
  if (cmdline[cl_BWMode]           < maxint) or
     (cmdline[cl_VideoMode]        < maxint) or
     (cmdline[cl_NormalBackground] < maxint) or
     (cmdline[cl_Stdio]            < maxint) then
    cmdline[cl_VideoTranslation] := 0;

  (* Override Joystick Switch if Necessary *)
  JoyStkPos(0,x,y);
  if JoyStkBtn(BtnA1) or JoyStkBtn(BtnA2) or (x=0) or (y=0) then
    cmdline[cl_NoJoystick] := 0;

  (* Get Path *)
  regs.ah := $30;
  intr($21,regs);
  if (regs.al>2) and (length(paramstr(0))>3) then
    prefix := copy(paramstr(0),1,length(paramstr(0))-3)
  else
    prefix := 'PYRO22.';
END;

PROCEDURE BetaTest (display : boolean);
VAR
  str       : string;
  loop      : word;
  checksum  : word;
  target1   : word;
  target2   : word;
  target3   : word;
  betafile  : text;
  failed    : boolean;
  zero      : word;
BEGIN
  if not betaversion then
    exit;

  if display then
    BEGIN
      charcolor(lightred);
      writeln;
    END; (* if *)

  failed   := false;
  zero     := 0;
  checksum := zero;
  str      := '';

  assign(betafile,prefix+'BET');
  reset(betafile);
  REPEAT
    readln(betafile,str);
    if display then
      writeln(str);
    if str<>'' then
      for loop := 1 to length(str) do
        checksum := checksum + loop + ord(str[loop]);
  UNTIL str='';
  readln(betafile,target1);
  readln(betafile,target2);
  readln(betafile,target3);
  close(betafile);

  if ioresult<>0 then
    failed := true;

  checksum := checksum + 55903;
  if checksum<>target1 then failed := true;
  checksum := checksum * 9;
  if checksum<>target2 then failed := true;
  checksum := checksum div 2 + 55903;
  if checksum<>target3 then failed := true;

  if failed or (failed and (zero=0)) or failed then (* <- confuse hackers *)
    BEGIN
      clrscr;
      charcolor(lightred);
      writeln('This is a beta test version and is not intended for general use.');
      writeln('For more information, write:');
      writeln('   Michael O''Brien');
      writeln('   3 Trovita');
      writeln('   Irvine, CA 92720');
      halt(250);
    END; (* if *)
END;

PROCEDURE Shareware;
VAR
  s         : array[1..5] of string[80];
  checksum  : word;
  i, j      : word;
BEGIN
  if not sharewareversion then
    exit;

  s[1] := 'Pyro ][ may be played and distributed without charge.';
  s[2] := 'Send your comments and suggestions to:';
  s[3] := '          Michael O''Brien';
  s[4] := '          3 Trovita';
  s[5] := '          Irvine, CA 92720';

  checksum := 0;
  for i := 1 to 5 do
    for j := 1 to length(s[i]) do
      checksum := checksum + ord(s[i,j]) + i + 2*j;

  if (checksum<>19399) or (checksum mod 19399<>0) then (* redundancy to     *)
    if (cmdline[cl_Code]<>code1) and                   (* confuse hackers.  *)
       ( (code1=1414) or (cmdline[cl_Code]<>1414) ) then
      checksumbad
    else
      writeln(checksum);

  charcolor(lightred);
  writeln;
  for i := 1 to 5 do
   writeln(s[i]);
END;

PROCEDURE WorkDisk;
VAR
  f         : text;
BEGIN
  assign(f,prefix+'CID');
  append(f);
  close(f);
  assign(f,prefix+'REC');
  append(f);
  close(f);
  if ioresult<>0 then
    BEGIN
      clrscr;
      charcolor(lightred);
      writeln('Either this disk is write-protected, or Pyro''s data files have');
      writeln('been marked as ''read-only''.  Please correct the problem and');
      writeln('run Pyro again.');
      halt(10);
    END; (* if *)
END;

PROCEDURE CharGen (level : word);
TYPE
  chartable = array[0..255,1..16] of byte;
VAR
  regs      : registers;
  buffer    : chartable;
  infile    : file of chartable;
BEGIN
  regs.ah := $11; (* character generator interface *)
  regs.bh := $10; (* 16-point characters *)
  regs.bl := $00; (* first table *)
  regs.es := seg(buffer); (* segment address of definition buffer *)
  regs.bp := ofs(buffer); (* offset address of definition buffer *)

  if (level=0) then
    BEGIN
      (* Reset all characters to 8 X 16 pixel ROM definitions *)
      regs.al := 4;
      regs.bl := 0;
      intr($10,regs);
    END (* if *)
  else
    BEGIN
      (* Load a character table from disk *)
      assign(infile,prefix+'CH'+chr(level+64));
      reset(infile);
      read(infile,buffer);
      close(infile);
      regs.al := $00;
      regs.cx := $0100;
      regs.dx := $0000;
      intr($10,regs);
    END; (* if *)
END;

PROCEDURE CursiveVersionNo (VAR Screen : ScrnArray);
VAR
  loop      : word;

  PROCEDURE DrawChar (x, y, start, ofs : word);
  BEGIN
    gotoxy(x+ofs-1,y);
    charcolor( (screen[x+ofs-1,y] mod 16) + 7*16 );
    write(chr(179+start+ofs));
  END;

BEGIN
  CharGen(20);
  gotoxy(38,2); for loop := 1 to 2 do DrawChar(38,2,01,loop);
  gotoxy(36,3); for loop := 1 to 4 do DrawChar(36,3,03,loop);
  gotoxy(35,4); for loop := 1 to 5 do DrawChar(35,4,07,loop);
  gotoxy(31,5); for loop := 1 to 7 do DrawChar(31,5,12,loop);
  gotoxy(30,6); for loop := 1 to 5 do DrawChar(30,6,19,loop);
  gotoxy(30,7); for loop := 1 to 3 do DrawChar(30,7,24,loop);
END;

PROCEDURE LoadTopTitle (VAR Screen : ScrnArray);
VAR
  ack       : integer;
BEGIN
  assign(logofile,prefix+'NAM');
  reset(logofile);
  read(logofile,screen);
  ack := ioresult;
  close(logofile);
END;

PROCEDURE MakeVGATitle;
VAR
  ack       : integer;
  col,char  : scrnarray;
  o,d,max   : word;
BEGIN
  assign(logofile,prefix+'VGA');
  reset(logofile);
  read(logofile,col);
  read(logofile,char);
  ack := ioresult;
  close(logofile);
  for d := 1 to 25 do
    BEGIN
      gotoxy(1,d);
      if d<25 then
        max := 40
      else
        max := 39;
      for o := 1 to max do
        BEGIN
          charcolor(col[o,d]);
          write(chr(char[o,d]));
        END; (* for *)
    END; (* for *)
  if directvideo then
    BEGIN
      mem[vidseg:vidend-2] := 0;
      mem[vidseg:vidend-1] := 0;
    END; (* if *)
END;

PROCEDURE LoadScenarioTitle (VAR Screen : ScrnArray;
                                 Scen   : ScenType);
VAR
  ack       : integer;
BEGIN
  assign(logofile,prefix+'L'+Scen);
  reset(logofile);
  read(logofile,screen);
  ack := ioresult;
  close(logofile);
END;

PROCEDURE CheckSumBad;
VAR
  superuser : boolean;
BEGIN
  superuser := (cmdline[cl_Code] = code1);

  if (not superuser) and (cmdline[cl_NoTamperCheck]=maxint) then
    BEGIN
      clrscr;
      if fades then
        fadein;
      CloseScreen(origmode);
      clrscr;
      writeln;
      writeln;
      writeln;
      charcolor(LightBlue);
      writeln('PYRO   (C)Copyright 1990, Michael O''Brien');
      charcolor(LightRed);
      writeln('THIS COPY OF PYRO HAS BEEN TAMPERED WITH!');
      writeln('OBTAIN A NEW COPY FROM YOUR LOCAL BBS, OR');
      writeln('WRITE FOR ASSISTANCE:     MICHAEL O''BRIEN');
      writeln('                                3 TROVITA');
      writeln('                         IRVINE, CA 92720');
                                      { ^address }
      writeln;
      REPEAT
        REPEAT UNTIL false
      UNTIL false;
      halt(2)
    END; (* if *)
END;


BEGIN
END.