// For each channel passed to the mixer.
typedef struct
{
	unsigned char *sound; 	// address of sound
	unsigned char *sndloc;	// Current output location.
	unsigned long sndlen; 	// Sound length.
	unsigned long silence;	// Amount of silence, between samples.
	unsigned long silout; 	// Number of silence samples, left over.
	short freq; 						// frequency modulate.
	char	oneshot;					// Sample is played as a one shot.
	char	trigger;					// Trigger is high for sample to be played.
	char	*buff;						// Build buffer. (ouput is interleaved)
	unsigned long bufflen;	// length of build buffer.
	short volume; 	// 0-255 channel volume.
	short lastvol;	// last volume table was built at.
	short voltab[256]; // Precomputed volume translate table.
} MODSPEC;

extern void cdecl BuildModStream(MODSPEC far *mod);

extern void cdecl ModSilence(MODSPEC *mod1,unsigned char *merge); // Build silence.
extern void cdecl MergeMod1(MODSPEC *mod1,unsigned char *merge);
extern void cdecl MergeMod2(MODSPEC *mod1,unsigned char *merge);
extern void cdecl MergeMod3(MODSPEC *mod1,unsigned char *merge);
extern void cdecl MergeMod4(MODSPEC *mod1,unsigned char *merge);
