/*  modplay.h - Tiny MOD Player V2.11 for Watcom C/C++ and DOS/4GW

    Module player for Sound Blaster and compatibles header file.

    Copyright 1993,94 Carlos Hasan
*/
#define PM_TIMER    0
#define PM_MANUAL   1

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;
typedef byte *pointer;

typedef struct
{
	word		NumTracks;
	word		OrderLength;
	byte		Orders[128];
	pointer Patterns[128];
	pointer SampPtr[32];
	pointer SampEnd[32];
	pointer SampLoop[32];
	byte		SampVolume[32];
} Module;

typedef struct
{
	word		Period;
	word		Volume;
	dword 	Length;
	pointer Data;
} Sample;

extern long cdecl MODPlayModule(Module *Modulefile,word Chans,word Rate,char **playbuf);
extern void cdecl MODStopModule(void);
extern void cdecl MODPlaySample(byte Voice,Sample *Instr);
extern void cdecl MODStopSample(byte Voice);
extern void cdecl MODSetPeriod(byte Voice,word Period);
extern void cdecl MODSetVolume(byte Voice,byte Volume);
extern void cdecl MODSetMusicVolume(byte Volume);
extern void cdecl MODSetSampleVolume(byte Volume);
extern void cdecl MODPoll(char *location);
extern long cdecl MODGetSetBuff(char *buff); // get size of low buffer.
extern long cdecl MODSizeDMA(void); // return length of DMA buffer

extern Module *MODLoadModule(char *Path);
extern void MODFreeModule(Module *Song);
extern long MODPlay(Module *Modulefile,word Chans,word Rate);
extern void MODTimeSlice(void); // give up time slice to mod player.

