/*****************************************************************************/
/* TMIX.C 	Digital Mixer test application. Dynmically loads DIGPAK and 		 */
/*					MIDPAK drivers, SOUNDRV.COM and MIDPAK.COM/MIDPAK.ADV/MIDPAK.AD  */
/*					then plays the MIDI file TEST.XMI and allows you to play sound	 */
/*					effects, with real time 4 channel digital mixing. 							 */
/*****************************************************************************/
/*		Written by John W. Ratcliff (c) 1994																	 */
/*			 Compuserve: 70253,3237 																						 */
/*			 Genie: J.RATCLIFF3 																								 */
/*			 BBS: 1-314-939-0200																								 */
/*			 Addresss:																													 */
/*					 747 Napa Lane																									 */
/*					 St. Charles, MO 63304																					 */
/*																																					 */
/*		A $500 per product license fee applies to all commercial software 		 */
/*		products distributed with ANY DIGPAK and another $500 for MIDPAK			 */
/*		drivers.	That's a total of $1,000 if your product uses BOTH DIGPAK    */
/*		and MIDPAK drivers.  If you distribute any commercial title with DIGPAK*/
/*		and/or MIDPAK drivers resident then this license fee applies. 				 */
/*																																					 */
/*		To pay a license, simply write a check for $500 for just DIGPAK 			 */
/*		$500 for just MIDPAK, or $1,000 for both DIGPAK and MIDPAK single 		 */
/*		product distribution license payable to:															 */
/*				The Audio Solution, 747 Napa Lane, St. Charles, MO 63304					 */
/*				with a copy of your commerical product.  You will receive a signed */
/*				license agreement from The Audio Solution shortly thereafter. 		 */
/*				This license fee applies specifically to the inclusion with your	 */
/*				distribution disk any of the DIGPAK and/or MIDPAK drivers.				 */
/*				These drivers are copyrighted works, created by me, to enhance the */
/*				use of sound and music in DOS based commercial software.	The 		 */
/*				license fees collected are used to maintain the drivers and keep	 */
/*				the BBS running.																									 */
/*																																					 */
/*				WARNING!!!!!!  You would be ill-advised to distribute a commercial */
/*				product containing either DIGPAK and/or MIDPAK drivers without		 */
/*				having paid the distribution license fee.  Since your product would*/
/*				contain unlicensed copyrighted software from The Audio Solution,	 */
/*				your product could be required to be immediately removed from retail*/
/*				distribution.  I doubt this is going to be a problem.  Clearly if  */
/*				your product is enhanced by the use of these drivers, your company */
/*				can easily afford a nominal license fee of $1,000 in exchange for  */
/*				getting the use of several man-years of software engineering			 */
/*				resources.																												 */
/*****************************************************************************/
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>

#include "keys.h"         // Include #define's for keyboard commands
#include "loader.h"       // Include header for midpak/digpak dynamic loader
#include "digplay.h"      // Include header for link layer to DIGPAK functions.
#include "doscalls.h"     // Include header to assembly DOS support functions.
#include "mixer.h"
#include "support.h"
#include "modplay.h"    // header for for the MOD player.

#define MUSICVOLUME 192

void main(int argc,char **argv)
{
	Module *Song;
	int modplaying=0;
	long int siz;
	char fname[128];

	if ( argc != 2 )
	{
		printf("Usage: PMOD <modfile>.MOD\n");
		printf("extension .MOD assumed.\n");
		exit(1);
	}
	strcpy(fname,argv[1]);
	strcat(fname,".MOD");

	if ( CheckIn() )
	{
		SetDPMIMode(1);
	}
	else
	{
		if ( !LoadDigPak("SOUNDRV.COM") )
		{
			printf("Failed to load sound driver.\n");
			exit(1);
		}

		if ( !InitDigPak() )
		{
			UnLoadDigPak();
			printf("Failed to initialize sound driver.\n");
			exit(1);
		}
	}

	StartMixer(1);

	if ((Song = MODLoadModule(fname)) != NULL)
	{
		if (MODPlay(Song,8,11000))
		{
			printf("Error initializing the sound system.\n");
		}
		else
		{
			printf("Playing music...\n");
			modplaying = 1;
		}
	}

	printf("Press a key to quit playing music.\n");
	getkey();

	if ( modplaying )
	{
		MODStopModule();
		MODFreeModule(Song);
	}

	StopMixer();

	UnLoadDigPak();
}

// Application provided callback service, for modulating any sound stuff.
// here you can change volume of a currently playing sound effect, or
// modulate it's frequency.  Just record the channel assigned when
// the sound was originally triggered, and then call the mixer routines
// to change it.	This is a HARDWARE CALLBACK FUNCTION!!!!!!	You should
// only check state variables, and make changes through the mixer functions.
void ServiceSound(void)
{
}


