// This is an interface for the application to get at the mixer.
// It will take a sound effect you pass, and will find a free channel to
// assign it to.	It will also install the mixer to begin with, including
// assigning a hardware interrupt to it, or else, you can install your own.
// the hardware interrupt is just the standard 18.2 time of day clock.
// even if you reprogram it, the chained interrupt should still work cleanly.

#define LOOPING 0 // mode flag for a sound that loops.
#define ONESHOT 1 // mode flag to play sound once, and stop.
#define FULLVOLUME 256 // do not exceed 256.	0-silence, 256, full volume.
#define FLATFREQ 256	// frequency is fractional, so 128 would be 1/2 freq
// and 512 would be double playback.	Will alias, so keep it reasonable.

short StartMixer(short installtimer);
void	StopMixer(void);
short TriggerSound(char far *sound,unsigned short length,short mode,short volume,short freq);
void	TriggerStop(short channel); // halt channel.
void	TriggerVolume(short channel,short volume); // change volume on channel.
short TriggerStatus(short channel); // report status of a channel.
void  TriggerFrequency(short channel,short freq); // Change frequency of a channel.
