// For each channel passed to the mixer.
typedef struct
{
	unsigned char far *sound; // address of sound mod, Must be on paragraph.
	unsigned char far *sndloc; // Current output location.
	unsigned short sndlen;	// Address of sound length.
	short silence;					// Amount of silence, between samples.
	short silout; 					// Number of silence samples, left over.
	short freq; 						// frequency modulate.
	char	oneshot;					// Sample is played as a one shot.
	char	trigger;					// Trigger is high for sample to be played.
	char far *buff; 				// Build buffer. (ouput is interleaved)
	short bufflen;					// length of build buffer.
	short volume; 	// 0-255 channel volume.
	short lastvol;	// last volume table was built at.
	short voltab[256]; // Precomputed volume translate table.
} MODSPEC;

extern void cdecl far BuildModStream(MODSPEC far *mod);

extern void cdecl far ModSilence(MODSPEC far *mod1,unsigned char far *merge); // Build silence.
extern void cdecl far MergeMod1(MODSPEC far *mod1,unsigned char far *merge);
extern void cdecl far MergeMod2(MODSPEC far *mod1,unsigned char far *merge);
extern void cdecl far MergeMod3(MODSPEC far *mod1,unsigned char far *merge);
extern void cdecl far MergeMod4(MODSPEC far *mod1,unsigned char far *merge);

