

#define BUFFSIZE 512	// Size of build buffer.
#define PHYSICAL 4	// number of physical channels.
#define STREAMSIZE (BUFFSIZE*PHYSICAL)
// Stream size, is the output stream size created for all channels.
// even though the input size is 1 byte, the output is a signed word
// per sample.	Thus the BUFFSIZE*PHYSICAL number of channels times 2

#define MINIMUMDMA 512 // Minimum size of DMA backfill buffer.

#define BASEFREQ 11000	 // Modify this for your base-line playback frequency

#define IRATE 64 // interrupt rate, 64 times per second


short ModSizeNeeded(void); // Return number of bytes needed by mixer for
// the specified number of channels.

// Bootstrap the mod player object.  MOD player requires a fixed address
// of a semaphore, to let it know if it's been interupting the set mixer
// code..
short  StartMod(short *InMix); // passes semaphore of mixer code.

void StopMod(void);  // Stop mixer.

void PollMod(void);
// Give the mod player a timeslice.

// If channel passed is a -1 then it means to establish on the first available
// channel found.  A return code of -1 means there was no channel free.
short  SetChannel(char *sound,				 // address of sound file.
								unsigned short length,	 // length of sound effect.
								short channel,					 // channel to establish.
								short mode);						 // mode 0-continuous, 1 - one shot effect.

void SetActive(short channel);
// Set physical channel active.

void InActive(short channel); // Make this physical channel inactive.

void ChannelOn(short channel); // trigger a channel to play.

void ChannelOff(short channel); // Turn channel off.

void ChannelVolume(short channel,short volume); // 0-255.

void ChannelFreq(short channel,short freq); // 0-768 - 256 is 1:1

short ChannelState(short channel); // Report channel status on/off.

short ActiveState(short channel); // Report active channel status on/off.

void StartDMA(void);

void StopDMA(void);

void SetChannelMode(short logical,short mode);

void ResetMod(void);

