/*****************************************************************************/
/* RECORD.C -> Records a digital sound effect using the PostAudioPending calls.  */
/* Written by John W. Ratcliff, September 1992, needs to link to						 */
/* DIGPLAY.OBJ, DOSCALLS.OBJ. 																							 */
/*****************************************************************************/
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>

#include "digplay.h"    // Include DIGPLAY header.
#include "doscalls.h"   // Include DOS tools header.
#include "video.h"      // Include header for VGA graphics tools.
#include "loader.h"      // Include header for VGA graphics tools.

// Define memory allocation functions.	If using DOS memory allocation
// functions, provided through DOSCALLS, then set the conditional compilation
// 'DOSALLOC' to true.  If using C compiler library function memory allocation
// set 'DOSALLOC' to zero.

#define DOSALLOC 0
// Redirect memory allocation to either DOS memory allocate functions located
// in DOSCALLS or to C library far memory allocation functions.
unsigned char far * far memalloc(long int siz)
{
	#if DOSALLOC
		return(fmalloc(siz));  // DOS far memory allocation functions
	#else
		return(farmalloc(siz)); // C's far memory allocation functions.
	#endif
}

void far memfree(char far *memory)
{
	#if DOSALLOC
		ffree(memory);
	#else
		farfree(memory);
	#endif
}

unsigned char far * far memalloc(long int siz); // Our application provided memory allocation functions.
void far memfree(char far *memory); // Application provided free memory allocate function.


#define SWID 320	// Width of sound data to record in.
// make this larger, like 5,000 or 10,000 bytes to reduce the ticking
// introduced from one transfer to the next.
char save[320];
char buffer[SWID*2]; // audio record transfer buffers.
long int RecordAudio(int draw,char *fname,int frequency);


void main(int argc,char **argv)
{

	if ( !LoadDigPak("SOUNDRV.COM") )
	{
		printf("Failed to load sound driver.\n");
		exit(1);
	}


	if ( !InitDigPak() )
	{
		UnLoadDigPak();
		printf("Failed to initialize sound driver.\n");
		exit(1);
	}

	if ( ! (AudioCapabilities() & AUDIORECORD ) )
	{
		printf("Current sound driver doesn't support audio recording.\n");
		UnLoadDigPak();
		exit(1);
	}


	VidOn();

	RecordAudio(1,"test.snd",11000);


	VidOff();


	UnLoadDigPak();

}

long int RecordAudio(int draw,char *fname,int frequency)
{
	char far *currentbuffer;
	char far *lastrecord;
	char far *t; //temp swap variable.
	int  key;
	int  xcon=0,i;
	SNDSTRUC snd;
	int  fpout;
	int  diskwrite=0;
	long int siz;

	fpout = mfopen(fname,&siz,NEW_FILE);

	for (i=0; i<320; i++) save[i] = 0x80;
	for (i=0; i<SWID; i++)
	{
		buffer[i] = 0x80;
		buffer[i+SWID] = 0x80;
	}

	currentbuffer = buffer;
	lastrecord = buffer+SWID;
	snd.sndlen = SWID;
	snd.frequency = frequency;

	if ( draw ) printf("[SPACEBAR] to toggle writing to disk\n[ESC] quit.\n");

	SetRecordMode(1); // Turn recording mode ON!

	do
	{
		// Check pending status.
		if (AudioPendingStatus() != PENDINGSOUND)
		{
			// ok, copy contents of other buffer into save.
			snd.sound = currentbuffer; // Set address of play sound location.
			PostAudioPending(&snd); // record into this buffer.
			if ( draw )
			{
				DrawSound(save,320,0); // Erase previous.
				DrawSound(currentbuffer,320,15); // draw the new one.
				farmov(save,currentbuffer,320); // save for next erase.
			}

			if (diskwrite)
			{
				mfwrite(currentbuffer,SWID,fpout);
				siz+=SWID;
			}

			t = currentbuffer; // save currentbuffer into temp variable.
			currentbuffer = lastrecord; // now current is last.
			lastrecord = t; // last is current, flip-flop done.

			// Check keypress.
			if (keystat())
			{
				key = getkey();
				switch ( key )
				{
					case 32: diskwrite = 1-diskwrite;
									 if ( draw )
									 {
										 if ( diskwrite )
											 printf("Writing to disk.\n");
										 else
												printf("Disk write turned off.\n");
									 }
									 break;
					case 27: xcon = 1;
									 break;
				}
			}
		}
	} while (!xcon);

	if ( diskwrite )
	{
		while (AudioPendingStatus() == PENDINGSOUND); // Wait until last complete.
		mfwrite(lastrecord,SWID,fpout); // write last one out.
	}
	StopSound();
	SetRecordMode(0);
	mfclose(fpout);
	return(siz);
}
