/*****************************************************************************/
/* TMIX.C 	Digital Mixer test application. Dynmically loads DIGPAK and 		 */
/*					MIDPAK drivers, SOUNDRV.COM and MIDPAK.COM/MIDPAK.ADV/MIDPAK.AD  */
/*					then plays the MIDI file TEST.XMI and allows you to play sound	 */
/*					effects, with real time 4 channel digital mixing. 							 */
/*****************************************************************************/
/*		Written by John W. Ratcliff (c) 1994																	 */
/*			 Compuserve: 70253,3237 																						 */
/*			 Genie: J.RATCLIFF3 																								 */
/*			 BBS: 1-314-939-0200																								 */
/*			 Addresss:																													 */
/*					 747 Napa Lane																									 */
/*					 St. Charles, MO 63304																					 */
/*																																					 */
/*		A $500 per product license fee applies to all commercial software 		 */
/*		products distributed with ANY DIGPAK and another $500 for MIDPAK			 */
/*		drivers.	That's a total of $1,000 if your product uses BOTH DIGPAK    */
/*		and MIDPAK drivers.  If you distribute any commercial title with DIGPAK*/
/*		and/or MIDPAK drivers resident then this license fee applies. 				 */
/*																																					 */
/*		To pay a license, simply write a check for $500 for just DIGPAK 			 */
/*		$500 for just MIDPAK, or $1,000 for both DIGPAK and MIDPAK single 		 */
/*		product distribution license payable to:															 */
/*				The Audio Solution, 747 Napa Lane, St. Charles, MO 63304					 */
/*				with a copy of your commerical product.  You will receive a signed */
/*				license agreement from The Audio Solution shortly thereafter. 		 */
/*				This license fee applies specifically to the inclusion with your	 */
/*				distribution disk any of the DIGPAK and/or MIDPAK drivers.				 */
/*				These drivers are copyrighted works, created by me, to enhance the */
/*				use of sound and music in DOS based commercial software.	The 		 */
/*				license fees collected are used to maintain the drivers and keep	 */
/*				the BBS running.																									 */
/*																																					 */
/*				WARNING!!!!!!  You would be ill-advised to distribute a commercial */
/*				product containing either DIGPAK and/or MIDPAK drivers without		 */
/*				having paid the distribution license fee.  Since your product would*/
/*				contain unlicensed copyrighted software from The Audio Solution,	 */
/*				your product could be required to be immediately removed from retail*/
/*				distribution.  I doubt this is going to be a problem.  Clearly if  */
/*				your product is enhanced by the use of these drivers, your company */
/*				can easily afford a nominal license fee of $1,000 in exchange for  */
/*				getting the use of several man-years of software engineering			 */
/*				resources.																												 */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "keys.h"         // Include #define's for keyboard commands
#include "loader.h"       // Include header for midpak/digpak dynamic loader
#include "midpak.h"       // Include header for link layer to MIDPAK functions.
#include "digplay.h"      // Include header for link layer to DIGPAK functions.
#include "doscalls.h"     // Include header to assembly DOS support functions.
#include "mixer.h"

#define TESTMIDPAK 0 // true if loading midpak as well.

#define NOBJ 8

static char *Names[NOBJ] =
{
	"MIX1.SND",
	"MIX2.SND",
	"MIX3.SND",
	"MIX4.SND",
	"MIX5.SND",
	"MIX6.SND",
	"MIX7.SND",
	"MIX8.SND",
};

static SNDSTRUC snd;
static char *soundbuffer=0;
static long int ssize[NOBJ];
static int NALLOC=0;
char *Sounds[NOBJ]; // addresses of all the beauty sounds.

void UnloadSounds(void);
int  LoadSounds(void);
void PlaySound(int sound);
void TestDigPak(void);

// Define memory allocation functions.	If using DOS memory allocation
// functions, provided through DOSCALLS, then set the conditional compilation
// 'DOSALLOC' to true.  If using C compiler library function memory allocation
// set 'DOSALLOC' to zero.  MUST BE SET TO 1 for RECURSE, because most memory
// allocation has to be on a paragraph boundary!

#define DOSALLOC 0
// Redirect memory allocation to either DOS memory allocate functions located
// in DOSCALLS or to C library far memory allocation functions.
unsigned char far * far memalloc(long int siz)
{
	unsigned char far *mem;

	#if DOSALLOC
		mem = fmalloc(siz);  // DOS far memory allocation functions
	#else
		mem = farmalloc(siz); // C's far memory allocation functions.
	#endif
	return(mem);
}

void far memfree(char far *memory)
{
	#if DOSALLOC
		ffree(memory);
	#else
		farfree(memory);
	#endif
}


void main(void)
{
	long int siz;
	char *fname;

	if ( !CheckIn() )
	{
		if ( !LoadDigPak("SOUNDRV.COM") )
		{
			printf("Failed to load sound driver.\n");
			exit(1);
		}

		if ( !InitDigPak() )
		{
			UnLoadDigPak();
			printf("Failed to initialize sound driver.\n");
			exit(1);
		}
	}

#if TESTMIDPAK
	if ( LoadMidPak("MIDPAK.COM", "MIDPAK.ADV", "MIDPAK.AD") )
	{
		printf("Loaded MIDPAK.COM MIDPAK.ADV and MIDPAK.AD into Low Mem\n");
		if ( InitMidPak() )
		{
			printf("MIDPAK driver initialized.\n");
			fname = fload("TEST.XMI",&siz);
			if ( fname )
			{
				printf("Loaded TEST.XMI %d bytes long.\n",siz);
				RegisterXmidi(fname,siz);
				printf("Sequence registered, now playing.\n");
				PlaySequence(0);
				SegueSequence(1,-1);
			}
		}
		else
			printf("Failed to initialize MIDPAK driver.\n");
	}
#endif

	StartMixer(1);

	TestDigPak();

	StopMixer();
#if TESTMIDPAK
	UnLoadMidPak();
#endif
	UnLoadDigPak();
}

static short ThunderVolume=256;
static short ThunderFreq=256;

void TestDigPak(void)
{
	int i,key,sound;

  printf("Loading digital sound effects.\n");
	if ( LoadSounds() )
  {
		printf("Select an sound effect to play. [ESC] when finished playing around.\n");
		for (i=0; i<NOBJ; i++)
		{
			printf("%c %s\n",i+'A',Names[i]);
		}

		// Ok, we will trigger the first channel, as rolling, continuous
		// thunder.
		TriggerSound(Sounds[0],ssize[0],LOOPING,FULLVOLUME,FLATFREQ);

		printf("Thunder has been triggered, as a continuous looping effect\n");
		printf("on channel zero (this is effect 'A').  Pressing the + and -\n");
		printf("key will increase and decrease the volume of the thunder.\n");
		printf("and '[' will decrease the pitch and ']' increase the pitch.\n");
		printf("SPACEBAR put's thunder back to original settings.\n");

		do
		{
			if ( keystat() )
			{
				key = getkey();
				if ( key >= 'a' && key <= 'z') key-=32;
				switch ( key )
				{
					case '+': ThunderVolume+=10;
						if ( ThunderVolume > 512 ) ThunderVolume = 512;
						break;
					case '-': ThunderVolume-=10;
						if ( ThunderVolume < 0 ) ThunderVolume = 0;
						break;
					case '[':
						ThunderFreq-=20;
						if ( ThunderFreq < 10 ) ThunderFreq = 10;
						break;
					case ']':
						ThunderFreq+=20;
						if ( ThunderFreq > 1024 ) ThunderFreq = 1024;
						break;
					case 32:
						ThunderVolume = 256;
						ThunderFreq = 256;
						break;
					default:
					if ( key >= 'A' && key <= 'Z')
					{
						sound = key-'A';
						if ( sound < NOBJ ) TriggerSound(Sounds[sound],ssize[sound],ONESHOT,FULLVOLUME,FLATFREQ);
					}
					break;
				}
			}
		} while ( key != 27 );

		UnloadSounds();
	}
}

// Load all of the sound files into memory.
int LoadSounds(void)
{
  int fph;
  long int siz,end;
  int i,handle,j;
  int select;

  for (i=0; i<NOBJ; i++)
  {
    Sounds[i] = fload(Names[i], &siz);
    if ( !Sounds[i] )
    {
      printf("File '%s' not found.\n",Names[i]);
      return(0);
    }
    ssize[i] = siz;
    printf("Sound Loaded '%s'.\n",Names[i]);
  }
	return(1);
}

void UnloadSounds(void)
{
	int i;

	for (i=0; i<NALLOC; i++) memfree(Sounds[i]);
	NALLOC=0;
}


// Application provided callback service, for modulating any sound stuff.
// here you can change volume of a currently playing sound effect, or
// modulate it's frequency.  Just record the channel assigned when
// the sound was originally triggered, and then call the mixer routines
// to change it.	This is a HARDWARE CALLBACK FUNCTION!!!!!!	You should
// only check state variables, and make changes through the mixer functions.
void ServiceSound(void)
{
	TriggerVolume(0,ThunderVolume);
	TriggerFrequency(0,ThunderFreq);
}
