/**************************************************************************/
/* COLOR DEFINES FOR EGA & VGA GRAPHICS PALETTE                           */
/**************************************************************************/
#define BLACK 0
#define BLUE 1
#define GREEN 2
#define CYAN 3
#define RED 4
#define MAGENTA 5
#define BROWN 6
#define GRAY 7
#define GREY 7
#define DARK_GREY 8
#define DARK_GRAY 8
#define LIGHT_BLUE 9
#define LIGHT_GREEN 10
#define LIGHT_CYAN 11
#define LIGHT_RED 12
#define LIGHT_MAGENTA 13
#define YELLOW 14
#define WHITE 15
/**************************************************************************/
/* GRAPHICS INITIALIZATION ROUTINES                                       */
/**************************************************************************/
void setega(int scrwid,int scrseg,int scrheight);
void setmod(int scrmode);
void showoff(int scrnoff);
void vwait(void);
/**************************************************************************/
/* GRAPHICS DISPLAY ROUTINES                                              */
/**************************************************************************/
void hline(int y1,int x1,int x2,int color);
void vline(int x,int y1,int y2,int color);
void clearf(int x1,int y1,int x2,int y2,int color);
void erase(int color);
void eplot(int x,int y,int color);
void movscrn(int x1,int y1,int x2,int y2,int from,int to);
int  decode( int  segment,
             int  x1,
             int  y2,
             int  width,
             int  height,
             int  xoff,
             int  yoff,
             char *cmap,
             int  background);

void getwh(int segment,int *wid,int *hit);
/****************************************************************************/
/* Character printing routines and variables.                               */
/****************************************************************************/
extern int xloc;        /* xlocation on the screen of the current character */
extern int yloc;        /* ylocation on the screen of the current character */
extern int delx;        /* delta x between characters                       */
extern int dely;        /* delta y between characters (8x13) character set  */
extern char tcolor;     /* color of text                                    */
extern int bold;        /* bold flag                                        */
extern int bcolor;      /* Background color for qprint                      */
extern char ucolor;     /* color of underline   (NOT IMPLEMENTED)           */
extern int leftm;       /* left margin of text                              */
extern int rightm;      /* right margin of text                             */
extern int topm;        /* top margin of text                               */
extern int botm;        /* bottom margin of text                            */
extern int indent;      /* paragraph indentation (NOT IMPLEMENTED)          */
extern int wordwrap;    /* flag for word wrapped text (NOT IMPLEMENTED)     */
extern int justified;   /* justification flag justifies (NOT IMPLEMENTED)   */
void gprint(char *string); /* prints the string specified */
void qprint(char *string,char stopchar); /* Quick byte boundary printing */
void wprint(char *string); /* Character printint with word wrap */
void setmarg(int left,int top,int right,int bot);  /* Set margins */
int siztext(char *string); /* Returns the width of the str in pixels */
void setfont(int font_id);
void charpos(char *str,int cpos,int *dx,int *dy);
/**************************************************************************/
/* MISC. ROUTINES, KEYBOARD AND SUCH                                      */
/**************************************************************************/
int  keystat(void);
int  getk(void);
void writeln(char *line);
/**************************************************************************/
/* MEMORY MANAGEMENT ROUTINES                                             */
/**************************************************************************/
int  memalloc(int size);
int  free0(void);
int  getseg(char *p);
int  freem(int segment);
void getram(int segment,void *buf,int offset,int len);
void putram(int segment,void *buf,int offset,int len);
/**************************************************************************/
/* FILE I/O ROUTINES                                                      */
/**************************************************************************/
int  mfopen(char *filename,long int *size,int type);
int  mfclose(int fhand);
int  mfpos(int fhand,long int *fpos);
int  mfseek(int fhand,long int *fpos);
int  mfread(int seg,int offset,long int size,int fhand);
int  mfwrite(int seg,int offset,long int size,int fhand);
int  mdelete(char *filename);
int  fbload(char *filename,long int *siz);
int  fbsave(char *filename,int seg,long int siz,int bytoff);
int  mchdir(char *command);
/**************************************************************************/
/* ECG DISPLAY ROUTINES                                                   */
/**************************************************************************/
typedef struct {
                int segment;
                unsigned int offset;
                int xlocation;
                int ylocation;
                int color;
                int deltax;
                int nosamples;
              } STRIP;
void makvert(int hit);
void makvert2(int hit);
void ecg(int segment,int offset,int y,int col,int deltax,int samps,int byteoff);
void stripper(STRIP *strip);
void clearstrip(int buf,int siz);
int  setclear(int buffer);
int  detect(int seg,int offset,unsigned int *table,int nosamples);
