#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "window.h"
#include "copy.h"
#include "sbdetect.h"
#include "loader.h"
#include "digplay.h"
#include "doscalls.h"

#define EA 0
#define GAMBIT 0 // True if building Kasparov's Gambit version.

#define SOUNDDESC 41

#define DoDebug asm int 3

#define ANYKEY 0
#define SKIP	 1

// Define memory allocation functions.	If using DOS memory allocation
// functions, provided through DOSCALLS, then set the conditional compilation
// 'DOSALLOC' to true.  If using C compiler library function memory allocation
// set 'DOSALLOC' to zero.

#define DOSALLOC 0
// Redirect memory allocation to either DOS memory allocate functions located
// in DOSCALLS or to C library far memory allocation functions.
unsigned char far * far memalloc(long int siz)
{
	#if DOSALLOC
		return(fmalloc(siz));  // DOS far memory allocation functions
	#else
		return(farmalloc(siz)); // C's far memory allocation functions.
	#endif
}

void far memfree(char far *memory)
{
	#if DOSALLOC
		ffree(memory);
	#else
		farfree(memory);
	#endif
}


void		main(int argc,char **argv);
int 		exists(char *path);
char 		error_message(void);
extern void interrupt critical_error(void);
void    Copy(char *srcname,char *dstname);
int 		SelectSound(int x1,int y1,int x2,int y2,char *soundlist,int mx,int cur);
// DEM : New parameters in GetSoundFiles
int 		GetSoundFiles(char soundfiles[100][13],char **soundlist,int ba[100],int irq[100],int other[100]);
void		ConfigDriver(int driver);
int 		GetBaseAddr(int driver);
int 		GetIRQ(int driver);
int 		GetOther(int driver);
int     gethex(int x,int y,int startvalue);
void		ErrorOut(char *msg);
int 		AskBlast(void);
int 		TestDriver(void);
int 		LoadTestDriver(void);
void		ConfigureDriver(int driver);
int 		ErrorMsg(char *str);
int 		lineno;
void center(char *str);

char scratch[80];

extern int _wscroll;

char		*grtbl[] = { "B", "F", "C", "A", "D", "E" };

int 		SpecialCritError;
int 		MyAbort,i;
char		Graphics,Printer;
int 		Sound;

char		soundfiles[100][13];
int 		BaseAddr[100];				// DEM: 92-05-22
int 		IRQ[100]; 						// DEM: 92-05-22
int 		Other[100]; 					// DEM: 92-05-22

int 		KernelGraphicsAvail = 0;		// Do we need to setup these options?
int 		PrinterAvail = 0;
int 		SoundAvail = 0;
int 		Floppy = 0;
int 		ProgramDisk = 0;
int 		ActivitiesDisk = 0;
int 		CovoxDemoDisk = 0;

int OnSoundBlaster=0;
int SoundBlaster=0;
int SoundBlasterIRQ=7,SoundBlasterBaseAddress=0x220;

char    *savebffr;
struct text_info saveti;


void		main(int argc,char **argv)
{
	FILE	 *fh;
	char		ch,*soundlist;
	int 		xcon,numsounds,cur,ret;
	int firstask=1;

	// DEM : New parameters in GetSoundFiles
	numsounds = GetSoundFiles(soundfiles,&soundlist,BaseAddr,IRQ,Other);
	if ( numsounds )
		SoundAvail = 1;
	else
	{
		SoundAvail = 0;
		printf("No DIGPAK sound drivers found.\n");
		exit(1);
	}

	mdelete("SOUNDRV.COM");
#if GAMBIT
	Copy("IBMSND.COM","SOUNDRV.COM");
#endif

	gettextinfo(&saveti);
	savebffr = malloc(4000);
	gettext(1,1,80,25,savebffr);


	Graphics = Printer = Sound = 0;
	setvect(0x24,critical_error); 	// Handle Critical Error's
	SpecialCritError = 0;
	_setcursortype(_NOCURSOR);


	do
	{
#if EA
		NewWindow(1,1,80,25,BLUE,WHITE,"DIGPAK Sound Driver Setup - Copyright (c) 1993 - Electronic Arts",SINGLE);
#else
		NewWindow(1,1,80,25,BLUE,WHITE,"DIGPAK Sound Driver Setup - Copyright (c) 1993 - John W. Ratcliff",SINGLE);
#endif
		gotoxy(40,2);
		CenterString("DIGPAK Sound Driver Setup Program V3.3");
		gotoxy(40,24);
		CenterString(" Locate driver. Enter to select. ESC to cancel.");

		if ( firstask )
		{
			firstask = 0;
			MyAbort = AskBlast();
			if ( MyAbort == 2 )
			{
				MyAbort = 1;
				goto IQUIT;
			}

			if ( MyAbort )
			{
				SoundBlaster = DetectBlaster(&SoundBlasterBaseAddress,&SoundBlasterIRQ);
				if ( !SoundBlaster )
				{
					if ( ErrorMsg("No SoundBlaster was detected.") )
					{
						MyAbort = 1;
						goto IQUIT;
					}
				}
			}

		}


		MyAbort = 0;
		cur = 0;
//		if (SoundBlaster)
//		{
//			for (i=0; i<numsounds; i++)
//			{
//				if ( !strcmp(soundfiles[i],"SBLASTER.COM") ) cur = i;
//			}
//		}

		if (SoundAvail)
		{
			NewWindow(16,4,63,12,LIGHTGRAY,BLACK,"Sound Capabilities",DOUBLE);
			Sound = SelectSound(17,5,62,11,soundlist,numsounds,cur);
			clearbox(16,4,63,12,BLUE,WHITE);
			if (Sound == -1) MyAbort = 1;
		}


		if (!MyAbort)
		{
			textcolor(WHITE);
			textbackground(BLUE);
			gotoxy(40,23);
			CenterString("                                  ");
			gotoxy(40,24);
			CenterString("          Press ESC to select another driver.          ");
			Copy(soundfiles[Sound],"SOUNDRV.COM");
			ConfigureDriver(Sound);

			if ( !strcmp(soundfiles[Sound],"NOSOUND.COM") )
			{
				MyAbort = 0;
				ret = 1;
			}
			else
			{
				if ( TestDriver() )
				{
					ret = LoadTestDriver();
					if ( !ret ) MyAbort = 2;
					if ( ret == 2 ) MyAbort = 2;
				}
				else
					MyAbort = 2;
			}
		}
IQUIT:
	} while ( MyAbort == 2 );

	_setcursortype(_NORMALCURSOR);
	puttext(1,1,80,25,savebffr);
	puttextinfo(&saveti);
	if ( MyAbort )
	{
		mdelete("SOUNDRV.COM");
#if GAMBIT
		Copy("IBMSND.COM","SOUNDRV.COM");
#endif
		printf("Sound Driver selection cancelled, no configuration performed.\n");
	}
	else
		printf("Sound Driver successfully configured as SOUNDRV.COM.\n");
	exit(MyAbort); // Exit with error level condition.
}


int 		exists(char *path)
{
	FILE		*fh;

	fh = fopen(path,"r");
	if (fh == NULL) return (0);
	fclose(fh);
	return (1);
}




// Ask the user if they want to auto-detect for the precense of
// a soundblaster.

#define ASKX1 20
#define ASKY1 7
#define ASKX2 60
#define ASKY2 10

int AskBlast(void)
{
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;

	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(ASKX1,ASKY1,ASKX2,ASKY2,bffr);
		NewWindow(ASKX1,ASKY1,ASKX2,ASKY2,RED,WHITE,"",SINGLE);
		gotoxy(40,ASKY1+1);
		CenterString("Do you want to auto-detect for the");
		gotoxy(40,ASKY1+2);
		CenterString("presence of a SoundBlaster? (y/n)");
		ch = toupper(getch());
		puttext(ASKX1,ASKY1,ASKX2,ASKY2,bffr);
		if ( ch == 27 )
		{
			ret = 2;
			xcon = 1;
		}
		if (ch == 'Y' || ch == 'N' )
		{
			if ( ch == 'Y' )
				ret = 1;
			else
				ret = 0;
			xcon = 1;
		}
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);
	return (ret);
}


#define TESTX1 20
#define TESTY1 7
#define TESTX2 60
#define TESTY2 10

int TestDriver(void)
{
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;

	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(TESTX1,TESTY1,TESTX2,TESTY2,bffr);
		NewWindow(TESTX1,TESTY1,TESTX2,TESTY2,RED,WHITE,"",SINGLE);
		gotoxy(40,TESTY1+1);
		CenterString("Are you ready to test the");
		gotoxy(40,TESTY1+2);
		CenterString("sound driver you have selected? (y/n)");
		ch = toupper(getch());
		puttext(TESTX1,TESTY1,TESTX2,TESTY2,bffr);
		if (ch == 'Y' || ch == 'N' || ch == 27 )
		{
			if ( ch == 'Y' )
				ret = 1;
			else
				ret = 0;
			xcon = 1;
		}
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);
	return (ret);
}


#define LOADX1 20
#define LOADY1 7
#define LOADX2 60
#define LOADY2 15

int LoadTestDriver(void)
{
	SNDSTRUC snd;
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;
	long int siz;

	ret = LoadDigPak("SOUNDRV.COM");
	if (!ret)
	{
		ErrorMsg("Unable to load driver SOUNDRV.COM.");
		return(0);
	}
	ret = InitDigPak();
	if ( !ret )
	{
		UnLoadDigPak();
		ErrorMsg("Failed to initialize sound driver.");
		return(0);
	}

	snd.sound = fload("SETD.SND", &siz);
	if ( !snd.sound )
	{
		UnLoadDigPak();
		ErrorMsg("Failed to locate test sound 'SETD.SND'.");
		return(0);
	}

	snd.sndlen = siz;
	snd.frequency = 11000;
	MassageAudio(&snd);


	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(LOADX1,LOADY1,LOADX2,LOADY2,bffr);
		NewWindow(LOADX1,LOADY1,LOADX2,LOADY2,RED,WHITE,"",SINGLE);
		gotoxy(40,LOADY1+1);
		CenterString("Playing sound effect 2 times");


		gotoxy(40,LOADY1+5);
		CenterString("Configuration music by Rob Wallace");
		gotoxy(40,LOADY1+6);
		CenterString("Copyright (c) 1993");
		gotoxy(40,LOADY1+7);
		CenterString(" Wallace Music & Sound ");
		DigPlay2(&snd);
		gotoxy(40,LOADY1+3);
		CenterString("Playing once.");

		DigPlay2(&snd);
		gotoxy(40,LOADY1+3);
		CenterString("Playing twice..");

		gotoxy(40,LOADY1+1);
		CenterString("Did the sound play ok? (y/n)");
		gotoxy(40,LOADY1+3);
		CenterString("SPACEBAR to hear sound again.");

		do
		{
			ch = toupper(getch());
			if ( ch == 32 )
			{
				DigPlay2(&snd);
			}
			if (ch == 'Y' || ch == 'N' || ch == 27 )
			{
				if ( ch == 'Y' )
					ret = 1;
				else
					ret = 2;
				xcon = 1;
			}
		} while (!xcon);
		puttext(LOADX1,LOADY1,LOADX2,LOADY2,bffr);
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);

	StopSound(); // Stop currently playing sound effect.
	memfree(snd.sound);
	DeInitDigPak();
	UnLoadDigPak();

	return (ret);
}


char 		error_message(void)
{
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;

	if (SpecialCritError)
		return (0);

	gettextinfo(&ti);
	bffr = malloc(730);

	xcon = 0;
	do
	{
		gettext(15,10,66,16,bffr);

		NewWindow(15,10,66,16,RED,WHITE,"",SINGLE);
		gotoxy(40,11);
		CenterString("A disk error has occured!");
		gotoxy(40,14);
		CenterString("Press 'R' to retry.");
		gotoxy(40,15);
		CenterString("Press ESC to terminate Install Program.");

		ch = toupper(getch());
		puttext(15,10,66,16,bffr);
		if (ch == 27) 				// Abort installation
		{
			free(bffr);
			window(1,1,80,25);
			textcolor(WHITE);
			textbackground(BLACK);
			clrscr();
			cprintf("Installation terminated!\r\n");
			chdir("\\");
			_setcursortype(_NORMALCURSOR);
			ret = 2;
			xcon = 1;
		}
		if (ch == 'R')
		{
			ret = 1;
			xcon = 1;
		}
	} while (!xcon);

	free(bffr);

	puttextinfo(&ti);
	return (ret);
}


void		Copy(char *src,char *dst)
{
	struct ffblk fb;
	int 		xcon;
	char		srcname[80],dstname[80],tfname[15];
	char    srcpath[80],dstpath[80];
	char 		drive[MAXDRIVE];
	char 		dir[MAXDIR];
	char 		file[MAXFILE];
	char 		ext[MAXEXT];
	int 		flags;

	flags = fnsplit(src,drive,dir,file,ext);

	srcpath[0] = 0;
	if (flags & DRIVE) strcat(srcpath,drive);
	if (flags & DIRECTORY) strcat(srcpath,dir);

	flags = fnsplit(dst,drive,dir,file,ext);

	dstpath[0] = 0;
	if (flags & DRIVE) strcat(dstpath,drive);
	if (flags & DIRECTORY) strcat(dstpath,dir);
	if (flags & FILENAME) strcpy(tfname,file);
	if (flags & EXTENSION) strcat(tfname,ext);


	xcon = 0;
	xcon = findfirst(src,&fb,0);
	strcpy(srcname,srcpath);
	strcat(srcname,fb.ff_name);
	strcpy(dstname,dstpath);
	if (dst != NULL)
		strcat(dstname,tfname);
	else
		strcat(dstname,fb.ff_name);
	while (!xcon)
	{
		FileCopy(srcname,dstname);
		xcon = findnext(&fb);
		strcpy(srcname,srcpath);
		strcat(srcname,fb.ff_name);
		strcpy(dstname,dstpath);
		if (dst != NULL)
			strcat(dstname,tfname);
		else
			strcat(dstname,fb.ff_name);
	}
}


int 		SelectSound(int x1,int y1,int x2,int y2,char *list,int mx,int cur)
{
	int AskConfig=0;
	char		savebffr[4000];
	struct text_info saveti;
	char		bffr[160];
	char		scrl[4096];
	char		curattr;
	int 		h,top,j,hl,xcon,ch,sel,ol,ot,attention;
	char	scratch[80];

	gettext(x1,y1-1,x1,y1-1,bffr);
	curattr = bffr[1];

	h = y2 - y1 + 1;
	top = 0;
	sel = cur;

	if (sel < h/2+1) hl = sel;
	if (sel > mx-(h/2+1)) hl = sel - (mx-h);
	if (sel > h/2 && sel < mx-(h/2)) top = sel - h/2;

	for (i=top,j=0; i<h+top; i++,j++)
	{
		gotoxy(40,y1+j);
		CenterString(list+(SOUNDDESC*i));
	}

	gettext(x1,hl+y1,x2,hl+y1,bffr);
	for (i=1; i<160; i+=2) bffr[i] = BLACK*16+WHITE;
	puttext(x1,hl+y1,x2,hl+y1,bffr);

	xcon = 0;
	do
	{
		Sound = sel;
		gotoxy(x1+2,y1-1);
		if (top)
		{
			textcolor(WHITE);
			textbackground(RED);
			cputs(" MORE ");
			textattr(curattr);
		}
		else
		{
			textattr(curattr);
			cputs("");
		}
		gotoxy(x1+2,y2+1);
		if (top+h < mx)
		{
			textcolor(WHITE);
			textbackground(RED);
			cputs(" MORE ");
			textattr(curattr);
		}
		else
		{
			textattr(curattr);
			cputs("");
		}

		attention = 0;

		if (!strcmp(soundfiles[sel],"IBMBAK.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Attention!",DOUBLE);
			lineno = 15;
			center("The IBM Internal Speaker: Background driver works with");
			center("16Mhz or better computers.  If your computer is less");
			center("than 16Mhz, you may want to select the Foreground");
			center("version or one of the other drivers.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}

		if (!strcmp(soundfiles[sel],"ARIA.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Aria Based Sound Cards",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have any of the popular");
			center("sound cards based on the Aria chipset from Sierra");
			center("Semiconductor. This includes the MidiMaestro from Computer");
			center("Peripherals and the Sonic Sound from Diamond computer systems.");
			center("This digital sound driver was created with the help of Kerchen");
			center("Heller at Sierra, and Mike Dabbs of Simutronics.");
			attention = 1;
		}

		if (!strcmp(soundfiles[sel],"SNDSYS.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Microsoft Sound System",DOUBLE);
			lineno = 15;
			center("Select this driver if you have the Microsoft Windows");
			center("Sound System, from Microsoft.  This driver was developed");
			center("with the cooporation of Microsoft Corporation.");
			center("Special thanks to Bryan Woodruff for his extensive help");
			center("in creating this digital sound driver.");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"MULTISND.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Turtle Beach Multisound",DOUBLE);
			lineno = 15;
      center("Select this sound driver if you own the Turtle Beach Multisound.");
			center("Currently this driver will only work if you have installed your");
			center("Turtle at the default manufacturer settings.  This driver will");
			center("not work unless you have run the PRESETS program provided by");
			center("Turtle Beach Systems prior to using DIGPAK.  Special thanks");
			center("to Roy Smith and Richard Mazzerese for creating this driver.");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"SBLASTER.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Creative Labs Sound Blaster",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own a SoundBlaster card from");
			center("Creative Labs.  If you own a SoundBlaster 'compatible' from");
			center("another manufacturer, then select the SoundBlaster CLONE");
			center("driver instead.  Special thanks to Scott Sindorf and Chong");
			center("from Creative Labs for their assistance with this driver.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"LSIZE.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Life Size Sound Enhancer",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have the Life Size");
			center("Sound Enhancer from Activision.  If your Life Size");
			center("Sound Enhancer is not located in the LPT1 parallel");
			center("port, and is instead locaed in LPT2, enter a base ");
			center("address of '40A' in the configuration screen.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"SBPRO.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Creative Labs SoundBlaster Pro",DOUBLE);
			lineno = 15;
			center("Select this driver if you have a true SoundBlaster Pro from");
			center("Creative Labs.  Do not select this driver if you have the");
			center("SoundBlaster 16, or some other SoundBlaster compatible.");
			center("The SoundBlaster Pro sound driver provides true stereo sound");
			center("for those applications that use it.  Special thanks to Scott");
			center("Sindorf of Creative Labs for his assistance with this driver.");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"SB16.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Creative Labs SoundBlaster 16",DOUBLE);
			lineno = 15;
			center("Select this driver if you have a true SoundBlaster 16 from");
			center("Creative Labs or SoundBlaster AWE-32 card.");
			center("Special thanks to Scott Sindorf of Creative Labs");
			center("for his assistance creating this driver.");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"PAS16.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"MediaVision ProAudio Spectrum 16",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have a ProAudio Spectrum 16");
			center("from MediaVision or a Logitech SoundMan 16 from Logitech.");
			center("This driver requires the presence of MVSOUND.SYS in your");
			center("CONFIG.SYS to run (availabe during manufacturer's install)");
			center("Special thanks to Doug Codey of MediaVision for his extensive");
			center("help creating this sound driver.");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"ADLIBG.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Adlib Gold",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own an Adlib Gold sound card.");
			center("Be sure that when you installed you Adlib you configured the");
			center("DMA channel properly for digital sound.  Special thanks to");
			center("John Miles of Miles Design for his extensive help creating");
			center("this sound driver.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"CVXSND.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Covox Speech Thing",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have the Covox Speech");
			center("Thing from Covox.  If your Speech Thing");
			center("is not located in the LPT1 parallel");
			center("port, and is instead locaed in LPT2, enter a base ");
			center("address of '40A' in the configuration screen.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"PAUDIO.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"MediaVision ProAudio Spectrum 8",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have one of the original");
			center("MediaVision ProAudio Spectrum 8 digital sound cards.");
			center("This driver requires the presence of MVSOUND.SYS in your");
			center("CONFIG.SYS to run (availabe during manufacturer's install)");
			center("Special thanks to Doug Codey of MediaVision for his extensive");
			center("help creating this sound driver.");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"SOURCE.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Walt Disney Sound Source",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have a Walt Disney Sound Source");
			center("conneted to your machine.  If your Sound Source ");
			center("is not located in the LPT1 parallel");
			center("port, and is instead locaed in LPT2, enter a base ");
			center("address of '40A' in the configuration screen.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"STFX.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"ATI Stereo FX",DOUBLE);
			lineno = 15;
			center("");
			center("Select this driver if you own an ATI Stereo FX card.");
			center("");
			center("Driver written by John W. Ratcliff");
			center("");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"IBMSND.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"PC Speaker Foreground",DOUBLE);
			lineno = 15;
			center("Select this driver if you do not own any third party");
			center("audio device and wish to hear sound effects out of your");
			center("PC internal speaker.  This driver is a foreground only");
			center("driver and thus causes the machine to stop while playing");
			center("a sound effect.  You may want to select the NOSOUND sound");
			center("driver instead.  Written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"ADLIB.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Adlib Personal Music System",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own the original Adlib Personal");
			center("Music system and have no other way to play digital sound.  You");
			center("will not be able to play both digital sound and music at the same");
			center("time on your Adlib.  If you plan to play music, then select the");
			center("no digital sound card driver instead.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"VMSND.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Covox Sound Master II",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own the original Covox");
			center("Voice Master I or the current Covox Sound Master II.");
			center("Special thanks to Brad Stewart of Covox for his assistance");
			center("with this sound driver.");
			center("");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"SMSND.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Covox Sound Master I",DOUBLE);
			lineno = 15;
			center("Select this sound driver only if you own the original");
			center("Covox Sound Master I, which is no longer made.  If you");
			center("own the Covox Sound Master II, select that driver instead.");
			center("Special thanks to Brad Stewart of Covox for his assistance");
			center("with this sound driver.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"DIGISP.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Digispeech DS201",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have the DigiSpeech DS201");
			center("speech adaptor.  This sound driver requires the presence of");
			center("the manufacturer provided driver LWDIGI.  Refer to your ");
			center("DigiSpeech documentation about how to get LWDIGI installed.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"TANEXTX.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Tandy EX/TX",DOUBLE);
			lineno = 15;
			center("Select this sound driver only if you own one of the very");
			center("old Tandy 3 voice systems.  This includes the Tandy EX,");
			center("TX,HX,SX, and even the original IBM PCjr.  The quality of");
			center("the digital sound on these old machines is marginal at best.");
			center("You may want to select one of the PC speaker drivers or the");
			center("no sound card option instead.  Written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"TANSLTL.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Tandy Sensation",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own a Tandy Sensation or one");
			center("of the Tandy SL/TL line of computers.");
			center("");
			center("Driver written by John W. Ratcliff");
			center("");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"ECHOII.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Echo II",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own the Echo II from");
			center("Street Electronics.  This is a sound device commonly");
			center("found in schools.  Special thanks to Milo Street for");
			center("his assistance with this sound driver.");
			center("");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"LANTSND.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Lantastic Voice Adaptor",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own the Lantastic Voice");
			center("Adaptor from Artisoft.  Use of this driver requires that");
			center("you have previously loaded the LANVOICE utility that comes");
			center("with your Voice Adaptor.");
			center("");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"IBM1BIT.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"PC Speaker 1 bit",DOUBLE);
			lineno = 15;
			center("This is an alternative PC speaker driver that while louder");
			center("than the others, is also much lower in quality.  You may");
			center("want to select the no digital sound driver instead.");
			center("");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"BIGMOUTH.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"BigMouth",DOUBLE);
			lineno = 15;
			center("Select this driver only if you own the BigMouth sound card");
			center("from Talking Technologies.  This is a very obscure sound card");
			center("which actually provides the ability to play digital sound over");
			center("a telephone.  If you find any practical use for this driver I");
			center("would love to hear about it.");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"GF166.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Gravis Ultrasound",DOUBLE);
			lineno = 15;
			center("Select this driver if you own the Gravis Ultrasound from");
			center("Gravis.  This driver REQUIRES the presence of the manufacturer");
			center("provided ULTRAMID driver.  You can get ULTRAMID from Gravis.");
			center("ULTRAMID provides high quality digital sound on your Ultrasound and");
			center("stunning quality music.  Thanks to Brad Craig of Gravis, and very");
			center("special thanks to Mike Leibow of Forte for creating these drivers.");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"NOSOUND.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"No Digital Sound Card",DOUBLE);
			lineno = 15;
			center("Select this sound driver, if you do not own any third party digital");
			center("sound card, available in this menu selection.  Because of the limited");
			center("functionality of the PC speaker drivers it is sometimes better to");
			center("simply select the no digital sound card driver instead.");
			center("");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}
		if (!strcmp(soundfiles[sel],"SBCLONE.COM"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"SoundBlaster Clone",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have a SoundBlaster compatible");
			center("that did not come from Creative Labs.  You would want to use this");
			center("driver if you owned a MediaVision Thunderboard, a Gravis using SBOS,");
			center("or some other sound card in SoundBlaster compatibility mode.");
			center("");
			center("Driver written by John W. Ratcliff");
			attention = 1;
		}

		if (!attention ) clearbox(5,14,75,21,BLUE,WHITE);


		if (	strcmp(soundfiles[sel],"SBLASTER.COM") == 0 ||
					strcmp(soundfiles[sel],"SBCLONE.COM") == 0 ||
					strcmp(soundfiles[sel],"SBPRO.COM") == 0 ||
					strcmp(soundfiles[sel],"SB16.COM") == 0 ||
					strcmp(soundfiles[sel],"STFX.COM") == 0 )
		{
			OnSoundBlaster = 1;
			if ( SoundBlaster )
			{
				BaseAddr[sel] = SoundBlasterBaseAddress;
				IRQ[sel] = SoundBlasterIRQ;
			}
		}
		else
			OnSoundBlaster = 0;


	// ***??? Print Sb info?
		if ( SoundBlaster && OnSoundBlaster )
		{
			textcolor(WHITE);
			textbackground(RED);
			sprintf(scratch,"SoundBlaster or compatible detected at base address: %X IRQ: %X",SoundBlasterBaseAddress,SoundBlasterIRQ);
			gotoxy(40,22);
			CenterString(scratch);
		}
		else
		{
			textcolor(BLUE);
			textbackground(BLUE);
			gotoxy(40,22);
			CenterString("                                                                        ");
		}


		textcolor(WHITE);
		textbackground(BLUE);
		if (BaseAddr[Sound]!=-1 || IRQ[Sound]!=-1 || Other[Sound]!=-1)
		{
			AskConfig = 1;
			gotoxy(40,23);
			CenterString("Press 'C' to reconfigure hardware.");
		}
		else
		{
			AskConfig = 0;
			gotoxy(40,23);
			CenterString("                                  ");
		}

		textattr(curattr);

		ch = getch();
		if (!ch) ch = getch()+256;
		ol = hl;
		ot = top;
		switch (ch)
		{
			case 328: 	// Up Arrow
			case 331: 	// Right Arrow
				if (sel > 0) sel--;
				break;
			case 336: 	// Down Arrow
			case 333: 	// Left Arrow
				if (sel < mx-1) sel++;
				break;
			case 13:		// Enter
				xcon = 1;
				break;
			case 'c':
			case 'C':
								if (BaseAddr[Sound]!=-1 || IRQ[Sound]!=-1 || Other[Sound]!=-1)
								{
									gettextinfo(&saveti);
									gettext(1,1,80,25,savebffr);
									ConfigDriver(Sound);
									puttext(1,1,80,25,savebffr);
									puttextinfo(&saveti);
								}

								break;

			case 27:		// Esc
				xcon = 1;
				sel = -1;
				break;
		}

		gettext(x1,ol+y1,x2,ol+y1,bffr);
		for (i=1; i<160; i+=2) bffr[i] = LIGHTGRAY*16+BLACK;
		puttext(x1,ol+y1,x2,ol+y1,bffr);

		if (!xcon)
		{
			if (sel < h/2+1) hl = sel;
			if (sel >= mx-(h/2+1)) hl = sel - (mx-h);
			if (sel >= h/2 && sel < mx-(h/2)) top = sel - h/2;

			if (top > ot)
			{
				gettext(x1,y1+1,x2,y2,scrl);
				puttext(x1,y1,x2,y2-1,scrl);
				gotoxy(x1,y2);
				for (i=x1; i<x2; i++) putch(' ');
				gotoxy(40,y2);
				CenterString(list+(SOUNDDESC*(top+h-1)));
			}

			if (top < ot)
			{
				gettext(x1,y1,x2,y2-1,scrl);
				puttext(x1,y1+1,x2,y2,scrl);
				gotoxy(x1,y1);
				for (i=x1; i<x2; i++) putch(' ');
				gotoxy(40,y1);
				CenterString(list+(SOUNDDESC*(top)));
			}

			gettext(x1,hl+y1,x2,hl+y1,bffr);
			for (i=1; i<160; i+=2) bffr[i] = BLACK*16+WHITE;
			puttext(x1,hl+y1,x2,hl+y1,bffr);
		}
	} while (!xcon);
	clearbox(5,14,75,21,BLUE,WHITE);

// Ok here goes.....
	if ( AskConfig && !SoundBlaster && sel != -1	&& OnSoundBlaster )
	{
		gettextinfo(&saveti);
		gettext(1,1,80,25,savebffr);
		ConfigDriver(Sound);
		puttext(1,1,80,25,savebffr);
		puttextinfo(&saveti);
	}

	return (sel);
}

// DEM 92-05-22 : New parameters in GetSoundFiles
int 		GetSoundFiles(char soundfiles[100][13],char **soundlist,int ba[100],int irq[100],int other[100])
{
	FILE	 *fh;
	struct ffblk fb;
	int 		xcon = 0,i=0,j,k,t;
	size_t	cursize = SOUNDDESC;
	char		name[SOUNDDESC],*sl;

	sl = malloc(cursize);
	if (sl == NULL) ErrorOut("Not Enough Memory for SoundList!\n");
	xcon = findfirst("*.COM",&fb,0);
	while (!xcon)
	{
		if (strcmp(fb.ff_name,"SOUNDRV.COM")) // If not SOUNDRV.COM then continue
		{
			fh = fopen(fb.ff_name,"r");
			fseek(fh,3L,SEEK_SET);
			fread(name,6,1,fh);
			if ( name[0] == 'D' &&
					 name[1] == 'I' &&
					 name[2] == 'G' &&
					 name[3] == 'P' &&
					 name[4] == 'A' &&
					 name[5] == 'K' )
			{
				sl = realloc(sl,cursize);
				if (sl == NULL) ErrorOut("Not Enough Memory for SoundList!\n");
				strcpy(soundfiles[i],fb.ff_name);
				fseek(fh,12L,SEEK_SET);
				fread(sl+(SOUNDDESC*i), SOUNDDESC-1, 1, fh);
				fseek(fh,0x106,SEEK_SET); 					// DEM 92-05-22
				fread(&ba[i],sizeof(int),1,fh); 		// DEM 92-05-22
				fread(&irq[i],sizeof(int),1,fh);		// DEM 92-05-22
				fread(&other[i],sizeof(int),1,fh);	// DEM 92-05-22
				fclose(fh);
				*(sl+(SOUNDDESC*i)+SOUNDDESC-1) = 0;
				i++;
				cursize += SOUNDDESC;
			}
		}
		xcon = findnext(&fb);
	}
	for (j=0; j<i; j++) 					// Sort sound drivers in Alpha order
	{
		for (k=j+1; k<i; k++)
		{
			if (strcmp(sl+(SOUNDDESC*j),sl+(SOUNDDESC*k)) > 0)	// if j > k
			{
				strcpy(name,sl+(SOUNDDESC*j));
				strcpy(sl+(SOUNDDESC*j),sl+(SOUNDDESC*k));
				strcpy(sl+(SOUNDDESC*k),name);
				strcpy(name,soundfiles[j]);
				strcpy(soundfiles[j],soundfiles[k]);
				strcpy(soundfiles[k],name);
				t = BaseAddr[j];
				BaseAddr[j] = BaseAddr[k];
				BaseAddr[k] = t;
				t = IRQ[j];
				IRQ[j] = IRQ[k];
				IRQ[k] = t;
				t = Other[j];
				Other[j] = Other[k];
				Other[k] = t;
			}
		}
	}
	*soundlist = sl;
	return (i);
}

//1
void		ConfigDriver(int driver)
{
	FILE *fh;

	NewWindow(13,4,69,22,CYAN,BLACK,"Configure Sound Driver",DOUBLE);
	window(15,6,68,20);

	if ( BaseAddr[driver] != -1 )
	{
		if ( OnSoundBlaster && SoundBlaster ) // Don't need to ask.
			BaseAddr[driver] = SoundBlasterBaseAddress;
		else
			GetBaseAddr(driver);
	}
	if ( IRQ[driver] != -1 )
	{
		if ( OnSoundBlaster && SoundBlaster )
			IRQ[driver] = SoundBlasterIRQ;
		else
			GetIRQ(driver);
	}
	if ( Other[driver] != -1 )    GetOther(driver);


	window(1,1,80,25);
	clearbox(13,4,69,22,BLUE,WHITE);
}


int 		GetBaseAddr(int driver)
{
	int			ix,iy,t;
	struct text_info ti;

	gettextinfo(&ti);
	cprintf("Default Base Address: %4X (hex)\r\n\n",BaseAddr[driver]);
	cputs("Enter new Base Address: ");
	ix = wherex();
	iy = wherey();

	textcolor(WHITE);
	textbackground(BLUE);
	cputs("    ");
	textattr(ti.attribute);

	cputs("  (hex)");

	cputs("\r\n\n\nThe Base Address of a sound device is the location\r\n");
	cputs("where data is sent and recieved.  If there is a\r\n");
	cputs("conflict with another device, you may experience\r\n");
	cputs("problems with one of the devices, consequently\r\n");
	cputs("a new location will need to be found for\r\n");
	cputs("either device.");

	if ( SoundBlaster && OnSoundBlaster )
	{
		textcolor(WHITE);
		textbackground(RED);
		sprintf(scratch,"\r\nSoundBlaster or compatible device detected at \r\nbase address: %X\r\n",SoundBlasterBaseAddress);
		cputs(scratch);
	}


	textcolor(WHITE);
	textbackground(BLUE);
	t = gethex(ix,iy,BaseAddr[driver]);
	textattr(ti.attribute);
	if (t==-1) return (-1);
	BaseAddr[driver] = t;
	return (0);
}


int 		GetIRQ(int driver)
{
	int			ix,iy,t;
	struct text_info ti;

	clrscr();
	gettextinfo(&ti);
	cprintf("Default IRQ: %4X (hex)\r\n\n",IRQ[driver]);
	cputs("Enter new IRQ: ");
	ix = wherex();
	iy = wherey();

	textcolor(WHITE);
	textbackground(BLUE);
	cputs("    ");
	textattr(ti.attribute);

	cputs("  (hex)");


	cputs("\r\n\n\n\n\nThe IRQ or Interrupt ReQuest line is used to let\r\n");
	cputs("the sound device know that data is ready.\r\n");

	if ( SoundBlaster && OnSoundBlaster )
	{
		textcolor(WHITE);
		textbackground(RED);
		sprintf(scratch,"\r\nSoundBlaster or compatible detected at IRQ: %X.\r\n",SoundBlasterIRQ);
		cputs(scratch);
	}

	textcolor(WHITE);
	textbackground(BLUE);
	t = gethex(ix,iy,IRQ[driver]);
	textattr(ti.attribute);
	if (t==-1) return (-1);
	IRQ[driver] = t;
	return (0);
}


int 		GetOther(int driver)
{
	int			ix,iy,t;
	struct text_info ti;

	clrscr();
	gettextinfo(&ti);
	cprintf("DMA Channel: %4X (hex)\r\n\n",Other[driver]);
	cputs("DMA Channel: ");
	ix = wherex();
	iy = wherey();

	textcolor(WHITE);
	textbackground(BLUE);
	cputs("    ");
	textattr(ti.attribute);

	cputs("  (hex)");

	cputs("\r\n\n\n\n\n\n\nThis value is different depending on the sound\r\n");
	cputs("device.  Check your users manual before changing\r\n");
	cputs("the value of this entry.  For SoundBlasters or\r\n");
	cputs("compatibles, this entry is the DMA channel.\r\n");

	textcolor(WHITE);
	textbackground(BLUE);
	t = gethex(ix,iy,Other[driver]);
	textattr(ti.attribute);
	if (t==-1) return (-1);
	Other[driver] = t;
	return (0);
}


int			gethex(int x,int y,int startvalue)
{
	int			xcon,gxcon,ip,value;
	char		ch,in[6];

	ip = 0;
	in[0] = 0;

	_setcursortype(_NORMALCURSOR);
	gotoxy(x,y);

	xcon = 0;
	do
	{
		gxcon = 0;
		do
		{
			ch = toupper(getch());
			if (ch == 27 || ch == 13 || ch == 8 || isxdigit(ch)) gxcon = 1;
		} while (!gxcon);
		switch (ch)
		{
			case 27:
				in[0] = 0;
				xcon = 1;
			case 13:
				if (!ip)
					sprintf(in,"%X",startvalue);
				else
					in[ip] = 0;
				xcon = 1;
				break;
			case 8:
				if (ip)
				{
					putch(8);
					putch(' ');
					putch(8);
					ip--;
				}
				break;
			default:
				if (ip < 4)
				{
					putch(ch);
					in[ip] = ch;
					ip++;
				}
				break;
		}
	} while (!xcon);
	_setcursortype(_NOCURSOR);
	sscanf(in,"%x",&value);
	if (ch==27) value = -1;
	return (value);
}


void		ErrorOut(char *msg)
{
	_setcursortype(_NORMALCURSOR);
	window(1,1,80,25);
	textcolor(WHITE);
	textbackground(BLACK);
	clrscr();
	cputs(msg);
	exit(1);
}


void ConfigureDriver(int driver)
{
	FILE *fh;

	fh = fopen("SOUNDRV.COM","r+b");
	fseek(fh,0x106,SEEK_SET);
	fwrite(&BaseAddr[driver],sizeof(int),1,fh);
	fwrite(&IRQ[driver],sizeof(int),1,fh);
	fwrite(&Other[driver],sizeof(int),1,fh);
	fclose(fh);
}


#define ERRORX1 20
#define ERRORY1 7
#define ERRORX2 60
#define ERRORY2 10

int ErrorMsg(char *str)
{
	int 		xcon,ret=0;
	char    *bffr,ch;
	struct text_info ti;

	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(ERRORX1,ERRORY1,ERRORX2,ERRORY2,bffr);
		NewWindow(ERRORX1,ERRORY1,ERRORX2,ERRORY2,RED,WHITE,"",SINGLE);
		gotoxy(40,ERRORY1+1);
		CenterString(str);
		gotoxy(40,ERRORY1+2);
		CenterString("Press a key to continue.");
		ch = toupper(getch());
		if ( ch == 27 ) ret = 1;
		puttext(ERRORX1,ERRORY1,ERRORX2,ERRORY2,bffr);
		xcon = 1;
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);
	return (ret);
}

void center(char *str)
{
	gotoxy(40,lineno);
	CenterString(str);
	lineno++;
}
