
          
                                 

'*****************************************************************************
'-----------------------------------------------------------------------------

'                    -  B A T T L E  T H E  A L I E N S  -

'                               A QBasic Game
'                            By Steve Protulipac

'                          Press Shift & F5 to Run

'------------------------------------------------------------------------------
'********************************************************************************















DEFINT A-Z
DECLARE SUB AnnLevel ()
DECLARE SUB Congrats ()
DECLARE SUB YouWin ()
DECLARE SUB Intro ()
DECLARE SUB Start ()
DECLARE SUB Ending ()
DECLARE SUB GameOver ()
DECLARE SUB MoveShip ()
DECLARE SUB CheckHit ()
DECLARE SUB TestShips ()
DECLARE SUB MoveTarget (type$)
DECLARE SUB GetDrawings ()
DECLARE SUB ChangeSight (dir%)
DECLARE SUB Rest (t#)
DECLARE SUB AlienKeys ()
DECLARE SUB DrawScreen ()

DIM SHARED Ship1(1, 5000)
DIM SHARED ClearShip(1, 5000)

DIM SHARED Shipy AS INTEGER
DIM SHARED Shipx AS INTEGER

DIM SHARED Angle1
DIM SHARED Angle2
DIM SHARED Radar
DIM SHARED TotShips
DIM SHARED HitShips
DIM SHARED Points
DIM SHARED Health
DIM SHARED Level
DIM SHARED Speed

CONST TRUE = -1
CONST FALSE = NOT TRUE
CONST MACHSPEED = 1
CONST SPEEDCONST = 5000

Shipx = 1
Shipy = 10
TotShips = 1
Health = 100
Level = 1
Speed = 1

SCREEN 9
DRAW "c5 r40 ta45 d3 ta180 br45 ta135 d3"
CIRCLE (340, 175), 4, 5
PAINT (340, 176), 5, 5
GET (300, 150)-(395, 215), Ship1
CLS
GET (100, 100)-(200, 150), ClearShip
PALETTE 2, 16
PALETTE 6, 26
    
       Intro
   
    DO
       AnnLevel
       DrawScreen
       Start
       AlienKeys
       Ending
    LOOP

SUB AlienKeys
   
    DO
       Radar = Radar + 10
       IF Radar > 360 THEN Radar = 0
       Rest .5
       MoveShip
       DrawScreen
      
       key$ = INKEY$
       SELECT CASE key$
           CASE CHR$(32): GOSUB Guns
           CASE CHR$(0) + "H":
                Shipy = Shipy + 10
                Angle1 = Angle1 + 1
                IF Angle1 > 9 THEN
                   Angle1 = 9
                   Shipy = Shipy - 10
                END IF
           CASE CHR$(0) + "P":
                Shipy = Shipy - 10
                Angle1 = Angle1 - 1
                IF Angle1 < 0 THEN
                   Angle1 = 0
                   Shipy = Shipy + 10
                END IF
           CASE CHR$(0) + "K":
                Shipx = Shipx + 10
                Angle2 = Angle2 - 1
                IF Angle2 < 0 THEN Angle2 = 36
           CASE CHR$(0) + "M":
                Shipx = Shipx - 10
                Angle2 = Angle2 + 1
                IF Angle2 > 36 THEN Angle2 = 0
           CASE CHR$(27): GameOver
       END SELECT
    LOOP UNTIL HitShips = TotShips OR Health = 0

    IF Health = 0 THEN
       GameOver
    ELSE
       Angle1 = 0
       Angle2 = 0
       HitShips = 0
       TotShips = TotShips + 5
       Health = 100
       Speed = Speed + 1
       Level = Level + 1
    END IF

    IF Level > 5 THEN
       Congrats
    END IF
EXIT SUB

Guns:
   FOR x = 1 TO 2
       LINE (20, 240)-(319, 125), 14, , &HFF00
       LINE (620, 240)-(319, 125), 14, , &HFF00
       SOUND 200, 1
       Rest 10
       LINE (20, 240)-(319, 125), 0, , &HFF00
       LINE (620, 240)-(319, 125), 0, , &HFF00
       Rest 10
       CheckHit
   NEXT x
RETURN

END SUB

SUB AnnLevel
   
    CLS
    COLOR 4
    LOCATE 11, 36
    PRINT "L "; : Rest .5
    PRINT "E "; : Rest .5
    PRINT "V "; : Rest .5
    PRINT "E "; : Rest .5
    PRINT "L "; : Rest .5
    PRINT " "; : Rest .5
    PRINT Level: Rest .5
    LOCATE 11, 36
    FOR x = 1 TO 14
        Rest .5
        PRINT SPACE$(1);
    NEXT x

END SUB

SUB CheckHit
    
    point1 = POINT(319, 124)
    point2 = POINT(319, 126)
    point3 = POINT(321, 124)
    point4 = POINT(321, 126)

    IF point1 = 5 OR point2 = 5 OR point3 = 5 OR point4 = 5 THEN
       PUT (Shipx, Shipy), ClearShip, PSET
       SOUND 37, 2
       FOR r = 1 TO 35
           CIRCLE (320, 125), r, 4, , , .5
       NEXT r
       FOR r = 1 TO 35
           CIRCLE (320, 125), r, 0, , , .5
       NEXT r
       Shipx = INT(RND * 590) + 10
       Shipy = 10
       Rest 500
       HitShips = HitShips + 1
       Points = Points + 50
    END IF

END SUB

SUB Congrats
   
    CLS
    COLOR 4
    LOCATE 11, 25
    PRINT "C "; : Rest .5
    PRINT "O "; : Rest .5
    PRINT "N "; : Rest .5
    PRINT "G "; : Rest .5
    PRINT "R "; : Rest .5
    PRINT "A "; : Rest .5
    PRINT "T "; : Rest .5
    PRINT "U "; : Rest .5
    PRINT "L "; : Rest .5
    PRINT "A "; : Rest .5
    PRINT "T "; : Rest .5
    PRINT "I "; : Rest .5
    PRINT "O "; : Rest .5
    PRINT "N "; : Rest .5
    PRINT "S": Rest .5
    LOCATE 11, 25
    FOR x = 1 TO 30
        Rest .5
        PRINT SPACE$(1);
    NEXT x
    
    YouWin

END SUB

SUB DrawScreen
   
    CIRCLE (10, 250), 10, 8
    PAINT (11, 250), 8, 8
  
    LINE (0, 0)-(10, 350), 8, BF
    LINE (0, 0)-(640, 10), 8, BF
    LINE (630, 0)-(640, 350), 8, BF
    LINE (300, 125)-(340, 125), 8
    LINE (320, 110)-(320, 140), 8
    LINE (0, 250)-(640, 350), 8, BF
   
    LINE (20, 300)-(100, 300), 7
    LINE (100, 250)-(100, 350), 7
    LINE (20, 250)-(20, 350), 7

    CIRCLE (60, 325), 15, 0
    DRAW "c0 ta" + STR$(-10 * Angle2) + " u20"

    CIRCLE (60, 285), 15, 0, 0, 3.1415
    LINE (45, 285)-(75, 285), 0
    DRAW "bm60,283 c0 ta" + STR$(-10 * Angle1) + " l25"

    COLOR 15, 0
    LOCATE 23, 15: PRINT 10 * Angle2; ""
    LOCATE 21, 15: PRINT 10 * Angle1; ""
    LOCATE 23, 40: PRINT " Hit:"; INT((100 * HitShips) / TotShips); "%"
    LOCATE 21, 40: PRINT " # Ships:"; TotShips - HitShips
    LOCATE 20, 55: PRINT " Points "
    LOCATE 23, 55: PRINT Points
    LOCATE 20, 64: PRINT " Health "
    LOCATE 23, 69: PRINT Health; "%"
   
    LINE (175, 250)-(175, 350), 7
    CIRCLE (240, 300), 50, 2
    PAINT (240, 300), 2, 2
    DRAW "c6 ta" + STR$(-Radar) + "u40"

    LINE (430, 250)-(430, 350), 7
    LINE (500, 250)-(500, 350), 7

    LINE (590, 235)-(640, 350), 8, BF
    LINE (600, 345)-(630, 245), 4, B
    LINE (600, 345)-(630, 345 - Health), 4, B

END SUB

SUB Ending
    
    COLOR 4
    LOCATE 13, 32
    PRINT "A "; : Rest .5
    PRINT "R "; : Rest .5
    PRINT "E "; : Rest .5
    PRINT "A "; : Rest .5
    PRINT "  "; : Rest .5
    PRINT "S "; : Rest .5
    PRINT "E "; : Rest .5
    PRINT "C "; : Rest .5
    PRINT "U "; : Rest .5
    PRINT "R "; : Rest .5
    PRINT "E": Rest .5
    LOCATE 13, 32
    FOR x = 1 TO 22
        Rest .5
        PRINT SPACE$(1);
    NEXT x

END SUB

SUB GameOver
   
    WHILE INKEY$ = ""
       CLS
       COLOR 4
       LOCATE 11, 32
       PRINT "G "; : Rest .5
       PRINT "A "; : Rest .5
       PRINT "M "; : Rest .5
       PRINT "E "; : Rest .5
       PRINT "  "; : Rest .5
       PRINT "O "; : Rest .5
       PRINT "V "; : Rest .5
       PRINT "E "; : Rest .5
       PRINT "R": Rest .5
       LOCATE 11, 32
       FOR x = 1 TO 18
           Rest .5
           PRINT SPACE$(1);
       NEXT x
    WEND
    END

END SUB

SUB Intro
   
    COLOR 7
    LOCATE 11, 37: PRINT "ALIENS"
    LOCATE 12, 31: PRINT "- Steve Protulipac"
    SLEEP 1

    WHILE INKEY$ = ""
       CLS
       COLOR 4
       LOCATE 11, 31
       PRINT "A  "; : Rest .5
       PRINT "L  "; : Rest .5
       PRINT "I  "; : Rest .5
       PRINT "E  "; : Rest .5
       PRINT "N  "; : Rest .5
       PRINT "S  "; : Rest .5
       LOCATE 11, 31
       FOR x = 1 TO 18
           Rest .5
           PRINT SPACE$(1);
       NEXT x
    WEND

END SUB

SUB MoveShip

    command = INT(RND * 10)
   
    IF command = 0 OR command = 1 OR command = 2 OR command = 3 THEN
       GOSUB Down
    ELSEIF command = 4 THEN
       GOSUB Left
    ELSEIF command = 5 OR command = 6 OR command = 7 THEN
       GOSUB Up
    ELSEIF command = 8 THEN
       GOSUB Right
    ELSEIF command = 9 THEN
       GOSUB Shoot
    END IF

EXIT SUB

Down:
    Shipy = Shipy + Speed
    IF Shipx <= 0 THEN
       PUT (0, Shipy - 3), ClearShip, PSET
       Shipy = -1
    ELSEIF Shipx >= 570 THEN
       PUT (525, Shipy - 3), ClearShip, PSET
       Shipy = -1
    END IF
    IF Shipy <= 0 OR Shipy >= 250 THEN
       PUT (Shipx + 10, 0), ClearShip, PSET
       Shipx = INT(RND * 460) + 10
       Shipy = 10
    END IF
    PUT (Shipx, Shipy), Ship1, PSET
RETURN

Left:
    Shipx = Shipx - Speed
    IF Shipx <= 0 OR Shipx >= 580 THEN
       PUT (0, Shipy), ClearShip, PSET
       Shipy = -1
    ELSEIF Shipx >= 560 THEN
       PUT (525, Shipy), ClearShip, PSET
       Shipy = -1
    END IF
    IF Shipy <= 0 OR Shipy >= 250 THEN
       PUT (Shipx + 10, 0), ClearShip, PSET
       Shipx = INT(RND * 500) + 10
       Shipy = 10
    END IF
    PUT (Shipx, Shipy), Ship1, PSET
RETURN

Up:
    Shipy = Shipy - Speed
    IF Shipx <= 0 OR Shipx >= 580 THEN
       PUT (0, Shipy + 3), ClearShip, PSET
       Shipy = -1
    ELSEIF Shipx >= 570 THEN
       PUT (525, Shipy + 3), ClearShip, PSET
       Shipy = -1
    END IF
    IF Shipy <= 0 OR Shipy >= 250 THEN
       PUT (Shipx + 10, 0), ClearShip, PSET
       Shipx = INT(RND * 500) + 10
       Shipy = 10
    END IF
    PUT (Shipx, Shipy), Ship1, PSET
RETURN

Right:
    Shipx = Shipx + Speed
    IF Shipx <= 0 OR Shipx >= 580 THEN
       PUT (0, Shipy), ClearShip, PSET
       Shipy = -1
    ELSEIF Shipx >= 570 THEN
       PUT (525, Shipy), ClearShip, PSET
       Shipy = -1
    END IF
    IF Shipy <= 0 OR Shipy >= 250 THEN
       PUT (Shipx + 10, 0), ClearShip, PSET
       Shipx = INT(RND * 500) + 10
       Shipy = 10
    END IF
    PUT (Shipx, Shipy), Ship1, PSET
RETURN

Shoot:
    CIRCLE (Shipx + 33, Shipy + 17), 2, 14
    SOUND 500, 1
    hit = INT(RND * 2)
    IF hit = 1 THEN
       hitx = INT(RND * 570) + 10
       hity = INT(RND * 190) + 10
       SOUND 37, 1
       FOR r = 1 TO 50
           CIRCLE (hitx, hity), r, 14
       NEXT r
       FOR r = 1 TO 50
           CIRCLE (hitx, hity), r, 0
       NEXT r
       Health = Health - 5
    END IF
RETURN

END SUB

SUB Rest (t#)
 
  s# = TIMER
  t2# = MACHSPEED * t# / SPEEDCONST
  DO
  LOOP UNTIL TIMER - s# > t2#

END SUB

SUB Start
   
    COLOR 4
    GOSUB Sensors
    Rest .5
    GOSUB Enemy
    Rest .5
    GOSUB Ready
    Rest .5

EXIT SUB

Sensors:
   LOCATE 13, 28
   PRINT "S "; : Rest .5
   PRINT "E "; : Rest .5
   PRINT "N "; : Rest .5
   PRINT "S "; : Rest .5
   PRINT "O "; : Rest .5
   PRINT "R "; : Rest .5
   PRINT "S "; : Rest .5
   PRINT "  "; : Rest .5
   PRINT "A "; : Rest .5
   PRINT "C "; : Rest .5
   PRINT "T "; : Rest .5
   PRINT "I "; : Rest .5
   PRINT "V "; : Rest .5
   PRINT "E": Rest .5
   LOCATE 13, 28
   FOR x = 1 TO 28
       Rest .5
       PRINT SPACE$(1);
   NEXT x
RETURN

Enemy:
   LOCATE 13, 25
   PRINT "E "; : Rest .5
   PRINT "N "; : Rest .5
   PRINT "E "; : Rest .5
   PRINT "M "; : Rest .5
   PRINT "Y "; : Rest .5
   PRINT "  "; : Rest .5
   PRINT "A "; : Rest .5
   PRINT "P "; : Rest .5
   PRINT "P "; : Rest .5
   PRINT "R "; : Rest .5
   PRINT "O "; : Rest .5
   PRINT "A "; : Rest .5
   PRINT "C "; : Rest .5
   PRINT "H "; : Rest .5
   PRINT "I "; : Rest .5
   PRINT "N "; : Rest .5
   PRINT "G": Rest .5
   LOCATE 13, 25
   FOR x = 1 TO 34
       Rest .5
       PRINT SPACE$(1);
   NEXT x
RETURN

Ready:
   LOCATE 13, 32
   PRINT "G "; : Rest .5
   PRINT "E "; : Rest .5
   PRINT "T "; : Rest .5
   PRINT "  "; : Rest .5
   PRINT "R "; : Rest .5
   PRINT "E "; : Rest .5
   PRINT "A "; : Rest .5
   PRINT "D "; : Rest .5
   PRINT "Y": Rest .5
   LOCATE 13, 32
   FOR x = 1 TO 18
       Rest .5
       PRINT SPACE$(1);
   NEXT x
RETURN

END SUB

SUB YouWin
   
    COLOR 4
    LOCATE 11, 36
    PRINT "Y "; : Rest .5
    PRINT "O "; : Rest .5
    PRINT "U "; : Rest .5
    PRINT "  "; : Rest .5
    PRINT "W "; : Rest .5
    PRINT "I "; : Rest .5
    PRINT "N": Rest .5
    LOCATE 11, 36
    FOR x = 1 TO 14
        Rest .5
        PRINT SPACE$(1);
    NEXT x

    GameOver

END SUB

