  ' ANTx.BAS, a cellular automata program
  ' (C) PC Solutions 1994. A shareware program.
  '   PC Solutions, Box 954, Bournemouth, BH7 6YJ.
  '     EMAIL:pc.solutions@glass.jecsystems.com
  '      Based on idea discussed in article by Phil South.
  '  Simplified version of the full ANT-LIFE program..
  '  ANT-LIFE is a cellular automator program.
  ' The rules are simple - Each ant is given a start position and direction
  ' on a blank grid, then for each generation moves forward 1 step.
  ' If the cell it steps on is marked (ie. non-black) it turns to the left.
  ' If the cell it steps on is black it turns to the right.
  ' Each cell it steps on is inverted - if it was black, it becomes
  ' coloured, if it was coloured it becomes black. Each ant is assigned
  ' a colour for its trail.
  '   And thats pretty much it! With these simple rules, amazing patterns
  ' can be generated just by adjusting the mouse start x/y positions
  ' and directions - see the data statements at the end of this program.
  ' The full ANT-LIFE program here has many extra features to generate richer
  ' patterns - X/Y kick-offsets, rainbow palette trails and more. For the
  ' full source code to that program, buy the PCS Util-pack - see the advert
  ' for more info..

  DEFINT A-Z

  DIM antx(30), anty(30), antdir(30)
  DIM dx(10), dy(10)

directions:
  DATA -1,0, -1,-1, 0,-1, 1,-1, 1,0, 1,1, 0,1, -1,1
  RESTORE directions
        ' dir 0..7 clockwise 8 compass points, 0=West,1=NW,2=N,4=E,6=S,etc
  FOR x = 0 TO 7
    READ dx(x), dy(x)
  NEXT x

  SCREEN 13
  Maxy = 199
  Maxx = 319
  GOSUB readdata        ' Ant start positions

  DO
    FOR ant = 1 TO nants
      cell = POINT(antx(ant), anty(ant))
                ' Is cell empty?
      IF cell < 5 THEN
        trule = 2               ' Rotate clockwise 2 notches if empty (turn right)
        tcol = 8 + ant
      ELSE
        trule = 6               ' Rotate clockwise 6 notches if empty (turn left)
        tcol = 0                ' Set to 1 for trace, 0 for black
      END IF
                ' Rotate direction in trule..
      antdir(ant) = (antdir(ant) + trule) AND 7
      PSET (antx(ant), anty(ant)), tcol
        ' Move to next cell..
      antx(ant) = (antx(ant) + dx(antdir(ant)) + Maxx) MOD Maxx
      anty(ant) = (anty(ant) + dy(antdir(ant)) + Maxy) MOD Maxy
    NEXT ant
  LOOP WHILE (INKEY$ = "")
  END

readdata:
  ref$ = "'B(@-LHKKDSS"
  RESTORE userdata
  READ nants
  FOR ant = 1 TO nants
    READ antx(ant), anty(ant), antdir(ant)
  NEXT
  RETURN

  '   Just enter Number of ants, then  start X,Y,direction for each ant
userdata:
  DATA 2, 177,101,2, 160,100,0
        ' Try these..
  DATA 2, 100,100,4, 101,100,0
  DATA 2, 100,100,4, 103,100,0
  DATA 2, 100,100,4, 107,100,0



