{Ŀ
  Tetris(Block) V1.1 Turbo Pascal 7.0
  Written by Jou-Nan Chen 1994       
 }

uses Crt,SVGA256,Txt;

const
  Xi=116; Yi=16;
  C:byte=37; C2:byte=35;  C3:byte=0;    { Window,GameOver,Box }
  Data:array[0..27,0..7] of shortint=(  {   Z S    }
    (0,0,1,0,0,1,1,1),   (0,0,1,0,0,1,1,1),  (0,0,1,0,0,1,1,1),
    (0,0,1,0,0,1,1,1),   (-2,0,-1,0,0,0,1,0),(0,-1,0,0,0,1,0,2),
    (-2,0,-1,0,0,0,1,0), (0,-1,0,0,0,1,0,2), (-1,0,0,0,0,1,1,1),
    (1,-1,0,0,1,0,0,1),  (-1,0,0,0,0,1,1,1), (1,-1,0,0,1,0,0,1),
    (0,0,1,0,-1,1,0,1),  (0,-1,0,0,1,0,1,1), (0,0,1,0,-1,1,0,1),
    (0,-1,0,0,1,0,1,1),  (0,-1,-1,0,0,0,1,0),(0,-1,-1,0,0,0,0,1),
    (-1,0,0,0,1,0,0,1),  (0,-1,0,0,1,0,0,1), (1,-1,-1,0,0,0,1,0),
    (-1,-1,0,-1,0,0,0,1),(-1,0,0,0,1,0,-1,1),(0,-1,0,0,0,1,1,1),
    (-1,-1,-1,0,0,0,1,0),(0,-1,0,0,-1,1,0,1),(-1,0,0,0,1,0,1,1),
    (0,-1,1,-1,0,0,0,1));
var Pic:array[0..447] of byte;
    PicBack:array[0..7999] of byte;
    Font1:array[0..767] of byte;
    B:array[0..19,0..9] of byte;
    No,X,Y,OldX,OldY,OldNo,Drop,Delay1:integer;
    Level,Score,Lines,OldLines:longint;
    Ch:char;

{  Sounds  }
procedure Sounds(No:byte);
var I:integer;
begin
  case No of
    1:for I:=1 to 20 do begin Sound(5*Random(500)+900); Delay(1); end;
    2:begin
	Sound(800); Delay(90);
	Sound(600); Delay(90);
	Sound(400); Delay(90);
      end;
    3:for I:=1 to 10 do begin Sound(50*Random(100)+500); Delay(50); end;
  end;
  NoSound;
end;
{  Screen  }
procedure Screen(X,Y:integer);  { 88x168 }
var I:integer;
begin
  for I:=0 to 7 do Put(80*(I mod 4),100*(I div 4),80,100,PicBack);
  for I:=0 to 3 do Box(X+I,Y+I,88-2*I,168-2*I,64+I);
  Bar(X+4,Y+4,80,160,0);
  Bar(36,16,72,76,C);  Box(38,18,68,72,C3);
  Bar(212,16,52,42,C); Box(214,18,48,38,C3);
  Print(44,24,14,'Level'); Print(92,34,14,'0');
  Print(44,44,14,'Score'); Print(92,54,14,'0');
  Print(44,64,14,'Line');  Print(92,74,14,'0');
end;
{  PutBlock  }
procedure PutBlock(X,Y,No:integer);
var I,Xp,Yp:integer;
begin
  for I:=0 to 3 do begin
    Xp:=8*Data[No,2*I]+X; Yp:=8*Data[No,2*I+1]+Y;
    Put(Xp,Yp,8,8,Pic[64*(No div 4)]);
  end;
end;
{  EraseBlock  }
procedure EraseBlock(X,Y,No:integer);
var I,Xp,Yp:integer;
begin
  for I:=0 to 3 do begin
    Xp:=8*Data[No,2*I]+X; Yp:=8*Data[No,2*I+1]+Y;
    Bar(Xp,Yp,8,8,0);
  end;
end;
{  Keys  }
procedure Keys;
var I:integer;
    St:string[7];
begin
if KeyPressed=1 then begin
  Ch:=ReadKey;
  case Ch of
    '4':begin
          X:=X-1;
          for I:=0 to 3 do if (Data[No,2*I]+X<0) or
            (B[Data[No,2*I+1]+Y,Data[No,2*I]+X]=1) then X:=X+1;
        end;
    '6':begin
	  X:=X+1;
	  for I:=0 to 3 do if (Data[No,2*I]+X>9) or
	    (B[Data[No,2*I+1]+Y,Data[No,2*I]+X]=1) then X:=X-1;
        end;
    '5':begin
          No:=No+1; if No mod 4=0 then No:=No-4;
	  for I:=0 to 3 do if (Data[No,2*I]+X<0) or (Data[No,2*I]+X>9)
            or (Data[No,2*I+1]+Y<0) or (Data[No,2*I+1]+Y>19) or
            (B[Data[No,2*I+1]+Y,Data[No,2*I]+X]=1) then
              if No mod 4=0 then No:=No+3 else No:=No-1;
        end;
    '2':Delay1:=0;
    '~':begin
	  Level:=Level+1; Str(Level:7,St);
	  Bar(44,34,60,8,C); Print(44,34,14,St);
          Delay1:=32-3*(Level mod 10);
        end;
  end;
  EraseBlock(Xi+4+8*OldX,Yi+4+8*OldY,OldNo);
  PutBlock(Xi+4+8*X,Yi+4+8*Y,No);
  OldX:=X; OldY:=Y; OldNo:=No;
end;
end;
{  EraseLines  }
procedure EraseLines;
var N:array[1..4] of byte;
    Ok,M,I,J,Num:integer;
    St:string[7];
begin
  Num:=0;
  for J:=0 to 19 do begin
    Ok:=0; for I:=0 to 9 do if B[J,I]=0 then Ok:=1;
    if Ok=0 then begin Num:=Num+1; N[Num]:=J; end;
  end;
  for J:=1 to Num do begin
    for I:=N[J]*8+7 downto 8 do begin
      M:=320*(Yi+I+4)+Xi+4;
      Move(Mem[$A000:M-2560],Mem[$A000:M],80);
    end;
    for I:=N[J] downto 1 do Move(B[I-1],B[I],10);
  end;
  if Num>0 then begin
    Lines:=Lines+Num; Str(Lines:7,St);
    Bar(44,74,60,8,C); Print(44,74,14,St);
    Sounds(2);
    if Lines>10*(OldLines div 10)+9 then begin
      Level:=Level+1; Str(Level:7,St);
      Bar(44,34,60,8,C); Print(44,34,14,St);
      Sounds(3); OldLines:=Lines;
    end;
  end;
end;
{  GameOver  }
procedure GameOver(X,Y:integer);  { 140x70 }
begin
  Bar(X,Y,140,70,C2);
  Box(X+2,Y+2,136,66,C3); Line(X+3,Y+22,X+136,Y+22,C3);
  Print(X+32,Y+ 8,14,'Game Over');
  Print(X+12,Y+32,14,'Esc-Quit game');
  Print(X+12,Y+48,14,'Enter-Continue');
  repeat
    Ch:=ReadKey;
    if Ch=#27 then begin
      TextMode(LastMode); Mem[0:$417]:=Mem[0:$417] and $DF;
      Halt(1);
    end;
  until Ch in [#13,#27];
end;
{  Title  }
procedure Title;
const
  St:array[0..9] of string[25]=(
    '           2222          ',
    '0000      2    2    4   4',
    '0   0 1   2    2    4  4 ',
    '0   0 1   2   3333  4 4  ',
    '0000  1   2  3 2  3 44   ',
    '0   0 1   2  3 2    4 4  ',
    '0   0 1    2232     4  4 ',
    '0000  1      3      4   4',
    '      11111  3    3      ',
    '              3333       ');
var I,J,N:integer;
begin
  SetMode(1); Bar(0,0,320,200,104);
  for J:=0 to 9 do for I:=0 to 24 do begin
    N:=(Ord(St[J][I+1])-48)*7 div 5;
    if N>=0 then Put(50+8*I,30+8*J,8,8,Pic[64*N]);
  end;
  Print2(40,135,64,'A game comes from "TETRIS"');
  Print2(40,155,64,'"BLOCK" Version 1.1');
  Print2(40,165,64,'Written by Jou-Nan Chen 1994');
  Ch:=ReadKey; Ch:=#0;
end;

{ ۲ Main Program  }

label 1000;
var I,Ok,No1,No2:integer;
    St:string[7];
begin
  FileRead('block.dat',0,7,64,Pic);
  FileRead('block.pic',0,1,8000,PicBack);
  FileRead('0808art.fnt',0,96,8,Font1);
  InstallFont(1,8,8,32,96,8,Font1);
  1000: Title;
  Level:=0; Score:=0; Lines:=0; OldLines:=0;
  Randomize; Screen(Xi,Yi); Ch:=#0; Drop:=0; Ok:=0;
  for Y:=0 to 19 do for X:=0 to 9 do B[Y,X]:=0;
  No1:=4*Random(7);
  repeat
    X:=4; Y:=1; OldX:=4; OldY:=1; Delay1:=32-3*(Level mod 10);
    No2:=4*Random(7); Bar(216,20,44,34,C); PutBlock(236,34,No2);
    No:=No1; OldNo:=No; PutBlock(Xi+4+8*X,Yi+4+8*Y,No); No1:=No2;
    repeat
      Mem[0:$417]:=Mem[0:$417] or $20; Keys;
      Delay(Delay1); Drop:=Drop+1;
      if Drop>20 then begin
	Drop:=0; Y:=Y+1;
	Ok:=0;
	for I:=0 to 3 do if (Data[No,2*I+1]+Y>19)
	  or (B[Data[No,2*I+1]+Y,Data[No,2*I]+X]=1) then
	  begin Y:=Y-1; Ok:=1; end;
	EraseBlock(Xi+4+8*OldX,Yi+4+8*OldY,OldNo);
	PutBlock(Xi+4+8*X,Yi+4+8*Y,No);
	OldX:=X; OldY:=Y; OldNo:=No;
      end;
    until (Ok=1) or (Ch=#27);
    Score:=Score+15+5*(Level mod 10); Str(Score:7,St);
    Bar(44,54,60,8,C); Print(44,54,14,St);
    for I:=0 to 3 do B[Data[No,2*I+1]+Y,Data[No,2*I]+X]:=1;
    Ok:=0; for I:=0 to 3 do if Data[No,2*I+1]+Y=1 then Ok:=1;
    Sounds(1); EraseLines;
  until (Ok=1) or (Ch=#27);
  GameOver(90,65); goto 1000;
end.
